/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fileClasses;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0011*\u00020\u0014\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\b\u001a\u00020\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\r\u001a\u00020\n*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "fileClassInfo", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "Lorg/jetbrains/kotlin/psi/KtFile;", "getFileClassInfo", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "internalNameWithoutInnerClasses", "", "Lorg/jetbrains/kotlin/name/FqName;", "getInternalNameWithoutInnerClasses", "(Lorg/jetbrains/kotlin/name/FqName;)Ljava/lang/String;", "javaFileFacadeFqName", "getJavaFileFacadeFqName", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/name/FqName;", "isInsideJvmMultifileClassFile", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isTopLevelInJvmMultifileClass", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "frontend.java"})
public final class JvmFileClassUtilKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final JvmFileClassInfo getFileClassInfo(@NotNull KtFile $this$fileClassInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$fileClassInfo, (String)"<this>");
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)$this$fileClassInfo), (CachedValueProvider)((CachedValueProvider)new CachedValueProvider<JvmFileClassInfo>($this$fileClassInfo){
            final /* synthetic */ KtFile $this_fileClassInfo;
            {
                this.$this_fileClassInfo = $receiver;
            }

            @Nullable
            public final CachedValueProvider.Result<JvmFileClassInfo> compute() {
                Object[] objectArray = new Object[]{this.$this_fileClassInfo};
                return new CachedValueProvider.Result((Object)JvmFileClassUtil.getFileClassInfoNoResolve(this.$this_fileClassInfo), objectArray);
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"KtFile.fileClassInfo: JvmFileClassInfo\n    get() {\n        return CachedValuesManager.getCachedValue(this) {\n            CachedValueProvider.Result(JvmFileClassUtil.getFileClassInfoNoResolve(this), this)\n        }");
        return (JvmFileClassInfo)object;
    }

    @NotNull
    public static final FqName getJavaFileFacadeFqName(@NotNull KtFile $this$javaFileFacadeFqName) {
        Intrinsics.checkNotNullParameter((Object)$this$javaFileFacadeFqName, (String)"<this>");
        FqName fqName2 = $this$javaFileFacadeFqName.isCompiled() ? $this$javaFileFacadeFqName.getPackageFqName().child(Name.identifier($this$javaFileFacadeFqName.getVirtualFile().getNameWithoutExtension())) : JvmFileClassUtilKt.getFileClassInfo($this$javaFileFacadeFqName).getFacadeClassFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"if (isCompiled) packageFqName.child(Name.identifier(virtualFile.nameWithoutExtension))\n            else this.fileClassInfo.facadeClassFqName");
        FqName facadeFqName = fqName2;
        if (!Name.isValidIdentifier(facadeFqName.shortName().getIdentifier())) {
            LOG.error("An invalid fqName `" + facadeFqName + "` with short name `" + facadeFqName.shortName() + "` is created for file `" + $this$javaFileFacadeFqName.getName() + "` (isCompiled = " + $this$javaFileFacadeFqName.isCompiled() + ')');
        }
        return facadeFqName;
    }

    public static final boolean isInsideJvmMultifileClassFile(@NotNull KtDeclaration $this$isInsideJvmMultifileClassFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isInsideJvmMultifileClassFile, (String)"<this>");
        KtFile ktFile = $this$isInsideJvmMultifileClassFile.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"containingKtFile");
        return JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(ktFile, JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS_SHORT()) != null;
    }

    public static final boolean isTopLevelInJvmMultifileClass(@NotNull DeclarationDescriptor $this$isTopLevelInJvmMultifileClass) {
        DeserializedContainerSource containerSource;
        Intrinsics.checkNotNullParameter((Object)$this$isTopLevelInJvmMultifileClass, (String)"<this>");
        if (!($this$isTopLevelInJvmMultifileClass.getContainingDeclaration() instanceof PackageFragmentDescriptor)) {
            return false;
        }
        PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration($this$isTopLevelInJvmMultifileClass);
        if (declaration instanceof KtDeclaration) {
            return JvmFileClassUtilKt.isInsideJvmMultifileClassFile((KtDeclaration)declaration);
        }
        return $this$isTopLevelInJvmMultifileClass instanceof DeserializedMemberDescriptor && (containerSource = ((DeserializedMemberDescriptor)$this$isTopLevelInJvmMultifileClass).getContainerSource()) instanceof JvmPackagePartSource && ((JvmPackagePartSource)containerSource).getFacadeClassName() != null;
    }

    @NotNull
    public static final String getInternalNameWithoutInnerClasses(@NotNull FqName $this$internalNameWithoutInnerClasses) {
        Intrinsics.checkNotNullParameter((Object)$this$internalNameWithoutInnerClasses, (String)"<this>");
        String string2 = JvmClassName.byFqNameWithoutInnerClasses($this$internalNameWithoutInnerClasses).getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"byFqNameWithoutInnerClasses(this).internalName");
        return string2;
    }

    static {
        Logger logger = Logger.getInstance((String)"JvmFileClassUtil");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"JvmFileClassUtil\")");
        LOG = logger;
    }
}

