/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.optimization.CapturedVarsOptimizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.CapturedVarsOptimizationMethodTransformer$Transformer$findCleanInstructions$;
import org.jetbrains.kotlin.codegen.optimization.CapturedVarsOptimizationMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.common.ProperTrackedReferenceValue;
import org.jetbrains.kotlin.codegen.optimization.common.ReferenceTrackingInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.ReferenceValueDescriptor;
import org.jetbrains.kotlin.codegen.optimization.common.TrackedReferenceValue;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "CapturedVarDescriptor", "Transformer", "backend"})
public final class CapturedVarsOptimizationMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        new Transformer(internalClassName, methodNode).run();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u00109\u001a\u00020\u0018J\b\u0010:\u001a\u00020;H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0017\u00101\u001a\b\u0012\u0004\u0012\u00020\u00150\t\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0017\u00105\u001a\b\u0012\u0004\u0012\u0002060\t\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00104\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$CapturedVarDescriptor;", "Lorg/jetbrains/kotlin/codegen/optimization/common/ReferenceValueDescriptor;", "newInsn", "Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "refType", "Lorg/jetbrains/org/objectweb/asm/Type;", "valueType", "(Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;Lorg/jetbrains/org/objectweb/asm/Type;Lorg/jetbrains/org/objectweb/asm/Type;)V", "aloadInsns", "", "Lorg/jetbrains/org/objectweb/asm/tree/VarInsnNode;", "getAloadInsns", "()Ljava/util/Collection;", "astoreInsns", "getAstoreInsns", "cleanVarInstruction", "getCleanVarInstruction", "()Lorg/jetbrains/org/objectweb/asm/tree/VarInsnNode;", "setCleanVarInstruction", "(Lorg/jetbrains/org/objectweb/asm/tree/VarInsnNode;)V", "getFieldInsns", "Lorg/jetbrains/org/objectweb/asm/tree/FieldInsnNode;", "getGetFieldInsns", "hazard", "", "getHazard", "()Z", "setHazard", "(Z)V", "initCallInsn", "Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;", "getInitCallInsn", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;", "setInitCallInsn", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;)V", "localVar", "Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;", "getLocalVar", "()Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;", "setLocalVar", "(Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;)V", "localVarIndex", "", "getLocalVarIndex", "()I", "setLocalVarIndex", "(I)V", "getNewInsn", "()Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "putFieldInsns", "getPutFieldInsns", "getRefType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "stackInsns", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getStackInsns", "getValueType", "canRewrite", "onUseAsTainted", "", "backend"})
    private static final class CapturedVarDescriptor
    implements ReferenceValueDescriptor {
        @NotNull
        private final TypeInsnNode newInsn;
        @NotNull
        private final Type refType;
        @NotNull
        private final Type valueType;
        private boolean hazard;
        @Nullable
        private MethodInsnNode initCallInsn;
        @Nullable
        private LocalVariableNode localVar;
        private int localVarIndex;
        @NotNull
        private final Collection<VarInsnNode> astoreInsns;
        @NotNull
        private final Collection<VarInsnNode> aloadInsns;
        @NotNull
        private final Collection<AbstractInsnNode> stackInsns;
        @NotNull
        private final Collection<FieldInsnNode> getFieldInsns;
        @NotNull
        private final Collection<FieldInsnNode> putFieldInsns;
        @Nullable
        private VarInsnNode cleanVarInstruction;

        public CapturedVarDescriptor(@NotNull TypeInsnNode newInsn, @NotNull Type refType, @NotNull Type valueType) {
            Intrinsics.checkNotNullParameter((Object)newInsn, (String)"newInsn");
            Intrinsics.checkNotNullParameter((Object)refType, (String)"refType");
            Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
            this.newInsn = newInsn;
            this.refType = refType;
            this.valueType = valueType;
            this.localVarIndex = -1;
            this.astoreInsns = new LinkedHashSet();
            this.aloadInsns = new LinkedHashSet();
            this.stackInsns = new LinkedHashSet();
            this.getFieldInsns = new LinkedHashSet();
            this.putFieldInsns = new LinkedHashSet();
        }

        @NotNull
        public final TypeInsnNode getNewInsn() {
            return this.newInsn;
        }

        @NotNull
        public final Type getRefType() {
            return this.refType;
        }

        @NotNull
        public final Type getValueType() {
            return this.valueType;
        }

        public final boolean getHazard() {
            return this.hazard;
        }

        public final void setHazard(boolean bl) {
            this.hazard = bl;
        }

        @Nullable
        public final MethodInsnNode getInitCallInsn() {
            return this.initCallInsn;
        }

        public final void setInitCallInsn(@Nullable MethodInsnNode methodInsnNode) {
            this.initCallInsn = methodInsnNode;
        }

        @Nullable
        public final LocalVariableNode getLocalVar() {
            return this.localVar;
        }

        public final void setLocalVar(@Nullable LocalVariableNode localVariableNode) {
            this.localVar = localVariableNode;
        }

        public final int getLocalVarIndex() {
            return this.localVarIndex;
        }

        public final void setLocalVarIndex(int n) {
            this.localVarIndex = n;
        }

        @NotNull
        public final Collection<VarInsnNode> getAstoreInsns() {
            return this.astoreInsns;
        }

        @NotNull
        public final Collection<VarInsnNode> getAloadInsns() {
            return this.aloadInsns;
        }

        @NotNull
        public final Collection<AbstractInsnNode> getStackInsns() {
            return this.stackInsns;
        }

        @NotNull
        public final Collection<FieldInsnNode> getGetFieldInsns() {
            return this.getFieldInsns;
        }

        @NotNull
        public final Collection<FieldInsnNode> getPutFieldInsns() {
            return this.putFieldInsns;
        }

        @Nullable
        public final VarInsnNode getCleanVarInstruction() {
            return this.cleanVarInstruction;
        }

        public final void setCleanVarInstruction(@Nullable VarInsnNode varInsnNode) {
            this.cleanVarInstruction = varInsnNode;
        }

        public final boolean canRewrite() {
            return !this.hazard && this.initCallInsn != null && this.localVar != null && this.localVarIndex >= 0;
        }

        @Override
        public void onUseAsTainted() {
            this.hazard = true;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001:\u00011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u001dH\u0002J&\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u001dH\u0002J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u0016H\u0002J\u0006\u0010+\u001a\u00020\u001dJ\b\u0010,\u001a\u00020\u001dH\u0002J\u000e\u0010-\u001a\u0004\u0018\u00010\u0016*\u00020\nH\u0002J\f\u0010.\u001a\u00020%*\u00020\u0011H\u0002J\u0014\u0010/\u001a\u00020\u001d*\u00020'2\u0006\u00100\u001a\u00020\u0011H\u0002R \u0010\u0007\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\bX\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR6\u0010\u0010\u001a(\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012*\u0014\u0012\u000e\b\u0001\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00160\u0019j\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u0016`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer;", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "frames", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "hasRewritableRefValues", "", "getHasRewritableRefValues", "()Z", "insns", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "kotlin.jvm.PlatformType", "[Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "refValues", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$CapturedVarDescriptor;", "Lkotlin/collections/ArrayList;", "refValuesByNewInsn", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "Lkotlin/collections/LinkedHashMap;", "analyze", "", "assignLocalVars", "createRefValues", "findCleanInstructions", "", "Lorg/jetbrains/org/objectweb/asm/tree/VarInsnNode;", "refValue", "oldVarIndex", "", "instructions", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "rewrite", "rewriteRefValue", "capturedVar", "run", "trackPops", "getCapturedVarOrNull", "getIndex", "removeOrReplaceByNop", "insn", "Interpreter", "backend"})
    private static final class Transformer {
        @NotNull
        private final String internalClassName;
        @NotNull
        private final MethodNode methodNode;
        @NotNull
        private final ArrayList<CapturedVarDescriptor> refValues;
        @NotNull
        private final LinkedHashMap<TypeInsnNode, CapturedVarDescriptor> refValuesByNewInsn;
        private final AbstractInsnNode[] insns;
        private Frame<BasicValue>[] frames;

        public Transformer(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
            Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
            Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
            this.internalClassName = internalClassName;
            this.methodNode = methodNode;
            this.refValues = new ArrayList();
            this.refValuesByNewInsn = new LinkedHashMap();
            this.insns = this.methodNode.instructions.toArray();
        }

        public final boolean getHasRewritableRefValues() {
            Collection collection = this.refValues;
            boolean bl = false;
            return !collection.isEmpty();
        }

        public final void run() {
            this.createRefValues();
            if (!this.getHasRewritableRefValues()) {
                return;
            }
            this.analyze();
            if (!this.getHasRewritableRefValues()) {
                return;
            }
            this.rewrite();
        }

        private final int getIndex(AbstractInsnNode $this$getIndex) {
            return this.methodNode.instructions.indexOf($this$getIndex);
        }

        private final void createRefValues() {
            AbstractInsnNode[] abstractInsnNodeArray = this.insns;
            Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNodeArray, (String)"insns");
            for (AbstractInsnNode insn : abstractInsnNodeArray) {
                Type type2;
                Object object;
                Type type3;
                if (insn.getOpcode() != 187 || !(insn instanceof TypeInsnNode) || !AsmTypes.isSharedVarType(type3 = Type.getObjectType((String)((TypeInsnNode)insn).desc)) || (object = CapturedVarsOptimizationMethodTransformerKt.getREF_TYPE_TO_ELEMENT_TYPE().get(type3.getInternalName())) == null) continue;
                Type valueType = type2 = object;
                TypeInsnNode typeInsnNode = (TypeInsnNode)insn;
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"type");
                CapturedVarDescriptor refValue = new CapturedVarDescriptor(typeInsnNode, type3, valueType);
                this.refValues.add(refValue);
                object = this.refValuesByNewInsn;
                TypeInsnNode typeInsnNode2 = (TypeInsnNode)insn;
                boolean bl = false;
                object.put(typeInsnNode2, refValue);
            }
        }

        private final void analyze() {
            Frame<V>[] frameArray = MethodTransformer.analyze(this.internalClassName, this.methodNode, new Interpreter());
            Intrinsics.checkNotNullExpressionValue(frameArray, (String)"analyze(internalClassName, methodNode, Interpreter())");
            this.frames = frameArray;
            this.trackPops();
            this.assignLocalVars();
            CollectionsKt.removeAll((List)this.refValues, (Function1)analyze.1.INSTANCE);
        }

        private final void trackPops() {
            int n = 0;
            int n2 = this.insns.length + -1;
            if (n <= n2) {
                block4: do {
                    int i = n++;
                    Frame<BasicValue>[] frameArray = this.frames;
                    if (frameArray == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"frames");
                        throw null;
                    }
                    Frame<BasicValue> frame = frameArray[i];
                    if (frame == null) continue;
                    Frame<BasicValue> frame2 = frame;
                    AbstractInsnNode insn = this.insns[i];
                    int n3 = insn.getOpcode();
                    switch (n3) {
                        case 87: {
                            Object object;
                            BasicValue basicValue = StackTransformationUtilsKt.top(frame2);
                            if (basicValue == null || (object = this.getCapturedVarOrNull(basicValue)) == null) continue block4;
                            Object object2 = object;
                            boolean bl = false;
                            boolean bl2 = false;
                            Object $this$trackPops_u24lambda_u2d0 = object2;
                            boolean bl3 = false;
                            Collection<AbstractInsnNode> collection = ((CapturedVarDescriptor)$this$trackPops_u24lambda_u2d0).getStackInsns();
                            Intrinsics.checkNotNullExpressionValue((Object)insn, (String)"insn");
                            collection.add(insn);
                            break;
                        }
                        case 88: {
                            BasicValue top = StackTransformationUtilsKt.top(frame2);
                            Object object = top;
                            Integer n4 = object == null ? null : Integer.valueOf(object.getSize());
                            int n5 = 1;
                            if (n4 == null || n4 != n5) continue block4;
                            CapturedVarDescriptor capturedVarDescriptor = this.getCapturedVarOrNull(top);
                            if (capturedVarDescriptor != null) {
                                capturedVarDescriptor.setHazard(true);
                            }
                            Object object2 = StackTransformationUtilsKt.peek(frame2, 1);
                            CapturedVarDescriptor capturedVarDescriptor2 = capturedVarDescriptor = object2 == null ? null : this.getCapturedVarOrNull((BasicValue)object2);
                            if (capturedVarDescriptor == null) continue block4;
                            capturedVarDescriptor.setHazard(true);
                        }
                    }
                } while (n <= n2);
            }
        }

        private final CapturedVarDescriptor getCapturedVarOrNull(BasicValue $this$getCapturedVarOrNull) {
            CapturedVarDescriptor capturedVarDescriptor;
            ProperTrackedReferenceValue properTrackedReferenceValue;
            BasicValue $this$safeAs$iv = $this$getCapturedVarOrNull;
            boolean $i$f$safeAs = false;
            BasicValue basicValue = $this$safeAs$iv;
            if (!(basicValue instanceof ProperTrackedReferenceValue)) {
                basicValue = null;
            }
            if ((properTrackedReferenceValue = (ProperTrackedReferenceValue)basicValue) == null) {
                capturedVarDescriptor = null;
            } else {
                ReferenceValueDescriptor referenceValueDescriptor = properTrackedReferenceValue.getDescriptor();
                if (referenceValueDescriptor == null) {
                    capturedVarDescriptor = null;
                } else {
                    ReferenceValueDescriptor $this$safeAs$iv2 = referenceValueDescriptor;
                    boolean $i$f$safeAs2 = false;
                    ReferenceValueDescriptor referenceValueDescriptor2 = $this$safeAs$iv2;
                    if (!(referenceValueDescriptor2 instanceof CapturedVarDescriptor)) {
                        referenceValueDescriptor2 = null;
                    }
                    capturedVarDescriptor = (CapturedVarDescriptor)referenceValueDescriptor2;
                }
            }
            return capturedVarDescriptor;
        }

        private final void assignLocalVars() {
            MethodNode refValue;
            Object object;
            for (LocalVariableNode localVar : this.methodNode.localVariables) {
                Object descriptor2;
                ReferenceValueDescriptor referenceValueDescriptor;
                LabelNode startFrame;
                Object object2;
                Type type2 = Type.getType((String)localVar.desc);
                if (!AsmTypes.isSharedVarType(type2)) continue;
                object = this.frames;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"frames");
                    throw null;
                }
                LabelNode labelNode = object;
                object = localVar.start;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"localVar.start");
                LabelNode labelNode2 = labelNode[this.getIndex((AbstractInsnNode)object)];
                if (labelNode2 == null || (object = (object2 = (startFrame = labelNode2).getLocal(localVar.index)) instanceof ProperTrackedReferenceValue ? (ProperTrackedReferenceValue)((Object)object2) : null) == null || (object2 = (referenceValueDescriptor = (refValue = object).getDescriptor()) instanceof CapturedVarDescriptor ? (CapturedVarDescriptor)referenceValueDescriptor : null) == null || ((CapturedVarDescriptor)(descriptor2 = object2)).getHazard()) continue;
                if (((CapturedVarDescriptor)descriptor2).getLocalVar() == null) {
                    ((CapturedVarDescriptor)descriptor2).setLocalVar(localVar);
                    continue;
                }
                ((CapturedVarDescriptor)descriptor2).setHazard(true);
            }
            for (CapturedVarDescriptor refValue2 : this.refValues) {
                LocalVariableNode startFrame;
                if (refValue2.getHazard() || (startFrame = refValue2.getLocalVar()) == null) continue;
                LocalVariableNode localVar = startFrame;
                int oldVarIndex = localVar.index;
                if (refValue2.getValueType().getSize() != 1) {
                    refValue2.setLocalVarIndex(this.methodNode.maxLocals);
                    refValue = this.methodNode;
                    refValue.maxLocals += 2;
                    localVar.index = refValue2.getLocalVarIndex();
                } else {
                    refValue2.setLocalVarIndex(localVar.index);
                }
                Intrinsics.checkNotNullExpressionValue((Object)refValue2, (String)"refValue");
                object = this.methodNode.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"methodNode.instructions");
                List<VarInsnNode> cleanInstructions = this.findCleanInstructions(refValue2, oldVarIndex, (InsnList)object);
                if (cleanInstructions.size() > 1) {
                    refValue2.setHazard(true);
                    continue;
                }
                refValue2.setCleanVarInstruction((VarInsnNode)CollectionsKt.firstOrNull(cleanInstructions));
            }
        }

        private final List<VarInsnNode> findCleanInstructions(CapturedVarDescriptor refValue, int oldVarIndex, InsnList instructions) {
            Sequence $this$filterIsInstance$iv = new InsnSequence(instructions);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Transformer$findCleanInstructions$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)sequence2, (Function1)((Function1)new Function1<VarInsnNode, Boolean>(oldVarIndex){
                final /* synthetic */ int $oldVarIndex;
                {
                    this.$oldVarIndex = $oldVarIndex;
                    super(1);
                }

                public final boolean invoke(@NotNull VarInsnNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getOpcode() == 58 && it.var == this.$oldVarIndex;
                }
            })), (Function1)findCleanInstructions.2.INSTANCE), (Function1)((Function1)new Function1<VarInsnNode, Boolean>(instructions, refValue){
                final /* synthetic */ InsnList $instructions;
                final /* synthetic */ CapturedVarDescriptor $refValue;
                {
                    this.$instructions = $instructions;
                    this.$refValue = $refValue;
                    super(1);
                }

                public final boolean invoke(@NotNull VarInsnNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    int operationIndex = this.$instructions.indexOf((AbstractInsnNode)it);
                    LocalVariableNode localVariableNode = this.$refValue.getLocalVar();
                    Intrinsics.checkNotNull((Object)localVariableNode);
                    LocalVariableNode localVariableNode2 = localVariableNode;
                    return this.$instructions.indexOf((AbstractInsnNode)localVariableNode2.start) < operationIndex && operationIndex < this.$instructions.indexOf((AbstractInsnNode)localVariableNode2.end);
                }
            })));
        }

        private final void rewrite() {
            for (CapturedVarDescriptor refValue : this.refValues) {
                if (!refValue.canRewrite()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)refValue, (String)"refValue");
                this.rewriteRefValue(refValue);
            }
            UtilKt.removeEmptyCatchBlocks(this.methodNode);
            UtilKt.removeUnusedLocalVariables(this.methodNode);
        }

        private final void removeOrReplaceByNop(InsnList $this$removeOrReplaceByNop, AbstractInsnNode insn) {
            if (insn.getPrevious() instanceof LineNumberNode && insn.getNext() instanceof LabelNode && insn.getNext().getNext() instanceof LineNumberNode) {
                $this$removeOrReplaceByNop.set(insn, (AbstractInsnNode)new InsnNode(0));
            } else {
                $this$removeOrReplaceByNop.remove(insn);
            }
        }

        private final void rewriteRefValue(CapturedVarDescriptor capturedVar) {
            FieldInsnNode it;
            boolean bl;
            Iterable $this$none$iv;
            int storeOpcode;
            int loadOpcode;
            InsnList $this$rewriteRefValue_u24lambda_u2d8;
            block10: {
                InsnList insnList = this.methodNode.instructions;
                boolean bl2 = false;
                boolean bl3 = false;
                $this$rewriteRefValue_u24lambda_u2d8 = insnList;
                boolean bl4 = false;
                LocalVariableNode localVariableNode = capturedVar.getLocalVar();
                Intrinsics.checkNotNull((Object)localVariableNode);
                LocalVariableNode localVar = localVariableNode;
                localVar.signature = null;
                localVar.desc = capturedVar.getValueType().getDescriptor();
                loadOpcode = capturedVar.getValueType().getOpcode(21);
                storeOpcode = capturedVar.getValueType().getOpcode(54);
                $this$none$iv = capturedVar.getPutFieldInsns();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (FieldInsnNode)element$iv;
                        boolean bl5 = false;
                        int n = this.getIndex((AbstractInsnNode)it);
                        LabelNode labelNode = localVar.start;
                        Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"localVar.start");
                        if (!(n < this.getIndex((AbstractInsnNode)labelNode))) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            if (bl) {
                $this$rewriteRefValue_u24lambda_u2d8.insertBefore((AbstractInsnNode)capturedVar.getNewInsn(), (AbstractInsnNode)new InsnNode(AsmUtil.defaultValueOpcode(capturedVar.getValueType())));
                $this$rewriteRefValue_u24lambda_u2d8.insertBefore((AbstractInsnNode)capturedVar.getNewInsn(), (AbstractInsnNode)new VarInsnNode(storeOpcode, capturedVar.getLocalVarIndex()));
            }
            $this$rewriteRefValue_u24lambda_u2d8.remove((AbstractInsnNode)capturedVar.getNewInsn());
            $this$none$iv = capturedVar.getInitCallInsn();
            Intrinsics.checkNotNull((Object)$this$none$iv);
            $this$rewriteRefValue_u24lambda_u2d8.remove((AbstractInsnNode)$this$none$iv);
            Iterable $this$forEach$iv = capturedVar.getStackInsns();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AbstractInsnNode)element$iv;
                boolean bl6 = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$rewriteRefValue_u24lambda_u2d8, (String)"");
                this.removeOrReplaceByNop($this$rewriteRefValue_u24lambda_u2d8, (AbstractInsnNode)it);
            }
            $this$forEach$iv = capturedVar.getAloadInsns();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (VarInsnNode)element$iv;
                boolean bl7 = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$rewriteRefValue_u24lambda_u2d8, (String)"");
                this.removeOrReplaceByNop($this$rewriteRefValue_u24lambda_u2d8, (AbstractInsnNode)it);
            }
            $this$forEach$iv = capturedVar.getAstoreInsns();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (VarInsnNode)element$iv;
                boolean bl8 = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$rewriteRefValue_u24lambda_u2d8, (String)"");
                this.removeOrReplaceByNop($this$rewriteRefValue_u24lambda_u2d8, (AbstractInsnNode)it);
            }
            $this$forEach$iv = capturedVar.getGetFieldInsns();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FieldInsnNode)element$iv;
                boolean bl9 = false;
                $this$rewriteRefValue_u24lambda_u2d8.set((AbstractInsnNode)it, (AbstractInsnNode)new VarInsnNode(loadOpcode, capturedVar.getLocalVarIndex()));
            }
            $this$forEach$iv = capturedVar.getPutFieldInsns();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FieldInsnNode)element$iv;
                boolean bl10 = false;
                $this$rewriteRefValue_u24lambda_u2d8.set((AbstractInsnNode)it, (AbstractInsnNode)new VarInsnNode(storeOpcode, capturedVar.getLocalVarIndex()));
            }
            VarInsnNode varInsnNode = capturedVar.getCleanVarInstruction();
            if (varInsnNode != null) {
                VarInsnNode varInsnNode2 = varInsnNode;
                boolean bl11 = false;
                boolean bl12 = false;
                it = varInsnNode2;
                boolean bl13 = false;
                $this$rewriteRefValue_u24lambda_u2d8.remove(it.getPrevious());
                $this$rewriteRefValue_u24lambda_u2d8.remove((AbstractInsnNode)it);
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer$Interpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/common/ReferenceTrackingInterpreter;", "(Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer;)V", "newOperation", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "processRefValueUsage", "", "value", "Lorg/jetbrains/kotlin/codegen/optimization/common/TrackedReferenceValue;", "position", "", "backend"})
        private final class Interpreter
        extends ReferenceTrackingInterpreter {
            public Interpreter() {
                Intrinsics.checkNotNullParameter((Object)Transformer.this, (String)"this$0");
            }

            @Override
            @NotNull
            public BasicValue newOperation(@NotNull AbstractInsnNode insn) {
                Object object;
                ProperTrackedReferenceValue properTrackedReferenceValue;
                Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                Object object2 = Transformer.this.refValuesByNewInsn;
                boolean bl = false;
                CapturedVarDescriptor capturedVarDescriptor = (CapturedVarDescriptor)object2.get(insn);
                if (capturedVarDescriptor == null) {
                    properTrackedReferenceValue = null;
                } else {
                    object2 = capturedVarDescriptor;
                    bl = false;
                    boolean bl2 = false;
                    Object descriptor2 = object2;
                    boolean bl3 = false;
                    properTrackedReferenceValue = new ProperTrackedReferenceValue(((CapturedVarDescriptor)descriptor2).getRefType(), (ReferenceValueDescriptor)descriptor2);
                }
                ProperTrackedReferenceValue properTrackedReferenceValue2 = properTrackedReferenceValue;
                if (properTrackedReferenceValue2 == null) {
                    capturedVarDescriptor = super.newOperation(insn);
                    Intrinsics.checkNotNullExpressionValue((Object)capturedVarDescriptor, (String)"super.newOperation(insn)");
                    object = capturedVarDescriptor;
                } else {
                    object = properTrackedReferenceValue2;
                }
                return object;
            }

            @Override
            protected void processRefValueUsage(@NotNull TrackedReferenceValue value2, @NotNull AbstractInsnNode insn, int position) {
                Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
                Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                for (ReferenceValueDescriptor descriptor2 : value2.getDescriptors()) {
                    if (!(descriptor2 instanceof CapturedVarDescriptor)) {
                        throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected descriptor: ", (Object)descriptor2));
                    }
                    if (insn.getOpcode() == 25) {
                        ((CapturedVarDescriptor)descriptor2).getAloadInsns().add((VarInsnNode)insn);
                        continue;
                    }
                    if (insn.getOpcode() == 58) {
                        ((CapturedVarDescriptor)descriptor2).getAstoreInsns().add((VarInsnNode)insn);
                        continue;
                    }
                    if (insn.getOpcode() == 180 && insn instanceof FieldInsnNode && Intrinsics.areEqual((Object)((FieldInsnNode)insn).name, (Object)"element") && position == 0) {
                        ((CapturedVarDescriptor)descriptor2).getGetFieldInsns().add((FieldInsnNode)insn);
                        continue;
                    }
                    if (insn.getOpcode() == 181 && insn instanceof FieldInsnNode && Intrinsics.areEqual((Object)((FieldInsnNode)insn).name, (Object)"element") && position == 0) {
                        ((CapturedVarDescriptor)descriptor2).getPutFieldInsns().add((FieldInsnNode)insn);
                        continue;
                    }
                    if (insn.getOpcode() == 183 && insn instanceof MethodInsnNode && Intrinsics.areEqual((Object)((MethodInsnNode)insn).name, (Object)"<init>") && position == 0) {
                        if (((CapturedVarDescriptor)descriptor2).getInitCallInsn() != null && !Intrinsics.areEqual((Object)((CapturedVarDescriptor)descriptor2).getInitCallInsn(), (Object)insn)) {
                            ((CapturedVarDescriptor)descriptor2).setHazard(true);
                            continue;
                        }
                        ((CapturedVarDescriptor)descriptor2).setInitCallInsn((MethodInsnNode)insn);
                        continue;
                    }
                    if (insn.getOpcode() == 89) {
                        ((CapturedVarDescriptor)descriptor2).getStackInsns().add(insn);
                        continue;
                    }
                    ((CapturedVarDescriptor)descriptor2).setHazard(true);
                }
            }
        }
    }
}

