/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Manifest;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.BytesUrlUtils;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

public class GeneratedClassLoader
extends URLClassLoader {
    private ClassFileFactory factory;

    public GeneratedClassLoader(@NotNull ClassFileFactory factory2, ClassLoader parentClassLoader, URL ... urls) {
        if (factory2 == null) {
            GeneratedClassLoader.$$$reportNull$$$0(0);
        }
        super(urls, parentClassLoader);
        this.factory = factory2;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        OutputFile outputFile = this.factory.get(name);
        if (outputFile != null) {
            return new ByteArrayInputStream(outputFile.asByteArray());
        }
        return super.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> fromParent = super.findResources(name);
        URL url = this.createFakeURLForResource(name);
        if (url == null) {
            return fromParent;
        }
        List fromMe = Collections.singletonList(url);
        List result2 = fromParent.hasMoreElements() ? CollectionsKt.plus(fromMe, Collections.list(fromParent)) : fromMe;
        return Collections.enumeration(result2);
    }

    @Override
    public URL findResource(String name) {
        URL url = this.createFakeURLForResource(name);
        return url != null ? url : super.findResource(name);
    }

    @Nullable
    private URL createFakeURLForResource(@NotNull String name) {
        if (name == null) {
            GeneratedClassLoader.$$$reportNull$$$0(1);
        }
        try {
            OutputFile outputFile = this.factory.get(name);
            return outputFile == null ? null : BytesUrlUtils.createBytesUrl(outputFile.asByteArray());
        }
        catch (IOException e) {
            throw ExceptionUtilsKt.rethrow(e);
        }
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        String classFilePath;
        OutputFile outputFile;
        if (name == null) {
            GeneratedClassLoader.$$$reportNull$$$0(2);
        }
        if ((outputFile = this.factory.get(classFilePath = name.replace('.', '/') + ".class")) != null) {
            String pkgName;
            byte[] bytes2 = outputFile.asByteArray();
            int lastDot = name.lastIndexOf(46);
            if (lastDot >= 0 && this.getPackage(pkgName = name.substring(0, lastDot)) == null) {
                this.definePackage(pkgName, new Manifest(), null);
            }
            Class<?> clazz = this.defineClass(name, bytes2, 0, bytes2.length);
            if (clazz == null) {
                GeneratedClassLoader.$$$reportNull$$$0(3);
            }
            return clazz;
        }
        Class<?> clazz = super.findClass(name);
        if (clazz == null) {
            GeneratedClassLoader.$$$reportNull$$$0(4);
        }
        return clazz;
    }

    public void dispose() {
        this.factory = null;
    }

    @NotNull
    public List<OutputFile> getAllGeneratedFiles() {
        List<OutputFile> list2 = this.factory.asList();
        if (list2 == null) {
            GeneratedClassLoader.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/GeneratedClassLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/GeneratedClassLoader";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllGeneratedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFakeURLForResource";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

