/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public class OperatorConventions {
    public static final Name DOUBLE = Name.identifier("toDouble");
    public static final Name FLOAT = Name.identifier("toFloat");
    public static final Name LONG = Name.identifier("toLong");
    public static final Name INT = Name.identifier("toInt");
    public static final Name CHAR = Name.identifier("toChar");
    public static final Name SHORT = Name.identifier("toShort");
    public static final Name BYTE = Name.identifier("toByte");
    public static final ImmutableSet<Name> NUMBER_CONVERSIONS = ImmutableSet.of((Object)DOUBLE, (Object)FLOAT, (Object)LONG, (Object)INT, (Object)SHORT, (Object)BYTE, (Object[])new Name[]{CHAR});
    public static final ImmutableBiMap<KtSingleValueToken, Name> UNARY_OPERATION_NAMES = ImmutableBiMap.builder().put((Object)KtTokens.PLUSPLUS, (Object)OperatorNameConventions.INC).put((Object)KtTokens.MINUSMINUS, (Object)OperatorNameConventions.DEC).put((Object)KtTokens.PLUS, (Object)OperatorNameConventions.UNARY_PLUS).put((Object)KtTokens.MINUS, (Object)OperatorNameConventions.UNARY_MINUS).put((Object)KtTokens.EXCL, (Object)OperatorNameConventions.NOT).build();
    public static final ImmutableBiMap<KtSingleValueToken, Name> BINARY_OPERATION_NAMES = ImmutableBiMap.builder().put((Object)KtTokens.MUL, (Object)OperatorNameConventions.TIMES).put((Object)KtTokens.PLUS, (Object)OperatorNameConventions.PLUS).put((Object)KtTokens.MINUS, (Object)OperatorNameConventions.MINUS).put((Object)KtTokens.DIV, (Object)OperatorNameConventions.DIV).put((Object)KtTokens.PERC, (Object)OperatorNameConventions.REM).put((Object)KtTokens.RANGE, (Object)OperatorNameConventions.RANGE_TO).build();
    public static final ImmutableBiMap<Name, Name> REM_TO_MOD_OPERATION_NAMES = ImmutableBiMap.builder().put((Object)OperatorNameConventions.REM, (Object)OperatorNameConventions.MOD).put((Object)OperatorNameConventions.REM_ASSIGN, (Object)OperatorNameConventions.MOD_ASSIGN).build();
    public static final ImmutableSet<KtSingleValueToken> NOT_OVERLOADABLE = ImmutableSet.of((Object)((Object)KtTokens.ANDAND), (Object)((Object)KtTokens.OROR), (Object)((Object)KtTokens.ELVIS), (Object)((Object)KtTokens.EQEQEQ), (Object)((Object)KtTokens.EXCLEQEQEQ));
    public static final ImmutableSet<KtSingleValueToken> INCREMENT_OPERATIONS = ImmutableSet.of((Object)((Object)KtTokens.PLUSPLUS), (Object)((Object)KtTokens.MINUSMINUS));
    public static final ImmutableSet<KtSingleValueToken> COMPARISON_OPERATIONS = ImmutableSet.of((Object)((Object)KtTokens.LT), (Object)((Object)KtTokens.GT), (Object)((Object)KtTokens.LTEQ), (Object)((Object)KtTokens.GTEQ));
    public static final ImmutableSet<KtSingleValueToken> EQUALS_OPERATIONS = ImmutableSet.of((Object)((Object)KtTokens.EQEQ), (Object)((Object)KtTokens.EXCLEQ));
    public static final ImmutableSet<KtSingleValueToken> IDENTITY_EQUALS_OPERATIONS = ImmutableSet.of((Object)((Object)KtTokens.EQEQEQ), (Object)((Object)KtTokens.EXCLEQEQEQ));
    public static final ImmutableSet<KtSingleValueToken> IN_OPERATIONS = ImmutableSet.of((Object)((Object)KtTokens.IN_KEYWORD), (Object)((Object)KtTokens.NOT_IN));
    public static final ImmutableBiMap<KtSingleValueToken, Name> ASSIGNMENT_OPERATIONS = ImmutableBiMap.builder().put((Object)KtTokens.MULTEQ, (Object)OperatorNameConventions.TIMES_ASSIGN).put((Object)KtTokens.DIVEQ, (Object)OperatorNameConventions.DIV_ASSIGN).put((Object)KtTokens.PERCEQ, (Object)OperatorNameConventions.REM_ASSIGN).put((Object)KtTokens.PLUSEQ, (Object)OperatorNameConventions.PLUS_ASSIGN).put((Object)KtTokens.MINUSEQ, (Object)OperatorNameConventions.MINUS_ASSIGN).build();
    public static final ImmutableBiMap<KtSingleValueToken, KtSingleValueToken> ASSIGNMENT_OPERATION_COUNTERPARTS = ImmutableBiMap.builder().put((Object)KtTokens.MULTEQ, (Object)KtTokens.MUL).put((Object)KtTokens.DIVEQ, (Object)KtTokens.DIV).put((Object)KtTokens.PERCEQ, (Object)KtTokens.PERC).put((Object)KtTokens.PLUSEQ, (Object)KtTokens.PLUS).put((Object)KtTokens.MINUSEQ, (Object)KtTokens.MINUS).build();
    public static final ImmutableBiMap<KtSingleValueToken, Name> BOOLEAN_OPERATIONS = ImmutableBiMap.builder().put((Object)KtTokens.ANDAND, (Object)OperatorNameConventions.AND).put((Object)KtTokens.OROR, (Object)OperatorNameConventions.OR).build();
    public static final ImmutableSet<Name> CONVENTION_NAMES = ImmutableSet.builder().add((Object[])new Name[]{OperatorNameConventions.GET, OperatorNameConventions.SET, OperatorNameConventions.INVOKE, OperatorNameConventions.CONTAINS, OperatorNameConventions.ITERATOR, OperatorNameConventions.NEXT, OperatorNameConventions.HAS_NEXT, OperatorNameConventions.EQUALS, OperatorNameConventions.COMPARE_TO, OperatorNameConventions.GET_VALUE, OperatorNameConventions.SET_VALUE}).addAll((Iterable)UNARY_OPERATION_NAMES.values()).addAll((Iterable)BINARY_OPERATION_NAMES.values()).addAll((Iterable)ASSIGNMENT_OPERATIONS.values()).build();

    private OperatorConventions() {
    }

    @Nullable
    public static Name getNameForOperationSymbol(@NotNull KtToken token) {
        if (token == null) {
            OperatorConventions.$$$reportNull$$$0(0);
        }
        return OperatorConventions.getNameForOperationSymbol(token, true, true);
    }

    @Nullable
    public static Name getNameForOperationSymbol(@NotNull KtToken token, boolean unaryOperations2, boolean binaryOperations2) {
        Name name;
        if (token == null) {
            OperatorConventions.$$$reportNull$$$0(1);
        }
        if (binaryOperations2 && (name = (Name)BINARY_OPERATION_NAMES.get((Object)token)) != null) {
            return name;
        }
        if (unaryOperations2 && (name = (Name)UNARY_OPERATION_NAMES.get((Object)token)) != null) {
            return name;
        }
        name = (Name)ASSIGNMENT_OPERATIONS.get((Object)token);
        if (name != null) {
            return name;
        }
        if (COMPARISON_OPERATIONS.contains((Object)token)) {
            return OperatorNameConventions.COMPARE_TO;
        }
        if (EQUALS_OPERATIONS.contains((Object)token)) {
            return OperatorNameConventions.EQUALS;
        }
        if (IN_OPERATIONS.contains((Object)token)) {
            return OperatorNameConventions.CONTAINS;
        }
        return null;
    }

    @Nullable
    public static KtToken getOperationSymbolForName(@NotNull Name name) {
        if (name == null) {
            OperatorConventions.$$$reportNull$$$0(2);
        }
        if (!OperatorConventions.isConventionName(name)) {
            return null;
        }
        KtToken token = (KtToken)((Object)BINARY_OPERATION_NAMES.inverse().get((Object)name));
        if (token != null) {
            return token;
        }
        token = (KtToken)((Object)UNARY_OPERATION_NAMES.inverse().get((Object)name));
        if (token != null) {
            return token;
        }
        token = (KtToken)((Object)ASSIGNMENT_OPERATIONS.inverse().get((Object)name));
        if (token != null) {
            return token;
        }
        return null;
    }

    public static boolean isConventionName(@NotNull Name name) {
        if (name == null) {
            OperatorConventions.$$$reportNull$$$0(3);
        }
        return CONVENTION_NAMES.contains((Object)name) || OperatorNameConventions.COMPONENT_REGEX.matches((CharSequence)name.asString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/types/expressions/OperatorConventions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getNameForOperationSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getOperationSymbolForName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isConventionName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

