/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.extensions.internal.TypeResolutionInterceptor;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerBuilder;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tower.KotlinResolutionCallbacksImpl;
import org.jetbrains.kotlin.resolve.checkers.TrailingCommaChecker;
import org.jetbrains.kotlin.resolve.checkers.UnderscoreChecker;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitor;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitorKt;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.ValueParameterResolver;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0018\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J$\u0010\u001e\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0011H\u0002J,\u0010 \u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010!\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010&\u001a\u00020%2\u0006\u0010\f\u001a\u00020'2\u0006\u0010(\u001a\u00020\bH\u0016J(\u0010&\u001a\u00020%2\u0006\u0010\f\u001a\u00020'2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u001d2\b\u0010*\u001a\u0004\u0018\u00010+J\f\u0010,\u001a\u00020\u001d*\u00020\u0011H\u0002J\f\u0010-\u001a\u00020\u001d*\u00020\u0011H\u0002\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/types/expressions/FunctionsTypingVisitor;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingVisitor;", "facade", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;)V", "checkReservedYield", "", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "expression", "Lcom/intellij/psi/PsiElement;", "checkTypesForReturnStatements", "function", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "actualReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "collectReturns", "", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "computeReturnType", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;", "functionTypeExpected", "", "computeReturnTypeBasedOnReturnExpressions", "typeOfBodyExpression", "computeUnsafeReturnType", "expectedReturnType", "createFunctionLiteralDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/AnonymousFunctionDescriptor;", "visitLambdaExpression", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "data", "isDeclaration", "statementScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "isBuiltinFunctionalType", "isSuspendFunctionType", "frontend"})
public final class FunctionsTypingVisitor
extends ExpressionTypingVisitor {
    public FunctionsTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        super(facade);
    }

    @Override
    @NotNull
    public KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull ExpressionTypingContext data) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.visitNamedFunction(function2, data, false, null);
    }

    @NotNull
    public final KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull ExpressionTypingContext context2, boolean isDeclaration, @Nullable LexicalWritableScope statementScope) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!isDeclaration) {
            if (!function2.getTypeParameters().isEmpty()) {
                context2.trace.report(Errors.TYPE_PARAMETERS_NOT_ALLOWED.on((KtDeclaration)((PsiElement)function2)));
            }
            if (function2.getName() != null) {
                BindingTrace bindingTrace = context2.trace;
                PsiElement psiElement = function2.getNameIdentifier();
                Intrinsics.checkNotNull((Object)psiElement);
                bindingTrace.report(Errors.ANONYMOUS_FUNCTION_WITH_NAME.on(psiElement));
            }
            for (KtParameter ktParameter : function2.getValueParameters()) {
                if (ktParameter.hasDefaultValue()) {
                    context2.trace.report(Errors.ANONYMOUS_FUNCTION_PARAMETER_WITH_DEFAULT_VALUE.on((KtParameter)((PsiElement)ktParameter)));
                }
                if (!ktParameter.isVarArg()) continue;
                context2.trace.report(Errors.USELESS_VARARG_ON_PARAMETER.on((KtParameter)((PsiElement)ktParameter)));
            }
        }
        SimpleFunctionDescriptor functionDescriptor = null;
        if (isDeclaration) {
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context2.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context2.scope;
            Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"context.scope");
            BindingTrace bindingTrace = context2.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
            DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"context.dataFlowInfo");
            functionDescriptor = functionDescriptorResolver.resolveFunctionDescriptor(declarationDescriptor, lexicalScope, function2, bindingTrace, dataFlowInfo);
            boolean bl = statementScope != null;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-FunctionsTypingVisitor$visitNamedFunction$232 = false;
                String $i$a$-assert-FunctionsTypingVisitor$visitNamedFunction$232 = "statementScope must be not null for function: " + function2.getName() + " at location " + PsiDiagnosticUtils.atLocation(function2);
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-FunctionsTypingVisitor$visitNamedFunction$232));
            }
            Intrinsics.checkNotNull((Object)statementScope);
            statementScope.addFunctionDescriptor(functionDescriptor);
        } else {
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context2.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context2.scope;
            Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"context.scope");
            BindingTrace bindingTrace = context2.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
            DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"context.dataFlowInfo");
            KotlinType kotlinType = context2.expectedType;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"context.expectedType");
            functionDescriptor = functionDescriptorResolver.resolveFunctionExpressionDescriptor(declarationDescriptor, lexicalScope, function2, bindingTrace, dataFlowInfo, kotlinType);
        }
        ForceResolveUtil.forceResolveAllContents(functionDescriptor.getAnnotations());
        Object object2 = FunctionDescriptorUtil.getFunctionInnerScope(context2.scope, functionDescriptor, context2.trace, this.components.overloadChecker);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getFunctionInnerScope(context.scope, functionDescriptor, context.trace, components.overloadChecker)");
        LexicalScope lexicalScope = object2;
        if (!function2.hasDeclaredReturnType() && !function2.hasBlockBody()) {
            ForceResolveUtil.forceResolveAllContents(functionDescriptor.getReturnType());
        } else {
            this.components.expressionTypingServices.checkFunctionReturnType(lexicalScope, function2, functionDescriptor, context2.dataFlowInfo, null, context2.trace);
        }
        ValueParameterResolver valueParameterResolver = this.components.valueParameterResolver;
        object2 = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"function.valueParameters");
        List<ValueParameterDescriptor> list2 = object2;
        object2 = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(object2, (String)"functionDescriptor.valueParameters");
        List<ValueParameterDescriptor> list3 = object2;
        object2 = context2.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.dataFlowInfo");
        Object object3 = object2;
        object2 = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.trace");
        valueParameterResolver.resolveValueParameters(list2, list3, lexicalScope, (DataFlowInfo)object3, (BindingTrace)object2);
        this.components.modifiersChecker.withTrace(context2.trace).checkModifiersForLocalDeclaration(function2, functionDescriptor);
        IdentifierChecker identifierChecker = this.components.identifierChecker;
        KtDeclaration ktDeclaration = function2;
        object2 = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.trace");
        identifierChecker.checkDeclaration(ktDeclaration, (DiagnosticSink)object2);
        DeclarationsCheckerBuilder declarationsCheckerBuilder = this.components.declarationsCheckerBuilder;
        object2 = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.trace");
        declarationsCheckerBuilder.withTrace((BindingTrace)object2).checkFunction(function2, functionDescriptor);
        if (isDeclaration) {
            object = TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(function2, context2), context2);
        } else {
            boolean newInferenceEnabled = this.components.languageVersionSettings.supportsFeature(LanguageFeature.NewInference);
            Object object4 = this.components.builtIns;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"components.builtIns");
            KotlinType resultType = FunctionsTypingVisitorKt.createFunctionType$default(functionDescriptor, (KotlinBuiltIns)object4, false, false, 4, null);
            if (newInferenceEnabled) {
                object4 = context2.expectedType;
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"context.expectedType");
                if (!TypeUtilsKt.contains((KotlinType)object4, (Function1<? super UnwrappedType, Boolean>)((Function1)visitNamedFunction.2.INSTANCE))) {
                    KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinBuiltIns, (String)"components.builtIns");
                    KotlinType typeToTypeCheck = FunctionsTypingVisitorKt.createFunctionType(functionDescriptor, kotlinBuiltIns, false, true);
                    this.components.dataFlowAnalyzer.checkType(typeToTypeCheck, (KtExpression)function2, (ResolutionContext)context2);
                }
                object = TypeInfoFactoryKt.createTypeInfo(resultType, context2);
            } else {
                object4 = this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context2, function2);
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"{\n                components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context, function)\n            }");
                object = object4;
            }
        }
        return object;
    }

    @Override
    @Nullable
    public KotlinTypeInfo visitLambdaExpression(@NotNull KtLambdaExpression expression2, @NotNull ExpressionTypingContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiElement psiElement = (PsiElement)expression2;
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
        ReservedCheckingKt.checkReservedYieldBeforeLambda(psiElement, bindingTrace);
        if (!expression2.getFunctionLiteral().hasBody()) {
            return null;
        }
        KotlinType kotlinType = context2.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"context.expectedType");
        KotlinType expectedType2 = kotlinType;
        boolean functionTypeExpected = this.isBuiltinFunctionalType(expectedType2);
        boolean suspendFunctionTypeExpected = this.isSuspendFunctionType(expectedType2);
        AnonymousFunctionDescriptor functionDescriptor = this.createFunctionLiteralDescriptor(expression2, context2);
        List<KtParameter> list2 = expression2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"expression.valueParameters");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            IdentifierChecker identifierChecker = this.components.identifierChecker;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            KtDeclaration ktDeclaration = it;
            Object object = context2.trace;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.trace");
            identifierChecker.checkDeclaration(ktDeclaration, (DiagnosticSink)object);
            KtNamedDeclaration ktNamedDeclaration = it;
            object = context2.trace;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.trace");
            DiagnosticSink diagnosticSink = (DiagnosticSink)object;
            object = this.components.languageVersionSettings;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"components.languageVersionSettings");
            UnderscoreChecker.INSTANCE.checkNamed(ktNamedDeclaration, diagnosticSink, (LanguageVersionSettings)object, true);
        }
        KtParameterList valueParameterList = expression2.getFunctionLiteral().getValueParameterList();
        Object $i$f$forEach22 = valueParameterList;
        if (($i$f$forEach22 == null ? null : (KotlinPlaceHolderStub)$i$f$forEach22.getStub()) == null) {
            $i$f$forEach22 = valueParameterList;
            PsiElement psiElement2 = $i$f$forEach22 == null ? null : ((KtParameterList)$i$f$forEach22).getTrailingComma();
            $i$f$forEach22 = context2.trace;
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach22, (String)"context.trace");
            Object object = $i$f$forEach22;
            $i$f$forEach22 = context2.languageVersionSettings;
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach22, (String)"context.languageVersionSettings");
            TrailingCommaChecker.INSTANCE.check(psiElement2, (BindingTrace)object, (LanguageVersionSettings)$i$f$forEach22);
        }
        KotlinType safeReturnType = this.computeReturnType(expression2, context2, functionDescriptor, functionTypeExpected);
        functionDescriptor.setReturnType(safeReturnType);
        TypeResolutionInterceptor typeResolutionInterceptor = this.components.typeResolutionInterceptor;
        KtElement ktElement = expression2;
        SimpleFunctionDescriptor simpleFunctionDescriptor = functionDescriptor;
        KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinBuiltIns, (String)"components.builtIns");
        KotlinType kotlinType2 = FunctionsTypingVisitorKt.createFunctionType$default(simpleFunctionDescriptor, kotlinBuiltIns, suspendFunctionTypeExpected, false, 4, null);
        Intrinsics.checkNotNull((Object)kotlinType2);
        KotlinType resultType = typeResolutionInterceptor.interceptType(ktElement, context2, kotlinType2);
        if (functionTypeExpected) {
            return TypeInfoFactoryKt.createTypeInfo(resultType, context2);
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context2, expression2);
    }

    private final void checkReservedYield(ExpressionTypingContext context2, PsiElement expression2) {
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
        ReservedCheckingKt.checkReservedPrefixWord(bindingTrace, expression2, "yield", "yield block/lambda. Use 'yield() { ... }' or 'yield(fun...)'");
    }

    private final AnonymousFunctionDescriptor createFunctionLiteralDescriptor(KtLambdaExpression expression2, ExpressionTypingContext context2) {
        KtFunctionLiteral ktFunctionLiteral = expression2.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"expression.functionLiteral");
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        DeclarationDescriptor declarationDescriptor = context2.scope.getOwnerDescriptor();
        AnnotationResolver annotationResolver = this.components.annotationResolver;
        Iterator<ValueParameterDescriptor> iterator2 = context2.scope;
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"context.scope");
        LexicalScope lexicalScope = iterator2;
        List<KtAnnotationEntry> list2 = KtPsiUtilKt.getAnnotationEntries(expression2);
        iterator2 = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"context.trace");
        Annotations annotations2 = annotationResolver.resolveAnnotationsWithArguments(lexicalScope, list2, (BindingTrace)((Object)iterator2));
        SourceElement sourceElement = KotlinSourceElementKt.toSourceElement(functionLiteral);
        iterator2 = context2.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"context.expectedType");
        iterator2 = new AnonymousFunctionDescriptor(declarationDescriptor, annotations2, CallableMemberDescriptor.Kind.DECLARATION, sourceElement, this.isSuspendFunctionType((KotlinType)((Object)iterator2)));
        boolean bl = false;
        boolean bl2 = false;
        Iterator<ValueParameterDescriptor> it = iterator2;
        boolean bl3 = false;
        AnonymousFunctionDescriptor functionDescriptor = this.facade.getComponents().typeResolutionInterceptor.interceptFunctionLiteralDescriptor(expression2, context2, (AnonymousFunctionDescriptor)((Object)it));
        FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
        DeclarationDescriptor declarationDescriptor2 = context2.scope.getOwnerDescriptor();
        iterator2 = context2.scope;
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"context.scope");
        Iterator<ValueParameterDescriptor> iterator3 = iterator2;
        KtFunction ktFunction = functionLiteral;
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        iterator2 = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"context.trace");
        Iterator<ValueParameterDescriptor> iterator4 = iterator2;
        iterator2 = context2.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"context.expectedType");
        Iterator<ValueParameterDescriptor> iterator5 = iterator2;
        iterator2 = context2.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"context.dataFlowInfo");
        functionDescriptorResolver.initializeFunctionDescriptorAndExplicitReturnType(declarationDescriptor2, (LexicalScope)((Object)iterator3), ktFunction, simpleFunctionDescriptorImpl, (BindingTrace)((Object)iterator4), (KotlinType)((Object)iterator5), (DataFlowInfo)((Object)iterator2));
        for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
            ForceResolveUtil.forceResolveAllContents(parameterDescriptor.getAnnotations());
        }
        BindingContextUtils.recordFunctionDeclarationToDescriptor(context2.trace, functionLiteral, functionDescriptor);
        return functionDescriptor;
    }

    private final boolean isBuiltinFunctionalType(KotlinType $this$isBuiltinFunctionalType) {
        return !TypeUtils.noExpectedType($this$isBuiltinFunctionalType) && FunctionTypesKt.isBuiltinFunctionalType($this$isBuiltinFunctionalType);
    }

    private final boolean isSuspendFunctionType(KotlinType $this$isSuspendFunctionType) {
        return !TypeUtils.noExpectedType($this$isSuspendFunctionType) && FunctionTypesKt.isSuspendFunctionType($this$isSuspendFunctionType);
    }

    private final KotlinType computeReturnType(KtLambdaExpression expression2, ExpressionTypingContext context2, SimpleFunctionDescriptorImpl functionDescriptor, boolean functionTypeExpected) {
        KotlinType kotlinType;
        KotlinType kotlinType2;
        KotlinType kotlinType3;
        if (functionTypeExpected) {
            KotlinType kotlinType4 = context2.expectedType;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType4, (String)"context.expectedType");
            kotlinType3 = FunctionTypesKt.getReturnTypeFromFunctionType(kotlinType4);
        } else {
            kotlinType3 = null;
        }
        KotlinType expectedReturnType = kotlinType3;
        KotlinType returnType2 = this.computeUnsafeReturnType(expression2, context2, functionDescriptor, expectedReturnType);
        if (!expression2.getFunctionLiteral().hasDeclaredReturnType() && functionTypeExpected) {
            Intrinsics.checkNotNull((Object)expectedReturnType);
            if (!TypeUtils.noExpectedType(expectedReturnType) && KotlinBuiltIns.isUnit(expectedReturnType)) {
                SimpleType simpleType2 = this.components.builtIns.getUnitType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"components.builtIns.unitType");
                return simpleType2;
            }
        }
        if ((kotlinType2 = returnType2) == null) {
            SimpleType simpleType3 = TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"CANT_INFER_FUNCTION_PARAM_TYPE");
            kotlinType = simpleType3;
        } else {
            kotlinType = kotlinType2;
        }
        return kotlinType;
    }

    private final KotlinType computeUnsafeReturnType(KtLambdaExpression expression2, ExpressionTypingContext context2, SimpleFunctionDescriptorImpl functionDescriptor, KotlinType expectedReturnType) {
        KotlinType kotlinType;
        Object object;
        KtFunctionLiteral ktFunctionLiteral = expression2.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"expression.functionLiteral");
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        KotlinType kotlinType2 = expectedReturnType;
        if (kotlinType2 == null) {
            object = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NO_EXPECTED_TYPE");
            kotlinType = (KotlinType)object;
        } else {
            kotlinType = kotlinType2;
        }
        KotlinType expectedType2 = kotlinType;
        object = FunctionDescriptorUtil.getFunctionInnerScope(context2.scope, functionDescriptor, context2.trace, this.components.overloadChecker);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getFunctionInnerScope(context.scope, functionDescriptor, context.trace, components.overloadChecker)");
        Object functionInnerScope = object;
        Object Context2 = ((ExpressionTypingContext)context2.replaceScope((LexicalScope)functionInnerScope)).replaceExpectedType(expectedType2);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"context.replaceScope(functionInnerScope).replaceExpectedType(expectedType)");
        ExpressionTypingContext newContext = (ExpressionTypingContext)Context2;
        context2.trace.record(BindingContext.EXPECTED_RETURN_TYPE, functionLiteral, expectedType2);
        KotlinResolutionCallbacksImpl.LambdaInfo newInferenceLambdaInfo = (KotlinResolutionCallbacksImpl.LambdaInfo)context2.trace.get(BindingContext.NEW_INFERENCE_LAMBDA_INFO, expression2.getFunctionLiteral());
        if (newInferenceLambdaInfo == null && context2.languageVersionSettings.supportsFeature(LanguageFeature.NewInference)) {
            Object Context3 = newContext.replaceContextDependency(ContextDependency.INDEPENDENT);
            Intrinsics.checkNotNullExpressionValue(Context3, (String)"newContext.replaceContextDependency(ContextDependency.INDEPENDENT)");
            newContext = (ExpressionTypingContext)Context3;
        }
        ExpressionTypingServices expressionTypingServices = this.components.expressionTypingServices;
        Object object2 = functionLiteral.getBodyExpression();
        Intrinsics.checkNotNull((Object)object2);
        KotlinTypeInfo kotlinTypeInfo = expressionTypingServices.getBlockReturnedType((KtBlockExpression)object2, CoercionStrategy.COERCION_TO_UNIT, newContext);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo, (String)"components.expressionTypingServices.getBlockReturnedType(functionLiteral.bodyExpression!!, COERCION_TO_UNIT, newContext)");
        KotlinTypeInfo blockReturnedType = kotlinTypeInfo;
        KotlinType typeOfBodyExpression = blockReturnedType.getType();
        object2 = newInferenceLambdaInfo;
        if (object2 != null) {
            Object object3 = object2;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object3;
            boolean bl3 = false;
            ((KotlinResolutionCallbacksImpl.LambdaInfo)it).getLastExpressionInfo().setDataFlowInfoAfter(blockReturnedType.getDataFlowInfo());
        }
        return this.computeReturnTypeBasedOnReturnExpressions(functionLiteral, context2, typeOfBodyExpression);
    }

    private final KotlinType computeReturnTypeBasedOnReturnExpressions(KtFunctionLiteral functionLiteral, ExpressionTypingContext context2, KotlinType typeOfBodyExpression) {
        boolean bl;
        ArrayList returnedExpressionTypes;
        block9: {
            KtExpression returnedExpression;
            returnedExpressionTypes = Lists.newArrayList();
            boolean hasEmptyReturn = false;
            Iterator<KtReturnExpression> iterator2 = context2.trace;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"context.trace");
            Collection<KtReturnExpression> returnExpressions = this.collectReturns(functionLiteral, (BindingTrace)((Object)iterator2));
            for (KtReturnExpression returnExpression : returnExpressions) {
                returnedExpression = returnExpression.getReturnedExpression();
                if (returnedExpression == null) {
                    hasEmptyReturn = true;
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)returnedExpressionTypes, (String)"returnedExpressionTypes");
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(returnedExpressionTypes, context2.trace.getType(returnedExpression));
            }
            if (hasEmptyReturn) {
                for (KtReturnExpression returnExpression : returnExpressions) {
                    KotlinType type2;
                    returnedExpression = returnExpression.getReturnedExpression();
                    if (returnedExpression == null || (type2 = context2.trace.getType(returnedExpression)) != null && KotlinBuiltIns.isUnit(type2)) continue;
                    context2.trace.report(Errors.RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)returnedExpression), this.components.builtIns.getUnitType()));
                }
                return this.components.builtIns.getUnitType();
            }
            Intrinsics.checkNotNullExpressionValue((Object)returnedExpressionTypes, (String)"returnedExpressionTypes");
            org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(returnedExpressionTypes, typeOfBodyExpression);
            if (returnedExpressionTypes.isEmpty()) {
                return null;
            }
            Iterable $this$any$iv = returnedExpressionTypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!TypeUtilsKt.contains(it, (Function1<? super UnwrappedType, Boolean>)((Function1)computeReturnTypeBasedOnReturnExpressions.1.1.INSTANCE))) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        return CommonSupertypes.commonSupertype(returnedExpressionTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KtReturnExpression> collectReturns(KtFunctionLiteral functionLiteral, BindingTrace trace) {
        void $this$filterTo$iv$iv;
        ArrayList result2 = Lists.newArrayList();
        KtBlockExpression bodyExpression = functionLiteral.getBodyExpression();
        KtBlockExpression ktBlockExpression = bodyExpression;
        if (ktBlockExpression != null) {
            Void cfr_ignored_0 = (Void)ktBlockExpression.accept((KtVisitor)new KtTreeVisitor<List<KtReturnExpression>>(){

                @Nullable
                public Void visitReturnExpression(@NotNull KtReturnExpression expression2, @NotNull List<KtReturnExpression> insideActualFunction) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    Intrinsics.checkNotNullParameter(insideActualFunction, (String)"insideActualFunction");
                    insideActualFunction.add(expression2);
                    return null;
                }
            }, result2);
        }
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result");
        Iterable $this$filter$iv = result2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement psiElement;
            KtReturnExpression it = (KtReturnExpression)element$iv$iv;
            boolean bl = false;
            KtSimpleNameExpression ktSimpleNameExpression = it.getTargetLabel();
            if (ktSimpleNameExpression == null) {
                psiElement = null;
            } else {
                KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression;
                boolean bl2 = false;
                boolean bl3 = false;
                KtSimpleNameExpression it2 = ktSimpleNameExpression2;
                boolean bl4 = false;
                psiElement = (PsiElement)trace.get(BindingContext.LABEL_TARGET, it2);
            }
            if (!Intrinsics.areEqual(psiElement, (Object)functionLiteral)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void checkTypesForReturnStatements(@NotNull KtDeclarationWithBody function2, @NotNull BindingTrace trace, @NotNull KotlinType actualReturnType) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)actualReturnType, (String)"actualReturnType");
        if (function2.hasBlockBody()) {
            return;
        }
        if (!(function2 instanceof KtNamedFunction && ((KtNamedFunction)function2).getTypeReference() == null || function2 instanceof KtPropertyAccessor && ((KtPropertyAccessor)function2).getReturnTypeReference() != null)) {
            return;
        }
        for (KtReturnExpression returnForCheck : this.collectReturns(function2, trace)) {
            KotlinType kotlinType;
            KotlinType expressionType;
            KtExpression expression2 = returnForCheck.getReturnedExpression();
            if (expression2 == null) {
                if (TypeUtilsKt.isUnit(actualReturnType)) continue;
                trace.report(Errors.RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)returnForCheck), actualReturnType));
                continue;
            }
            KotlinType kotlinType2 = trace.getType(expression2);
            if (kotlinType2 == null || KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType = (kotlinType = kotlinType2), actualReturnType)) continue;
            trace.report(Errors.TYPE_MISMATCH.on((KtExpression)((PsiElement)expression2), expressionType, actualReturnType));
        }
    }

    private final List<KtReturnExpression> collectReturns(KtDeclarationWithBody function2, BindingTrace trace) {
        KtExpression ktExpression;
        KtExpression ktExpression2 = function2.getBodyExpression();
        if (ktExpression2 == null) {
            return CollectionsKt.emptyList();
        }
        KtExpression bodyExpression = ktExpression = ktExpression2;
        ArrayList<KtReturnExpression> returns = new ArrayList<KtReturnExpression>();
        bodyExpression.accept((KtVisitor)new KtTreeVisitor<Boolean>(function2, returns, trace){
            final /* synthetic */ KtDeclarationWithBody $function;
            final /* synthetic */ ArrayList<KtReturnExpression> $returns;
            final /* synthetic */ BindingTrace $trace;
            {
                this.$function = $function;
                this.$returns = $returns;
                this.$trace = $trace;
            }

            @Nullable
            public Void visitReturnExpression(@NotNull KtReturnExpression expression2, boolean insideActualFunction) {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                KtSimpleNameExpression ktSimpleNameExpression = expression2.getTargetLabel();
                if (ktSimpleNameExpression == null) {
                    psiElement = null;
                } else {
                    KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression;
                    BindingTrace bindingTrace = this.$trace;
                    boolean bl = false;
                    boolean bl2 = false;
                    KtSimpleNameExpression it = ktSimpleNameExpression2;
                    boolean bl3 = false;
                    psiElement = (PsiElement)bindingTrace.get(BindingContext.LABEL_TARGET, it);
                }
                PsiElement labelTarget = psiElement;
                if (Intrinsics.areEqual(labelTarget, (Object)this.$function) || labelTarget == null && insideActualFunction) {
                    this.$returns.add(expression2);
                }
                return (Void)super.visitReturnExpression(expression2, insideActualFunction);
            }

            @Nullable
            public Void visitNamedFunction(@NotNull KtNamedFunction function2, boolean data) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                return (Void)super.visitNamedFunction(function2, false);
            }

            @Nullable
            public Void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor, boolean data) {
                Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
                return (Void)super.visitPropertyAccessor(accessor, false);
            }

            @Nullable
            public Void visitAnonymousInitializer(@NotNull KtAnonymousInitializer initializer2, boolean data) {
                Intrinsics.checkNotNullParameter((Object)initializer2, (String)"initializer");
                return (Void)super.visitAnonymousInitializer(initializer2, false);
            }
        }, true);
        return returns;
    }
}

