/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/FunInterfaceDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkSingleAbstractMember", "abstractMember", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "funInterfaceKeyword", "Lcom/intellij/psi/PsiElement;", "frontend"})
public final class FunInterfaceDeclarationChecker
implements DeclarationChecker {
    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable reportOn;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(declaration instanceof KtClass)) {
            return;
        }
        if (!(descriptor2 instanceof ClassDescriptor) || !((ClassDescriptor)descriptor2).isFun()) {
            return;
        }
        PsiElement psiElement = ((KtClass)declaration).getFunKeyword();
        if (psiElement == null) {
            return;
        }
        PsiElement funKeyword = psiElement;
        List<CallableMemberDescriptor> abstractMembers = SamConversionResolverImplKt.getAbstractMembers((ClassDescriptor)descriptor2);
        for (CallableMemberDescriptor abstractMember : abstractMembers) {
            PsiElement psiElement2;
            if (!(abstractMember instanceof PropertyDescriptor)) continue;
            boolean reportOnProperty = Intrinsics.areEqual((Object)((PropertyDescriptor)abstractMember).getContainingDeclaration(), (Object)descriptor2);
            if (reportOnProperty) {
                KtProperty ktProperty;
                SourceElement sourceElement = ((PropertyDescriptor)abstractMember).getSource();
                Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"abstractMember.source");
                PsiElement psiElement3 = KotlinSourceElementKt.getPsi(sourceElement);
                KtProperty ktProperty2 = ktProperty = psiElement3 instanceof KtProperty ? (KtProperty)psiElement3 : null;
                psiElement2 = ktProperty == null ? funKeyword : ((psiElement3 = ktProperty.getValOrVarKeyword()) == null ? funKeyword : psiElement3);
            } else {
                psiElement2 = funKeyword;
            }
            PsiElement psiElement4 = psiElement2;
            reportOn = psiElement4;
            context2.getTrace().report(Errors.FUN_INTERFACE_CANNOT_HAVE_ABSTRACT_PROPERTIES.on((PsiElement)reportOn));
            if (reportOnProperty) continue;
            return;
        }
        Iterable $this$filterIsInstance$iv = abstractMembers;
        boolean $i$f$filterIsInstance = false;
        reportOn = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FunctionDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        FunctionDescriptor abstractMember = (FunctionDescriptor)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        if (abstractMember == null) {
            context2.getTrace().report(Errors.FUN_INTERFACE_WRONG_COUNT_OF_ABSTRACT_MEMBERS.on(funKeyword));
            return;
        }
        this.checkSingleAbstractMember(abstractMember, funKeyword, context2);
    }

    private final void checkSingleAbstractMember(FunctionDescriptor abstractMember, PsiElement funInterfaceKeyword, DeclarationCheckerContext context2) {
        Object reportOn;
        KtNamedFunction ktFunction;
        SourceElement sourceElement = abstractMember.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"abstractMember.source");
        PsiElement psiElement = KotlinSourceElementKt.getPsi(sourceElement);
        KtNamedFunction ktNamedFunction = ktFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
        if (abstractMember.isSuspend()) {
            KtModifierList ktModifierList;
            KtNamedFunction ktNamedFunction2 = ktFunction;
            KtModifierList ktModifierList2 = ktModifierList = ktNamedFunction2 == null ? null : ktNamedFunction2.getModifierList();
            sourceElement = ktModifierList == null ? funInterfaceKeyword : ((ktNamedFunction2 = ktModifierList.getModifier(KtTokens.SUSPEND_KEYWORD)) == null ? funInterfaceKeyword : ktNamedFunction2);
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"ktFunction?.modifierList?.getModifier(KtTokens.SUSPEND_KEYWORD) ?: funInterfaceKeyword");
            reportOn = sourceElement;
            context2.getTrace().report(Errors.FUN_INTERFACE_WITH_SUSPEND_FUNCTION.on((PsiElement)reportOn));
            return;
        }
        reportOn = abstractMember.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(reportOn, (String)"abstractMember.typeParameters");
        reportOn = (Collection)reportOn;
        boolean bl = false;
        if (!reportOn.isEmpty()) {
            PsiElement psiElement2;
            KtTypeParameterList ktTypeParameterList;
            KtNamedFunction ktNamedFunction3 = ktFunction;
            KtTypeParameterList ktTypeParameterList2 = ktTypeParameterList = ktNamedFunction3 == null ? null : ktNamedFunction3.getTypeParameterList();
            PsiElement psiElement3 = ktTypeParameterList == null ? ((ktNamedFunction3 = ktFunction) == null ? funInterfaceKeyword : ((psiElement2 = ktNamedFunction3.getFunKeyword()) == null ? funInterfaceKeyword : psiElement2)) : (PsiElement)ktTypeParameterList;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"ktFunction?.typeParameterList ?: ktFunction?.funKeyword ?: funInterfaceKeyword");
            reportOn = psiElement3;
            context2.getTrace().report(Errors.FUN_INTERFACE_ABSTRACT_METHOD_WITH_TYPE_PARAMETERS.on((PsiElement)reportOn));
            return;
        }
        for (ValueParameterDescriptor parameter : abstractMember.getValueParameters()) {
            PsiElement psiElement4;
            Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
            if (!ArgumentsUtilsKt.hasDefaultValue(parameter)) continue;
            Object object = parameter.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameter.source");
            PsiElement psiElement5 = KotlinSourceElementKt.getPsi((SourceElement)object);
            PsiElement reportOn2 = psiElement5 == null ? ((object = ktFunction) == null ? funInterfaceKeyword : ((psiElement4 = ((KtNamedFunction)object).getFunKeyword()) == null ? funInterfaceKeyword : psiElement4)) : psiElement5;
            context2.getTrace().report(Errors.FUN_INTERFACE_ABSTRACT_METHOD_WITH_DEFAULT_VALUE.on(reportOn2));
            return;
        }
    }
}

