/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/OperatorCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "Companion", "frontend"})
public final class OperatorCallChecker
implements CallChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        boolean isConventionOperator;
        FunctionDescriptor functionDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = resolvedCall2.getResultingDescriptor();
        FunctionDescriptor functionDescriptor2 = functionDescriptor = object instanceof FunctionDescriptor ? (FunctionDescriptor)object : null;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor3 = functionDescriptor;
        if (!OperatorCallChecker.Companion.checkNotErrorOrDynamic(functionDescriptor3)) {
            return;
        }
        Object object2 = resolvedCall2.getCall().getCalleeExpression();
        object = object2 == null ? resolvedCall2.getCall().getCallElement() : (KtElement)object2;
        Intrinsics.checkNotNullExpressionValue(object, (String)"resolvedCall.call.calleeExpression ?: resolvedCall.call.callElement");
        Object element = object;
        object2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"resolvedCall.call");
        Object call2 = object2;
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall && call2 instanceof CallTransformer.CallForImplicitInvoke && ((CallTransformer.CallForImplicitInvoke)call2).itIsVariableAsFunctionCall) {
            Call call3 = ((CallTransformer.CallForImplicitInvoke)call2).getOuterCall();
            Intrinsics.checkNotNullExpressionValue((Object)call3, (String)"call.outerCall");
            Call outerCall = call3;
            if (CallResolverUtilKt.isConventionCall(outerCall)) {
                DeclarationDescriptor declarationDescriptor = functionDescriptor3.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"functionDescriptor.containingDeclaration");
                String string2 = DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"functionDescriptor.containingDeclaration.fqNameUnsafe.asString()");
                String containingDeclarationName = string2;
                context2.getTrace().report(Errors.PROPERTY_AS_OPERATOR.on(reportOn, functionDescriptor3, containingDeclarationName));
            } else if (OperatorCallChecker.Companion.isWrongCallWithExplicitTypeArguments((VariableAsFunctionResolvedCall)((Object)resolvedCall2), outerCall)) {
                throw new AssertionError((Object)("Illegal resolved call to variable with invoke for " + outerCall + ". Variable: " + ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getResultingDescriptor() + "Invoke: " + ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall().getResultingDescriptor()));
            }
        }
        if (call2.getCallElement() instanceof KtDestructuringDeclarationEntry || call2 instanceof CallTransformer.CallForImplicitInvoke) {
            if (!functionDescriptor3.isOperator()) {
                Companion.report(reportOn, functionDescriptor3, context2.getTrace());
            }
            return;
        }
        boolean bl = isConventionOperator = element instanceof KtOperationReferenceExpression && ((KtOperationReferenceExpression)element).isConventionOperator();
        if (isConventionOperator) {
            OperatorCallCheckerKt.access$checkModConvention(functionDescriptor3, context2.getLanguageVersionSettings(), context2.getTrace(), reportOn);
        }
        if ((isConventionOperator || element instanceof KtArrayAccessExpression) && !functionDescriptor3.isOperator()) {
            Companion.report(reportOn, functionDescriptor3, context2.getTrace());
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/OperatorCallChecker$Companion;", "", "()V", "checkNotErrorOrDynamic", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isWrongCallWithExplicitTypeArguments", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/VariableAsFunctionResolvedCall;", "outerCall", "Lorg/jetbrains/kotlin/psi/Call;", "report", "", "reportOn", "Lcom/intellij/psi/PsiElement;", "descriptor", "sink", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        public final void report(@NotNull PsiElement reportOn, @NotNull FunctionDescriptor descriptor2, @NotNull DiagnosticSink sink) {
            Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!this.checkNotErrorOrDynamic(descriptor2)) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
            DeclarationDescriptor containingDeclaration = declarationDescriptor;
            String string2 = DescriptorUtilsKt.getFqNameUnsafe(containingDeclaration).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"containingDeclaration.fqNameUnsafe.asString()");
            String containingDeclarationName = string2;
            sink.report(Errors.OPERATOR_MODIFIER_REQUIRED.on(reportOn, descriptor2, containingDeclarationName));
        }

        private final boolean checkNotErrorOrDynamic(FunctionDescriptor functionDescriptor) {
            return !DynamicCallsKt.isDynamic(functionDescriptor) && !ErrorUtils.isError(functionDescriptor);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isWrongCallWithExplicitTypeArguments(VariableAsFunctionResolvedCall resolvedCall2, Call outerCall) {
            Collection<KtTypeProjection> collection = outerCall.getTypeArguments();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"outerCall.typeArguments");
            collection = collection;
            boolean bl = false;
            if (collection.isEmpty()) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            collection = resolvedCall2.getFunctionCall().getCandidateDescriptor().getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"resolvedCall.functionCall.candidateDescriptor.typeParameters");
            bl = false;
            if (collection.isEmpty()) return false;
            boolean bl3 = true;
            if (!bl3) return false;
            boolean bl4 = true;
            boolean passedTypeArgumentsToInvoke = bl4;
            if (!passedTypeArgumentsToInvoke) return false;
            collection = resolvedCall2.getVariableCall().getCandidateDescriptor().getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"resolvedCall.variableCall.candidateDescriptor.typeParameters");
            bl = false;
            if (collection.isEmpty()) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

