/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.signaturer;

import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.signaturer.FirMangler;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "mangler", "Lorg/jetbrains/kotlin/fir/signaturer/FirMangler;", "(Lorg/jetbrains/kotlin/fir/signaturer/FirMangler;)V", "composeAccessorSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "isSetter", "", "containingClass", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "composeSignature", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "SignatureBuilder", "fir2ir"})
public final class FirBasedSignatureComposer
implements Fir2IrSignatureComposer {
    @NotNull
    private final FirMangler mangler;

    public FirBasedSignatureComposer(@NotNull FirMangler mangler) {
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        this.mangler = mangler;
    }

    @Override
    @Nullable
    public IdSignature composeSignature(@NotNull FirDeclaration declaration, @Nullable ConeClassLikeLookupTag containingClass) {
        IdSignature idSignature;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof FirAnonymousObject || declaration instanceof FirAnonymousFunction) {
            return null;
        }
        if (declaration instanceof FirRegularClass && FirDeclarationUtilKt.getClassId((FirClass)declaration).isLocal()) {
            return null;
        }
        if (declaration instanceof FirCallableMemberDeclaration) {
            Object $this$visibility$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$getVisibility = false;
            if (Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) {
                return null;
            }
            $this$visibility$iv = ClassMembersKt.dispatchReceiverClassOrNull(((FirCallableMemberDeclaration)declaration).getSymbol());
            if (Intrinsics.areEqual($this$visibility$iv == null ? null : (($i$f$getVisibility = ((ConeClassLikeLookupTag)$this$visibility$iv).getClassId()) == null ? null : Boolean.valueOf($i$f$getVisibility.isLocal())), (Object)true) || Intrinsics.areEqual(($this$visibility$iv = containingClass) == null ? null : (($i$f$getVisibility = ((ConeClassLikeLookupTag)$this$visibility$iv).getClassId()) == null ? null : Boolean.valueOf($i$f$getVisibility.isLocal())), (Object)true)) {
                return null;
            }
        }
        SignatureBuilder builder = new SignatureBuilder();
        try {
            declaration.accept(builder);
        }
        catch (Throwable t) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Error while composing signature for ", (Object)FirRendererKt.render$default(declaration, null, 1, null)), t);
        }
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirRegularClass) {
            ClassId classId = FirDeclarationUtilKt.getClassId((FirClass)declaration);
            String string2 = classId.getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classId.packageFqName.asString()");
            String string3 = string2;
            string2 = classId.getRelativeClassName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classId.relativeClassName.asString()");
            idSignature = new IdSignature.PublicSignature(string3, string2, builder.getHashId(), builder.getMask());
        } else if (firDeclaration instanceof FirTypeAlias) {
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$getVisibility22 = false;
            if (Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) {
                return null;
            }
            ClassId classId = ((FirTypeAlias)declaration).getSymbol().getClassId();
            String $i$f$getVisibility22 = classId.getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$getVisibility22, (String)"classId.packageFqName.asString()");
            String string4 = $i$f$getVisibility22;
            $i$f$getVisibility22 = classId.getRelativeClassName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$getVisibility22, (String)"classId.relativeClassName.asString()");
            idSignature = new IdSignature.PublicSignature(string4, $i$f$getVisibility22, builder.getHashId(), builder.getMask());
        } else if (firDeclaration instanceof FirCallableMemberDeclaration) {
            FqName fqName2;
            Object object;
            ClassId classId;
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$getVisibility32 = false;
            if (Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) {
                return null;
            }
            ConeClassLikeLookupTag $i$f$getVisibility32 = containingClass;
            ClassId containingClassId = $i$f$getVisibility32 == null ? null : $i$f$getVisibility32.getClassId();
            ClassId classId2 = containingClassId;
            ClassId classId3 = classId = classId2 == null ? ((object = ClassMembersKt.containingClass((FirCallableDeclaration)declaration)) == null ? null : ((ConeClassLikeLookupTag)object).getClassId()) : classId2;
            Object object2 = classId3 == null ? null : classId3.getPackageFqName();
            object = object2 == null ? ((FirCallableMemberDeclaration)declaration).getSymbol().getCallableId().getPackageName() : object2;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classId?.packageFqName ?: declaration.symbol.callableId.packageName");
            Object packageName = object;
            Name callableName = ((FirCallableMemberDeclaration)declaration).getSymbol().getCallableId().getCallableName();
            object2 = ((FqName)packageName).asString();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"packageName.asString()");
            Object object3 = object2;
            Object object4 = classId;
            FqName fqName3 = fqName2 = object4 == null ? null : ((ClassId)object4).getRelativeClassName();
            classId3 = fqName2 == null ? null : ((object4 = fqName2.child(callableName)) == null ? null : ((FqName)object4).asString());
            object2 = classId3 == null ? callableName.asString() : classId3;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"classId?.relativeClassName?.child(callableName)?.asString() ?: callableName.asString()");
            idSignature = new IdSignature.PublicSignature((String)object3, (String)object2, builder.getHashId(), builder.getMask());
        } else {
            String string5 = Intrinsics.stringPlus((String)"Unsupported FIR declaration in signature composer: ", (Object)FirRendererKt.render$default(declaration, null, 1, null));
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string5.toString());
        }
        return idSignature;
    }

    @Override
    @Nullable
    public IdSignature composeAccessorSignature(@NotNull FirProperty property2, boolean isSetter, @Nullable ConeClassLikeLookupTag containingClass) {
        IdSignature.PublicSignature publicSignature;
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        IdSignature idSignature = this.composeSignature(property2, containingClass);
        IdSignature.PublicSignature publicSignature2 = publicSignature = idSignature instanceof IdSignature.PublicSignature ? (IdSignature.PublicSignature)idSignature : null;
        if (publicSignature == null) {
            return null;
        }
        IdSignature.PublicSignature propertySignature = publicSignature;
        String accessorFqName = isSetter ? propertySignature.getDeclarationFqName() + ".<set-" + property2.getName().asString() + '>' : propertySignature.getDeclarationFqName() + ".<get-" + property2.getName().asString() + '>';
        return new IdSignature.PublicSignature(propertySignature.getPackageFqName(), accessorFqName, propertySignature.getId(), propertySignature.getMask());
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'H\u0016R\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer$SignatureBuilder;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "(Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;)V", "hashId", "", "getHashId", "()Ljava/lang/Long;", "setHashId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "mask", "getMask", "()J", "setMask", "(J)V", "setExpected", "", "f", "", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "fir2ir"})
    public final class SignatureBuilder
    extends FirVisitorVoid {
        @Nullable
        private Long hashId;
        private long mask;

        public SignatureBuilder() {
            Intrinsics.checkNotNullParameter((Object)FirBasedSignatureComposer.this, (String)"this$0");
        }

        @Nullable
        public final Long getHashId() {
            return this.hashId;
        }

        public final void setHashId(@Nullable Long l) {
            this.hashId = l;
        }

        public final long getMask() {
            return this.mask;
        }

        public final void setMask(long l) {
            this.mask = l;
        }

        private final void setExpected(boolean f) {
            this.mask |= IdSignature.Flags.IS_EXPECT.encode(f);
        }

        @Override
        public void visitElement(@NotNull FirElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String string2 = "Should not be here";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass) {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            FirMemberDeclaration $this$isExpect$iv = regularClass;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitTypeAlias(@NotNull FirTypeAlias typeAlias) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            FirMemberDeclaration $this$isExpect$iv = typeAlias;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitConstructor(@NotNull FirConstructor constructor2) {
            void $this$visitConstructor_u24lambda_u2d0;
            Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
            FirMangler firMangler = FirBasedSignatureComposer.this.mangler;
            boolean bl = false;
            boolean bl2 = false;
            FirMangler firMangler2 = firMangler;
            SignatureBuilder signatureBuilder = this;
            boolean bl3 = false;
            Long l = $this$visitConstructor_u24lambda_u2d0.getSignatureMangle(constructor2);
            signatureBuilder.hashId = l;
            FirMemberDeclaration $this$isExpect$iv = constructor2;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction) {
            void $this$visitSimpleFunction_u24lambda_u2d1;
            Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            FirMangler firMangler = FirBasedSignatureComposer.this.mangler;
            boolean bl = false;
            boolean bl2 = false;
            FirMangler firMangler2 = firMangler;
            SignatureBuilder signatureBuilder = this;
            boolean bl3 = false;
            Long l = $this$visitSimpleFunction_u24lambda_u2d1.getSignatureMangle(simpleFunction);
            signatureBuilder.hashId = l;
            FirMemberDeclaration $this$isExpect$iv = simpleFunction;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitProperty(@NotNull FirProperty property2) {
            void $this$visitProperty_u24lambda_u2d2;
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            FirMangler firMangler = FirBasedSignatureComposer.this.mangler;
            boolean bl = false;
            boolean bl2 = false;
            FirMangler firMangler2 = firMangler;
            SignatureBuilder signatureBuilder = this;
            boolean bl3 = false;
            Long l = $this$visitProperty_u24lambda_u2d2.getSignatureMangle(property2);
            signatureBuilder.hashId = l;
            FirMemberDeclaration $this$isExpect$iv = property2;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitEnumEntry(@NotNull FirEnumEntry enumEntry) {
            Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
            FirMemberDeclaration $this$isExpect$iv = enumEntry;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }
    }
}

