/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.DecompiledTryDescriptor;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.utils.SmartSet;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001aD\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\nH\u0002\u001a\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a$\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000eH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"collectDecompiledTryDescriptors", "", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/DecompiledTryDescriptor;", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "insertSaveRestoreStackMarkers", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "decompiledTryDescriptorForStart", "newTryStartLabels", "", "insertTryCatchBlocksMarkers", "transformTryCatchBlocks", "", "Ljava/util/HashMap;", "debugString", "", "tcb", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "isDefaultHandlerNode", "", "backend"})
public final class AnalyzeTryCatchBlocksKt {
    private static final boolean isDefaultHandlerNode(TryCatchBlockNode $this$isDefaultHandlerNode) {
        return Intrinsics.areEqual((Object)$this$isDefaultHandlerNode.start, (Object)$this$isDefaultHandlerNode.handler);
    }

    private static final String debugString(MethodNode $this$debugString, TryCatchBlockNode tcb) {
        return "TCB<" + $this$debugString.instructions.indexOf((AbstractInsnNode)tcb.start) + ", " + $this$debugString.instructions.indexOf((AbstractInsnNode)tcb.end) + ", " + $this$debugString.instructions.indexOf((AbstractInsnNode)tcb.handler) + '>';
    }

    @NotNull
    public static final Map<AbstractInsnNode, AbstractInsnNode> insertTryCatchBlocksMarkers(@NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        if (methodNode.tryCatchBlocks.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map<LabelNode, DecompiledTryDescriptor> decompiledTryDescriptorForStart = AnalyzeTryCatchBlocksKt.collectDecompiledTryDescriptors(methodNode);
        boolean bl = false;
        HashMap<LabelNode, LabelNode> newTryStartLabels = new HashMap<LabelNode, LabelNode>();
        Map<AbstractInsnNode, AbstractInsnNode> restoreStackToSaveStackMarker = AnalyzeTryCatchBlocksKt.insertSaveRestoreStackMarkers(decompiledTryDescriptorForStart, methodNode, (Map<LabelNode, LabelNode>)newTryStartLabels);
        AnalyzeTryCatchBlocksKt.transformTryCatchBlocks(methodNode, newTryStartLabels);
        return restoreStackToSaveStackMarker;
    }

    /*
     * WARNING - void declaration
     */
    private static final void transformTryCatchBlocks(MethodNode methodNode, HashMap<LabelNode, LabelNode> newTryStartLabels) {
        Collection<TryCatchBlockNode> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = methodNode.tryCatchBlocks;
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"methodNode.tryCatchBlocks");
        iterable = iterable;
        MethodNode methodNode2 = methodNode;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void tcb;
            TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            LabelNode newTryStartLabel = newTryStartLabels.get(tcb.start);
            TryCatchBlockNode tryCatchBlockNode2 = newTryStartLabel == null ? tcb : new TryCatchBlockNode(newTryStartLabel, tcb.end, tcb.handler, tcb.type);
            collection.add(tryCatchBlockNode2);
        }
        collection = (List)destination$iv$iv;
        methodNode2.tryCatchBlocks = collection;
    }

    private static final Map<AbstractInsnNode, AbstractInsnNode> insertSaveRestoreStackMarkers(Map<LabelNode, DecompiledTryDescriptor> decompiledTryDescriptorForStart, MethodNode methodNode, Map<LabelNode, LabelNode> newTryStartLabels) {
        boolean bl = false;
        HashMap restoreStackToSaveMarker = new HashMap();
        boolean bl2 = false;
        HashMap saveStackMarkerByTryLabel = new HashMap();
        boolean bl3 = false;
        HashSet<LabelNode> doneHandlerLabels = new HashSet<LabelNode>();
        for (DecompiledTryDescriptor decompiledTryDescriptor : decompiledTryDescriptorForStart.values()) {
            boolean bl4;
            Object $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$422;
            AbstractInsnNode newTryStartLabel;
            boolean bl5 = false;
            boolean bl6 = false;
            DecompiledTryDescriptor $this$insertSaveRestoreStackMarkers_u24lambda_u2d5 = decompiledTryDescriptor;
            boolean bl7 = false;
            Map saveStackMarker = null;
            Object object = saveStackMarkerByTryLabel;
            LabelNode labelNode = $this$insertSaveRestoreStackMarkers_u24lambda_u2d5.getTryStartLabel();
            boolean bl8 = false;
            Map map = object;
            boolean bl9 = false;
            if (!map.containsKey(labelNode)) {
                AbstractInsnNode finger$iv4222;
                AbstractInsnNode $this$findNextOrNull$iv322 = (AbstractInsnNode)$this$insertSaveRestoreStackMarkers_u24lambda_u2d5.getTryStartLabel();
                boolean $i$f$findNextOrNull = false;
                for (finger$iv4222 = $this$findNextOrNull$iv322.getNext(); finger$iv4222 != null; finger$iv4222 = finger$iv4222.getNext()) {
                    AbstractInsnNode abstractInsnNode;
                    AbstractInsnNode it = abstractInsnNode = finger$iv4222;
                    boolean bl10 = false;
                    if (UtilKt.hasOpcode(it)) break;
                }
                labelNode = finger$iv4222;
                Intrinsics.checkNotNull((Object)labelNode);
                LabelNode nopNode = labelNode;
                boolean bl11 = nopNode.getOpcode() == 0;
                boolean $this$findNextOrNull$iv322 = false;
                if (_Assertions.ENABLED && !bl11) {
                    boolean $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$422 = false;
                    String $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$422 = methodNode.instructions.indexOf((AbstractInsnNode)nopNode) + ": try block should start with NOP";
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$422));
                }
                newTryStartLabel = new LabelNode(new Label());
                Map<LabelNode, LabelNode> $this$findNextOrNull$iv322 = newTryStartLabels;
                $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$422 = $this$insertSaveRestoreStackMarkers_u24lambda_u2d5.getTryStartLabel();
                boolean finger$iv4222 = false;
                $this$findNextOrNull$iv322.put((LabelNode)$i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$422, (LabelNode)newTryStartLabel);
                saveStackMarker = (AbstractInsnNode)PseudoInsn.SAVE_STACK_BEFORE_TRY.createInsnNode();
                MethodInsnNode restoreStackMarker = PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.createInsnNode();
                $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$422 = saveStackMarkerByTryLabel;
                LabelNode finger$iv4222 = $this$insertSaveRestoreStackMarkers_u24lambda_u2d5.getTryStartLabel();
                bl4 = false;
                $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$422.put(finger$iv4222, saveStackMarker);
                $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$422 = restoreStackToSaveMarker;
                boolean finger$iv4222 = false;
                $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$422.put(restoreStackMarker, saveStackMarker);
                methodNode.instructions.insertBefore((AbstractInsnNode)nopNode, (AbstractInsnNode)saveStackMarker);
                methodNode.instructions.insertBefore((AbstractInsnNode)nopNode, newTryStartLabel);
                methodNode.instructions.insert((AbstractInsnNode)nopNode, (AbstractInsnNode)restoreStackMarker);
            } else {
                newTryStartLabel = (AbstractInsnNode)saveStackMarkerByTryLabel.get($this$insertSaveRestoreStackMarkers_u24lambda_u2d5.getTryStartLabel());
                Intrinsics.checkNotNull((Object)newTryStartLabel);
                object = newTryStartLabel;
                saveStackMarker = object;
            }
            for (LabelNode handlerStartLabel : $this$insertSaveRestoreStackMarkers_u24lambda_u2d5.getHandlerStartLabels()) {
                AbstractInsnNode finger$iv;
                if (doneHandlerLabels.contains(handlerStartLabel)) continue;
                doneHandlerLabels.add(handlerStartLabel);
                Intrinsics.checkNotNullExpressionValue((Object)handlerStartLabel, (String)"handlerStartLabel");
                AbstractInsnNode $this$findNextOrNull$iv = (AbstractInsnNode)handlerStartLabel;
                boolean $i$f$findNextOrNull = false;
                for (finger$iv = $this$findNextOrNull$iv.getNext(); finger$iv != null; finger$iv = finger$iv.getNext()) {
                    AbstractInsnNode abstractInsnNode;
                    AbstractInsnNode it = abstractInsnNode = finger$iv;
                    boolean bl12 = false;
                    if (UtilKt.hasOpcode(it)) break;
                }
                $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$422 = finger$iv;
                Intrinsics.checkNotNull((Object)$i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$422);
                LabelNode storeNode = $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$422;
                boolean $i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$422 = storeNode.getOpcode() == 58;
                boolean bl13 = false;
                if (_Assertions.ENABLED && !$i$a$-assert-AnalyzeTryCatchBlocksKt$insertSaveRestoreStackMarkers$1$422) {
                    boolean bl14 = false;
                    String string2 = methodNode.instructions.indexOf((AbstractInsnNode)storeNode) + ": handler should start with ASTORE";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                MethodInsnNode restoreStackMarker = PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.createInsnNode();
                Map map2 = restoreStackToSaveMarker;
                bl4 = false;
                map2.put(restoreStackMarker, saveStackMarker);
                methodNode.instructions.insert((AbstractInsnNode)storeNode, (AbstractInsnNode)restoreStackMarker);
            }
        }
        return restoreStackToSaveMarker;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<LabelNode, DecompiledTryDescriptor> collectDecompiledTryDescriptors(MethodNode methodNode) {
        TryCatchBlockNode it;
        void $this$mapNotNullTo$iv;
        boolean bl = false;
        Map decompiledTryDescriptorForStart = new HashMap();
        boolean bl2 = false;
        Map decompiledTryDescriptorForHandler = new HashMap();
        Object object = methodNode.tryCatchBlocks;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"methodNode.tryCatchBlocks");
        object = (Iterable)object;
        Collection destination$iv = SmartSet.Companion.create();
        boolean $i$f$mapNotNullTo = false;
        Map $this$forEach$iv$iv2 = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            LabelNode labelNode;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl3 = false;
            it = (TryCatchBlockNode)element$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if ((AnalyzeTryCatchBlocksKt.isDefaultHandlerNode(it) ? it.handler : null) == null) continue;
            labelNode = labelNode;
            boolean bl5 = false;
            boolean bl6 = false;
            LabelNode it$iv = labelNode;
            boolean bl7 = false;
            destination$iv.add(it$iv);
        }
        SmartSet defaultHandlers = (SmartSet)destination$iv;
        for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
            Object object2;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullExpressionValue((Object)tcb, (String)"tcb");
            if (AnalyzeTryCatchBlocksKt.isDefaultHandlerNode(tcb)) {
                $i$f$mapNotNullTo = decompiledTryDescriptorForHandler.containsKey(tcb.start);
                boolean $this$forEach$iv$iv2 = false;
                if (_Assertions.ENABLED && !$i$f$mapNotNullTo) {
                    boolean $i$a$-assert-AnalyzeTryCatchBlocksKt$collectDecompiledTryDescriptors$22 = false;
                    String $i$a$-assert-AnalyzeTryCatchBlocksKt$collectDecompiledTryDescriptors$22 = Intrinsics.stringPlus((String)AnalyzeTryCatchBlocksKt.debugString(methodNode, tcb), (Object)": default handler should occur after some regular handler");
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-AnalyzeTryCatchBlocksKt$collectDecompiledTryDescriptors$22));
                }
            }
            $this$forEach$iv$iv2 = decompiledTryDescriptorForHandler;
            LabelNode $i$a$-assert-AnalyzeTryCatchBlocksKt$collectDecompiledTryDescriptors$22 = tcb.handler;
            Intrinsics.checkNotNullExpressionValue((Object)$i$a$-assert-AnalyzeTryCatchBlocksKt$collectDecompiledTryDescriptors$22, (String)"tcb.handler");
            LabelNode key$iv = $i$a$-assert-AnalyzeTryCatchBlocksKt$collectDecompiledTryDescriptors$22;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                Object object3;
                void $this$getOrPut$iv2;
                boolean bl8 = false;
                Map bl3 = decompiledTryDescriptorForStart;
                it = tcb.start;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"tcb.start");
                TryCatchBlockNode key$iv2 = it;
                boolean $i$f$getOrPut2 = false;
                Object value$iv2 = $this$getOrPut$iv2.get(key$iv2);
                if (value$iv2 == null) {
                    boolean bl9 = false;
                    LabelNode labelNode = tcb.start;
                    Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"tcb.start");
                    DecompiledTryDescriptor answer$iv = new DecompiledTryDescriptor(labelNode);
                    $this$getOrPut$iv2.put(key$iv2, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv2;
                }
                DecompiledTryDescriptor answer$iv = (DecompiledTryDescriptor)object3;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            DecompiledTryDescriptor decompiledTryDescriptor = (DecompiledTryDescriptor)object2;
            boolean bl10 = false;
            boolean bl11 = false;
            DecompiledTryDescriptor $this$collectDecompiledTryDescriptors_u24lambda_u2d11 = decompiledTryDescriptor;
            boolean bl12 = false;
            if (AnalyzeTryCatchBlocksKt.isDefaultHandlerNode(tcb)) {
                boolean bl13 = $this$collectDecompiledTryDescriptors_u24lambda_u2d11.getDefaultHandlerTcb() == null;
                boolean bl14 = false;
                if (_Assertions.ENABLED && !bl13) {
                    boolean bl15 = false;
                    StringBuilder stringBuilder2 = new StringBuilder().append(AnalyzeTryCatchBlocksKt.debugString(methodNode, tcb)).append(": default handler is already found: ");
                    TryCatchBlockNode tryCatchBlockNode = $this$collectDecompiledTryDescriptors_u24lambda_u2d11.getDefaultHandlerTcb();
                    Intrinsics.checkNotNull((Object)tryCatchBlockNode);
                    String string2 = stringBuilder2.append(AnalyzeTryCatchBlocksKt.debugString(methodNode, tryCatchBlockNode)).toString();
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                $this$collectDecompiledTryDescriptors_u24lambda_u2d11.setDefaultHandlerTcb(tcb);
            }
            if (defaultHandlers.contains(tcb.handler)) continue;
            $this$collectDecompiledTryDescriptors_u24lambda_u2d11.getHandlerStartLabels().add(tcb.handler);
        }
        return decompiledTryDescriptorForStart;
    }
}

