/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.ComparableRangeInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.FloatingPointRangeHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ForLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfoBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.IndexedGetHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.IndexedGetLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.IterableHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.IterableLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.WithIndexHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.WithIndexLoopHeader;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderProcessor;", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "headerInfoBuilder", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoBuilder;", "scopeOwnerSymbol", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoBuilder;Lkotlin/jvm/functions/Function0;)V", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "extractHeader", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopHeader;", "variable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "ir.backend.common"})
public final class HeaderProcessor {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final HeaderInfoBuilder headerInfoBuilder;
    @NotNull
    private final Function0<IrSymbol> scopeOwnerSymbol;
    @NotNull
    private final Symbols<CommonBackendContext> symbols;

    public HeaderProcessor(@NotNull CommonBackendContext context2, @NotNull HeaderInfoBuilder headerInfoBuilder2, @NotNull Function0<? extends IrSymbol> scopeOwnerSymbol) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)headerInfoBuilder2, (String)"headerInfoBuilder");
        Intrinsics.checkNotNullParameter(scopeOwnerSymbol, (String)"scopeOwnerSymbol");
        this.context = context2;
        this.headerInfoBuilder = headerInfoBuilder2;
        this.scopeOwnerSymbol = scopeOwnerSymbol;
        this.symbols = this.context.getIr().getSymbols();
    }

    @Nullable
    public final ForLoopHeader extractHeader(@NotNull IrVariable variable2) {
        ForLoopHeader forLoopHeader;
        IrElement iterable;
        IrCall irCall;
        IrElement irElement;
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
        boolean bl = Intrinsics.areEqual((Object)variable2.getOrigin(), (Object)IrDeclarationOrigin.FOR_LOOP_ITERATOR.INSTANCE);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        if (!IrTypeUtilsKt.isSubtypeOfClass(variable2.getType(), this.symbols.getIterator())) {
            return null;
        }
        IrExpression irExpression = variable2.getInitializer();
        IrCall iteratorCall = irExpression instanceof IrCall ? (IrCall)irExpression : null;
        IrCall irCall2 = iteratorCall;
        if (irCall2 == null) {
            irElement = null;
        } else {
            irCall = irCall2;
            boolean bl5 = false;
            boolean bl6 = false;
            IrCall $this$extractHeader_u24lambda_u2d0 = irCall;
            boolean bl7 = false;
            irElement = $this$extractHeader_u24lambda_u2d0.getExtensionReceiver() != null ? $this$extractHeader_u24lambda_u2d0.getExtensionReceiver() : $this$extractHeader_u24lambda_u2d0.getDispatchReceiver();
        }
        IrElement irElement2 = iterable = irElement;
        IrCall irCall3 = irCall = irElement2 == null ? null : (HeaderInfo)irElement2.accept(this.headerInfoBuilder, iteratorCall);
        if (irCall == null) {
            return null;
        }
        IrCall headerInfo = irCall;
        DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder(this.context, (IrSymbol)this.scopeOwnerSymbol.invoke(), variable2.getStartOffset(), variable2.getEndOffset());
        irElement2 = headerInfo;
        if (irElement2 instanceof IndexedGetHeaderInfo) {
            forLoopHeader = new IndexedGetLoopHeader((IndexedGetHeaderInfo)((Object)headerInfo), builder, this.context);
        } else if (irElement2 instanceof ProgressionHeaderInfo) {
            forLoopHeader = new ProgressionLoopHeader((ProgressionHeaderInfo)((Object)headerInfo), builder, this.context);
        } else if (irElement2 instanceof WithIndexHeaderInfo) {
            forLoopHeader = new WithIndexLoopHeader((WithIndexHeaderInfo)((Object)headerInfo), builder, this.context);
        } else if (irElement2 instanceof IterableHeaderInfo) {
            forLoopHeader = new IterableLoopHeader((IterableHeaderInfo)((Object)headerInfo));
        } else {
            if (irElement2 instanceof FloatingPointRangeHeaderInfo ? true : irElement2 instanceof ComparableRangeInfo) {
                String string3 = "Unexpected " + Reflection.getOrCreateKotlinClass(headerInfo.getClass()).getSimpleName() + " for loops";
                boolean bl8 = false;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return forLoopHeader;
    }
}

