/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u001c\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u0001H\u0007\u001a\u0018\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u0001\u001a$\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u0007\u001a\u00020\u000e2\b\b\u0002\u0010\t\u001a\u00020\u0001\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u0002*\u00020\u0010\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\u00a8\u0006\u0011"}, d2={"isAnnotated", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z", "isOrdinaryClass", "findImplementationFromInterface", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "descriptor", "findInterfaceImplementation", "returnImplNotDelegate", "firstSuperMethodFromKotlin", "implementation", "getNonPrivateTraitMembersForDelegation", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "containingNonLocalDeclaration", "Lorg/jetbrains/kotlin/psi/KtElement;", "frontend"})
public final class DeclarationUtilKt {
    @Nullable
    public static final KtDeclaration containingNonLocalDeclaration(@NotNull KtElement $this$containingNonLocalDeclaration) {
        Intrinsics.checkNotNullParameter((Object)$this$containingNonLocalDeclaration, (String)"$this$containingNonLocalDeclaration");
        KtDeclaration container = PseudocodeUtilsKt.getContainingDeclarationForPseudocode($this$containingNonLocalDeclaration);
        while (container != null && KtPsiUtil.isLocal(container)) {
            container = PseudocodeUtilsKt.getContainingDeclarationForPseudocode(container);
        }
        return container;
    }

    public static final boolean isOrdinaryClass(@NotNull KtDeclaration $this$isOrdinaryClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isOrdinaryClass, (String)"$this$isOrdinaryClass");
        return $this$isOrdinaryClass instanceof KtClass && !$this$isOrdinaryClass.hasModifier(KtTokens.INLINE_KEYWORD) && !((KtClass)$this$isOrdinaryClass).isAnnotation() && !((KtClass)$this$isOrdinaryClass).isInterface();
    }

    public static final boolean isAnnotated(@NotNull KtDeclaration $this$isAnnotated) {
        Intrinsics.checkNotNullParameter((Object)$this$isAnnotated, (String)"$this$isAnnotated");
        List list2 = $this$isAnnotated.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"this.annotationEntries");
        Collection collection = list2;
        boolean bl = false;
        return !collection.isEmpty();
    }

    @Nullable
    public static final CallableMemberDescriptor findImplementationFromInterface(@NotNull CallableMemberDescriptor descriptor2) {
        Object v3;
        block3: {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Set<CallableMemberDescriptor> set = OverridingUtil.getOverriddenDeclarations(descriptor2);
            Intrinsics.checkNotNullExpressionValue(set, (String)"OverridingUtil.getOverri\u2026nDeclarations(descriptor)");
            Set<CallableMemberDescriptor> overridden = set;
            Set<CallableMemberDescriptor> set2 = OverridingUtil.filterOutOverridden(overridden);
            Intrinsics.checkNotNullExpressionValue(set2, (String)"OverridingUtil.filterOutOverridden(overridden)");
            Set<CallableMemberDescriptor> filtered = set2;
            Iterable $this$firstOrNull$iv = filtered;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                boolean bl = false;
                CallableMemberDescriptor callableMemberDescriptor = it;
                Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor, (String)"it");
                if (!(callableMemberDescriptor.getModality() != Modality.ABSTRACT)) continue;
                v3 = element$iv;
                break block3;
            }
            v3 = null;
        }
        CallableMemberDescriptor callableMemberDescriptor = v3;
        if (callableMemberDescriptor == null) {
            return null;
        }
        CallableMemberDescriptor result2 = callableMemberDescriptor;
        if (DescriptorUtils.isClassOrEnumClass(result2.getContainingDeclaration())) {
            return null;
        }
        return result2;
    }

    @JvmOverloads
    @Nullable
    public static final CallableMemberDescriptor findInterfaceImplementation(@NotNull CallableMemberDescriptor descriptor2, boolean returnImplNotDelegate) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        CallableMemberDescriptor.Kind kind = descriptor2.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)kind), (String)"descriptor.kind");
        if (kind.isReal()) {
            return null;
        }
        if (CallResolverUtilKt.isOrOverridesSynthesized(descriptor2)) {
            return null;
        }
        CallableMemberDescriptor callableMemberDescriptor = DeclarationUtilKt.findImplementationFromInterface(descriptor2);
        if (callableMemberDescriptor == null) {
            return null;
        }
        CallableMemberDescriptor implementation2 = callableMemberDescriptor;
        CallableMemberDescriptor callableMemberDescriptor2 = DeclarationUtilKt.firstSuperMethodFromKotlin(descriptor2, implementation2);
        if (callableMemberDescriptor2 == null) {
            return null;
        }
        CallableMemberDescriptor immediateConcreteSuper = callableMemberDescriptor2;
        if (!DescriptorUtils.isInterface(immediateConcreteSuper.getContainingDeclaration())) {
            return null;
        }
        return returnImplNotDelegate ? implementation2 : immediateConcreteSuper;
    }

    public static /* synthetic */ CallableMemberDescriptor findInterfaceImplementation$default(CallableMemberDescriptor callableMemberDescriptor, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return DeclarationUtilKt.findInterfaceImplementation(callableMemberDescriptor, bl);
    }

    @JvmOverloads
    @Nullable
    public static final CallableMemberDescriptor findInterfaceImplementation(@NotNull CallableMemberDescriptor descriptor2) {
        return DeclarationUtilKt.findInterfaceImplementation$default(descriptor2, false, 2, null);
    }

    @Nullable
    public static final CallableMemberDescriptor firstSuperMethodFromKotlin(@NotNull CallableMemberDescriptor descriptor2, @NotNull CallableMemberDescriptor implementation2) {
        Object v2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)implementation2, (String)"implementation");
            Collection<? extends CallableMemberDescriptor> collection = descriptor2.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"descriptor.overriddenDescriptors");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CallableMemberDescriptor overridden = (CallableMemberDescriptor)element$iv;
                boolean bl = false;
                CallableMemberDescriptor callableMemberDescriptor = overridden;
                Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor, (String)"overridden");
                if (!(callableMemberDescriptor.getModality() != Modality.ABSTRACT && (Intrinsics.areEqual((Object)overridden, (Object)implementation2) || OverridingUtil.overrides((CallableDescriptor)overridden, (CallableDescriptor)implementation2, DescriptorUtilsKt.isTypeRefinementEnabled(DescriptorUtilsKt.getModule(overridden)), true)))) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    @NotNull
    public static final Map<CallableMemberDescriptor, CallableMemberDescriptor> getNonPrivateTraitMembersForDelegation(@NotNull ClassDescriptor descriptor2, boolean returnImplNotDelegate) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        boolean bl = false;
        LinkedHashMap result2 = new LinkedHashMap();
        for (DeclarationDescriptor declaration : DescriptorUtils.getAllDescriptors(descriptor2.getDefaultType().getMemberScope())) {
            if (!(declaration instanceof CallableMemberDescriptor)) continue;
            CallableMemberDescriptor callableMemberDescriptor = DeclarationUtilKt.getNonPrivateTraitMembersForDelegation((CallableMemberDescriptor)declaration, returnImplNotDelegate);
            if (callableMemberDescriptor == null) {
                continue;
            }
            ((Map)result2).put(declaration, callableMemberDescriptor);
        }
        return result2;
    }

    public static /* synthetic */ Map getNonPrivateTraitMembersForDelegation$default(ClassDescriptor classDescriptor2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return DeclarationUtilKt.getNonPrivateTraitMembersForDelegation(classDescriptor2, bl);
    }

    @Nullable
    public static final CallableMemberDescriptor getNonPrivateTraitMembersForDelegation(@NotNull CallableMemberDescriptor descriptor2, boolean returnImplNotDelegate) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        CallableMemberDescriptor traitMember = DeclarationUtilKt.findInterfaceImplementation(descriptor2, returnImplNotDelegate);
        if (traitMember == null || DescriptorVisibilities.isPrivate(traitMember.getVisibility()) || Intrinsics.areEqual((Object)traitMember.getVisibility(), (Object)DescriptorVisibilities.INVISIBLE_FAKE)) {
            return null;
        }
        return traitMember;
    }

    public static /* synthetic */ CallableMemberDescriptor getNonPrivateTraitMembersForDelegation$default(CallableMemberDescriptor callableMemberDescriptor, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return DeclarationUtilKt.getNonPrivateTraitMembersForDelegation(callableMemberDescriptor, bl);
    }
}

