/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.metadata.jvm.deserialization;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.metadata.deserialization.VersionSpecificBehaviorKt;
import org.jetbrains.kotlin.metadata.jvm.JvmModuleProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.BinaryModuleData;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMappingKt;
import org.jetbrains.kotlin.metadata.jvm.deserialization.PackageParts;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0006J\b\u0010\u0014\u001a\u00020\u0006H\u0016R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping;", "", "version", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "packageFqName2Parts", "", "", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/PackageParts;", "moduleData", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/BinaryModuleData;", "debugName", "(Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;Ljava/util/Map;Lorg/jetbrains/kotlin/metadata/jvm/deserialization/BinaryModuleData;Ljava/lang/String;)V", "getModuleData", "()Lorg/jetbrains/kotlin/metadata/jvm/deserialization/BinaryModuleData;", "getPackageFqName2Parts", "()Ljava/util/Map;", "getVersion", "()Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "findPackageParts", "packageFqName", "toString", "Companion", "metadata.jvm"})
public final class ModuleMapping {
    private final JvmMetadataVersion version;
    private final Map<String, PackageParts> packageFqName2Parts;
    private final BinaryModuleData moduleData;
    private final String debugName;
    @NotNull
    public static final String MAPPING_FILE_EXT = "kotlin_module";
    @JvmField
    @NotNull
    public static final ModuleMapping EMPTY;
    @JvmField
    @NotNull
    public static final ModuleMapping CORRUPTED;
    public static final int STRICT_METADATA_VERSION_SEMANTICS_FLAG = 1;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final PackageParts findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return this.packageFqName2Parts.get(packageFqName);
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    @NotNull
    public final JvmMetadataVersion getVersion() {
        return this.version;
    }

    @NotNull
    public final Map<String, PackageParts> getPackageFqName2Parts() {
        return this.packageFqName2Parts;
    }

    @NotNull
    public final BinaryModuleData getModuleData() {
        return this.moduleData;
    }

    private ModuleMapping(JvmMetadataVersion version, Map<String, PackageParts> packageFqName2Parts, BinaryModuleData moduleData, String debugName) {
        this.version = version;
        this.packageFqName2Parts = packageFqName2Parts;
        this.moduleData = moduleData;
        this.debugName = debugName;
    }

    static {
        Companion = new Companion(null);
        EMPTY = new ModuleMapping(JvmMetadataVersion.INSTANCE, MapsKt.emptyMap(), ModuleMapping.Companion.emptyBinaryData(), "EMPTY");
        CORRUPTED = new ModuleMapping(JvmMetadataVersion.INSTANCE, MapsKt.emptyMap(), ModuleMapping.Companion.emptyBinaryData(), "CORRUPTED");
    }

    public /* synthetic */ ModuleMapping(JvmMetadataVersion version, Map packageFqName2Parts, BinaryModuleData moduleData, String debugName, DefaultConstructorMarker $constructor_marker) {
        this(version, packageFqName2Parts, moduleData, debugName);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J<\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014J6\u0010\u0017\u001a\u0004\u0018\u00010\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping$Companion;", "", "()V", "CORRUPTED", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping;", "EMPTY", "MAPPING_FILE_EXT", "", "STRICT_METADATA_VERSION_SEMANTICS_FLAG", "", "emptyBinaryData", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/BinaryModuleData;", "loadModuleMapping", "bytes", "", "debugName", "skipMetadataVersionCheck", "", "isJvmPackageNameSupported", "reportIncompatibleVersionError", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "", "loadMultiFileFacadeInternalName", "multifileFacadeIds", "", "multifileFacadeShortNames", "index", "packageFqName", "readVersionNumber", "", "stream", "Ljava/io/DataInputStream;", "metadata.jvm"})
    public static final class Companion {
        @Nullable
        public final int[] readVersionNumber(@NotNull DataInputStream stream) {
            int[] nArray;
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            try {
                int n = stream.readInt();
                int[] nArray2 = new int[n];
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n2;
                    int n5 = n2++;
                    int[] nArray3 = nArray2;
                    boolean bl = false;
                    nArray3[n5] = n3 = stream.readInt();
                }
                nArray = nArray2;
            }
            catch (IOException e) {
                nArray = null;
            }
            return nArray;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping loadModuleMapping(@Nullable byte[] bytes2, @NotNull String debugName, boolean skipMetadataVersionCheck, boolean isJvmPackageNameSupported, @NotNull Function1<? super JvmMetadataVersion, Unit> reportIncompatibleVersionError) {
            void $this$mapTo$iv$iv;
            Object packageParts;
            Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
            Intrinsics.checkNotNullParameter(reportIncompatibleVersionError, (String)"reportIncompatibleVersionError");
            if (bytes2 == null) {
                return EMPTY;
            }
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes2));
            int[] nArray = this.readVersionNumber(stream);
            if (nArray == null) {
                return CORRUPTED;
            }
            int[] versionNumber = nArray;
            JvmMetadataVersion preVersion = new JvmMetadataVersion(Arrays.copyOf(versionNumber, versionNumber.length));
            if (!skipMetadataVersionCheck && !preVersion.isCompatible()) {
                reportIncompatibleVersionError.invoke((Object)preVersion);
                return EMPTY;
            }
            int flags = VersionSpecificBehaviorKt.isKotlin1Dot4OrLater(preVersion) ? stream.readInt() : 0;
            JvmMetadataVersion version = new JvmMetadataVersion(versionNumber, (flags & 1) != 0);
            if (!skipMetadataVersionCheck && !version.isCompatible()) {
                reportIncompatibleVersionError.invoke((Object)version);
                return EMPTY;
            }
            ExtensionRegistryLite extensionRegistryLite = ExtensionRegistryLite.newInstance();
            boolean bl = false;
            boolean bl2 = false;
            Iterator<JvmModuleProtoBuf.PackageParts> p1 = extensionRegistryLite;
            boolean bl3 = false;
            BuiltInsProtoBuf.registerAllExtensions((ExtensionRegistryLite)((Object)p1));
            ExtensionRegistryLite extensions = extensionRegistryLite;
            JvmModuleProtoBuf.Module module2 = JvmModuleProtoBuf.Module.parseFrom(stream, extensions);
            if (module2 == null) {
                return EMPTY;
            }
            JvmModuleProtoBuf.Module moduleProto = module2;
            bl2 = false;
            LinkedHashMap result2 = new LinkedHashMap();
            p1 = moduleProto.getPackagePartsList().iterator();
            while (p1.hasNext()) {
                int index2;
                Object object;
                String key$iv;
                void $this$getOrPut$iv22;
                JvmModuleProtoBuf.PackageParts proto;
                JvmModuleProtoBuf.PackageParts packageParts2 = proto = (JvmModuleProtoBuf.PackageParts)p1.next();
                Intrinsics.checkNotNullExpressionValue((Object)packageParts2, (String)"proto");
                String packageFqName = packageParts2.getPackageFqName();
                Map map2 = result2;
                Intrinsics.checkNotNullExpressionValue((Object)packageFqName, (String)"packageFqName");
                boolean $i$f$getOrPut22 = false;
                Object value$iv = $this$getOrPut$iv22.get(key$iv);
                if (value$iv == null) {
                    boolean bl4 = false;
                    PackageParts answer$iv = new PackageParts(packageFqName);
                    $this$getOrPut$iv22.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                packageParts = (PackageParts)object;
                boolean $this$getOrPut$iv22 = false;
                ProtocolStringList protocolStringList = proto.getShortClassNameList();
                Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"proto.shortClassNameList");
                Iterator $i$f$getOrPut22 = ((Iterable)protocolStringList).iterator();
                while ($i$f$getOrPut22.hasNext()) {
                    String partShortName;
                    String string2 = partShortName = (String)$i$f$getOrPut22.next();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"partShortName");
                    String string3 = ModuleMappingKt.access$internalNameOf(packageFqName, string2);
                    List<Integer> list2 = proto.getMultifileFacadeShortNameIdList();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.multifileFacadeShortNameIdList");
                    ProtocolStringList protocolStringList2 = proto.getMultifileFacadeShortNameList();
                    Intrinsics.checkNotNullExpressionValue((Object)protocolStringList2, (String)"proto.multifileFacadeShortNameList");
                    ((PackageParts)packageParts).addPart(string3, this.loadMultiFileFacadeInternalName(list2, protocolStringList2, index2, packageFqName));
                    ++index2;
                }
                if (!isJvmPackageNameSupported) continue;
                index2 = 0;
                ProtocolStringList protocolStringList3 = proto.getClassWithJvmPackageNameShortNameList();
                Intrinsics.checkNotNullExpressionValue((Object)protocolStringList3, (String)"proto.classWithJvmPackageNameShortNameList");
                for (String partShortName : (Iterable)protocolStringList3) {
                    List<Integer> list3 = proto.getClassWithJvmPackageNamePackageIdList();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"proto.classWithJvmPackageNamePackageIdList");
                    Integer n = (Integer)CollectionsKt.getOrNull(list3, (int)index2);
                    if (n == null) {
                        List<Integer> list4 = proto.getClassWithJvmPackageNamePackageIdList();
                        Intrinsics.checkNotNullExpressionValue(list4, (String)"proto.classWithJvmPackageNamePackageIdList");
                        n = (Integer)CollectionsKt.lastOrNull(list4);
                    }
                    if (n == null) {
                    } else {
                        int packageId = n;
                        ProtocolStringList protocolStringList4 = moduleProto.getJvmPackageNameList();
                        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList4, (String)"moduleProto.jvmPackageNameList");
                        if ((String)CollectionsKt.getOrNull((List)protocolStringList4, (int)packageId) == null) {
                        } else {
                            String jvmPackageName;
                            String string4 = partShortName;
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"partShortName");
                            String string5 = ModuleMappingKt.access$internalNameOf(jvmPackageName, string4);
                            List<Integer> list5 = proto.getClassWithJvmPackageNameMultifileFacadeShortNameIdList();
                            Intrinsics.checkNotNullExpressionValue(list5, (String)"proto.classWithJvmPackag\u2026fileFacadeShortNameIdList");
                            ProtocolStringList protocolStringList5 = proto.getMultifileFacadeShortNameList();
                            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList5, (String)"proto.multifileFacadeShortNameList");
                            ((PackageParts)packageParts).addPart(string5, this.loadMultiFileFacadeInternalName(list5, protocolStringList5, index2, jvmPackageName));
                        }
                    }
                    ++index2;
                }
            }
            for (JvmModuleProtoBuf.PackageParts proto : moduleProto.getMetadataPartsList()) {
                Object object;
                String key$iv;
                void $this$getOrPut$iv;
                packageParts = result2;
                JvmModuleProtoBuf.PackageParts packageParts3 = proto;
                Intrinsics.checkNotNullExpressionValue((Object)packageParts3, (String)"proto");
                Intrinsics.checkNotNullExpressionValue((Object)packageParts3.getPackageFqName(), (String)"proto.packageFqName");
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl5 = false;
                    String string6 = proto.getPackageFqName();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"proto.packageFqName");
                    PackageParts answer$iv = new PackageParts(string6);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                PackageParts packageParts4 = (PackageParts)object;
                ProtocolStringList protocolStringList = proto.getShortClassNameList();
                Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"proto.shortClassNameList");
                Iterable $this$forEach$iv = protocolStringList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String p12 = (String)element$iv;
                    boolean bl6 = false;
                    packageParts4.addMetadataPart(p12);
                }
            }
            ProtoBuf.StringTable stringTable = moduleProto.getStringTable();
            Intrinsics.checkNotNullExpressionValue((Object)stringTable, (String)"moduleProto.stringTable");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = moduleProto.getQualifiedNameTable();
            Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"moduleProto.qualifiedNameTable");
            NameResolverImpl nameResolver2 = new NameResolverImpl(stringTable, qualifiedNameTable);
            List<ProtoBuf.Annotation> list6 = moduleProto.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list6, (String)"moduleProto.annotationList");
            Iterable $this$map$iv = list6;
            boolean $i$f$map = false;
            Iterable $i$f$forEach = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void proto;
                ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl7 = false;
                void v25 = proto;
                Intrinsics.checkNotNullExpressionValue((Object)v25, (String)"proto");
                String string7 = nameResolver2.getQualifiedClassName(v25.getId());
                collection.add(string7);
            }
            List annotations2 = (List)destination$iv$iv;
            Map map3 = result2;
            List<ProtoBuf.Class> list7 = moduleProto.getOptionalAnnotationClassList();
            Intrinsics.checkNotNullExpressionValue(list7, (String)"moduleProto.optionalAnnotationClassList");
            return new ModuleMapping(version, map3, new BinaryModuleData(annotations2, list7, nameResolver2), debugName, null);
        }

        private final String loadMultiFileFacadeInternalName(List<Integer> multifileFacadeIds, List<String> multifileFacadeShortNames, int index2, String packageFqName) {
            String string2;
            String facadeShortName;
            String string3;
            boolean bl;
            boolean bl2;
            Integer n;
            Integer multifileFacadeId;
            Integer n2 = (Integer)CollectionsKt.getOrNull(multifileFacadeIds, (int)index2);
            Integer n3 = multifileFacadeId = n2 != null ? Integer.valueOf(n2 - 1) : null;
            if (n3 != null) {
                n = n3;
                bl2 = false;
                bl = false;
                int p1 = ((Number)n).intValue();
                boolean bl3 = false;
                string3 = (String)CollectionsKt.getOrNull(multifileFacadeShortNames, (int)p1);
            } else {
                string3 = null;
            }
            String string4 = facadeShortName = string3;
            if (string4 != null) {
                n = string4;
                bl2 = false;
                bl = false;
                Integer it = n;
                boolean bl4 = false;
                string2 = ModuleMappingKt.access$internalNameOf(packageFqName, (String)((Object)it));
            } else {
                string2 = null;
            }
            return string2;
        }

        private final BinaryModuleData emptyBinaryData() {
            List list2 = CollectionsKt.emptyList();
            List list3 = CollectionsKt.emptyList();
            ProtoBuf.StringTable stringTable = ProtoBuf.StringTable.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)stringTable, (String)"ProtoBuf.StringTable.getDefaultInstance()");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = ProtoBuf.QualifiedNameTable.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"ProtoBuf.QualifiedNameTable.getDefaultInstance()");
            return new BinaryModuleData(list2, list3, new NameResolverImpl(stringTable, qualifiedNameTable));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

