/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.types;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.symbols.FqNameEqualityChecker;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeCheckerContext;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u001a\u001a\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\r\u001a\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f*\u00020\u000b\u001a\u0012\u0010\u0010\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u0011"}, d2={"isBoxedArray", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "getArrayElementType", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "isNullable", "isSubtypeOf", "superType", "isSubtypeOfClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "superClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "superTypes", "", "toArrayOrPrimitiveArrayType", "ir.tree"})
public final class IrTypeUtilsKt {
    @NotNull
    public static final List<IrType> superTypes(@NotNull IrClassifierSymbol $this$superTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$superTypes, (String)"$this$superTypes");
        IrClassifierSymbol irClassifierSymbol = $this$superTypes;
        return irClassifierSymbol instanceof IrClassSymbol ? ((IrClass)((IrClassSymbol)$this$superTypes).getOwner()).getSuperTypes() : (irClassifierSymbol instanceof IrTypeParameterSymbol ? ((IrTypeParameter)((IrTypeParameterSymbol)$this$superTypes).getOwner()).getSuperTypes() : CollectionsKt.emptyList());
    }

    public static final boolean isSubtypeOfClass(@NotNull IrClassifierSymbol $this$isSubtypeOfClass, @NotNull IrClassSymbol superClass) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOfClass, (String)"$this$isSubtypeOfClass");
            Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
            if (FqNameEqualityChecker.INSTANCE.areEqual($this$isSubtypeOfClass, superClass)) {
                return true;
            }
            Iterable $this$any$iv = IrTypeUtilsKt.superTypes($this$isSubtypeOfClass);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrType it = (IrType)element$iv;
                    boolean bl2 = false;
                    if (!IrTypeUtilsKt.isSubtypeOfClass(it, superClass)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isSubtypeOfClass(@NotNull IrType $this$isSubtypeOfClass, @NotNull IrClassSymbol superClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOfClass, (String)"$this$isSubtypeOfClass");
        Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
        if (!($this$isSubtypeOfClass instanceof IrSimpleType)) {
            return false;
        }
        return IrTypeUtilsKt.isSubtypeOfClass(((IrSimpleType)$this$isSubtypeOfClass).getClassifier(), superClass);
    }

    public static final boolean isSubtypeOf(@NotNull IrType $this$isSubtypeOf, @NotNull IrType superType, @NotNull IrBuiltIns irBuiltIns) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOf, (String)"$this$isSubtypeOf");
        Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, new IrTypeCheckerContext(irBuiltIns), (KotlinTypeMarker)$this$isSubtypeOf, (KotlinTypeMarker)superType, false, 8, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNullable(@NotNull IrType $this$isNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullable, (String)"$this$isNullable");
        IrType irType = $this$isNullable;
        if (irType instanceof IrSimpleType) {
            IrClassifierSymbol classifier = ((IrSimpleType)$this$isNullable).getClassifier();
            if (!(classifier instanceof IrClassSymbol)) {
                if (classifier instanceof IrTypeParameterSymbol) {
                    IrType p1;
                    if (((IrSimpleType)$this$isNullable).getHasQuestionMark()) return true;
                    Iterable $this$any$iv = ((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getSuperTypes();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        return false;
                    }
                    Iterator iterator2 = $this$any$iv.iterator();
                    do {
                        if (!iterator2.hasNext()) return false;
                        Object element$iv = iterator2.next();
                        p1 = (IrType)element$iv;
                        boolean bl = false;
                    } while (!IrTypeUtilsKt.isNullable(p1));
                    return true;
                }
                String string2 = "Unsupported classifier: " + classifier;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        } else {
            if (!(irType instanceof IrDynamicType)) return false;
            return true;
        }
        boolean bl = ((IrSimpleType)$this$isNullable).getHasQuestionMark();
        return bl;
    }

    public static final boolean isBoxedArray(@NotNull IrType $this$isBoxedArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isBoxedArray, (String)"$this$isBoxedArray");
        Object object = IrTypesKt.getClassOrNull($this$isBoxedArray);
        return Intrinsics.areEqual(object != null && (object = (IrClass)object.getOwner()) != null ? IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object) : null, (Object)StandardNames.FqNames.array.toSafe());
    }

    @NotNull
    public static final IrType getArrayElementType(@NotNull IrType $this$getArrayElementType, @NotNull IrBuiltIns irBuiltIns) {
        IrType irType;
        Intrinsics.checkNotNullParameter((Object)$this$getArrayElementType, (String)"$this$getArrayElementType");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        if (IrTypeUtilsKt.isBoxedArray($this$getArrayElementType)) {
            Object object = CollectionsKt.single(((IrSimpleType)$this$getArrayElementType).getArguments());
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrTypeProjection");
            }
            irType = ((IrTypeProjection)object).getType();
        } else {
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$getArrayElementType);
            Intrinsics.checkNotNull((Object)irClassSymbol);
            IrClassSymbol classifier = irClassSymbol;
            irType = irBuiltIns.getPrimitiveArrayElementTypes().get(classifier);
            if (irType == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Primitive array expected: " + classifier)));
            }
        }
        return irType;
    }

    @NotNull
    public static final IrType toArrayOrPrimitiveArrayType(@NotNull IrType $this$toArrayOrPrimitiveArrayType, @NotNull IrBuiltIns irBuiltIns) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toArrayOrPrimitiveArrayType, (String)"$this$toArrayOrPrimitiveArrayType");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        if (IrTypePredicatesKt.isPrimitiveType($this$toArrayOrPrimitiveArrayType)) {
            object = irBuiltIns.getPrimitiveArrayForType().get($this$toArrayOrPrimitiveArrayType);
            if (object == null || (object = IrTypesKt.getDefaultType((IrClassifierSymbol)object)) == null) {
                throw (Throwable)((Object)new AssertionError((Object)($this$toArrayOrPrimitiveArrayType + " not in primitiveArrayForType")));
            }
        } else {
            object = IrTypesKt.typeWith((IrClassifierSymbol)irBuiltIns.getArrayClass(), $this$toArrayOrPrimitiveArrayType);
        }
        return object;
    }
}

