/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.signaturer;

import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.signaturer.FirMangler;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "mangler", "Lorg/jetbrains/kotlin/fir/signaturer/FirMangler;", "(Lorg/jetbrains/kotlin/fir/signaturer/FirMangler;)V", "relativeCallableName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/symbols/CallableId;", "getRelativeCallableName", "(Lorg/jetbrains/kotlin/fir/symbols/CallableId;)Lorg/jetbrains/kotlin/name/FqName;", "composeAccessorSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "isSetter", "", "composeSignature", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "SignatureBuilder", "fir2ir"})
public final class FirBasedSignatureComposer
implements Fir2IrSignatureComposer {
    private final FirMangler mangler;

    private final FqName getRelativeCallableName(CallableId $this$relativeCallableName) {
        FqName fqName2 = $this$relativeCallableName.getClassName();
        if (fqName2 == null || (fqName2 = fqName2.child($this$relativeCallableName.getCallableName())) == null) {
            FqName fqName3 = FqName.topLevel($this$relativeCallableName.getCallableName());
            fqName2 = fqName3;
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"FqName.topLevel(callableName)");
        }
        return fqName2;
    }

    @Override
    @Nullable
    public IdSignature composeSignature(@NotNull FirDeclaration declaration) {
        IdSignature.PublicSignature publicSignature;
        block13: {
            block14: {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                if (declaration instanceof FirAnonymousObject || declaration instanceof FirAnonymousFunction) {
                    return null;
                }
                if (declaration instanceof FirRegularClass && FirDeclarationUtilKt.getClassId((FirClass)declaration).isLocal()) {
                    return null;
                }
                if (!(declaration instanceof FirCallableMemberDeclaration)) break block13;
                FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
                boolean $i$f$getVisibility = false;
                if (Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) break block14;
                ClassId classId = ((FirCallableMemberDeclaration)declaration).getSymbol().getCallableId().getClassId();
                if (classId == null) break block13;
                if (!classId.isLocal()) break block13;
            }
            return null;
        }
        SignatureBuilder builder = new SignatureBuilder();
        try {
            declaration.accept(builder);
        }
        catch (Throwable t) {
            throw (Throwable)new IllegalStateException("Error while composing signature for " + FirRendererKt.render$default(declaration, null, 1, null), t);
        }
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirRegularClass) {
            ClassId classId = FirDeclarationUtilKt.getClassId((FirClass)declaration);
            String string2 = classId.getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classId.packageFqName.asString()");
            String string3 = classId.getRelativeClassName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"classId.relativeClassName.asString()");
            publicSignature = new IdSignature.PublicSignature(string2, string3, builder.getHashId(), builder.getMask());
        } else if (firDeclaration instanceof FirTypeAlias) {
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$getVisibility = false;
            if (Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) {
                return null;
            }
            ClassId classId = ((FirTypeAlias)declaration).getSymbol().getClassId();
            String string4 = classId.getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"classId.packageFqName.asString()");
            String string5 = classId.getRelativeClassName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"classId.relativeClassName.asString()");
            publicSignature = new IdSignature.PublicSignature(string4, string5, builder.getHashId(), builder.getMask());
        } else if (firDeclaration instanceof FirCallableMemberDeclaration) {
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$getVisibility = false;
            if (Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) {
                return null;
            }
            CallableId callableId = ((FirCallableMemberDeclaration)declaration).getSymbol().getCallableId();
            String string6 = callableId.getPackageName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"callableId.packageName.asString()");
            String string7 = this.getRelativeCallableName(callableId).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"callableId.relativeCallableName.asString()");
            publicSignature = new IdSignature.PublicSignature(string6, string7, builder.getHashId(), builder.getMask());
        } else {
            String string8 = "Unsupported FIR declaration in signature composer: " + FirRendererKt.render$default(declaration, null, 1, null);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string8.toString());
        }
        return publicSignature;
    }

    @Override
    @Nullable
    public IdSignature composeAccessorSignature(@NotNull FirProperty property2, boolean isSetter) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        IdSignature idSignature = this.composeSignature(property2);
        if (!(idSignature instanceof IdSignature.PublicSignature)) {
            idSignature = null;
        }
        IdSignature.PublicSignature publicSignature = (IdSignature.PublicSignature)idSignature;
        if (publicSignature == null) {
            return null;
        }
        IdSignature.PublicSignature propertySignature = publicSignature;
        String accessorFqName = isSetter ? propertySignature.getDeclarationFqName() + ".<set-" + property2.getName().asString() + '>' : propertySignature.getDeclarationFqName() + ".<get-" + property2.getName().asString() + '>';
        return new IdSignature.PublicSignature(propertySignature.getPackageFqName(), accessorFqName, propertySignature.getId(), propertySignature.getMask());
    }

    public FirBasedSignatureComposer(@NotNull FirMangler mangler) {
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        this.mangler = mangler;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'H\u0016R\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer$SignatureBuilder;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "(Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;)V", "hashId", "", "getHashId", "()Ljava/lang/Long;", "setHashId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "mask", "getMask", "()J", "setMask", "(J)V", "setExpected", "", "f", "", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "fir2ir"})
    public final class SignatureBuilder
    extends FirVisitorVoid {
        private Long hashId;
        private long mask;

        @Nullable
        public final Long getHashId() {
            return this.hashId;
        }

        public final void setHashId(@Nullable Long l) {
            this.hashId = l;
        }

        public final long getMask() {
            return this.mask;
        }

        public final void setMask(long l) {
            this.mask = l;
        }

        private final void setExpected(boolean f) {
            this.mask |= IdSignature.Flags.IS_EXPECT.encode(f);
        }

        @Override
        public void visitElement(@NotNull FirElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String string2 = "Should not be here";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass) {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            FirMemberDeclaration $this$isExpect$iv = regularClass;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitTypeAlias(@NotNull FirTypeAlias typeAlias) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            FirMemberDeclaration $this$isExpect$iv = typeAlias;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitConstructor(@NotNull FirConstructor constructor2) {
            void $this$run;
            Long l;
            Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
            FirMangler firMangler = FirBasedSignatureComposer.this.mangler;
            boolean bl = false;
            boolean bl2 = false;
            FirMangler firMangler2 = firMangler;
            SignatureBuilder signatureBuilder = this;
            boolean bl3 = false;
            signatureBuilder.hashId = l = Long.valueOf($this$run.getSignatureMangle((FirDeclaration)constructor2));
            FirMemberDeclaration $this$isExpect$iv = constructor2;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction) {
            void $this$run;
            Long l;
            Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            FirMangler firMangler = FirBasedSignatureComposer.this.mangler;
            boolean bl = false;
            boolean bl2 = false;
            FirMangler firMangler2 = firMangler;
            SignatureBuilder signatureBuilder = this;
            boolean bl3 = false;
            signatureBuilder.hashId = l = Long.valueOf($this$run.getSignatureMangle((FirDeclaration)simpleFunction));
            FirMemberDeclaration $this$isExpect$iv = simpleFunction;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitProperty(@NotNull FirProperty property2) {
            void $this$run;
            Long l;
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            FirMangler firMangler = FirBasedSignatureComposer.this.mangler;
            boolean bl = false;
            boolean bl2 = false;
            FirMangler firMangler2 = firMangler;
            SignatureBuilder signatureBuilder = this;
            boolean bl3 = false;
            signatureBuilder.hashId = l = Long.valueOf($this$run.getSignatureMangle((FirDeclaration)property2));
            FirMemberDeclaration $this$isExpect$iv = property2;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitEnumEntry(@NotNull FirEnumEntry enumEntry) {
            Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
            FirMemberDeclaration $this$isExpect$iv = enumEntry;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }
    }
}

