/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerScopeLevel;
import org.jetbrains.kotlin.fir.resolve.transformers.PhaseUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.KotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractProviderBasedScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirObjectImportedCallableScope;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJL\u0010\u000f\u001a\u00020\u0010\"\f\b\u0000\u0010\u0011*\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00182\u0016\u0010\u0019\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0004\u0012\u00020\u00100\u001aH\u0004JD\u0010\u000f\u001a\u00020\u0010\"\f\b\u0000\u0010\u0011*\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00182\u0016\u0010\u0019\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0004\u0012\u00020\u00100\u001aH&J&\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010\u0019\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u0004\u0012\u00020\u00100\u001aJ&\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010\u0019\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e\u0012\u0004\u0012\u00020\u00100\u001aR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractImportingScope;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractProviderBasedScope;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "lookupInFir", "", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Z)V", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getStaticsScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "processCallables", "", "T", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "import", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "name", "Lorg/jetbrains/kotlin/name/Name;", "token", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerScopeLevel$Token;", "processor", "Lkotlin/Function1;", "processFunctionsByName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "processPropertiesByName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "resolve"})
public abstract class FirAbstractImportingScope
extends FirAbstractProviderBasedScope {
    private final ScopeSession scopeSession;

    @Nullable
    public final FirScope getStaticsScope(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        FirClassLikeSymbol<?> firClassLikeSymbol = this.getProvider().getClassLikeSymbolByFqName(classId);
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> symbol2 = firClassLikeSymbol;
        if (symbol2 instanceof FirTypeAliasSymbol) {
            FirClassLikeSymbol<?> expansionSymbol;
            Object object = FirDeclarationUtilKt.getExpandedConeType((FirTypeAlias)((FirTypeAliasSymbol)symbol2).getFir());
            FirClassLikeSymbol<?> firClassLikeSymbol2 = object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, this.getSession()) : (expansionSymbol = null);
            if (expansionSymbol != null) {
                return this.getStaticsScope(expansionSymbol.getClassId());
            }
        } else {
            FirClassLikeSymbol<?> firClassLikeSymbol3 = symbol2;
            if (firClassLikeSymbol3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol<*>");
            }
            FirClass firClass = (FirClass)((FirClassSymbol)firClassLikeSymbol3).getFir();
            return firClass.getClassKind() == ClassKind.OBJECT ? (FirScope)new FirObjectImportedCallableScope(classId, KotlinScopeProviderKt.unsubstitutedScope(firClass, this.getSession(), this.scopeSession)) : firClass.getScopeProvider().getStaticScope(firClass, this.getSession(), this.scopeSession);
        }
        return null;
    }

    protected final <T extends FirCallableSymbol<?>> void processCallables(@NotNull FirResolvedImport firResolvedImport, @NotNull Name name, @NotNull TowerScopeLevel.Token<? extends T> token, @NotNull Function1<? super FirCallableSymbol<?>, Unit> processor2) {
        block8: {
            List<FirCallableSymbol<?>> symbols;
            CallableId callableId;
            block9: {
                block6: {
                    TowerScopeLevel.Token<? extends T> token2;
                    FirScope scope2;
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)firResolvedImport, (String)"import");
                        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                        Intrinsics.checkNotNullParameter(token, (String)"token");
                        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
                        callableId = new CallableId(firResolvedImport.getPackageFqName(), firResolvedImport.getRelativeClassName(), name, null, 8, null);
                        ClassId classId = firResolvedImport.getResolvedClassId();
                        if (classId == null) break block6;
                        FirScope firScope = this.getStaticsScope(classId);
                        if (firScope == null) {
                            return;
                        }
                        scope2 = firScope;
                        token2 = token;
                        if (!Intrinsics.areEqual(token2, (Object)TowerScopeLevel.Token.Functions.INSTANCE)) break block7;
                        scope2.processFunctionsByName(callableId.getCallableName(), processor2);
                        break block8;
                    }
                    if (!Intrinsics.areEqual(token2, (Object)TowerScopeLevel.Token.Properties.INSTANCE)) break block8;
                    scope2.processPropertiesByName(callableId.getCallableName(), processor2);
                    break block8;
                }
                if (name.isSpecial()) break block9;
                String string2 = name.getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.identifier");
                CharSequence scope2 = string2;
                boolean bl = false;
                if (!(scope2.length() > 0)) break block8;
            }
            if ((symbols = this.getProvider().getTopLevelCallableSymbols(callableId.getPackageName(), callableId.getCallableName())).isEmpty()) {
                return;
            }
            for (FirCallableSymbol<?> symbol2 : symbols) {
                PhaseUtilsKt.ensureResolvedForCalls((AbstractFirBasedSymbol)symbol2, this.getSession());
                processor2.invoke(symbol2);
            }
        }
    }

    public abstract <T extends FirCallableSymbol<?>> void processCallables(@NotNull Name var1, @NotNull TowerScopeLevel.Token<? extends T> var2, @NotNull Function1<? super FirCallableSymbol<?>, Unit> var3);

    @Override
    public final void processFunctionsByName(@NotNull Name name, @NotNull Function1<? super FirFunctionSymbol<?>, Unit> processor2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        this.processCallables(name, TowerScopeLevel.Token.Functions.INSTANCE, (Function1)new Function1<FirCallableSymbol<?>, Unit>(processor2){
            final /* synthetic */ Function1 $processor;

            public final void invoke(@NotNull FirCallableSymbol<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (it instanceof FirFunctionSymbol) {
                    this.$processor.invoke(it);
                }
            }
            {
                this.$processor = function1;
                super(1);
            }
        });
    }

    @Override
    public final void processPropertiesByName(@NotNull Name name, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        this.processCallables(name, TowerScopeLevel.Token.Properties.INSTANCE, (Function1)new Function1<FirCallableSymbol<?>, Unit>(processor2){
            final /* synthetic */ Function1 $processor;

            public final void invoke(@NotNull FirCallableSymbol<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (it instanceof FirVariableSymbol) {
                    this.$processor.invoke(it);
                }
            }
            {
                this.$processor = function1;
                super(1);
            }
        });
    }

    @NotNull
    protected final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    public FirAbstractImportingScope(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, boolean lookupInFir) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        super(session2, lookupInFir);
        this.scopeSession = scopeSession;
    }
}

