/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.GeneratedDeclarationValidationKt;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtension;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtensionKt;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProvider;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProviderKt;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.FirGlobalResolveProcessor;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.GeneratedClass;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.GeneratedClassIndex;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.GeneratedClassIndexKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirGlobalNewMemberGenerationProcessor;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirGlobalResolveProcessor;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "index", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/GeneratedClassIndex;", "provider", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProvider;", "fillGeneratedClasses", "", "extension", "Lorg/jetbrains/kotlin/fir/extensions/FirDeclarationGenerationExtension;", "generateNewMembers", "process", "resolve"})
public final class FirGlobalNewMemberGenerationProcessor
extends FirGlobalResolveProcessor {
    private final GeneratedClassIndex index;
    private final FirPredicateBasedProvider provider;

    @Override
    public void process() {
        List<FirDeclarationGenerationExtension> extensions = FirDeclarationGenerationExtensionKt.getDeclarationGenerators(FirExtensionServiceKt.getExtensionService(this.getSession()));
        if (extensions.isEmpty()) {
            return;
        }
        for (FirDeclarationGenerationExtension extension : extensions) {
            this.generateNewMembers(extension);
            this.fillGeneratedClasses(extension);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateNewMembers(FirDeclarationGenerationExtension extension) {
        List<Pair<FirAnnotatedDeclaration, List<FirAnnotatedDeclaration>>> declarations2 = this.provider.getSymbolsWithOwnersByPredicate(extension.getPredicate());
        for (Pair<FirAnnotatedDeclaration, List<FirAnnotatedDeclaration>> pair : declarations2) {
            void declaration;
            FirAnnotatedDeclaration firAnnotatedDeclaration = (FirAnnotatedDeclaration)pair.component1();
            List owners = (List)pair.component2();
            List<FirDeclarationGenerationExtension.GeneratedDeclaration<?>> newMembers = extension.generateMembers((FirDeclaration)declaration, owners);
            for (FirDeclarationGenerationExtension.GeneratedDeclaration<?> generatedDeclaration : newMembers) {
                void newMember;
                Object obj = generatedDeclaration.component1();
                FirAnnotatedDeclaration owner = generatedDeclaration.component2();
                GeneratedDeclarationValidationKt.validate((FirElement)newMember);
                FirAnnotatedDeclaration firAnnotatedDeclaration2 = owner;
                if (firAnnotatedDeclaration2 instanceof FirRegularClass) {
                    FirDeclarationUtilKt.addDeclaration((FirRegularClass)owner, (FirDeclaration)newMember);
                } else if (firAnnotatedDeclaration2 instanceof FirFile) {
                    FirDeclarationUtilKt.addDeclaration((FirFile)owner, (FirDeclaration)newMember);
                } else {
                    String string2 = "Should not be here";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                MainSessionComponentsKt.getFirProvider(this.getSession()).recordGeneratedMember(owner, (FirDeclaration)newMember);
            }
        }
    }

    private final void fillGeneratedClasses(FirDeclarationGenerationExtension extension) {
        for (GeneratedClass generatedClass : this.index.get(extension.getKey())) {
            FirRegularClass klass = generatedClass.getKlass();
            List<FirDeclaration> newMembers = extension.generateMembersForGeneratedClass(generatedClass);
            for (FirDeclaration newMember : newMembers) {
                GeneratedDeclarationValidationKt.validate(newMember);
                FirDeclarationUtilKt.addDeclaration(klass, newMember);
                MainSessionComponentsKt.getFirProvider(this.getSession()).recordGeneratedMember(klass, newMember);
            }
        }
    }

    public FirGlobalNewMemberGenerationProcessor(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        super(session2, scopeSession);
        this.index = GeneratedClassIndexKt.getGeneratedClassIndex(session2);
        this.provider = FirPredicateBasedProviderKt.getPredicateBasedProvider(session2);
    }
}

