/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.evaluate;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.interpreter.EvaluationMode;
import org.jetbrains.kotlin.ir.interpreter.IrCompileTimeChecker;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\f*\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\u00020\f*\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0014\u0010\u001a\u001a\u00020\f*\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001dH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/backend/evaluate/IrConstTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "(Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;)V", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "transformAnnotations", "", "annotationContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "convertToConstIfPossible", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "replaceIfError", "original", "transformSingleArg", "expectedType", "transformVarArg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "fir2ir"})
public final class IrConstTransformer
extends IrElementTransformerVoid {
    private final IrInterpreter interpreter;

    private final IrExpression replaceIfError(IrExpression $this$replaceIfError, IrExpression original) {
        return !($this$replaceIfError instanceof IrErrorExpression) ? $this$replaceIfError : original;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (((Boolean)expression2.accept(new IrCompileTimeChecker(null, EvaluationMode.ONLY_BUILTINS, 1, null), null)).booleanValue()) {
            return this.replaceIfError(this.interpreter.interpret(expression2), expression2);
        }
        return expression2;
    }

    @Override
    @NotNull
    public IrStatement visitField(@NotNull IrField declaration) {
        boolean isConst;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.transformAnnotations(declaration);
        IrExpressionBody initializer2 = declaration.getInitializer();
        IrElementBase irElementBase = initializer2;
        if (irElementBase == null || (irElementBase = ((IrExpressionBody)irElementBase).getExpression()) == null) {
            return declaration;
        }
        IrElementBase expression2 = irElementBase;
        if (expression2 instanceof IrConst) {
            return declaration;
        }
        Object object = declaration.getCorrespondingPropertySymbol();
        boolean bl = object != null && (object = (IrProperty)object.getOwner()) != null && ((IrProperty)object).isConst() ? true : (isConst = false);
        if (isConst && ((Boolean)expression2.accept(new IrCompileTimeChecker(declaration, EvaluationMode.ONLY_BUILTINS), null)).booleanValue()) {
            initializer2.setExpression(this.replaceIfError(this.interpreter.interpret((IrExpression)expression2), (IrExpression)expression2));
        }
        return declaration;
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.transformAnnotations(declaration);
        return super.visitDeclaration(declaration);
    }

    /*
     * WARNING - void declaration
     */
    private final void transformAnnotations(IrAnnotationContainer annotationContainer) {
        Iterable $this$forEach$iv = annotationContainer.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrConstructorCall annotation2 = (IrConstructorCall)element$iv;
            boolean bl = false;
            int n = 0;
            int n2 = annotation2.getValueArgumentsCount();
            while (n < n2) {
                void i;
                if (annotation2.getValueArgument((int)i) == null) {
                } else {
                    IrExpression arg;
                    IrExpression irExpression = arg;
                    if (irExpression instanceof IrVararg) {
                        annotation2.putValueArgument((int)i, this.transformVarArg((IrVararg)arg));
                    } else {
                        annotation2.putValueArgument((int)i, this.transformSingleArg(arg, ((IrConstructor)annotation2.getSymbol().getOwner()).getValueParameters().get((int)i).getType()));
                    }
                }
                ++i;
            }
        }
    }

    private final IrVararg transformVarArg(IrVararg $this$transformVarArg) {
        if ($this$transformVarArg.getElements().isEmpty()) {
            return $this$transformVarArg;
        }
        IrVarargImpl newIrVararg = new IrVarargImpl($this$transformVarArg.getStartOffset(), $this$transformVarArg.getEndOffset(), $this$transformVarArg.getType(), $this$transformVarArg.getVarargElementType());
        for (IrVarargElement element : $this$transformVarArg.getElements()) {
            IrVarargElement irVarargElement = element;
            if (irVarargElement instanceof IrExpression) {
                newIrVararg.addElement(this.transformSingleArg((IrExpression)element, $this$transformVarArg.getVarargElementType()));
                continue;
            }
            if (!(irVarargElement instanceof IrSpreadElement)) continue;
            IrExpression expression2 = ((IrSpreadElement)element).getExpression();
            if (expression2 instanceof IrVararg) {
                Iterable $this$forEach$iv = this.transformVarArg((IrVararg)expression2).getElements();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrVarargElement it = (IrVarargElement)element$iv;
                    boolean bl = false;
                    newIrVararg.addElement(it);
                }
                continue;
            }
            newIrVararg.addElement(this.transformSingleArg(expression2, $this$transformVarArg.getVarargElementType()));
        }
        return newIrVararg;
    }

    private final IrExpression transformSingleArg(IrExpression $this$transformSingleArg, IrType expectedType2) {
        if (((Boolean)$this$transformSingleArg.accept(new IrCompileTimeChecker(null, EvaluationMode.ONLY_BUILTINS, 1, null), null)).booleanValue()) {
            IrExpression irExpression = this.replaceIfError(this.interpreter.interpret($this$transformSingleArg), $this$transformSingleArg);
            return this.convertToConstIfPossible(irExpression, expectedType2);
        }
        return $this$transformSingleArg;
    }

    private final IrExpression convertToConstIfPossible(IrExpression $this$convertToConstIfPossible, IrType type2) {
        if (!($this$convertToConstIfPossible instanceof IrConst) || type2 instanceof IrErrorType) {
            return $this$convertToConstIfPossible;
        }
        if (IrTypePredicatesKt.isArray(type2)) {
            IrType irType = type2;
            if (irType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            }
            IrType irType2 = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.single(((IrSimpleType)irType).getArguments()));
            Intrinsics.checkNotNull((Object)irType2);
            return this.convertToConstIfPossible($this$convertToConstIfPossible, irType2);
        }
        return UtilsKt.toIrConst(((IrConst)$this$convertToConstIfPossible).getValue(), type2, $this$convertToConstIfPossible.getStartOffset(), $this$convertToConstIfPossible.getEndOffset());
    }

    public IrConstTransformer(@NotNull IrBuiltIns irBuiltIns) {
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        this.interpreter = new IrInterpreter(irBuiltIns, null, 2, null);
    }
}

