/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.backend.Fir2IrScopeCache;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\u0004\u0018\u00010\t2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fJ1\u0010 \u001a\u0004\u0018\u0001H!\"\u0004\b\u0000\u0010!2\u0019\u0010\"\u001a\u0015\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u0001H!0#\u00a2\u0006\u0002\b$H\u0082\b\u00a2\u0006\u0002\u0010%J\u0006\u0010&\u001a\u00020\u000bJ\u0016\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\rJ\u001a\u0010*\u001a\u00020\u000b2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010,\u001a\u00020\tJ\u001a\u0010-\u001a\u00020\u000b2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010/\u001a\u00020\u0015J\u0016\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u0019J\u001a\u00103\u001a\u00020\u000b2\n\u00104\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u00105\u001a\u00020\u001dR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrLocalStorage;", "", "()V", "cacheStack", "", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrScopeCache;", "localClassCache", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "enterCallable", "", "getDelegatedProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrLocalDelegatedProperty;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getLocalClass", "localClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getLocalFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "localFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "getParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "last", "T", "getter", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "leaveCallable", "putDelegatedProperty", "firProperty", "irProperty", "putLocalClass", "firClass", "irClass", "putLocalFunction", "firFunction", "irFunction", "putParameter", "firParameter", "irParameter", "putVariable", "firVariable", "irVariable", "fir2ir"})
public final class Fir2IrLocalStorage {
    private final List<Fir2IrScopeCache> cacheStack;
    private final Map<FirClass<?>, IrClass> localClassCache;

    public final void enterCallable() {
        Collection collection = this.cacheStack;
        Fir2IrScopeCache fir2IrScopeCache = new Fir2IrScopeCache();
        boolean bl = false;
        collection.add(fir2IrScopeCache);
    }

    public final void leaveCallable() {
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).clear();
        this.cacheStack.remove(this.cacheStack.size() - 1);
    }

    @Nullable
    public final IrValueParameter getParameter(@NotNull FirValueParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        for (Fir2IrScopeCache cache2 : CollectionsKt.asReversedMutable(this.cacheStack)) {
            IrValueParameter local = cache2.getParameter(parameter);
            if (local == null) continue;
            return local;
        }
        return null;
    }

    @Nullable
    public final IrVariable getVariable(@NotNull FirVariable<?> variable2) {
        IrVariable irVariable2;
        block1: {
            Intrinsics.checkNotNullParameter(variable2, (String)"variable");
            Fir2IrLocalStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator iterator2 = CollectionsKt.asReversedMutable((List)this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$last = cache$iv = (Fir2IrScopeCache)iterator2.next();
                boolean bl = false;
                IrVariable irVariable3 = $this$last.getVariable(variable2);
                if (irVariable3 == null) continue;
                IrVariable irVariable4 = irVariable3;
                boolean bl2 = false;
                boolean bl3 = false;
                IrVariable it$iv = irVariable4;
                boolean bl4 = false;
                irVariable2 = it$iv;
                break block1;
            }
            irVariable2 = null;
        }
        return irVariable2;
    }

    @Nullable
    public final IrClass getLocalClass(@NotNull FirClass<?> localClass) {
        Intrinsics.checkNotNullParameter(localClass, (String)"localClass");
        return this.localClassCache.get(localClass);
    }

    @Nullable
    public final IrClass getLocalClass(@NotNull ClassId classId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            Iterable iterable = this.localClassCache.entrySet();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Map.Entry $dstr$firClass$_u24__u24 = (Map.Entry)t;
                boolean bl3 = false;
                Map.Entry entry = $dstr$firClass$_u24__u24;
                boolean bl4 = false;
                FirClass firClass = (FirClass)entry.getKey();
                if (!Intrinsics.areEqual((Object)FirDeclarationUtilKt.getClassId(firClass), (Object)classId)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? (IrClass)entry.getValue() : null;
    }

    @Nullable
    public final IrSimpleFunction getLocalFunction(@NotNull FirFunction<?> localFunction) {
        IrSimpleFunction irSimpleFunction;
        block1: {
            Intrinsics.checkNotNullParameter(localFunction, (String)"localFunction");
            Fir2IrLocalStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator iterator2 = CollectionsKt.asReversedMutable((List)this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$last = cache$iv = (Fir2IrScopeCache)iterator2.next();
                boolean bl = false;
                IrSimpleFunction irSimpleFunction2 = $this$last.getLocalFunction(localFunction);
                if (irSimpleFunction2 == null) continue;
                IrSimpleFunction irSimpleFunction3 = irSimpleFunction2;
                boolean bl2 = false;
                boolean bl3 = false;
                IrSimpleFunction it$iv = irSimpleFunction3;
                boolean bl4 = false;
                irSimpleFunction = it$iv;
                break block1;
            }
            irSimpleFunction = null;
        }
        return irSimpleFunction;
    }

    @Nullable
    public final IrLocalDelegatedProperty getDelegatedProperty(@NotNull FirProperty property2) {
        IrLocalDelegatedProperty irLocalDelegatedProperty;
        block1: {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            Fir2IrLocalStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator iterator2 = CollectionsKt.asReversedMutable((List)this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$last = cache$iv = (Fir2IrScopeCache)iterator2.next();
                boolean bl = false;
                IrLocalDelegatedProperty irLocalDelegatedProperty2 = $this$last.getDelegatedProperty(property2);
                if (irLocalDelegatedProperty2 == null) continue;
                IrLocalDelegatedProperty irLocalDelegatedProperty3 = irLocalDelegatedProperty2;
                boolean bl2 = false;
                boolean bl3 = false;
                IrLocalDelegatedProperty it$iv = irLocalDelegatedProperty3;
                boolean bl4 = false;
                irLocalDelegatedProperty = it$iv;
                break block1;
            }
            irLocalDelegatedProperty = null;
        }
        return irLocalDelegatedProperty;
    }

    private final <T> T last(Function1<? super Fir2IrScopeCache, ? extends T> getter2) {
        int $i$f$last = 0;
        for (Fir2IrScopeCache cache2 : CollectionsKt.asReversedMutable((List)this.cacheStack)) {
            Object object = getter2.invoke((Object)cache2);
            if (object == null) continue;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            return (T)it;
        }
        return null;
    }

    public final void putParameter(@NotNull FirValueParameter firParameter, @NotNull IrValueParameter irParameter2) {
        Intrinsics.checkNotNullParameter((Object)firParameter, (String)"firParameter");
        Intrinsics.checkNotNullParameter((Object)irParameter2, (String)"irParameter");
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).putParameter(firParameter, irParameter2);
    }

    public final void putVariable(@NotNull FirVariable<?> firVariable, @NotNull IrVariable irVariable2) {
        Intrinsics.checkNotNullParameter(firVariable, (String)"firVariable");
        Intrinsics.checkNotNullParameter((Object)irVariable2, (String)"irVariable");
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).putVariable(firVariable, irVariable2);
    }

    public final void putLocalClass(@NotNull FirClass<?> firClass, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(firClass, (String)"firClass");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        this.localClassCache.put(firClass, irClass2);
    }

    public final void putLocalFunction(@NotNull FirFunction<?> firFunction, @NotNull IrSimpleFunction irFunction2) {
        Intrinsics.checkNotNullParameter(firFunction, (String)"firFunction");
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).putLocalFunction(firFunction, irFunction2);
    }

    public final void putDelegatedProperty(@NotNull FirProperty firProperty, @NotNull IrLocalDelegatedProperty irProperty2) {
        Intrinsics.checkNotNullParameter((Object)firProperty, (String)"firProperty");
        Intrinsics.checkNotNullParameter((Object)irProperty2, (String)"irProperty");
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).putDelegatedProperty(firProperty, irProperty2);
    }

    public Fir2IrLocalStorage() {
        boolean bl = false;
        this.cacheStack = new ArrayList();
        bl = false;
        this.localClassCache = new LinkedHashMap();
    }
}

