/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirTypeMismatchOnOverrideChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.KotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.AbstractTypeCheckerContext;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J0\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J0\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J4\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u0006\u0012\u0002\b\u00030\u00182\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001a*\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001a*\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u001f\u001a\u00020\u0006*\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\u0017H\u0002J&\u0010$\u001a\u00020\u0006*\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\u0017H\u0002J&\u0010%\u001a\u00020\u0006*\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\u0017H\u0002J$\u0010&\u001a\u00020'*\u00020'2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\u00182\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeMismatchOnOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "typeCheckerContext", "Lorg/jetbrains/kotlin/types/AbstractTypeCheckerContext;", "firTypeScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "checkProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkReturnType", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "overriddenSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getDirectOverridesOf", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "reportMismatchOnFunction", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "type", "", "reportMismatchOnProperty", "reportMismatchOnVariable", "substituteAllTypeParameters", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "overrideDeclaration", "baseDeclarationSymbol", "checkers"})
public final class FirTypeMismatchOnOverrideChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirTypeMismatchOnOverrideChecker INSTANCE;

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        AbstractTypeCheckerContext typeCheckerContext = SessionUtilsKt.getTypeContext(context2.getSession()).newBaseTypeCheckerContext(false, false);
        FirTypeScope firTypeScope = KotlinScopeProviderKt.unsubstitutedScope(declaration, context2.getSessionHolder().getSession(), context2.getSessionHolder().getScopeSession());
        for (FirDeclaration it : declaration.getDeclarations()) {
            FirDeclaration firDeclaration = it;
            if (firDeclaration instanceof FirSimpleFunction) {
                this.checkFunction((FirSimpleFunction)it, reporter, typeCheckerContext, firTypeScope, context2);
                continue;
            }
            if (!(firDeclaration instanceof FirProperty)) continue;
            this.checkProperty((FirProperty)it, reporter, typeCheckerContext, firTypeScope, context2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirFunctionSymbol<?>> getDirectOverridesOf(FirTypeScope $this$getDirectOverridesOf, FirSimpleFunction function2) {
        void $this$processDirectlyOverriddenFunctions$iv;
        boolean bl = false;
        Set overriddenFunctions2 = new LinkedHashSet();
        $this$getDirectOverridesOf.processFunctionsByName(function2.getName(), getDirectOverridesOf.1.INSTANCE);
        FirTypeScope firTypeScope = $this$getDirectOverridesOf;
        FirFunctionSymbol<FirSimpleFunction> functionSymbol$iv = function2.getSymbol();
        boolean $i$f$processDirectlyOverriddenFunctions = false;
        $this$processDirectlyOverriddenFunctions$iv.processDirectOverriddenFunctionsWithBaseScope(functionSymbol$iv, (Function2)new Function2<FirFunctionSymbol<?>, FirTypeScope, ProcessorAction>(overriddenFunctions2){
            final /* synthetic */ Set $overriddenFunctions$inlined;
            {
                this.$overriddenFunctions$inlined = set;
                super(2);
            }

            @NotNull
            public final ProcessorAction invoke(@NotNull FirFunctionSymbol<?> overridden, @NotNull FirTypeScope $noName_1) {
                Intrinsics.checkNotNullParameter(overridden, (String)"overridden");
                Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                FirFunctionSymbol<?> it = overridden;
                boolean bl = false;
                this.$overriddenFunctions$inlined.add(it);
                return ProcessorAction.NEXT;
            }
        });
        return CollectionsKt.toList((Iterable)overriddenFunctions2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirPropertySymbol> getDirectOverridesOf(FirTypeScope $this$getDirectOverridesOf, FirProperty property2) {
        void $this$processDirectlyOverriddenProperties$iv;
        boolean bl = false;
        Set overriddenProperties = new LinkedHashSet();
        $this$getDirectOverridesOf.processPropertiesByName(property2.getName(), getDirectOverridesOf.3.INSTANCE);
        FirTypeScope firTypeScope = $this$getDirectOverridesOf;
        FirPropertySymbol propertySymbol$iv = property2.getSymbol();
        boolean $i$f$processDirectlyOverriddenProperties = false;
        $this$processDirectlyOverriddenProperties$iv.processDirectOverriddenPropertiesWithBaseScope(propertySymbol$iv, (Function2<? super FirPropertySymbol, ? super FirTypeScope, ? extends ProcessorAction>)((Function2)new Function2<FirPropertySymbol, FirTypeScope, ProcessorAction>(overriddenProperties){
            final /* synthetic */ Set $overriddenProperties$inlined;
            {
                this.$overriddenProperties$inlined = set;
                super(2);
            }

            @NotNull
            public final ProcessorAction invoke(@NotNull FirPropertySymbol overridden, @NotNull FirTypeScope $noName_1) {
                Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
                Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                FirPropertySymbol it = overridden;
                boolean bl = false;
                this.$overriddenProperties$inlined.add(it);
                return ProcessorAction.NEXT;
            }
        }));
        return CollectionsKt.toList((Iterable)overriddenProperties);
    }

    /*
     * WARNING - void declaration
     */
    private final ConeKotlinType substituteAllTypeParameters(ConeKotlinType $this$substituteAllTypeParameters, FirCallableMemberDeclaration<?> overrideDeclaration, FirCallableSymbol<?> baseDeclarationSymbol) {
        if (overrideDeclaration.getTypeParameters().isEmpty()) {
            return $this$substituteAllTypeParameters;
        }
        Object $this$safeAs$iv = baseDeclarationSymbol.getFir();
        boolean $i$f$safeAs = false;
        Object e = $this$safeAs$iv;
        if (!(e instanceof FirTypeParametersOwner)) {
            e = null;
        }
        FirTypeParametersOwner firTypeParametersOwner = (FirTypeParametersOwner)e;
        if (firTypeParametersOwner == null) {
            return $this$substituteAllTypeParameters;
        }
        FirTypeParametersOwner parametersOwner = firTypeParametersOwner;
        $i$f$safeAs = false;
        Map map2 = new LinkedHashMap();
        int size2 = ((Number)((Object)AddToStdlibKt.min(overrideDeclaration.getTypeParameters().size(), parametersOwner.getTypeParameters().size()))).intValue();
        int n = 0;
        int n2 = size2;
        while (n < n2) {
            void it;
            FirTypeParameterRef to = overrideDeclaration.getTypeParameters().get((int)it);
            FirTypeParameter from = parametersOwner.getTypeParameters().get((int)it);
            map2.put(from.getSymbol(), FirNestedClassifierScopeKt.toConeType(to));
            ++it;
        }
        return SubstitutorsKt.substitutorByMap(map2).substituteOrSelf($this$substituteAllTypeParameters);
    }

    /*
     * WARNING - void declaration
     */
    private final FirMemberDeclaration checkReturnType(FirCallableMemberDeclaration<?> $this$checkReturnType, List<? extends FirCallableSymbol<?>> overriddenSymbols2, AbstractTypeCheckerContext typeCheckerContext, CheckerContext context2) {
        void $this$mapTo$iv$iv;
        Object object;
        FirTypeRef $this$safeAs$iv = $this$checkReturnType.getReturnTypeRef();
        boolean $i$f$safeAs = false;
        FirTypeRef firTypeRef = $this$safeAs$iv;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        if ((object = (FirResolvedTypeRef)firTypeRef) == null || (object = ((FirResolvedTypeRef)object).getType()) == null) {
            return null;
        }
        Object returnType2 = object;
        Iterable $this$map$iv22 = overriddenSymbols2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirCallableSymbol firCallableSymbol = (FirCallableSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FirTypeRef $this$coneType$iv = context2.getReturnTypeCalculator().tryCalculateReturnType((FirTypedDeclaration)it.getFir());
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            ConeKotlinType coneKotlinType2 = ConeTypesKt.upperBoundIfFlexible(coneKotlinType);
            collection.add(coneKotlinType2);
        }
        List bounds = (List)destination$iv$iv;
        int $this$map$iv22 = 0;
        int n = ((Collection)bounds).size();
        while ($this$map$iv22 < n) {
            void it;
            ConeKotlinType restriction = this.substituteAllTypeParameters((ConeKotlinType)bounds.get((int)it), $this$checkReturnType, overriddenSymbols2.get((int)it));
            if (!AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerContext, (KotlinTypeMarker)returnType2, (KotlinTypeMarker)restriction, false, 8, null)) {
                Object $this$safeAs$iv2 = overriddenSymbols2.get((int)it).getFir();
                boolean $i$f$safeAs2 = false;
                Object e = $this$safeAs$iv2;
                if (!(e instanceof FirMemberDeclaration)) {
                    e = null;
                }
                return (FirMemberDeclaration)e;
            }
            ++it;
        }
        return null;
    }

    private final void checkFunction(FirSimpleFunction function2, DiagnosticReporter reporter, AbstractTypeCheckerContext typeCheckerContext, FirTypeScope firTypeScope, CheckerContext context2) {
        block3: {
            FirMemberDeclaration restriction;
            FirMemberDeclaration $this$isOverride$iv = function2;
            boolean $i$f$isOverride = false;
            if (!$this$isOverride$iv.getStatus().isOverride()) {
                return;
            }
            List<FirFunctionSymbol<?>> overriddenFunctionSymbols = this.getDirectOverridesOf(firTypeScope, function2);
            if (overriddenFunctionSymbols.isEmpty()) {
                return;
            }
            FirMemberDeclaration firMemberDeclaration = restriction = this.checkReturnType(function2, overriddenFunctionSymbols, typeCheckerContext, context2);
            if (firMemberDeclaration == null) break block3;
            FirMemberDeclaration firMemberDeclaration2 = firMemberDeclaration;
            boolean bl = false;
            boolean bl2 = false;
            FirMemberDeclaration it = firMemberDeclaration2;
            boolean bl3 = false;
            FirTypeRef $this$coneType$iv = function2.getReturnTypeRef();
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            INSTANCE.reportMismatchOnFunction(reporter, function2.getReturnTypeRef().getSource(), coneKotlinType.toString(), it);
        }
    }

    private final void checkProperty(FirProperty property2, DiagnosticReporter reporter, AbstractTypeCheckerContext typeCheckerContext, FirTypeScope firTypeScope, CheckerContext context2) {
        block6: {
            FirMemberDeclaration restriction;
            FirMemberDeclaration $this$isOverride$iv = property2;
            boolean $i$f$isOverride = false;
            if (!$this$isOverride$iv.getStatus().isOverride()) {
                return;
            }
            List<FirPropertySymbol> overriddenPropertySymbols = this.getDirectOverridesOf(firTypeScope, property2);
            if (overriddenPropertySymbols.isEmpty()) {
                return;
            }
            FirMemberDeclaration firMemberDeclaration = restriction = this.checkReturnType(property2, overriddenPropertySymbols, typeCheckerContext, context2);
            if (firMemberDeclaration == null) break block6;
            FirMemberDeclaration firMemberDeclaration2 = firMemberDeclaration;
            boolean bl = false;
            boolean bl2 = false;
            FirMemberDeclaration it = firMemberDeclaration2;
            boolean bl3 = false;
            if (property2.isVar()) {
                FirTypeRef $this$coneType$iv = property2.getReturnTypeRef();
                boolean $i$f$getConeType = false;
                FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
                boolean $i$f$coneTypeUnsafe = false;
                ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
                if (coneKotlinType == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                }
                INSTANCE.reportMismatchOnVariable(reporter, property2.getReturnTypeRef().getSource(), coneKotlinType.toString(), it);
            } else {
                FirTypeRef $this$coneType$iv = property2.getReturnTypeRef();
                boolean $i$f$getConeType = false;
                FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
                boolean $i$f$coneTypeUnsafe = false;
                ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
                if (coneKotlinType == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                }
                INSTANCE.reportMismatchOnProperty(reporter, property2.getReturnTypeRef().getSource(), coneKotlinType.toString(), it);
            }
        }
    }

    private final void reportMismatchOnFunction(DiagnosticReporter $this$reportMismatchOnFunction, FirSourceElement source, String type2, FirMemberDeclaration declaration) {
        block0: {
            FirSourceElement firSourceElement = source;
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportMismatchOnFunction.report((FirDiagnostic)FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_ON_OVERRIDE().on(it, type2, declaration));
        }
    }

    private final void reportMismatchOnProperty(DiagnosticReporter $this$reportMismatchOnProperty, FirSourceElement source, String type2, FirMemberDeclaration declaration) {
        block0: {
            FirSourceElement firSourceElement = source;
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportMismatchOnProperty.report((FirDiagnostic)FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_ON_OVERRIDE().on(it, type2, declaration));
        }
    }

    private final void reportMismatchOnVariable(DiagnosticReporter $this$reportMismatchOnVariable, FirSourceElement source, String type2, FirMemberDeclaration declaration) {
        block0: {
            FirSourceElement firSourceElement = source;
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportMismatchOnVariable.report((FirDiagnostic)FirErrors.INSTANCE.getVAR_TYPE_MISMATCH_ON_OVERRIDE().on(it, type2, declaration));
        }
    }

    private FirTypeMismatchOnOverrideChecker() {
    }

    static {
        FirTypeMismatchOnOverrideChecker firTypeMismatchOnOverrideChecker;
        INSTANCE = firTypeMismatchOnOverrideChecker = new FirTypeMismatchOnOverrideChecker();
    }
}

