/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u0011H\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u0012H\u0002J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002J\u0016\u0010\u0015\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSupertypeInitializedInInterfaceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "findSuperTypeCall", "", "Lcom/intellij/lang/LighterASTNode;", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "getChildren", "", "report", "source", "checkers"})
public final class FirSupertypeInitializedInInterfaceChecker
extends FirDeclarationChecker<FirMemberDeclaration> {
    @NotNull
    public static final FirSupertypeInitializedInInterfaceChecker INSTANCE;

    @Override
    public void check(@NotNull FirMemberDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (!(declaration instanceof FirClass) || ((FirClass)((Object)declaration)).getClassKind() != ClassKind.INTERFACE) {
                return;
            }
            FirSourceElement firSourceElement = declaration.getSource();
            if (firSourceElement == null) break block1;
            int n = this.findSuperTypeCall(firSourceElement);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            FirTypeRef firTypeRef = (FirTypeRef)CollectionsKt.getOrNull(((FirClass)((Object)declaration)).getSuperTypeRefs(), (int)it);
            INSTANCE.report(reporter, firTypeRef != null ? firTypeRef.getSource() : null);
        }
    }

    private final int findSuperTypeCall(FirSourceElement $this$findSuperTypeCall) {
        PsiElement localPsi = FirSourceElementKt.getPsi($this$findSuperTypeCall);
        LighterASTNode localLightNode = FirSourceElementKt.getLightNode($this$findSuperTypeCall);
        if (localPsi != null && !(localPsi instanceof PsiErrorElement)) {
            return this.findSuperTypeCall(localPsi);
        }
        if (localLightNode != null && $this$findSuperTypeCall instanceof FirLightSourceElement) {
            return this.findSuperTypeCall(localLightNode, ((FirLightSourceElement)$this$findSuperTypeCall).getTree());
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private final int findSuperTypeCall(PsiElement $this$findSuperTypeCall) {
        int n;
        block4: {
            PsiElement[] children2 = $this$findSuperTypeCall.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)children2, (String)"children");
            PsiElement[] psiElementArray = children2;
            boolean bl = false;
            PsiElement[] psiElementArray2 = psiElementArray;
            int n2 = 0;
            if (!(psiElementArray2.length == 0) && !(children2[0] instanceof PsiErrorElement)) {
                PsiElement psiElement = children2[0];
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"children[0]");
                PsiElement[] psiElementArray3 = psiElement.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray3, (String)"children[0].children");
                PsiElement[] $this$indexOfFirst$iv = psiElementArray3;
                boolean $i$f$indexOfFirst = false;
                int n3 = 0;
                n2 = $this$indexOfFirst$iv.length;
                while (n3 < n2) {
                    void index$iv;
                    PsiElement it = $this$indexOfFirst$iv[index$iv];
                    boolean bl2 = false;
                    if (it instanceof KtSuperTypeCallEntry) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = -1;
            } else {
                n = -1;
            }
        }
        return n;
    }

    private final int findSuperTypeCall(LighterASTNode $this$findSuperTypeCall, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        int n;
        block8: {
            List<LighterASTNode> children2 = this.getChildren($this$findSuperTypeCall, tree);
            Iterable iterable = children2;
            boolean bl = false;
            if (!iterable.isEmpty()) {
                Object object;
                Object v0;
                block7: {
                    iterable = children2;
                    bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (Object e : iterable2) {
                        LighterASTNode it = (LighterASTNode)e;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.SUPER_TYPE_LIST)) continue;
                        v0 = e;
                        break block7;
                    }
                    v0 = null;
                }
                if ((object = (LighterASTNode)v0) != null && (object = this.getChildren((LighterASTNode)object, tree)) != null) {
                    Object $this$indexOfFirst$iv = object;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator iterator2 = $this$indexOfFirst$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object item$iv = iterator2.next();
                        LighterASTNode it = (LighterASTNode)item$iv;
                        boolean bl4 = false;
                        if (Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.SUPER_TYPE_CALL_ENTRY)) {
                            n = index$iv;
                            break block8;
                        }
                        ++index$iv;
                    }
                    n = -1;
                } else {
                    n = -1;
                }
            } else {
                n = -1;
            }
        }
        return n;
    }

    private final List<LighterASTNode> getChildren(LighterASTNode $this$getChildren, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        List list2;
        Ref children2 = new Ref();
        int count = tree.getChildren((Object)$this$getChildren, children2);
        if (count > 0) {
            Object object = children2.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"children.get()");
            list2 = ArraysKt.filterNotNull((Object[])((Object[])object));
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final void report(DiagnosticReporter $this$report, FirSourceElement source) {
        block0: {
            FirSourceElement firSourceElement = source;
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$report.report((FirDiagnostic)FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_IN_INTERFACE().on(it));
        }
    }

    private FirSupertypeInitializedInInterfaceChecker() {
    }

    static {
        FirSupertypeInitializedInInterfaceChecker firSupertypeInitializedInInterfaceChecker;
        INSTANCE = firSupertypeInitializedInInterfaceChecker = new FirSupertypeInitializedInInterfaceChecker();
    }
}

