/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u000e\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u000f\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u0010\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSealedSupertypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkInnerDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "checkLocalDeclaration", "checkTopLevelDeclaration", "report", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "reportInLocal", "checkers"})
public final class FirSealedSupertypeChecker
extends FirDeclarationChecker<FirMemberDeclaration> {
    @NotNull
    public static final FirSealedSupertypeChecker INSTANCE;

    @Override
    public void check(@NotNull FirMemberDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration instanceof FirClass) {
            if (context2.getContainingDeclarations().size() == 1) {
                this.checkTopLevelDeclaration((FirClass)((Object)declaration), context2, reporter);
            } else if (FirDeclarationUtilKt.getClassId((FirClass)((Object)declaration)).isLocal()) {
                this.checkLocalDeclaration((FirClass)((Object)declaration), context2, reporter);
            } else {
                this.checkInnerDeclaration((FirClass)((Object)declaration), context2, reporter);
            }
        } else if (declaration instanceof FirProperty) {
            FirExpression $this$safeAs$iv = ((FirProperty)declaration).getInitializer();
            boolean $i$f$safeAs = false;
            FirExpression firExpression2 = $this$safeAs$iv;
            if (!(firExpression2 instanceof FirClass)) {
                firExpression2 = null;
            }
            FirClass firClass = (FirClass)((Object)firExpression2);
            if (firClass == null) {
                return;
            }
            FirClass initializer2 = firClass;
            this.checkLocalDeclaration(initializer2, context2, reporter);
        }
    }

    private final void checkTopLevelDeclaration(FirClass<?> declaration, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirTypeRef it : declaration.getSuperTypeRefs()) {
            FirRegularClass fir;
            Object object;
            Object $this$safeAs$iv = it;
            boolean $i$f$safeAs = false;
            Object object2 = $this$safeAs$iv;
            if (!(object2 instanceof FirResolvedTypeRef)) {
                object2 = null;
            }
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)object2;
            $this$safeAs$iv = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            $i$f$safeAs = false;
            Object object3 = $this$safeAs$iv;
            if (!(object3 instanceof ConeClassLikeType)) {
                object3 = null;
            }
            if ((object = (ConeClassLikeType)object3) == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null || (object = ((ConeClassLikeLookupTag)object).getClassId()) == null) {
                continue;
            }
            Object classId = object;
            if (((ClassId)classId).isLocal()) continue;
            FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getFirSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName((ClassId)classId);
            FirClassLikeDeclaration $this$safeAs$iv2 = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
            boolean $i$f$safeAs2 = false;
            FirClassLikeDeclaration firClassLikeDeclaration = $this$safeAs$iv2;
            if (!(firClassLikeDeclaration instanceof FirRegularClass)) {
                firClassLikeDeclaration = null;
            }
            if ((FirRegularClass)firClassLikeDeclaration == null) {
                continue;
            }
            if (fir.getStatus().getModality() != Modality.SEALED || ((ClassId)classId).getOuterClassId() == null) continue;
            this.report(reporter, it.getSource());
            return;
        }
    }

    private final void checkLocalDeclaration(FirClass<?> declaration, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirTypeRef it : declaration.getSuperTypeRefs()) {
            FirRegularClass fir;
            Object object;
            Object $this$safeAs$iv = it;
            boolean $i$f$safeAs = false;
            Object object2 = $this$safeAs$iv;
            if (!(object2 instanceof FirResolvedTypeRef)) {
                object2 = null;
            }
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)object2;
            $this$safeAs$iv = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            $i$f$safeAs = false;
            Object object3 = $this$safeAs$iv;
            if (!(object3 instanceof ConeClassLikeType)) {
                object3 = null;
            }
            if ((object = (ConeClassLikeType)object3) == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null || (object = ((ConeClassLikeLookupTag)object).getClassId()) == null) {
                continue;
            }
            Object classId = object;
            if (((ClassId)classId).isLocal()) continue;
            FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getFirSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName((ClassId)classId);
            FirClassLikeDeclaration $this$safeAs$iv2 = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
            boolean $i$f$safeAs2 = false;
            FirClassLikeDeclaration firClassLikeDeclaration = $this$safeAs$iv2;
            if (!(firClassLikeDeclaration instanceof FirRegularClass)) {
                firClassLikeDeclaration = null;
            }
            if ((FirRegularClass)firClassLikeDeclaration == null) {
                continue;
            }
            if (fir.getStatus().getModality() != Modality.SEALED) continue;
            this.reportInLocal(reporter, it.getSource());
            return;
        }
    }

    private final void checkInnerDeclaration(FirClass<?> declaration, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirTypeRef it : declaration.getSuperTypeRefs()) {
            FirRegularClass fir;
            Object object;
            Object $this$safeAs$iv = it;
            boolean $i$f$safeAs = false;
            Object object2 = $this$safeAs$iv;
            if (!(object2 instanceof FirResolvedTypeRef)) {
                object2 = null;
            }
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)object2;
            $this$safeAs$iv = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            $i$f$safeAs = false;
            Object object3 = $this$safeAs$iv;
            if (!(object3 instanceof ConeClassLikeType)) {
                object3 = null;
            }
            if ((object = (ConeClassLikeType)object3) == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null || (object = ((ConeClassLikeLookupTag)object).getClassId()) == null) {
                continue;
            }
            Object classId = object;
            if (((ClassId)classId).isLocal()) continue;
            FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getFirSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName((ClassId)classId);
            FirClassLikeDeclaration $this$safeAs$iv2 = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
            boolean $i$f$safeAs2 = false;
            FirClassLikeDeclaration firClassLikeDeclaration = $this$safeAs$iv2;
            if (!(firClassLikeDeclaration instanceof FirRegularClass)) {
                firClassLikeDeclaration = null;
            }
            if ((FirRegularClass)firClassLikeDeclaration == null) {
                continue;
            }
            if (fir.getStatus().getModality() != Modality.SEALED || context2.getContainingDeclarations().contains(fir)) continue;
            this.report(reporter, it.getSource());
            return;
        }
    }

    private final void report(DiagnosticReporter $this$report, FirSourceElement source) {
        block0: {
            FirSourceElement firSourceElement = source;
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$report.report((FirDiagnostic)FirErrors.INSTANCE.getSEALED_SUPERTYPE().on(it));
        }
    }

    private final void reportInLocal(DiagnosticReporter $this$reportInLocal, FirSourceElement source) {
        block0: {
            FirSourceElement firSourceElement = source;
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportInLocal.report((FirDiagnostic)FirErrors.INSTANCE.getSEALED_SUPERTYPE_IN_LOCAL_CLASS().on(it));
        }
    }

    private FirSealedSupertypeChecker() {
    }

    static {
        FirSealedSupertypeChecker firSealedSupertypeChecker;
        INSTANCE = firSealedSupertypeChecker = new FirSealedSupertypeChecker();
    }
}

