/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.BuiltinTypes;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0015*\u00020\u0016H\u0002J\f\u0010\u0018\u001a\u00020\u0015*\u00020\u0016H\u0002J\u001e\u0010\u0019\u001a\u00020\r*\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\"\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInapplicableLateinitChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberDeclarationChecker;", "()V", "primitives", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getPrimitives", "()Ljava/util/Set;", "setPrimitives", "(Ljava/util/Set;)V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "getPrimitiveTypes", "hasGetter", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "hasSetter", "isNullable", "report", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "target", "", "checkers"})
public final class FirInapplicableLateinitChecker
extends FirDeclarationChecker<FirMemberDeclaration> {
    private static Set<? extends ConeKotlinType> primitives;
    @NotNull
    public static final FirInapplicableLateinitChecker INSTANCE;

    @Nullable
    public final Set<ConeKotlinType> getPrimitives() {
        return primitives;
    }

    public final void setPrimitives(@Nullable Set<? extends ConeKotlinType> set) {
        primitives = set;
    }

    private final Set<ConeKotlinType> getPrimitiveTypes(CheckerContext context2) {
        Set set = primitives;
        if (set == null) {
            boolean bl = false;
            Set set2 = new LinkedHashSet();
            boolean bl2 = false;
            boolean bl3 = false;
            Set $this$apply = set2;
            boolean bl4 = false;
            BuiltinTypes builtinTypes = context2.getSession().getBuiltinTypes();
            boolean bl5 = false;
            boolean bl6 = false;
            BuiltinTypes $this$with = builtinTypes;
            boolean bl7 = false;
            FirTypeRef $this$coneType$iv = $this$with.getIntType();
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            $this$apply.add(coneKotlinType);
            $this$coneType$iv = $this$with.getBooleanType();
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType2 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            $this$apply.add(coneKotlinType2);
            $this$coneType$iv = $this$with.getCharType();
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType3 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            $this$apply.add(coneKotlinType3);
            $this$coneType$iv = $this$with.getShortType();
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType4 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            $this$apply.add(coneKotlinType4);
            $this$coneType$iv = $this$with.getByteType();
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType5 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            $this$apply.add(coneKotlinType5);
            $this$coneType$iv = $this$with.getLongType();
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType6 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            $this$apply.add(coneKotlinType6);
            $this$coneType$iv = $this$with.getDoubleType();
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType7 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            $this$apply.add(coneKotlinType7);
            $this$coneType$iv = $this$with.getFloatType();
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType8 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            $this$apply.add(coneKotlinType8);
            primitives = $this$apply;
            set = set2;
        }
        return set;
    }

    @Override
    public void check(@NotNull FirMemberDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block11: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block10: {
                                block9: {
                                    block8: {
                                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                                        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                                        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                                        if (!(declaration instanceof FirProperty)) break block8;
                                        FirMemberDeclaration $this$isLateInit$iv = declaration;
                                        boolean $i$f$isLateInit = false;
                                        if ($this$isLateInit$iv.getStatus().isLateInit()) break block9;
                                    }
                                    return;
                                }
                                if (!((FirProperty)declaration).isVal()) break block10;
                                this.report(reporter, declaration.getSource(), "is allowed only on mutable properties");
                                break block11;
                            }
                            if (((FirProperty)declaration).getInitializer() == null) break block12;
                            if (((FirProperty)declaration).isLocal()) {
                                this.report(reporter, declaration.getSource(), "is not allowed on local variables with initializer");
                            } else {
                                this.report(reporter, declaration.getSource(), "is not allowed on properties with initializer");
                            }
                            break block11;
                        }
                        if (((FirProperty)declaration).getDelegate() == null) break block13;
                        this.report(reporter, declaration.getSource(), "is not allowed on delegated properties");
                        break block11;
                    }
                    if (!this.isNullable((FirProperty)declaration)) break block14;
                    this.report(reporter, declaration.getSource(), "is not allowed on properties of a type with nullable upper bound");
                    break block11;
                }
                FirTypeRef $this$coneType$iv = ((FirProperty)declaration).getReturnTypeRef();
                boolean $i$f$getConeType = false;
                FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
                boolean $i$f$coneTypeUnsafe = false;
                ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
                if (coneKotlinType == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                }
                if (!this.getPrimitiveTypes(context2).contains(coneKotlinType)) break block15;
                if (((FirProperty)declaration).isLocal()) {
                    this.report(reporter, declaration.getSource(), "is not allowed on local variables of primitive types");
                } else {
                    this.report(reporter, declaration.getSource(), "is not allowed on properties of primitive types");
                }
                break block11;
            }
            if (!this.hasGetter((FirProperty)declaration) && !this.hasSetter((FirProperty)declaration)) break block11;
            this.report(reporter, declaration.getSource(), "is not allowed on properties with a custom getter or setter");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNullable(FirProperty $this$isNullable) {
        FirTypeRef $this$coneType$iv = $this$isNullable.getReturnTypeRef();
        boolean $i$f$getConeType = false;
        FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        ConeKotlinType type2 = coneKotlinType;
        if (type2 instanceof ConeTypeParameterType) {
            ConeKotlinType coneKotlinType2;
            if (ConeTypeUtilsKt.isNullable(type2)) return true;
            Iterable $this$any$iv = ((FirTypeParameter)((ConeTypeParameterType)type2).getLookupTag().getTypeParameterSymbol().getFir()).getBounds();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                FirTypeRef it = (FirTypeRef)element$iv;
                boolean bl = false;
                FirTypeRef $this$coneType$iv2 = it;
                boolean $i$f$getConeType2 = false;
                FirTypeRef $this$coneTypeUnsafe$iv$iv2 = $this$coneType$iv2;
                boolean $i$f$coneTypeUnsafe2 = false;
                coneKotlinType2 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv2).getType();
                if (coneKotlinType2 != null) continue;
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            } while (!ConeTypeUtilsKt.isNullable(coneKotlinType2));
            return true;
        }
        boolean bl = ConeTypeUtilsKt.isNullable(type2);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasGetter(FirProperty $this$hasGetter) {
        if ($this$hasGetter.getGetter() == null) return false;
        FirPropertyAccessor firPropertyAccessor = $this$hasGetter.getGetter();
        if (firPropertyAccessor == null) return false;
        FirSourceElement firSourceElement = firPropertyAccessor.getSource();
        if (firSourceElement == null) return false;
        Object object = $this$hasGetter.getGetter();
        if ((object != null && (object = ((FirPropertyAccessor)object).getSource()) != null ? ((FirSourceElement)object).getKind() : null) instanceof FirFakeSourceElementKind) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasSetter(FirProperty $this$hasSetter) {
        if ($this$hasSetter.getSetter() == null) return false;
        FirPropertyAccessor firPropertyAccessor = $this$hasSetter.getSetter();
        if (firPropertyAccessor == null) return false;
        FirSourceElement firSourceElement = firPropertyAccessor.getSource();
        if (firSourceElement == null) return false;
        Object object = $this$hasSetter.getSetter();
        if ((object != null && (object = ((FirPropertyAccessor)object).getSource()) != null ? ((FirSourceElement)object).getKind() : null) instanceof FirFakeSourceElementKind) return false;
        return true;
    }

    private final void report(DiagnosticReporter $this$report, FirSourceElement source, String target) {
        block0: {
            FirSourceElement firSourceElement = source;
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$report.report((FirDiagnostic)FirErrors.INSTANCE.getINAPPLICABLE_LATEINIT_MODIFIER().on(it, target));
        }
    }

    private FirInapplicableLateinitChecker() {
    }

    static {
        FirInapplicableLateinitChecker firInapplicableLateinitChecker;
        INSTANCE = firInapplicableLateinitChecker = new FirInapplicableLateinitChecker();
    }
}

