/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.DescriptorByIdSignatureFinder$WhenMappings;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProviderKt;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001%B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ'\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J\"\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\f*\u00020\"2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u0018H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinder;", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;", "lookupMode", "Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinder$LookupMode;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinder$LookupMode;)V", "findDescriptorByHash", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "candidates", "", "id", "", "(Ljava/util/Collection;Ljava/lang/Long;)Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findDescriptorBySignature", "signature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "findDescriptorForAccessorSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$AccessorSignature;", "findDescriptorForPublicSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$PublicSignature;", "isConstructorName", "", "n", "Lorg/jetbrains/kotlin/name/Name;", "performLookup", "nameSegments", "", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "loadDescriptors", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "name", "isLeaf", "LookupMode", "ir.serialization.common"})
public final class DescriptorByIdSignatureFinder {
    private final ModuleDescriptor moduleDescriptor;
    private final KotlinMangler.DescriptorMangler mangler;
    private final LookupMode lookupMode;

    @Nullable
    public final DeclarationDescriptor findDescriptorBySignature(@NotNull IdSignature signature2) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
        IdSignature idSignature = signature2;
        if (idSignature instanceof IdSignature.AccessorSignature) {
            declarationDescriptor = this.findDescriptorForAccessorSignature((IdSignature.AccessorSignature)signature2);
        } else if (idSignature instanceof IdSignature.PublicSignature) {
            declarationDescriptor = this.findDescriptorForPublicSignature((IdSignature.PublicSignature)signature2);
        } else {
            String string2 = "only PublicSignature or AccessorSignature should reach this point, got " + signature2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return declarationDescriptor;
    }

    private final DeclarationDescriptor findDescriptorForAccessorSignature(IdSignature.AccessorSignature signature2) {
        Object v4;
        block4: {
            DeclarationDescriptor declarationDescriptor = this.findDescriptorBySignature(signature2.getPropertySignature());
            if (!(declarationDescriptor instanceof PropertyDescriptor)) {
                declarationDescriptor = null;
            }
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
            if (propertyDescriptor == null) {
                return null;
            }
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            String shortName = signature2.getAccessorSignature().getShortName();
            List<PropertyAccessorDescriptor> list2 = propertyDescriptor2.getAccessors();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"propertyDescriptor.accessors");
            Iterable $this$singleOrNull$iv = list2;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                PropertyAccessorDescriptor it = (PropertyAccessorDescriptor)element$iv;
                boolean bl = false;
                PropertyAccessorDescriptor propertyAccessorDescriptor = it;
                Intrinsics.checkNotNullExpressionValue((Object)propertyAccessorDescriptor, (String)"it");
                if (!Intrinsics.areEqual((Object)propertyAccessorDescriptor.getName().asString(), (Object)shortName)) continue;
                if (found$iv) {
                    v4 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v4 = !found$iv ? null : single$iv;
        }
        return v4;
    }

    private final boolean isConstructorName(Name n) {
        return n.isSpecial() && Intrinsics.areEqual((Object)n.asString(), (Object)"<init>");
    }

    private final Collection<DeclarationDescriptor> loadDescriptors(MemberScope $this$loadDescriptors, String name, boolean isLeaf) {
        Name name2 = Name.guessByFirstCharacter(name);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.guessByFirstCharacter(name)");
        Name descriptorName = name2;
        ClassifierDescriptor classifier = $this$loadDescriptors.getContributedClassifier(descriptorName, NoLookupLocation.FROM_BACKEND);
        if (!isLeaf) {
            return kotlin.collections.CollectionsKt.listOfNotNull((Object)classifier);
        }
        boolean bl = false;
        List result2 = new ArrayList();
        ClassifierDescriptor classifierDescriptor = classifier;
        if (classifierDescriptor != null) {
            ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
            boolean bl2 = false;
            boolean bl3 = false;
            ClassifierDescriptor it = classifierDescriptor2;
            boolean bl4 = false;
            result2.add(it);
        }
        result2.addAll($this$loadDescriptors.getContributedFunctions(descriptorName, NoLookupLocation.FROM_BACKEND));
        result2.addAll($this$loadDescriptors.getContributedVariables(descriptorName, NoLookupLocation.FROM_BACKEND));
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<DeclarationDescriptor> performLookup(List<String> nameSegments, FqName packageFqName) {
        Collection collection;
        String declarationName = nameSegments.get(0);
        boolean isLeaf = nameSegments.size() == 1;
        switch (DescriptorByIdSignatureFinder$WhenMappings.$EnumSwitchMapping$0[this.lookupMode.ordinal()]) {
            case 1: {
                collection = this.loadDescriptors(this.moduleDescriptor.getPackage(packageFqName).getMemberScope(), declarationName, isLeaf);
                break;
            }
            case 2: {
                void $this$flatMapTo$iv$iv;
                ModuleDescriptor moduleDescriptor = this.moduleDescriptor;
                if (moduleDescriptor == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl");
                }
                Iterable $this$flatMap$iv = PackageFragmentProviderKt.packageFragments(((ModuleDescriptorImpl)moduleDescriptor).getPackageFragmentProviderForModuleContentWithoutDependencies(), packageFqName);
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    PackageFragmentDescriptor it = (PackageFragmentDescriptor)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = this.loadDescriptors(it.getMemberScope(), declarationName, isLeaf);
                    kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                collection = (List)destination$iv$iv;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final DeclarationDescriptor findDescriptorForPublicSignature(IdSignature.PublicSignature signature2) {
        DeclarationDescriptor declarationDescriptor;
        Collection toplevelDescriptors2;
        List<String> nameSegments = signature2.getNameSegments();
        Collection collection = this.performLookup(nameSegments, signature2.packageFqName());
        boolean bl = false;
        if (collection.isEmpty()) {
            boolean bl2 = false;
            return null;
        }
        Collection acc = toplevelDescriptors2 = collection;
        int lastIndex = kotlin.collections.CollectionsKt.getLastIndex(nameSegments);
        int bl2 = 1;
        int n = nameSegments.size();
        while (bl2 < n) {
            void $this$flatMapTo$iv$iv;
            void i;
            Intrinsics.checkNotNullExpressionValue((Object)Name.guessByFirstCharacter(nameSegments.get((int)i)), (String)"Name.guessByFirstCharacter(nameSegments[i])");
            Iterable $this$flatMap$iv = acc;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Object object;
                block12: {
                    boolean bl3;
                    boolean bl4;
                    Object object2;
                    ClassifierDescriptor classifier;
                    Name current2;
                    MemberScope memberScope2;
                    ClassDescriptor classDescriptor2;
                    block13: {
                        block14: {
                            block11: {
                                DeclarationDescriptor container = (DeclarationDescriptor)element$iv$iv;
                                boolean bl5 = false;
                                DeclarationDescriptor declarationDescriptor2 = container;
                                if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
                                    declarationDescriptor2 = null;
                                }
                                if ((ClassDescriptor)declarationDescriptor2 != null) break block11;
                                object = kotlin.collections.CollectionsKt.emptyList();
                                break block12;
                            }
                            boolean isLeaf = i == lastIndex;
                            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2.getUnsubstitutedMemberScope(), (String)"classDescriptor.unsubstitutedMemberScope");
                            classifier = memberScope2.getContributedClassifier(current2, NoLookupLocation.FROM_BACKEND);
                            if (isLeaf) break block13;
                            object = classifier;
                            if (object == null) break block14;
                            object2 = object;
                            bl4 = false;
                            bl3 = false;
                            Object it = object2;
                            boolean bl6 = false;
                            object = kotlin.collections.CollectionsKt.listOf((Object)it);
                            if (object != null) break block12;
                        }
                        object = kotlin.collections.CollectionsKt.emptyList();
                        break block12;
                    }
                    boolean bl7 = false;
                    object2 = new ArrayList();
                    bl4 = false;
                    bl3 = false;
                    Object $this$apply = object2;
                    boolean bl8 = false;
                    CollectionsKt.addIfNotNull((Collection)$this$apply, classifier);
                    if (signature2.getId() != null) {
                        if (this.isConstructorName(current2)) {
                            Collection<ClassConstructorDescriptor> collection2 = classDescriptor2.getConstructors();
                            Intrinsics.checkNotNullExpressionValue(collection2, (String)"classDescriptor.constructors");
                            $this$apply.addAll(collection2);
                        }
                        $this$apply.addAll(memberScope2.getContributedFunctions(current2, NoLookupLocation.FROM_BACKEND));
                        $this$apply.addAll(memberScope2.getContributedVariables(current2, NoLookupLocation.FROM_BACKEND));
                        $this$apply.addAll(ResolutionScope.DefaultImpls.getContributedDescriptors$default(classDescriptor2.getStaticScope(), null, (Function1)new Function1<Name, Boolean>(classifier, classDescriptor2, memberScope2, this, (int)i, lastIndex, current2, signature2){
                            final /* synthetic */ ClassifierDescriptor $classifier$inlined;
                            final /* synthetic */ ClassDescriptor $classDescriptor$inlined;
                            final /* synthetic */ MemberScope $memberScope$inlined;
                            final /* synthetic */ DescriptorByIdSignatureFinder this$0;
                            final /* synthetic */ int $i$inlined;
                            final /* synthetic */ int $lastIndex$inlined;
                            final /* synthetic */ Name $current$inlined;
                            final /* synthetic */ IdSignature.PublicSignature $signature$inlined;
                            {
                                this.$classifier$inlined = classifierDescriptor;
                                this.$classDescriptor$inlined = classDescriptor2;
                                this.$memberScope$inlined = memberScope2;
                                this.this$0 = descriptorByIdSignatureFinder;
                                this.$i$inlined = n;
                                this.$lastIndex$inlined = n2;
                                this.$current$inlined = name;
                                this.$signature$inlined = publicSignature;
                                super(1);
                            }

                            public final boolean invoke(@NotNull Name it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return Intrinsics.areEqual((Object)it, (Object)this.$current$inlined);
                            }
                        }, 1, null));
                    }
                    object = object2;
                }
                Iterable list$iv$iv = (Iterable)object;
                kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            acc = (List)destination$iv$iv;
            ++i;
        }
        Collection candidates2 = acc;
        switch (candidates2.size()) {
            case 1: {
                declarationDescriptor = (DeclarationDescriptor)kotlin.collections.CollectionsKt.first((Iterable)candidates2);
                break;
            }
            default: {
                declarationDescriptor = this.findDescriptorByHash(candidates2, signature2.getId());
                if (declarationDescriptor != null) break;
                String string2 = "No descriptor found for " + signature2;
                boolean bl9 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        return declarationDescriptor;
    }

    private final DeclarationDescriptor findDescriptorByHash(Collection<? extends DeclarationDescriptor> candidates2, Long id) {
        Object v1;
        block3: {
            Iterable $this$firstOrNull$iv = candidates2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                DeclarationDescriptor candidate2 = (DeclarationDescriptor)element$iv;
                boolean bl2 = false;
                if (id == null) {
                    bl = candidate2 instanceof ClassDescriptor || candidate2 instanceof TypeAliasDescriptor;
                } else {
                    KotlinMangler.DescriptorMangler descriptorMangler = this.mangler;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    KotlinMangler.DescriptorMangler $this$with = descriptorMangler;
                    boolean bl5 = false;
                    long candidateHash = $this$with.getSignatureMangle(candidate2);
                    bl = candidateHash == id;
                }
                if (!bl) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }

    public DescriptorByIdSignatureFinder(@NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinMangler.DescriptorMangler mangler, @NotNull LookupMode lookupMode) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        Intrinsics.checkNotNullParameter((Object)((Object)lookupMode), (String)"lookupMode");
        this.moduleDescriptor = moduleDescriptor;
        this.mangler = mangler;
        this.lookupMode = lookupMode;
        boolean bl = this.lookupMode != LookupMode.MODULE_ONLY || this.moduleDescriptor instanceof ModuleDescriptorImpl;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinder$LookupMode;", "", "(Ljava/lang/String;I)V", "MODULE_WITH_DEPENDENCIES", "MODULE_ONLY", "ir.serialization.common"})
    public static final class LookupMode
    extends Enum<LookupMode> {
        public static final /* enum */ LookupMode MODULE_WITH_DEPENDENCIES;
        public static final /* enum */ LookupMode MODULE_ONLY;
        private static final /* synthetic */ LookupMode[] $VALUES;

        static {
            LookupMode[] lookupModeArray = new LookupMode[2];
            LookupMode[] lookupModeArray2 = lookupModeArray;
            lookupModeArray[0] = MODULE_WITH_DEPENDENCIES = new LookupMode();
            lookupModeArray[1] = MODULE_ONLY = new LookupMode();
            $VALUES = lookupModeArray;
        }

        public static LookupMode[] values() {
            return (LookupMode[])$VALUES.clone();
        }

        public static LookupMode valueOf(String string2) {
            return Enum.valueOf(LookupMode.class, string2);
        }
    }
}

