/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.RangeHeaderInfoBuilder;
import org.jetbrains.kotlin.backend.common.lower.Transformer;
import org.jetbrains.kotlin.backend.common.lower.Transformer$WhenMappings;
import org.jetbrains.kotlin.backend.common.lower.loops.ComparableRangeInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.FloatingPointRangeHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.IndexedGetHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.NumericHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.UnsignedProgressionType;
import org.jetbrains.kotlin.backend.common.lower.loops.UtilsKt;
import org.jetbrains.kotlin.backend.common.lower.matchers.IrFunctionMatcherContainer;
import org.jetbrains.kotlin.backend.common.lower.matchers.SimpleCalleeMatcher;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.PrimitivesKt;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ(\u0010\u001b\u001a\u0004\u0018\u00010\u00162\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00142\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J&\u0010\"\u001a\u0004\u0018\u00010\u001f*\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0002J\u001a\u0010)\u001a\u00020\u0016*\u00020\u00162\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/Transformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;)V", "getContainer", "()Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "headerInfoBuilder", "Lorg/jetbrains/kotlin/backend/common/lower/RangeHeaderInfoBuilder;", "stdlibExtensionContainsCallMatcher", "Lorg/jetbrains/kotlin/backend/common/lower/matchers/SimpleCalleeMatcher;", "getStdlibExtensionContainsCallMatcher", "()Lorg/jetbrains/kotlin/backend/common/lower/matchers/SimpleCalleeMatcher;", "computeComparisonClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "lowerType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "upperType", "argumentType", "getScopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "leastCommonPrimitiveNumericType", "t1", "t2", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "buildContainsComparison", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "headerInfo", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfo;", "argument", "origin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "promoteIntegerTypeToIntIfRequired", "ir.backend.common"})
final class Transformer
extends IrElementTransformerVoidWithContext {
    private final RangeHeaderInfoBuilder headerInfoBuilder;
    private final SimpleCalleeMatcher stdlibExtensionContainsCallMatcher;
    private final CommonBackendContext context;
    private final IrSymbolOwner container;

    @NotNull
    public final IrSymbol getScopeOwnerSymbol() {
        Object object = this.getCurrentScope();
        if (object == null || (object = ((ScopeWithIr)object).getScope()) == null || (object = ((Scope)object).getScopeOwnerSymbol()) == null) {
            object = this.container.getSymbol();
        }
        return object;
    }

    @NotNull
    public final SimpleCalleeMatcher getStdlibExtensionContainsCallMatcher() {
        return this.stdlibExtensionContainsCallMatcher;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrStatementOrigin origin = expression2.getOrigin();
        if (Intrinsics.areEqual((Object)origin, (Object)IrStatementOrigin.IN.INSTANCE) ^ true && Intrinsics.areEqual((Object)origin, (Object)IrStatementOrigin.NOT_IN.INSTANCE) ^ true) {
            return super.visitCall(expression2);
        }
        if (Intrinsics.areEqual((Object)origin, (Object)IrStatementOrigin.NOT_IN.INSTANCE) && Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)this.context.getIrBuiltIns().getBooleanNotSymbol())) {
            return super.visitCall(expression2);
        }
        if (expression2.getExtensionReceiver() != null && !this.stdlibExtensionContainsCallMatcher.invoke(expression2).booleanValue()) {
            return super.visitCall(expression2);
        }
        IrExpression irExpression = expression2.getDispatchReceiver();
        if (irExpression == null) {
            IrExpression irExpression2 = expression2.getExtensionReceiver();
            irExpression = irExpression2;
            Intrinsics.checkNotNull((Object)irExpression2);
        }
        IrExpression receiver = irExpression;
        HeaderInfo headerInfo = (HeaderInfo)receiver.accept(this.headerInfoBuilder, expression2);
        if (headerInfo == null) {
            return super.visitCall(expression2);
        }
        HeaderInfo headerInfo2 = headerInfo;
        IrExpression irExpression3 = expression2.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression3);
        IrExpression argument = irExpression3;
        if (IrTypeUtilsKt.isNullable(argument.getType())) {
            return super.visitCall(expression2);
        }
        DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder(this.context, this.getScopeOwnerSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
        IrExpression irExpression4 = this.buildContainsComparison(builder, headerInfo2, argument, origin);
        if (irExpression4 == null) {
            irExpression4 = super.visitCall(expression2);
        }
        return irExpression4;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression buildContainsComparison(DeclarationIrBuilder $this$buildContainsComparison, HeaderInfo headerInfo, IrExpression argument, IrStatementOrigin origin) {
        IrExpression irExpression;
        IrCall irCall;
        IrElement $this$deepCopyWithSymbols$iv;
        Object object3;
        IrCall $this$apply;
        boolean $this$apply2;
        IrCall single$iv22;
        IrCall lowerClause;
        IrCall irCall2;
        boolean bl;
        IrCall $this$apply3;
        boolean single$iv22;
        IrCall $i$f$singleOrNull2;
        Object v5;
        boolean bl22;
        IrElementBase it;
        boolean found$iv2;
        IrSimpleFunctionSymbol lessOrEqualFun;
        boolean useLowerClauseOnLeftSide;
        IrExpression upperExpression;
        IrExpression lowerExpression;
        IrExpression argExpression;
        List additionalStatements2;
        IrExpression additionalNotEmptyCondition;
        boolean useCompareTo;
        block42: {
            IrVariable lowerVar;
            Pair upperVar;
            IrExpression tmpLowerExpression;
            void argVar;
            IrClass comparisonClass;
            IrClass irClass2;
            IrExpression lower2 = null;
            IrExpression upper = null;
            boolean shouldUpperComeFirst = false;
            useCompareTo = false;
            boolean isNumericRange = false;
            additionalNotEmptyCondition = null;
            boolean bl3 = false;
            additionalStatements2 = new ArrayList();
            HeaderInfo headerInfo2 = headerInfo;
            if (headerInfo2 instanceof NumericHeaderInfo) {
                HeaderInfo headerInfo3 = headerInfo;
                if (headerInfo3 instanceof ProgressionHeaderInfo) {
                    additionalStatements2.addAll((Collection)((ProgressionHeaderInfo)headerInfo).getAdditionalStatements());
                } else if (headerInfo3 instanceof IndexedGetHeaderInfo) {
                    String string2 = "Unexpected IndexedGetHeaderInfo returned by RangeHeaderInfoBuilder";
                    boolean bl4 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                switch (Transformer$WhenMappings.$EnumSwitchMapping$0[((NumericHeaderInfo)headerInfo).getDirection().ordinal()]) {
                    case 1: {
                        Long l = UtilsKt.getConstLongValue(((NumericHeaderInfo)headerInfo).getStep());
                        if (l == null || l != 1L) {
                            return null;
                        }
                        lower2 = ((NumericHeaderInfo)headerInfo).getFirst();
                        upper = ((NumericHeaderInfo)headerInfo).getLast();
                        shouldUpperComeFirst = ((NumericHeaderInfo)headerInfo).isReversed();
                        break;
                    }
                    case 2: {
                        Long l = UtilsKt.getConstLongValue(((NumericHeaderInfo)headerInfo).getStep());
                        if (l == null || l != -1L) {
                            return null;
                        }
                        lower2 = ((NumericHeaderInfo)headerInfo).getLast();
                        upper = ((NumericHeaderInfo)headerInfo).getFirst();
                        shouldUpperComeFirst = !((NumericHeaderInfo)headerInfo).isReversed();
                        break;
                    }
                    case 3: {
                        return null;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                useCompareTo = ((NumericHeaderInfo)headerInfo).getProgressionType() instanceof UnsignedProgressionType;
                isNumericRange = true;
                additionalNotEmptyCondition = ((NumericHeaderInfo)headerInfo).getAdditionalNotEmptyCondition();
            } else if (headerInfo2 instanceof FloatingPointRangeHeaderInfo) {
                lower2 = ((FloatingPointRangeHeaderInfo)headerInfo).getStart();
                upper = ((FloatingPointRangeHeaderInfo)headerInfo).getEndInclusive();
                shouldUpperComeFirst = false;
                useCompareTo = false;
                isNumericRange = true;
                additionalNotEmptyCondition = null;
            } else if (headerInfo2 instanceof ComparableRangeInfo) {
                lower2 = ((ComparableRangeInfo)headerInfo).getStart();
                upper = ((ComparableRangeInfo)headerInfo).getEndInclusive();
                shouldUpperComeFirst = false;
                useCompareTo = true;
                isNumericRange = false;
                additionalNotEmptyCondition = null;
            } else {
                return null;
            }
            IrExpression arg = argument;
            IrBuiltIns builtIns = $this$buildContainsComparison.getContext().getIrBuiltIns();
            if (isNumericRange) {
                irClass2 = this.computeComparisonClass(this.context.getIr().getSymbols(), lower2.getType(), upper.getType(), arg.getType());
                if (irClass2 == null) {
                    return null;
                }
            } else {
                boolean bl5 = headerInfo instanceof ComparableRangeInfo;
                boolean bl6 = false;
                boolean bl7 = false;
                if (_Assertions.ENABLED && !bl5) {
                    boolean bl8 = false;
                    String string3 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string3));
                }
                irClass2 = comparisonClass = (IrClass)this.context.getIr().getSymbols().getComparable().getOwner();
            }
            if (isNumericRange) {
                arg = UtilsKt.castIfNecessary(arg, comparisonClass);
            }
            Pair pair = UtilsKt.createTemporaryVariableIfNecessary$default($this$buildContainsComparison, arg, "containsArg", null, false, 12, null);
            IrVariable irVariable2 = (IrVariable)pair.component1();
            argExpression = (IrExpression)pair.component2();
            lowerExpression = null;
            upperExpression = null;
            useLowerClauseOnLeftSide = false;
            if (argVar != null) {
                Object object2 = UtilsKt.createTemporaryVariableIfNecessary$default($this$buildContainsComparison, lower2, "containsLower", null, false, 12, null);
                IrVariable irVariable3 = (IrVariable)object2.component1();
                tmpLowerExpression = (IrExpression)object2.component2();
                Pair pair2 = UtilsKt.createTemporaryVariableIfNecessary$default($this$buildContainsComparison, upper, "containsUpper", null, false, 12, null);
                object2 = (IrVariable)pair2.component1();
                IrExpression tmpUpperExpression = (IrExpression)pair2.component2();
                if (shouldUpperComeFirst) {
                    CollectionsKt.addIfNotNull(additionalStatements2, upperVar);
                    CollectionsKt.addIfNotNull(additionalStatements2, lowerVar);
                } else {
                    CollectionsKt.addIfNotNull(additionalStatements2, lowerVar);
                    CollectionsKt.addIfNotNull(additionalStatements2, upperVar);
                }
                lowerExpression = tmpLowerExpression;
                upperExpression = tmpUpperExpression;
                useLowerClauseOnLeftSide = true;
            } else if (UtilsKt.getCanHaveSideEffects(lower2) && UtilsKt.getCanHaveSideEffects(upper)) {
                IrVariable upperVar2;
                if (shouldUpperComeFirst) {
                    upperVar = UtilsKt.createTemporaryVariableIfNecessary$default($this$buildContainsComparison, upper, "containsUpper", null, false, 12, null);
                    lowerVar = (IrVariable)upperVar.component1();
                    IrExpression tmpUpperExpression = (IrExpression)upperVar.component2();
                    IrVariable irVariable4 = upperVar2;
                    Intrinsics.checkNotNull((Object)irVariable4);
                    additionalStatements2.add(irVariable4);
                    lowerExpression = lower2;
                    upperExpression = tmpUpperExpression;
                    useLowerClauseOnLeftSide = true;
                } else {
                    upperVar = UtilsKt.createTemporaryVariableIfNecessary$default($this$buildContainsComparison, lower2, "containsLower", null, false, 12, null);
                    upperVar2 = (IrVariable)upperVar.component1();
                    tmpLowerExpression = (IrExpression)upperVar.component2();
                    IrVariable irVariable5 = lowerVar;
                    Intrinsics.checkNotNull((Object)irVariable5);
                    additionalStatements2.add(irVariable5);
                    lowerExpression = tmpLowerExpression;
                    upperExpression = upper;
                    useLowerClauseOnLeftSide = false;
                }
            } else {
                lowerExpression = lower2;
                upperExpression = upper;
                useLowerClauseOnLeftSide = true;
            }
            CollectionsKt.addIfNotNull(additionalStatements2, argVar);
            if (isNumericRange) {
                lowerExpression = UtilsKt.castIfNecessary(lowerExpression, comparisonClass);
                upperExpression = UtilsKt.castIfNecessary(upperExpression, comparisonClass);
            }
            lessOrEqualFun = (IrSimpleFunctionSymbol)MapsKt.getValue(builtIns.getLessOrEqualFunByOperandType(), (Object)(useCompareTo ? builtIns.getIntClass() : (IrClassSymbol)comparisonClass.getSymbol()));
            Sequence<IrSimpleFunction> $this$singleOrNull$iv = IrUtilsKt.getFunctions(comparisonClass);
            boolean $i$f$singleOrNull2 = false;
            Object single$iv22 = null;
            found$iv2 = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                it = (IrSimpleFunction)element$iv;
                bl22 = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)OperatorNameConventions.COMPARE_TO) && it.getDispatchReceiverParameter() != null && it.getExtensionReceiverParameter() == null && it.getValueParameters().size() == 1 && (!isNumericRange || Intrinsics.areEqual((Object)it.getValueParameters().get(0).getType(), (Object)IrUtilsKt.getDefaultType(comparisonClass))))) continue;
                if (found$iv2) {
                    v5 = null;
                    break block42;
                }
                single$iv22 = element$iv;
                found$iv2 = true;
            }
            v5 = !found$iv2 ? null : single$iv22;
        }
        IrSimpleFunction irSimpleFunction = v5;
        if (irSimpleFunction == null) {
            return null;
        }
        IrSimpleFunction compareToFun = irSimpleFunction;
        if (useCompareTo) {
            void $this$apply4;
            $i$f$singleOrNull2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildContainsComparison, lessOrEqualFun);
            single$iv22 = false;
            found$iv2 = false;
            $this$apply3 = $i$f$singleOrNull2;
            boolean bl9 = false;
            $this$apply3.putValueArgument(0, ExpressionHelpersKt.irInt$default($this$buildContainsComparison, 0, null, 2, null));
            it = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildContainsComparison, compareToFun);
            bl22 = false;
            bl = false;
            IrElementBase irElementBase = it;
            int n = 1;
            IrCall irCall3 = $this$apply3;
            boolean object3 = false;
            $this$apply4.setDispatchReceiver(argExpression);
            $this$apply4.putValueArgument(0, lowerExpression);
            Unit unit = Unit.INSTANCE;
            irCall3.putValueArgument(n, (IrExpression)it);
            irCall2 = $i$f$singleOrNull2;
        } else {
            $i$f$singleOrNull2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildContainsComparison, lessOrEqualFun);
            single$iv22 = false;
            found$iv2 = false;
            $this$apply3 = $i$f$singleOrNull2;
            boolean bl10 = false;
            $this$apply3.putValueArgument(0, lowerExpression);
            $this$apply3.putValueArgument(1, argExpression);
            irCall2 = lowerClause = $i$f$singleOrNull2;
        }
        if (useCompareTo) {
            void p2;
            void p1;
            void $this$apply5;
            single$iv22 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildContainsComparison, lessOrEqualFun);
            found$iv2 = false;
            $this$apply2 = false;
            $this$apply = single$iv22;
            boolean bl11 = false;
            IrFunctionAccessExpression bl22 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildContainsComparison, compareToFun);
            bl = false;
            boolean $this$apply4 = false;
            IrFunctionAccessExpression irFunctionAccessExpression = bl22;
            int n = 0;
            object3 = $this$apply;
            boolean bl12 = false;
            $this$deepCopyWithSymbols$iv = argExpression;
            IrDeclarationParent initialParent$iv = null;
            boolean $i$f$deepCopyWithSymbols = false;
            DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
            IrElementVisitorVoidKt.acceptVoid($this$deepCopyWithSymbols$iv, symbolRemapper$iv);
            DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
            TypeRemapper typeRemapper = typeRemapper$iv;
            SymbolRemapper symbolRemapper = symbolRemapper$iv;
            IrElement irElement = $this$deepCopyWithSymbols$iv;
            void var44_80 = $this$apply5;
            DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols((SymbolRemapper)p1, (TypeRemapper)p2);
            IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(irElement.transform(deepCopyIrTreeWithSymbols, null), initialParent$iv);
            if (irElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            }
            var44_80.setDispatchReceiver((IrExpression)((IrElement)((IrExpression)irElement2)));
            $this$apply5.putValueArgument(0, upperExpression);
            Unit unit = Unit.INSTANCE;
            ((IrFunctionAccessExpression)object3).putValueArgument(n, bl22);
            $this$apply.putValueArgument(1, ExpressionHelpersKt.irInt$default($this$buildContainsComparison, 0, null, 2, null));
            irCall = single$iv22;
        } else {
            void p2;
            void p1;
            single$iv22 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildContainsComparison, lessOrEqualFun);
            found$iv2 = false;
            $this$apply2 = false;
            $this$apply = single$iv22;
            boolean bl13 = false;
            IrElement $this$deepCopyWithSymbols$iv2 = argExpression;
            IrDeclarationParent initialParent$iv = null;
            boolean $i$f$deepCopyWithSymbols = false;
            DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
            IrElementVisitorVoidKt.acceptVoid($this$deepCopyWithSymbols$iv2, symbolRemapper$iv);
            DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
            object3 = typeRemapper$iv;
            SymbolRemapper bl12 = symbolRemapper$iv;
            $this$deepCopyWithSymbols$iv = $this$deepCopyWithSymbols$iv2;
            int n = 0;
            IrCall irCall4 = $this$apply;
            DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols((SymbolRemapper)p1, (TypeRemapper)p2);
            IrElement irElement = PatchDeclarationParentsKt.patchDeclarationParents($this$deepCopyWithSymbols$iv.transform(deepCopyIrTreeWithSymbols, null), initialParent$iv);
            if (irElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            }
            irCall4.putValueArgument(n, (IrExpression)((IrElement)((IrExpression)irElement)));
            $this$apply.putValueArgument(1, upperExpression);
            irCall = single$iv22;
        }
        IrCall upperClause = irCall;
        IrWhen found$iv2 = PrimitivesKt.andand($this$buildContainsComparison.getContext(), useLowerClauseOnLeftSide ? lowerClause : upperClause, useLowerClauseOnLeftSide ? upperClause : lowerClause, origin);
        $this$apply2 = false;
        boolean $this$apply6 = false;
        IrWhen it2 = found$iv2;
        boolean bl14 = false;
        IrWhen contains = additionalNotEmptyCondition != null ? PrimitivesKt.andand$default($this$buildContainsComparison.getContext(), it2, additionalNotEmptyCondition, null, 4, null) : it2;
        if (additionalStatements2.isEmpty()) {
            irExpression = contains;
        } else {
            IrBuilderWithScope $this$irBlock$iv = $this$buildContainsComparison;
            int startOffset$iv = $this$irBlock$iv.getStartOffset();
            int endOffset$iv = $this$irBlock$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder this_$iv$iv = new IrBlockBuilder($this$irBlock$iv.getContext(), $this$irBlock$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            IrBlockBuilder $this$irBlock = this_$iv$iv;
            boolean bl15 = false;
            for (IrStatement stmt : additionalStatements2) {
                $this$irBlock.unaryPlus(stmt);
            }
            $this$irBlock.unaryPlus(contains);
            irExpression = this_$iv$iv.doBuild();
        }
        return irExpression;
    }

    private final IrClass computeComparisonClass(Symbols<? extends CommonBackendContext> symbols, IrType lowerType, IrType upperType, IrType argumentType) {
        IrType irType = this.leastCommonPrimitiveNumericType(symbols, lowerType, upperType);
        if (irType == null) {
            return null;
        }
        IrType commonBoundType = irType;
        IrType irType2 = this.leastCommonPrimitiveNumericType(symbols, argumentType, commonBoundType);
        return irType2 != null ? IrTypesKt.getClass(irType2) : null;
    }

    private final IrType leastCommonPrimitiveNumericType(Symbols<? extends CommonBackendContext> symbols, IrType t1, IrType t2) {
        IrClassSymbol irClassSymbol;
        IrType pt1 = this.promoteIntegerTypeToIntIfRequired(t1, symbols);
        IrType pt2 = this.promoteIntegerTypeToIntIfRequired(t2, symbols);
        if (IrTypePredicatesKt.isDouble(pt1) || IrTypePredicatesKt.isDouble(pt2)) {
            irClassSymbol = symbols.getDouble();
        } else if (IrTypePredicatesKt.isFloat(pt1) || IrTypePredicatesKt.isFloat(pt2)) {
            irClassSymbol = symbols.getFloat();
        } else if (IrTypePredicatesKt.isULong(pt1) || IrTypePredicatesKt.isULong(pt2)) {
            IrClassSymbol irClassSymbol2 = symbols.getULong();
            irClassSymbol = irClassSymbol2;
            Intrinsics.checkNotNull((Object)irClassSymbol2);
        } else if (IrTypePredicatesKt.isUInt(pt1) || IrTypePredicatesKt.isUInt(pt2)) {
            IrClassSymbol irClassSymbol3 = symbols.getUInt();
            irClassSymbol = irClassSymbol3;
            Intrinsics.checkNotNull((Object)irClassSymbol3);
        } else if (IrTypePredicatesKt.isLong(pt1) || IrTypePredicatesKt.isLong(pt2)) {
            irClassSymbol = symbols.getLong();
        } else if (IrTypePredicatesKt.isInt(pt1) || IrTypePredicatesKt.isInt(pt2)) {
            irClassSymbol = symbols.getInt();
        } else if (IrTypePredicatesKt.isChar(pt1) || IrTypePredicatesKt.isChar(pt2)) {
            irClassSymbol = symbols.getChar();
        } else {
            Object object;
            Object object2;
            String string2 = "Unexpected types: t1=" + ((object2 = IrTypesKt.getClassOrNull(t1)) != null && (object2 = (IrClass)object2.getOwner()) != null ? object2.getName() : null) + ", t2=" + ((object = IrTypesKt.getClassOrNull(t2)) != null && (object = (IrClass)object.getOwner()) != null ? object.getName() : null);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return IrTypesKt.getDefaultType(irClassSymbol);
    }

    private final IrType promoteIntegerTypeToIntIfRequired(IrType $this$promoteIntegerTypeToIntIfRequired, Symbols<? extends CommonBackendContext> symbols) {
        IrType irType;
        if (IrTypePredicatesKt.isByte($this$promoteIntegerTypeToIntIfRequired) || IrTypePredicatesKt.isShort($this$promoteIntegerTypeToIntIfRequired)) {
            irType = IrTypesKt.getDefaultType(symbols.getInt());
        } else if (IrTypePredicatesKt.isUByte($this$promoteIntegerTypeToIntIfRequired) || IrTypePredicatesKt.isUShort($this$promoteIntegerTypeToIntIfRequired)) {
            IrClassSymbol irClassSymbol = symbols.getUInt();
            Intrinsics.checkNotNull((Object)irClassSymbol);
            irType = IrTypesKt.getDefaultType(irClassSymbol);
        } else {
            irType = $this$promoteIntegerTypeToIntIfRequired;
        }
        return irType;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrSymbolOwner getContainer() {
        return this.container;
    }

    public Transformer(@NotNull CommonBackendContext context2, @NotNull IrSymbolOwner container) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.context = context2;
        this.container = container;
        this.headerInfoBuilder = new RangeHeaderInfoBuilder(this.context, (Function0<? extends IrSymbol>)((Function0)new Function0<IrSymbol>(this){

            @NotNull
            public final IrSymbol invoke() {
                return ((Transformer)this.receiver).getScopeOwnerSymbol();
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Transformer.class);
            }

            public final String getName() {
                return "getScopeOwnerSymbol";
            }

            public final String getSignature() {
                return "getScopeOwnerSymbol()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;";
            }
        }));
        this.stdlibExtensionContainsCallMatcher = new SimpleCalleeMatcher((Function1<? super IrFunctionMatcherContainer, Unit>)((Function1)new Function1<IrFunctionMatcherContainer, Unit>(this){
            final /* synthetic */ Transformer this$0;

            public final void invoke(@NotNull IrFunctionMatcherContainer $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                $receiver.extensionReceiver((Function1<? super IrValueParameter, Boolean>)((Function1)new Function1<IrValueParameter, Boolean>(this){
                    final /* synthetic */ stdlibExtensionContainsCallMatcher.1 this$0;

                    public final boolean invoke(@Nullable IrValueParameter it) {
                        return it != null && IrTypeUtilsKt.isSubtypeOfClass(it.getType(), this.this$0.this$0.getContext().getIr().getSymbols().getClosedRange());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                $receiver.fqName((Function1<? super FqName, Boolean>)((Function1)stdlibExtensionContainsCallMatcher.2.INSTANCE));
                $receiver.parameterCount((Function1<? super Integer, Boolean>)((Function1)stdlibExtensionContainsCallMatcher.3.INSTANCE));
            }
            {
                this.this$0 = transformer2;
                super(1);
            }
        }));
    }
}

