/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/DefaultParameterCleaner;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "replaceDefaultValuesWithStubs", "", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Z)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "getReplaceDefaultValuesWithStubs", "()Z", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "ir.backend.common"})
public final class DefaultParameterCleaner
implements DeclarationTransformer {
    private final CommonBackendContext context;
    private final boolean replaceDefaultValuesWithStubs;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        LowerKt.toFileLoweringPass(LowerKt.runPostfix(this, true)).lower(irFile);
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof IrValueParameter && ((IrValueParameter)declaration).getDefaultValue() != null) {
            if (this.replaceDefaultValuesWithStubs) {
                IrDeclarationParent irDeclarationParent = declaration.getParent();
                if (irDeclarationParent == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
                }
                if (this.context.getMapping().getDefaultArgumentsOriginalFunction().get((IrFunction)((IrDeclaration)((IrFunction)irDeclarationParent))) == null) {
                    ((IrValueParameter)declaration).setDefaultValue(this.context.getIrFactory().createExpressionBody(new IrErrorExpressionImpl(-1, -1, ((IrValueParameter)declaration).getType(), "Default Stub")));
                }
            } else {
                ((IrValueParameter)declaration).setDefaultValue(null);
            }
        }
        return null;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public final boolean getReplaceDefaultValuesWithStubs() {
        return this.replaceDefaultValuesWithStubs;
    }

    public DefaultParameterCleaner(@NotNull CommonBackendContext context2, boolean replaceDefaultValuesWithStubs) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.replaceDefaultValuesWithStubs = replaceDefaultValuesWithStubs;
    }

    public /* synthetic */ DefaultParameterCleaner(CommonBackendContext commonBackendContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(commonBackendContext, bl);
    }
}

