/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.finder;

import com.google.common.collect.Sets;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.finder.KtLightPackage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J#\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0014J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0002J&\u0010\u001a\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J#\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010!J#\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00122\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010$J \u0010%\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010&2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J#\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00122\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010(J\u001e\u0010)\u001a\u00020\u00162\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0+2\u0006\u0010,\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder;", "Lcom/intellij/psi/PsiElementFinder;", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinFinderMarker;", "project", "Lcom/intellij/openapi/project/Project;", "kotlinAsJavaSupport", "Lorg/jetbrains/kotlin/asJava/KotlinAsJavaSupport;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/asJava/KotlinAsJavaSupport;)V", "psiManager", "Lcom/intellij/psi/PsiManager;", "Lorg/jetbrains/annotations/NotNull;", "findClass", "Lcom/intellij/psi/PsiClass;", "qualifiedName", "", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findClasses", "", "qualifiedNameString", "(Ljava/lang/String;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiClass;", "findClassesAndObjects", "", "Lorg/jetbrains/kotlin/name/FqName;", "answer", "", "findInterfaceDefaultImpls", "findPackage", "Lcom/intellij/psi/PsiPackage;", "getClassNames", "", "psiPackage", "getClasses", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiClass;", "getPackageFiles", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiFile;", "getPackageFilesFilter", "Lcom/intellij/openapi/util/Condition;", "getSubPackages", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiPackage;", "sortByPreferenceToSourceFile", "list", "Lcom/intellij/util/SmartList;", "searchScope", "Companion", "light-classes"})
public final class JavaElementFinder
extends PsiElementFinder
implements KotlinFinderMarker {
    private final PsiManager psiManager;
    private final Project project;
    private final KotlinAsJavaSupport kotlinAsJavaSupport;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        return (PsiClass)ArraysKt.firstOrNull((Object[])this.findClasses(qualifiedName, scope2));
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedNameString, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)qualifiedNameString, (String)"qualifiedNameString");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiClass.EMPTY_ARRAY, (String)"PsiClass.EMPTY_ARRAY");
            return PsiClass.EMPTY_ARRAY;
        }
        SmartList answer = new SmartList();
        FqName qualifiedName = new FqName(qualifiedNameString);
        this.findClassesAndObjects(qualifiedName, scope2, (List)answer);
        answer.addAll(this.kotlinAsJavaSupport.getFacadeClasses(qualifiedName, scope2));
        answer.addAll(this.kotlinAsJavaSupport.getKotlinInternalClasses(qualifiedName, scope2));
        this.sortByPreferenceToSourceFile((SmartList<PsiClass>)answer, scope2);
        Collection $this$toTypedArray$iv = (Collection)answer;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiClass[] psiClassArray = thisCollection$iv.toArray(new PsiClass[0]);
        if (psiClassArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiClassArray;
    }

    private final void findClassesAndObjects(FqName qualifiedName, GlobalSearchScope scope2, List<PsiClass> answer) {
        this.findInterfaceDefaultImpls(qualifiedName, scope2, answer);
        Collection<KtClassOrObject> classOrObjectDeclarations = this.kotlinAsJavaSupport.findClassOrObjectDeclarations(qualifiedName, scope2);
        for (KtClassOrObject declaration : classOrObjectDeclarations) {
            KtLightClass lightClass;
            if (declaration instanceof KtEnumEntry || (lightClass = LightClassUtilsKt.toLightClass(declaration)) == null) continue;
            answer.add(lightClass);
        }
    }

    private final void findInterfaceDefaultImpls(FqName qualifiedName, GlobalSearchScope scope2, List<PsiClass> answer) {
        if (qualifiedName.isRoot()) {
            return;
        }
        if (Intrinsics.areEqual((Object)qualifiedName.shortName().asString(), (Object)"DefaultImpls") ^ true) {
            return;
        }
        FqName fqName2 = qualifiedName.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"qualifiedName.parent()");
        for (KtClassOrObject classOrObject : this.kotlinAsJavaSupport.findClassOrObjectDeclarations(fqName2, scope2)) {
            PsiClass implsClass;
            KtLightClass interfaceClass;
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            if (!(classOrObject instanceof KtClass) || !((KtClass)classOrObject).isInterface()) continue;
            if (LightClassUtilsKt.toLightClass(classOrObject) == null) {
                continue;
            }
            if (interfaceClass.findInnerClassByName("DefaultImpls", false) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)implsClass, (String)"interfaceClass.findInner\u2026_NAME, false) ?: continue");
            answer.add(implsClass);
        }
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<KtClassOrObject> declarations2 = this.kotlinAsJavaSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope2);
        HashSet answer = Sets.newHashSet();
        answer.addAll(this.kotlinAsJavaSupport.getFacadeNames(packageFQN, scope2));
        for (KtClassOrObject declaration : declarations2) {
            String name;
            if (declaration.getName() == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"declaration.name ?: continue");
            answer.add(name);
        }
        HashSet hashSet = answer;
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"answer");
        return hashSet;
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedNameString) {
        Intrinsics.checkNotNullParameter((Object)qualifiedNameString, (String)"qualifiedNameString");
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            return null;
        }
        FqName fqName2 = new FqName(qualifiedNameString);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
        GlobalSearchScope allScope = globalSearchScope;
        return (PsiPackage)(this.kotlinAsJavaSupport.packageExists(fqName2, allScope) ? new KtLightPackage(this.psiManager, fqName2, allScope) : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Collection<FqName> subpackages = this.kotlinAsJavaSupport.getSubPackages(new FqName(psiPackage.getQualifiedName()), scope2);
        Iterable $this$map$iv = subpackages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FqName fqName2 = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KtLightPackage ktLightPackage = new KtLightPackage(this.psiManager, (FqName)it, scope2);
            collection.add(ktLightPackage);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiPackage[] psiPackageArray = thisCollection$iv.toArray(new PsiPackage[0]);
        if (psiPackageArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiPackageArray;
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        SmartList answer = new SmartList();
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        answer.addAll(this.kotlinAsJavaSupport.getFacadeClassesInPackage(packageFQN, scope2));
        Collection<KtClassOrObject> declarations2 = this.kotlinAsJavaSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope2);
        for (KtClassOrObject declaration : declarations2) {
            KtLightClass aClass2;
            if (LightClassUtilsKt.toLightClass(declaration) == null) {
                continue;
            }
            answer.add((Object)aClass2);
        }
        this.sortByPreferenceToSourceFile((SmartList<PsiClass>)answer, scope2);
        Collection $this$toTypedArray$iv = (Collection)answer;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiClass[] psiClassArray = thisCollection$iv.toArray(new PsiClass[0]);
        if (psiClassArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiClassArray;
    }

    private final void sortByPreferenceToSourceFile(SmartList<PsiClass> list2, GlobalSearchScope searchScope) {
        if (list2.size() < 2) {
            return;
        }
        ContainerUtil.quickSort((List)((List)list2), Companion.byClasspathComparator(searchScope));
        List $this$sortBy$iv = (List)list2;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            boolean bl = false;
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    PsiClass it = (PsiClass)a;
                    boolean bl2 = false;
                    boolean bl3 = !(it instanceof ClsClassImpl);
                    it = (PsiClass)b;
                    Comparable comparable = Boolean.valueOf(bl3);
                    bl2 = false;
                    Boolean bl4 = !(it instanceof ClsClassImpl);
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)bl4);
                }
            });
        }
    }

    @NotNull
    public PsiFile[] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Collection<KtFile> $this$toTypedArray$iv = this.kotlinAsJavaSupport.findFilesForPackage(new FqName(psiPackage.getQualifiedName()), scope2);
        boolean $i$f$toTypedArray = false;
        Collection<KtFile> thisCollection$iv = $this$toTypedArray$iv;
        PsiFile[] psiFileArray = thisCollection$iv.toArray(new PsiFile[0]);
        if (psiFileArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiFileArray;
    }

    @Nullable
    public Condition<PsiFile> getPackageFilesFilter(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        return (Condition)new Condition<PsiFile>(psiPackage){
            final /* synthetic */ PsiPackage $psiPackage;

            public final boolean value(PsiFile input) {
                return !(input instanceof KtFile) ? true : Intrinsics.areEqual((Object)this.$psiPackage.getQualifiedName(), (Object)((KtFile)input).getPackageFqName().asString());
            }
            {
                this.$psiPackage = psiPackage;
            }
        };
    }

    public JavaElementFinder(@NotNull Project project, @NotNull KotlinAsJavaSupport kotlinAsJavaSupport) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)kotlinAsJavaSupport, (String)"kotlinAsJavaSupport");
        this.project = project;
        this.kotlinAsJavaSupport = kotlinAsJavaSupport;
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(project)");
        this.psiManager = psiManager;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder$Companion;", "", "()V", "byClasspathComparator", "Ljava/util/Comparator;", "Lcom/intellij/psi/PsiElement;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getInstance", "Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder;", "project", "Lcom/intellij/openapi/project/Project;", "light-classes"})
    public static final class Companion {
        @NotNull
        public final JavaElementFinder getInstance(@NotNull Project project) {
            Object object;
            block2: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                ExtensionPoint extensionPoint = PsiElementFinder.EP.getPoint((AreaInstance)project);
                Intrinsics.checkNotNullExpressionValue((Object)extensionPoint, (String)"EP.getPoint(project)");
                Object[] objectArray = extensionPoint.getExtensions();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"EP.getPoint(project).extensions");
                Object[] $this$firstIsInstanceOrNull$iv = objectArray;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof JavaElementFinder)) continue;
                    object = element$iv;
                    break block2;
                }
                object = null;
            }
            JavaElementFinder javaElementFinder = (JavaElementFinder)object;
            if (javaElementFinder == null) {
                String string2 = JavaElementFinder.class.getSimpleName() + " is not found for project " + project;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            return javaElementFinder;
        }

        @NotNull
        public final Comparator<PsiElement> byClasspathComparator(@NotNull GlobalSearchScope searchScope) {
            Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
            return new Comparator<PsiElement>(searchScope){
                final /* synthetic */ GlobalSearchScope $searchScope;

                public final int compare(PsiElement o1, PsiElement o2) {
                    VirtualFile f1 = PsiUtilCore.getVirtualFile((PsiElement)o1);
                    VirtualFile f2 = PsiUtilCore.getVirtualFile((PsiElement)o2);
                    return f1 == f2 ? 0 : (f1 == null ? -1 : (f2 == null ? 1 : this.$searchScope.compare(f2, f1)));
                }
                {
                    this.$searchScope = globalSearchScope;
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

