/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatedPropertyInferenceSession;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.InferenceSessionForExistingCandidates;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallChecker;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.components.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.EmptySubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.components.KotlinConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutorByConstructorMap;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionAtomsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.tower.KotlinResolutionCallbacksImpl;
import org.jetbrains.kotlin.resolve.calls.tower.PSICallResolver;
import org.jetbrains.kotlin.resolve.calls.tower.ResolutionResultCallInfo;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.ScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.StubTypeForProvideDelegateReceiver;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.NewTypeVariableConstructor;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001fBM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J0\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J(\u0010-\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J \u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*H\u0002J \u00103\u001a\u00020\u001c2\u0006\u00100\u001a\u0002012\u0006\u0010)\u001a\u00020*2\u0006\u00102\u001a\u00020\u001cH\u0002Jf\u00104\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u00020\u00162\n\b\u0002\u00107\u001a\u0004\u0018\u00010/2\n\b\u0002\u00108\u001a\u0004\u0018\u00010\"H\u0002J8\u00109\u001a\u0004\u0018\u00010\u001c2\u0006\u0010:\u001a\u00020$2\u0006\u00100\u001a\u0002012\u0006\u0010;\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010<\u001a\u00020&2\u0006\u0010'\u001a\u00020(J>\u0010=\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u00100\u001a\u0002012\u0006\u0010>\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010<\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J.\u0010=\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u00100\u001a\u0002012\u0006\u0010>\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020\"H\u0002J(\u0010@\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020$2\u0006\u00100\u001a\u0002012\u0006\u0010;\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*H\u0002JB\u0010A\u001a\u00020\u001a2\u0006\u00100\u001a\u0002012\u0006\u0010:\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020B2\u0006\u00102\u001a\u00020\u001c2\b\u0010C\u001a\u0004\u0018\u00010\u001c2\u0006\u0010D\u001a\u00020(H\u0002J*\u0010E\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0014\u0010F\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0002J.\u0010G\u001a\u00020H2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010J\u001a\u00020K2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\u0006\u0010?\u001a\u00020PH\u0002J.\u0010Q\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*2\u0006\u0010R\u001a\u00020O2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u00100\u001a\u000201H\u0002J0\u0010T\u001a\u00020H2\u0006\u0010R\u001a\u00020O2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u00105\u001a\u00020\u0016H\u0002J>\u0010U\u001a\u00020H2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010J\u001a\u00020K2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u00105\u001a\u00020\u0016H\u0002J>\u0010V\u001a\u00020\u001c2\u0006\u00100\u001a\u0002012\u0006\u0010W\u001a\u00020X2\u0006\u0010:\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020(2\u0006\u0010Y\u001a\u00020,J@\u0010Z\u001a\u00020H2\u0006\u0010#\u001a\u00020$2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010<\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00105\u001a\u00020\u0016H\u0002J8\u0010[\u001a\u00020H2\u0006\u0010:\u001a\u00020$2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010<\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J>\u0010\\\u001a\u00020H2\u0006\u0010]\u001a\u00020(2\u0006\u0010W\u001a\u00020X2\u0006\u0010:\u001a\u00020$2\u0006\u00100\u001a\u0002012\u0006\u0010^\u001a\u00020&2\u0006\u0010Y\u001a\u00020,2\u0006\u0010)\u001a\u00020*J8\u0010_\u001a\u00020H2\u0006\u0010#\u001a\u00020$2\u0006\u0010`\u001a\u0002012\u0006\u0010;\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010<\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J8\u0010a\u001a\u00020H2\u0006\u0010:\u001a\u00020$2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010<\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J:\u0010b\u001a\u0004\u0018\u00010\u001c2\u0006\u00100\u001a\u0002012\u0006\u0010:\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020(2\u0006\u0010Y\u001a\u00020,H\u0002J\f\u0010c\u001a\u000201*\u00020dH\u0002J\f\u0010e\u001a\u00020\u0016*\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006g"}, d2={"Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;", "", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "fakeCallResolver", "Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "psiCallResolver", "Lorg/jetbrains/kotlin/resolve/calls/tower/PSICallResolver;", "postponedArgumentsAnalyzer", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;", "kotlinConstraintSystemCompleter", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;", "callComponents", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;Lorg/jetbrains/kotlin/resolve/calls/tower/PSICallResolver;Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;)V", "isOperatorProvideDelegateSupported", "", "()Z", "buildSubstitutionMapOfNonFixedVariables", "", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "conventionMethodFound", "results", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "createContextForGetSetValueMethods", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "scopeForDelegate", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "inferenceExtension", "Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "createContextForProvideDelegateMethod", "createReceiverForGetSetValueMethods", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "delegateExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "delegateType", "extractResolvedDelegateType", "getGetSetValueMethod", "isGet", "isComplete", "knownReceiver", "knownContext", "getGetValueMethodReturnType", "variableDescriptor", "byExpressionType", "initializerScope", "getProvideDelegateMethod", "delegateExpressionType", "context", "getResolvedDelegateType", "inferDelegateTypeFromGetSetValueMethods", "Lorg/jetbrains/kotlin/resolve/TemporaryBindingTrace;", "delegateTypeForProperType", "delegateDataFlow", "inverseSubstitution", "substitutionMap", "recordDelegateOperatorResults", "", "result", "accessor", "Lorg/jetbrains/kotlin/descriptors/VariableAccessorDescriptor;", "renderCall", "", "call", "Lorg/jetbrains/kotlin/psi/Call;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "reportDelegateErrorIfCandidateExists", "delegateOperatorCall", "delegateOperatorResults", "reportDelegateFunctionMissing", "reportGetSetValueResolutionError", "resolveDelegateExpression", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "inferenceSession", "resolveGetSetValueMethod", "resolveGetValueMethod", "resolvePropertyDelegate", "outerDataFlowInfo", "propertyHeaderScope", "resolveProvideDelegateMethod", "byExpression", "resolveSetValueMethod", "resolveWithNewInference", "createExpressionForProperty", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "isProperType", "ConstraintSystemCompleterImpl", "frontend"})
public final class DelegatedPropertyResolver {
    private final KotlinBuiltIns builtIns;
    private final FakeCallResolver fakeCallResolver;
    private final ExpressionTypingServices expressionTypingServices;
    private final LanguageVersionSettings languageVersionSettings;
    private final DataFlowValueFactory dataFlowValueFactory;
    private final PSICallResolver psiCallResolver;
    private final PostponedArgumentsAnalyzer postponedArgumentsAnalyzer;
    private final KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter;
    private final KotlinCallComponents callComponents;

    public final void resolvePropertyDelegate(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull KtProperty property2, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KtExpression delegateExpression2, @NotNull LexicalScope propertyHeaderScope, @NotNull InferenceSession inferenceSession, @NotNull BindingTrace trace) {
        LexicalScope lexicalScope;
        boolean bl;
        boolean bl2;
        KtPropertyAccessor ktPropertyAccessor;
        Intrinsics.checkNotNullParameter((Object)outerDataFlowInfo, (String)"outerDataFlowInfo");
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)variableDescriptor, (String)"variableDescriptor");
        Intrinsics.checkNotNullParameter((Object)delegateExpression2, (String)"delegateExpression");
        Intrinsics.checkNotNullParameter((Object)propertyHeaderScope, (String)"propertyHeaderScope");
        Intrinsics.checkNotNullParameter((Object)inferenceSession, (String)"inferenceSession");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        KtPropertyAccessor ktPropertyAccessor2 = property2.getGetter();
        if (ktPropertyAccessor2 != null) {
            ktPropertyAccessor = ktPropertyAccessor2;
            bl2 = false;
            bl = false;
            KtPropertyAccessor getter2 = ktPropertyAccessor;
            boolean bl3 = false;
            if (getter2.hasBody()) {
                trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on((KtPropertyAccessor)((PsiElement)getter2)));
            }
        }
        KtPropertyAccessor ktPropertyAccessor3 = property2.getSetter();
        if (ktPropertyAccessor3 != null) {
            ktPropertyAccessor = ktPropertyAccessor3;
            bl2 = false;
            bl = false;
            KtPropertyAccessor setter2 = ktPropertyAccessor;
            boolean bl4 = false;
            if (setter2.hasBody()) {
                trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on((KtPropertyAccessor)((PsiElement)setter2)));
            }
        }
        if (variableDescriptor instanceof PropertyDescriptor) {
            LexicalScope lexicalScope2 = ScopeUtils.makeScopeForPropertyInitializer(propertyHeaderScope, (PropertyDescriptor)variableDescriptor);
            lexicalScope = lexicalScope2;
            Intrinsics.checkNotNullExpressionValue((Object)lexicalScope2, (String)"ScopeUtils.makeScopeForP\u2026cope, variableDescriptor)");
        } else {
            lexicalScope = propertyHeaderScope;
        }
        LexicalScope initializerScope = lexicalScope;
        KotlinType byExpressionType = this.resolveDelegateExpression(delegateExpression2, property2, variableDescriptor, initializerScope, trace, outerDataFlowInfo, inferenceSession);
        this.resolveProvideDelegateMethod(variableDescriptor, delegateExpression2, byExpressionType, trace, initializerScope, outerDataFlowInfo);
        KotlinType delegateType = this.getResolvedDelegateType(variableDescriptor, delegateExpression2, byExpressionType, trace);
        this.resolveGetValueMethod(variableDescriptor, delegateExpression2, delegateType, trace, initializerScope, outerDataFlowInfo);
        if (property2.isVar()) {
            this.resolveSetValueMethod(variableDescriptor, delegateExpression2, delegateType, trace, initializerScope, outerDataFlowInfo);
        }
    }

    private final KotlinType getResolvedDelegateType(VariableDescriptorWithAccessors variableDescriptor, KtExpression delegateExpression2, KotlinType byExpressionType, BindingTrace trace) {
        ResolvedCall provideDelegateResolvedCall = (ResolvedCall)trace.getBindingContext().get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, variableDescriptor);
        if (provideDelegateResolvedCall != null) {
            Object d = provideDelegateResolvedCall.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(d, (String)"provideDelegateResolvedCall.resultingDescriptor");
            KotlinType kotlinType = ((FunctionDescriptor)d).getReturnType();
            if (kotlinType == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No return type fore 'provideDelegate' of " + delegateExpression2.getText())));
            }
            return kotlinType;
        }
        return byExpressionType;
    }

    @Nullable
    public final KotlinType getGetValueMethodReturnType(@NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KtExpression delegateExpression2, @NotNull KotlinType byExpressionType, @NotNull BindingTrace trace, @NotNull LexicalScope initializerScope, @NotNull DataFlowInfo dataFlowInfo) {
        Intrinsics.checkNotNullParameter((Object)variableDescriptor, (String)"variableDescriptor");
        Intrinsics.checkNotNullParameter((Object)delegateExpression2, (String)"delegateExpression");
        Intrinsics.checkNotNullParameter((Object)byExpressionType, (String)"byExpressionType");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)initializerScope, (String)"initializerScope");
        Intrinsics.checkNotNullParameter((Object)dataFlowInfo, (String)"dataFlowInfo");
        this.resolveProvideDelegateMethod(variableDescriptor, delegateExpression2, byExpressionType, trace, initializerScope, dataFlowInfo);
        KotlinType delegateType = this.getResolvedDelegateType(variableDescriptor, delegateExpression2, byExpressionType, trace);
        this.resolveGetSetValueMethod(variableDescriptor, delegateExpression2, delegateType, trace, initializerScope, dataFlowInfo, true);
        ResolvedCall resolvedCall2 = (ResolvedCall)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, variableDescriptor.getGetter());
        Object object = resolvedCall2;
        return object != null && (object = (FunctionDescriptor)object.getResultingDescriptor()) != null ? object.getReturnType() : null;
    }

    private final boolean isOperatorProvideDelegateSupported() {
        return this.languageVersionSettings.supportsFeature(LanguageFeature.OperatorProvideDelegate);
    }

    private final void resolveGetValueMethod(VariableDescriptorWithAccessors variableDescriptor, KtExpression delegateExpression2, KotlinType delegateType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo) {
        KotlinType returnType2 = this.getGetValueMethodReturnType(variableDescriptor, delegateExpression2, delegateType, trace, initializerScope, dataFlowInfo);
        KotlinType kotlinType = variableDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"variableDescriptor.type");
        KotlinType propertyType = kotlinType;
        if (!(propertyType instanceof DeferredType) && returnType2 != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(returnType2, propertyType)) {
            Call call2 = (Call)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, variableDescriptor.getGetter());
            if (call2 == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Call should exists for " + variableDescriptor.getGetter())));
            }
            Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"trace.bindingContext.get\u2026iableDescriptor.getter}\")");
            Call call3 = call2;
            PsiElement psiElement = (PsiElement)delegateExpression2;
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_RETURN_TYPE_MISMATCH.on((KtExpression)psiElement, this.renderCall(call3, bindingContext), variableDescriptor.getType(), returnType2));
        }
    }

    private final void resolveSetValueMethod(VariableDescriptorWithAccessors variableDescriptor, KtExpression delegateExpression2, KotlinType delegateType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo) {
        this.resolveGetSetValueMethod(variableDescriptor, delegateExpression2, delegateType, trace, initializerScope, dataFlowInfo, false);
    }

    private final KtExpression createExpressionForProperty(KtPsiFactory $this$createExpressionForProperty) {
        return $this$createExpressionForProperty.createExpression("null as " + KotlinBuiltIns.FQ_NAMES.kPropertyFqName.asString() + "<*>");
    }

    private final void resolveGetSetValueMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression2, KotlinType delegateType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo, boolean isGet) {
        VariableAccessorDescriptor variableAccessorDescriptor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        if (variableAccessorDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Delegated property should have getter/setter " + propertyDescriptor + ' ' + delegateExpression2.getText())));
        }
        VariableAccessorDescriptor accessor = variableAccessorDescriptor;
        if (trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor) != null) {
            return;
        }
        OverloadResolutionResults functionResults = DelegatedPropertyResolver.getGetSetValueMethod$default(this, propertyDescriptor, delegateExpression2, delegateType, trace, initializerScope, dataFlowInfo, isGet, true, null, null, 768, null);
        if (functionResults.isSuccess()) {
            this.recordDelegateOperatorResults(functionResults, propertyDescriptor, accessor, trace);
        } else {
            this.reportGetSetValueResolutionError(functionResults, accessor, delegateExpression2, delegateType, trace, isGet);
        }
    }

    private final void recordDelegateOperatorResults(OverloadResolutionResults<FunctionDescriptor> result2, VariableDescriptorWithAccessors propertyDescriptor, VariableAccessorDescriptor accessor, BindingTrace trace) {
        KtPropertyDelegate delegate;
        PsiElement declaration;
        FunctionDescriptor functionDescriptor = result2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"result.resultingDescriptor");
        FunctionDescriptor resultingDescriptor = functionDescriptor;
        ResolvedCall<FunctionDescriptor> resolvedCall2 = result2.getResultingCall();
        Intrinsics.checkNotNullExpressionValue(resolvedCall2, (String)"result.resultingCall");
        ResolvedCall<FunctionDescriptor> resultingCall = resolvedCall2;
        if (!resultingDescriptor.isOperator() && (declaration = DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor)) instanceof KtProperty && (delegate = ((KtProperty)declaration).getDelegate()) != null) {
            PsiElement byKeyword;
            ASTNode aSTNode = delegate.getByKeywordNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"delegate.byKeywordNode");
            PsiElement psiElement = byKeyword = aSTNode.getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"byKeyword");
            OperatorCallChecker.Companion.report(psiElement, resultingDescriptor, trace);
        }
        trace.record(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, accessor, resultingCall);
    }

    private final void reportGetSetValueResolutionError(OverloadResolutionResults<FunctionDescriptor> result2, VariableAccessorDescriptor accessor, KtExpression delegateExpression2, KotlinType delegateType, BindingTrace trace, boolean isGet) {
        Call call2 = (Call)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor);
        if (call2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)"'getDelegatedPropertyConventionMethod' didn't record a call"));
        }
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"trace.bindingContext.get\u2026d' didn't record a call\")");
        Call call3 = call2;
        boolean errorReportedForCandidate = this.reportDelegateErrorIfCandidateExists(trace, call3, result2, delegateExpression2);
        if (!errorReportedForCandidate) {
            this.reportDelegateFunctionMissing(call3, delegateExpression2, delegateType, trace, isGet);
        }
    }

    private final void reportDelegateFunctionMissing(Call delegateOperatorCall, KtExpression delegateExpression2, KotlinType delegateType, BindingTrace trace, boolean isGet) {
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        String expectedFunction = this.renderCall(delegateOperatorCall, bindingContext);
        String delegateKind = isGet ? "delegate" : "delegate for var (read-write property)";
        trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_MISSING.on((KtExpression)((PsiElement)delegateExpression2), expectedFunction, delegateType, delegateKind));
    }

    private final boolean reportDelegateErrorIfCandidateExists(BindingTrace trace, Call delegateOperatorCall, OverloadResolutionResults<FunctionDescriptor> delegateOperatorResults, KtExpression delegateExpression2) {
        DiagnosticFactory2<KtExpression, String, Collection<ResolvedCall<?>>> resolutionErrorFactory;
        block0: {
            DiagnosticFactory2<KtExpression, String, Collection<ResolvedCall<?>>> diagnosticFactory2 = resolutionErrorFactory = delegateOperatorResults.isSingleResult() || delegateOperatorResults.isIncomplete() || delegateOperatorResults.getResultCode() == OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES ? Errors.DELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE : (delegateOperatorResults.isAmbiguity() ? Errors.DELEGATE_SPECIAL_FUNCTION_AMBIGUITY : null);
            if (diagnosticFactory2 == null) break block0;
            DiagnosticFactory2<KtExpression, String, Collection<ResolvedCall<?>>> diagnosticFactory22 = diagnosticFactory2;
            boolean bl = false;
            boolean bl2 = false;
            DiagnosticFactory2<KtExpression, String, Collection<ResolvedCall<?>>> it = diagnosticFactory22;
            boolean bl3 = false;
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            String expectedFunction = this.renderCall(delegateOperatorCall, bindingContext);
            trace.report(it.on((KtExpression)((PsiElement)delegateExpression2), expectedFunction, delegateOperatorResults.getResultingCalls()));
        }
        return resolutionErrorFactory != null;
    }

    private final void resolveProvideDelegateMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression byExpression, KotlinType byExpressionType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo) {
        if (!this.isOperatorProvideDelegateSupported()) {
            return;
        }
        if (trace.getBindingContext().get(BindingContext.PROVIDE_DELEGATE_CALL, propertyDescriptor) != null) {
            return;
        }
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(trace, "trace to resolve provideDelegate method");
        Intrinsics.checkNotNullExpressionValue((Object)temporaryBindingTrace, (String)"TemporaryBindingTrace.cr\u2026 provideDelegate method\")");
        TemporaryBindingTrace traceForProvideDelegate = temporaryBindingTrace;
        OverloadResolutionResults<FunctionDescriptor> provideDelegateResults = this.getProvideDelegateMethod(propertyDescriptor, byExpression, byExpressionType, traceForProvideDelegate, initializerScope, dataFlowInfo);
        if (!provideDelegateResults.isSuccess()) {
            Call call2 = (Call)traceForProvideDelegate.getBindingContext().get(BindingContext.PROVIDE_DELEGATE_CALL, propertyDescriptor);
            if (call2 == null) {
                throw (Throwable)((Object)new AssertionError((Object)"'getDelegatedPropertyConventionMethod' didn't record a call"));
            }
            Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"traceForProvideDelegate.\u2026d' didn't record a call\")");
            Call call3 = call2;
            boolean shouldCommitTrace = this.reportDelegateErrorIfCandidateExists(traceForProvideDelegate, call3, provideDelegateResults, byExpression);
            if (shouldCommitTrace) {
                traceForProvideDelegate.commit();
            }
            return;
        }
        traceForProvideDelegate.commit();
        FunctionDescriptor functionDescriptor = provideDelegateResults.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"provideDelegateResults.resultingDescriptor");
        FunctionDescriptor resultingDescriptor = functionDescriptor;
        if (!resultingDescriptor.isOperator()) {
            return;
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = provideDelegateResults.getResultingCall();
        Intrinsics.checkNotNullExpressionValue(resolvedCall2, (String)"provideDelegateResults.resultingCall");
        ResolvedCall<FunctionDescriptor> resultingCall = resolvedCall2;
        trace.record(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor, resultingCall);
    }

    private final OverloadResolutionResults<FunctionDescriptor> getGetSetValueMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression2, KotlinType delegateType, BindingTrace trace, LexicalScope scopeForDelegate, DataFlowInfo dataFlowInfo, boolean isGet, boolean isComplete, ExpressionReceiver knownReceiver, ExpressionTypingContext knownContext) {
        LexicalScope lexicalScope = ScopeUtils.makeScopeForDelegateConventionFunctions(scopeForDelegate, propertyDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"ScopeUtils.makeScopeForD\u2026gate, propertyDescriptor)");
        LexicalScope delegateFunctionsScope = lexicalScope;
        VariableAccessorDescriptor variableAccessorDescriptor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        if (variableAccessorDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Delegated property should have getter/setter " + propertyDescriptor + ' ' + delegateExpression2.getText())));
        }
        VariableAccessorDescriptor accessor = variableAccessorDescriptor;
        KotlinType kotlinType = isComplete && isGet && !(propertyDescriptor.getType() instanceof DeferredType) ? propertyDescriptor.getType() : (KotlinType)TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"if (isComplete && isGet \u2026         NO_EXPECTED_TYPE");
        KotlinType expectedType2 = kotlinType;
        ExpressionTypingContext expressionTypingContext = knownContext;
        if (expressionTypingContext == null) {
            ExpressionTypingContext expressionTypingContext2 = ExpressionTypingContext.newContext(trace, delegateFunctionsScope, dataFlowInfo, expectedType2, this.languageVersionSettings, this.dataFlowValueFactory);
            expressionTypingContext = expressionTypingContext2;
            Intrinsics.checkNotNullExpressionValue((Object)expressionTypingContext2, (String)"ExpressionTypingContext.\u2026alueFactory\n            )");
        }
        ExpressionTypingContext context2 = expressionTypingContext;
        boolean hasThis = propertyDescriptor.getExtensionReceiverParameter() != null || propertyDescriptor.getDispatchReceiverParameter() != null;
        ArrayList arguments2 = Lists.newArrayList();
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)delegateExpression2, false);
        arguments2.add(psiFactory.createExpression(hasThis ? "this" : "null"));
        arguments2.add(this.createExpressionForProperty(psiFactory));
        if (!isGet) {
            KtExpression ktExpression = ExpressionTypingUtils.createFakeExpressionOfType(delegateExpression2.getProject(), trace, "fakeArgument" + arguments2.size(), propertyDescriptor.getType());
            if (ktExpression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReferenceExpression");
            }
            KtReferenceExpression fakeArgument = (KtReferenceExpression)ktExpression;
            arguments2.add(fakeArgument);
            List<ValueParameterDescriptor> list2 = accessor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"accessor.valueParameters");
            List<ValueParameterDescriptor> valueParameters2 = list2;
            trace.record(BindingContext.REFERENCE_TARGET, fakeArgument, valueParameters2.get(0));
        }
        Name functionName = isGet ? OperatorNameConventions.GET_VALUE : OperatorNameConventions.SET_VALUE;
        ExpressionReceiver expressionReceiver = knownReceiver;
        if (expressionReceiver == null) {
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            expressionReceiver = ExpressionReceiver.Companion.create(delegateExpression2, delegateType, bindingContext);
        }
        ExpressionReceiver receiver = expressionReceiver;
        ReceiverValue receiverValue = receiver;
        ResolutionContext resolutionContext = context2;
        ArrayList arrayList = arguments2;
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"arguments");
        Pair resolutionResult = FakeCallResolver.makeAndResolveFakeCallInContext$default(this.fakeCallResolver, receiverValue, resolutionContext, arrayList, functionName, delegateExpression2, null, null, 96, null);
        trace.record(BindingContext.DELEGATED_PROPERTY_CALL, accessor, resolutionResult.getFirst());
        return (OverloadResolutionResults)resolutionResult.getSecond();
    }

    static /* synthetic */ OverloadResolutionResults getGetSetValueMethod$default(DelegatedPropertyResolver delegatedPropertyResolver, VariableDescriptorWithAccessors variableDescriptorWithAccessors, KtExpression ktExpression, KotlinType kotlinType, BindingTrace bindingTrace, LexicalScope lexicalScope, DataFlowInfo dataFlowInfo, boolean bl, boolean bl2, ExpressionReceiver expressionReceiver, ExpressionTypingContext expressionTypingContext, int n, Object object) {
        if ((n & 0x100) != 0) {
            expressionReceiver = null;
        }
        if ((n & 0x200) != 0) {
            expressionTypingContext = null;
        }
        return delegatedPropertyResolver.getGetSetValueMethod(variableDescriptorWithAccessors, ktExpression, kotlinType, bindingTrace, lexicalScope, dataFlowInfo, bl, bl2, expressionReceiver, expressionTypingContext);
    }

    private final ExpressionReceiver createReceiverForGetSetValueMethods(KtExpression delegateExpression2, KotlinType delegateType, BindingTrace trace) {
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        return ExpressionReceiver.Companion.create(delegateExpression2, delegateType, bindingContext);
    }

    private final ExpressionTypingContext createContextForGetSetValueMethods(VariableDescriptorWithAccessors propertyDescriptor, LexicalScope scopeForDelegate, DataFlowInfo dataFlowInfo, BindingTrace trace, InferenceSession inferenceExtension) {
        LexicalScope lexicalScope = ScopeUtils.makeScopeForDelegateConventionFunctions(scopeForDelegate, propertyDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"ScopeUtils.makeScopeForD\u2026gate, propertyDescriptor)");
        LexicalScope delegateFunctionsScope = lexicalScope;
        ExpressionTypingContext expressionTypingContext = ExpressionTypingContext.newContext(trace, delegateFunctionsScope, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory, inferenceExtension);
        Intrinsics.checkNotNullExpressionValue((Object)expressionTypingContext, (String)"ExpressionTypingContext.\u2026erenceExtension\n        )");
        return expressionTypingContext;
    }

    private final ExpressionTypingContext createContextForProvideDelegateMethod(LexicalScope scopeForDelegate, DataFlowInfo dataFlowInfo, BindingTrace trace, InferenceSession inferenceExtension) {
        ExpressionTypingContext expressionTypingContext = ExpressionTypingContext.newContext(trace, scopeForDelegate, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, ContextDependency.INDEPENDENT, StatementFilter.NONE, this.languageVersionSettings, this.dataFlowValueFactory, inferenceExtension);
        Intrinsics.checkNotNullExpressionValue((Object)expressionTypingContext, (String)"ExpressionTypingContext.\u2026erenceExtension\n        )");
        return expressionTypingContext;
    }

    private final OverloadResolutionResults<FunctionDescriptor> getProvideDelegateMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression2, KotlinType delegateExpressionType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo) {
        ExpressionTypingContext expressionTypingContext = ExpressionTypingContext.newContext(trace, initializerScope, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory);
        Intrinsics.checkNotNullExpressionValue((Object)expressionTypingContext, (String)"ExpressionTypingContext.\u2026lowValueFactory\n        )");
        ExpressionTypingContext context2 = expressionTypingContext;
        return this.getProvideDelegateMethod(propertyDescriptor, delegateExpression2, delegateExpressionType, context2);
    }

    /*
     * WARNING - void declaration
     */
    private final OverloadResolutionResults<FunctionDescriptor> getProvideDelegateMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression2, KotlinType delegateExpressionType, ExpressionTypingContext context2) {
        void provideDelegateCall;
        boolean propertyHasReceiver = propertyDescriptor.getDispatchReceiverParameter() != null;
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)delegateExpression2, false);
        boolean bl = false;
        boolean bl2 = false;
        KtPsiFactory $this$run = ktPsiFactory;
        boolean bl3 = false;
        List arguments2 = CollectionsKt.listOf((Object[])new KtExpression[]{$this$run.createExpression(propertyHasReceiver ? "this" : "null"), this.createExpressionForProperty($this$run)});
        Name functionName = OperatorNameConventions.PROVIDE_DELEGATE;
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
        BindingContext bindingContext = bindingTrace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(delegateExpression2, delegateExpressionType, bindingContext);
        Pair pair = FakeCallResolver.makeAndResolveFakeCallInContext$default(this.fakeCallResolver, receiver, context2, arguments2, functionName, delegateExpression2, null, null, 96, null);
        Call call2 = (Call)pair.component1();
        OverloadResolutionResults provideDelegateResults = (OverloadResolutionResults)pair.component2();
        if (provideDelegateResults.isSingleResult()) {
            context2.trace.record(BindingContext.DELEGATE_EXPRESSION_TO_PROVIDE_DELEGATE_CALL, delegateExpression2, provideDelegateCall);
        }
        context2.trace.record(BindingContext.PROVIDE_DELEGATE_CALL, propertyDescriptor, provideDelegateCall);
        return provideDelegateResults;
    }

    private final String renderCall(Call call2, BindingContext context2) {
        KtExpression ktExpression = call2.getCalleeExpression();
        if (ktExpression == null) {
            throw (Throwable)((Object)new AssertionError((Object)"CalleeExpression should exists for fake call of convention method"));
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"call.calleeExpression\n  \u2026ll of convention method\")");
        KtExpression calleeExpression = ktExpression;
        List<? extends ValueArgument> list2 = call2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"call.valueArguments");
        Function1 function1 = (Function1)new Function1<ValueArgument, CharSequence>(context2){
            final /* synthetic */ BindingContext $context;

            @NotNull
            public final CharSequence invoke(ValueArgument argument) {
                KtExpression ktExpression = argument.getArgumentExpression();
                Intrinsics.checkNotNull((Object)ktExpression);
                KotlinType kotlinType = this.$context.getType(ktExpression);
                Intrinsics.checkNotNull((Object)kotlinType);
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"context.getType(argument\u2026ArgumentExpression()!!)!!");
                KotlinType type2 = kotlinType;
                return DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(type2);
            }
            {
                this.$context = bindingContext;
                super(1);
            }
        };
        CharSequence charSequence = null;
        int n = 0;
        CharSequence charSequence2 = ", ";
        CharSequence charSequence3 = ")";
        CharSequence charSequence4 = calleeExpression.getText() + '(';
        return CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)charSequence2, (CharSequence)charSequence4, (CharSequence)charSequence3, (int)n, charSequence, (Function1)function1, (int)24, null);
    }

    @NotNull
    public final KotlinType resolveDelegateExpression(@NotNull KtExpression delegateExpression2, @NotNull KtProperty property2, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull LexicalScope scopeForDelegate, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession) {
        Intrinsics.checkNotNullParameter((Object)delegateExpression2, (String)"delegateExpression");
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)variableDescriptor, (String)"variableDescriptor");
        Intrinsics.checkNotNullParameter((Object)scopeForDelegate, (String)"scopeForDelegate");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)dataFlowInfo, (String)"dataFlowInfo");
        Intrinsics.checkNotNullParameter((Object)inferenceSession, (String)"inferenceSession");
        KotlinType kotlinType = property2.getTypeReference() != null ? variableDescriptor.getType() : (KotlinType)TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"if (property.typeReferen\u2026ype else NO_EXPECTED_TYPE");
        KotlinType propertyExpectedType = kotlinType;
        KotlinType kotlinType2 = this.resolveWithNewInference(delegateExpression2, variableDescriptor, scopeForDelegate, trace, dataFlowInfo, inferenceSession);
        if (kotlinType2 != null) {
            KotlinType kotlinType3 = kotlinType2;
            boolean bl = false;
            boolean bl2 = false;
            KotlinType it = kotlinType3;
            boolean bl3 = false;
            return it;
        }
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(trace, "Trace to resolve delegated property");
        Intrinsics.checkNotNullExpressionValue((Object)temporaryBindingTrace, (String)"TemporaryBindingTrace.cr\u2026olve delegated property\")");
        TemporaryBindingTrace traceToResolveDelegatedProperty = temporaryBindingTrace;
        ConstraintSystemCompleterImpl completer = new ConstraintSystemCompleterImpl(property2, propertyExpectedType, variableDescriptor, delegateExpression2, scopeForDelegate, trace, dataFlowInfo);
        KtExpression ktExpression = CallUtilKt.getCalleeExpressionIfAny(delegateExpression2);
        if (ktExpression != null) {
            KtExpression ktExpression2 = ktExpression;
            boolean bl = false;
            boolean bl4 = false;
            KtExpression it = ktExpression2;
            boolean bl5 = false;
            WritableSlice<KtElement, ConstraintSystemCompleter> writableSlice = BindingContext.CONSTRAINT_SYSTEM_COMPLETER;
            Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"CONSTRAINT_SYSTEM_COMPLETER");
            traceToResolveDelegatedProperty.record(writableSlice, it, completer);
        }
        KotlinType kotlinType4 = this.expressionTypingServices.safeGetType(scopeForDelegate, delegateExpression2, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, inferenceSession, traceToResolveDelegatedProperty);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType4, (String)"expressionTypingServices\u2026legatedProperty\n        )");
        KotlinType delegateType = kotlinType4;
        traceToResolveDelegatedProperty.commit(resolveDelegateExpression.3.INSTANCE, true);
        return delegateType;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType resolveWithNewInference(KtExpression delegateExpression2, VariableDescriptorWithAccessors variableDescriptor, LexicalScope scopeForDelegate, BindingTrace trace, DataFlowInfo dataFlowInfo, InferenceSession inferenceSession) {
        KotlinType delegateTypeForProperType;
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.NewInference)) {
            return null;
        }
        KotlinType kotlinType = trace.getType(delegateExpression2);
        if (kotlinType != null) {
            KotlinType kotlinType2 = kotlinType;
            boolean bl = false;
            boolean bl2 = false;
            KotlinType it = kotlinType2;
            boolean bl3 = false;
            return it;
        }
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(trace, "Trace to resolve delegated property");
        Intrinsics.checkNotNullExpressionValue((Object)temporaryBindingTrace, (String)"TemporaryBindingTrace.cr\u2026olve delegated property\")");
        TemporaryBindingTrace traceToResolveDelegatedProperty = temporaryBindingTrace;
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(scopeForDelegate, delegateExpression2, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, inferenceSession, traceToResolveDelegatedProperty, false, delegateExpression2, ContextDependency.DEPENDENT);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo, (String)"expressionTypingServices\u2026dency.DEPENDENT\n        )");
        KotlinTypeInfo delegateTypeInfo = kotlinTypeInfo;
        KotlinType kotlinType3 = delegateTypeInfo.getType();
        if (kotlinType3 == null) {
            return null;
        }
        KotlinType delegateType = kotlinType3;
        DataFlowInfo delegateDataFlow = delegateTypeInfo.getDataFlowInfo();
        TypeConstructor delegateTypeConstructor = delegateType.getConstructor();
        if (delegateTypeConstructor instanceof IntegerLiteralTypeConstructor) {
            delegateType = ((IntegerLiteralTypeConstructor)delegateTypeConstructor).getApproximatedType();
        }
        KotlinType kotlinType4 = delegateTypeForProperType = this.isProperType(delegateType) ? delegateType : null;
        if (this.languageVersionSettings.supportsFeature(LanguageFeature.OperatorProvideDelegate)) {
            NewTypeSubstitutor newTypeSubstitutor;
            TemporaryBindingTrace temporaryBindingTrace2 = TemporaryBindingTrace.create(traceToResolveDelegatedProperty, "Trace to resolve provide delegate");
            Intrinsics.checkNotNullExpressionValue((Object)temporaryBindingTrace2, (String)"TemporaryBindingTrace.cr\u2026esolve provide delegate\")");
            TemporaryBindingTrace traceForProvideDelegate = temporaryBindingTrace2;
            Map<UnwrappedType, UnwrappedType> substitutionMap = this.buildSubstitutionMapOfNonFixedVariables(delegateType);
            if (substitutionMap != null) {
                Map map2;
                void $this$mapKeysTo$iv$iv;
                Map<UnwrappedType, UnwrappedType> $this$mapKeys$iv = substitutionMap;
                boolean $i$f$mapKeys = false;
                Map<UnwrappedType, UnwrappedType> map3 = $this$mapKeys$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                boolean $i$f$mapKeysTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    void it;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    map2 = destination$iv$iv;
                    boolean bl = false;
                    TypeConstructor typeConstructor2 = ((UnwrappedType)it.getKey()).getConstructor();
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    TypeConstructor typeConstructor3 = typeConstructor2;
                    Map map4 = map2;
                    boolean bl4 = false;
                    entry = it$iv$iv.getValue();
                    map4.put(typeConstructor3, entry);
                }
                Map map5 = map2 = destination$iv$iv;
                newTypeSubstitutor = new NewTypeSubstitutorByConstructorMap(map5);
            } else {
                newTypeSubstitutor = EmptySubstitutor.INSTANCE;
            }
            NewTypeSubstitutor nonFixedVariablesToStubTypesSubstitutor = newTypeSubstitutor;
            UnwrappedType delegateTypeWithoutNonFixedVariables = nonFixedVariablesToStubTypesSubstitutor.safeSubstitute(delegateType.unwrap());
            ExpressionTypingContext contextForProvideDelegate = this.createContextForProvideDelegateMethod(scopeForDelegate, delegateDataFlow, traceForProvideDelegate, new InferenceSessionForExistingCandidates(substitutionMap != null));
            OverloadResolutionResults<FunctionDescriptor> provideDelegateResults = this.getProvideDelegateMethod(variableDescriptor, delegateExpression2, delegateTypeWithoutNonFixedVariables, contextForProvideDelegate);
            if (provideDelegateResults.isSuccess()) {
                FunctionDescriptor functionDescriptor = provideDelegateResults.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"provideDelegateResults.resultingDescriptor");
                FunctionDescriptor provideDelegateDescriptor = functionDescriptor;
                if (provideDelegateDescriptor.isOperator()) {
                    UnwrappedType unwrappedType = this.inverseSubstitution(provideDelegateDescriptor.getReturnType(), substitutionMap);
                    if (unwrappedType == null) {
                        return null;
                    }
                    delegateType = unwrappedType;
                    ResolvedCall<FunctionDescriptor> resolvedCall2 = provideDelegateResults.getResultingCall();
                    Intrinsics.checkNotNullExpressionValue(resolvedCall2, (String)"provideDelegateResults.resultingCall");
                    DataFlowInfoForArguments dataFlowInfoForArguments = resolvedCall2.getDataFlowInfoForArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfoForArguments, (String)"provideDelegateResults.r\u2026.dataFlowInfoForArguments");
                    DataFlowInfo dataFlowInfo2 = dataFlowInfoForArguments.getResultInfo();
                    Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo2, (String)"provideDelegateResults.r\u2026foForArguments.resultInfo");
                    delegateDataFlow = dataFlowInfo2;
                }
                if (substitutionMap == null) {
                    WritableSlice<VariableDescriptorWithAccessors, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL;
                    Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"PROVIDE_DELEGATE_RESOLVED_CALL");
                    traceForProvideDelegate.record(writableSlice, variableDescriptor, provideDelegateResults.getResultingCall());
                    traceForProvideDelegate.commit();
                }
            }
        }
        return this.inferDelegateTypeFromGetSetValueMethods(delegateExpression2, variableDescriptor, scopeForDelegate, traceToResolveDelegatedProperty, delegateType, delegateTypeForProperType, delegateDataFlow);
    }

    /*
     * WARNING - void declaration
     */
    private final UnwrappedType inverseSubstitution(KotlinType type2, Map<UnwrappedType, ? extends UnwrappedType> substitutionMap) {
        if (type2 == null) {
            return null;
        }
        if (substitutionMap == null) {
            return type2.unwrap();
        }
        boolean bl = false;
        HashMap invertedMap = new HashMap();
        Object object = substitutionMap;
        boolean bl2 = false;
        Iterator<Map.Entry<UnwrappedType, ? extends UnwrappedType>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void variable2;
            Map.Entry<UnwrappedType, ? extends UnwrappedType> entry;
            Map.Entry<UnwrappedType, ? extends UnwrappedType> entry2 = entry = iterator2.next();
            boolean bl3 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl3 = false;
            UnwrappedType stubType = entry2.getValue();
            ((Map)invertedMap).put(stubType.getConstructor(), variable2);
        }
        return new NewTypeSubstitutorByConstructorMap(invertedMap).safeSubstitute(type2.unwrap());
    }

    /*
     * WARNING - void declaration
     */
    private final Map<UnwrappedType, UnwrappedType> buildSubstitutionMapOfNonFixedVariables(KotlinType type2) {
        void substitutionMap;
        if (type2.getConstructor() instanceof NewTypeVariableConstructor) {
            return null;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        TypeUtilsKt.contains(type2, (Function1<? super UnwrappedType, Boolean>)((Function1)new Function1<UnwrappedType, Boolean>((Ref.ObjectRef)substitutionMap){
            final /* synthetic */ Ref.ObjectRef $substitutionMap;

            public final boolean invoke(@NotNull UnwrappedType innerType) {
                Intrinsics.checkNotNullParameter((Object)innerType, (String)"innerType");
                TypeConstructor constructor = innerType.getConstructor();
                if (constructor instanceof NewTypeVariableConstructor) {
                    if ((Map)this.$substitutionMap.element == null) {
                        boolean bl = false;
                        this.$substitutionMap.element = new HashMap<K, V>();
                    }
                    Map map2 = (Map)this.$substitutionMap.element;
                    Intrinsics.checkNotNull((Object)map2);
                    Map map3 = map2;
                    boolean bl = false;
                    Map map4 = map3;
                    boolean bl2 = false;
                    if (!map4.containsKey(innerType)) {
                        Map map5 = (Map)this.$substitutionMap.element;
                        Intrinsics.checkNotNull((Object)map5);
                        map5.put(innerType, new StubTypeForProvideDelegateReceiver(constructor, innerType.isMarkedNullable(), null, null, 12, null));
                    }
                }
                return false;
            }
            {
                this.$substitutionMap = objectRef;
                super(1);
            }
        }));
        return (Map)substitutionMap.element;
    }

    /*
     * WARNING - void declaration
     */
    private final UnwrappedType inferDelegateTypeFromGetSetValueMethods(KtExpression delegateExpression2, VariableDescriptorWithAccessors variableDescriptor, LexicalScope scopeForDelegate, TemporaryBindingTrace trace, KotlinType delegateType, KotlinType delegateTypeForProperType, DataFlowInfo delegateDataFlow) {
        UnwrappedType expectedType2 = !(variableDescriptor.getType() instanceof DeferredType) ? variableDescriptor.getType().unwrap() : null;
        DelegatedPropertyInferenceSession inferenceSession = new DelegatedPropertyInferenceSession(variableDescriptor, expectedType2, this.psiCallResolver, this.postponedArgumentsAnalyzer, this.kotlinConstraintSystemCompleter, this.callComponents, this.builtIns);
        ExpressionReceiver receiver = this.createReceiverForGetSetValueMethods(delegateExpression2, delegateType, trace);
        ExpressionTypingContext context2 = this.createContextForGetSetValueMethods(variableDescriptor, scopeForDelegate, delegateDataFlow, trace, inferenceSession);
        Function2<OverloadResolutionResults<FunctionDescriptor>, Boolean, Unit> $fun$recordResolvedDelegateOrReportError$1 = new Function2<OverloadResolutionResults<FunctionDescriptor>, Boolean, Unit>(this, variableDescriptor, delegateExpression2, trace, delegateType){
            final /* synthetic */ DelegatedPropertyResolver this$0;
            final /* synthetic */ VariableDescriptorWithAccessors $variableDescriptor;
            final /* synthetic */ KtExpression $delegateExpression;
            final /* synthetic */ TemporaryBindingTrace $trace;
            final /* synthetic */ KotlinType $delegateType;

            public final void invoke(@NotNull OverloadResolutionResults<FunctionDescriptor> result2, boolean isGet) {
                VariableAccessorDescriptor variableAccessorDescriptor;
                Intrinsics.checkNotNullParameter(result2, (String)"result");
                boolean bl = isGet;
                if (bl) {
                    variableAccessorDescriptor = this.$variableDescriptor.getGetter();
                } else if (!bl) {
                    variableAccessorDescriptor = this.$variableDescriptor.getSetter();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                VariableAccessorDescriptor accessor = variableAccessorDescriptor;
                bl = false;
                boolean bl2 = false;
                if (accessor == null) {
                    boolean bl3 = false;
                    String string2 = "Delegated property should have getter/setter " + this.$variableDescriptor + ' ' + this.$delegateExpression.getText();
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                if (result2.isSuccess()) {
                    DelegatedPropertyResolver.access$recordDelegateOperatorResults(this.this$0, result2, this.$variableDescriptor, accessor, this.$trace);
                } else {
                    DelegatedPropertyResolver.access$reportGetSetValueResolutionError(this.this$0, result2, accessor, this.$delegateExpression, this.$delegateType, this.$trace, isGet);
                }
            }
            {
                this.this$0 = delegatedPropertyResolver;
                this.$variableDescriptor = variableDescriptorWithAccessors;
                this.$delegateExpression = ktExpression;
                this.$trace = temporaryBindingTrace;
                this.$delegateType = kotlinType;
                super(2);
            }
        };
        this.getGetSetValueMethod(variableDescriptor, delegateExpression2, delegateType, trace, scopeForDelegate, delegateDataFlow, true, true, receiver, context2);
        if (variableDescriptor.isVar() && !(variableDescriptor.getReturnType() instanceof DeferredType)) {
            this.getGetSetValueMethod(variableDescriptor, delegateExpression2, delegateType, trace, scopeForDelegate, delegateDataFlow, false, true, receiver, context2);
        }
        KotlinResolutionCallbacksImpl resolutionCallbacks = this.psiCallResolver.createResolutionCallbacks(trace, inferenceSession, null);
        List resolutionResults = inferenceSession.resolveCandidates(resolutionCallbacks);
        for (Pair pair : CollectionsKt.listOf((Object[])new Pair[]{TuplesKt.to((Object)OperatorNameConventions.GET_VALUE, (Object)true), TuplesKt.to((Object)OperatorNameConventions.SET_VALUE, (Object)false)})) {
            ResolutionResultCallInfo resolutionResultCallInfo;
            Object v1;
            boolean isGet;
            block4: {
                Name name = (Name)pair.component1();
                isGet = (Boolean)pair.component2();
                Iterable $this$firstOrNull$iv = resolutionResults;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    void name2;
                    ResolutionResultCallInfo it = (ResolutionResultCallInfo)element$iv;
                    boolean bl = false;
                    Object object = ResolutionAtomsKt.resultCallAtom(it.getResolutionResult());
                    if (!Intrinsics.areEqual((Object)(object != null && (object = ((ResolvedCallAtom)object).getAtom()) != null ? object.getName() : null), (Object)name2)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            ResolutionResultCallInfo result2 = v1;
            if (result2 == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            ResolutionResultCallInfo it = resolutionResultCallInfo;
            boolean bl3 = false;
            $fun$recordResolvedDelegateOrReportError$1.invoke(it.getOverloadResolutionResults(), isGet);
        }
        KotlinType resolvedDelegateType = this.extractResolvedDelegateType(delegateExpression2, trace, delegateType);
        KotlinType kotlinType = delegateTypeForProperType;
        if (kotlinType == null) {
            kotlinType = resolvedDelegateType;
        }
        trace.recordType(delegateExpression2, kotlinType);
        trace.commit();
        return resolvedDelegateType.unwrap();
    }

    private final KotlinType extractResolvedDelegateType(KtExpression delegateExpression2, BindingTrace trace, KotlinType delegateType) {
        KotlinType kotlinType;
        KotlinType kotlinType2;
        block5: {
            KotlinType it;
            boolean bl;
            boolean bl2;
            KotlinType kotlinType3;
            block4: {
                KtElement ktElement = delegateExpression2;
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                Call call2 = CallUtilKt.getCall(ktElement, bindingContext);
                BindingContext bindingContext2 = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"trace.bindingContext");
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(call2, bindingContext2);
                KotlinType pretendReturnType = resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null ? resolvedCall2.getReturnType() : null;
                kotlinType2 = pretendReturnType;
                if (kotlinType2 == null) break block4;
                kotlinType3 = kotlinType2;
                bl2 = false;
                bl = false;
                it = kotlinType3;
                boolean bl3 = false;
                kotlinType2 = this.isProperType(it) ? kotlinType3 : null;
                if (kotlinType2 != null) break block5;
            }
            kotlinType3 = delegateType;
            bl2 = false;
            bl = false;
            it = kotlinType3;
            boolean bl4 = false;
            kotlinType2 = kotlinType = this.isProperType(it) ? kotlinType3 : null;
        }
        if (kotlinType2 == null) {
            SimpleType simpleType2 = ErrorUtils.createErrorType("Type for " + delegateExpression2.getText());
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"ErrorUtils.createErrorTy\u2026elegateExpression.text}\")");
            kotlinType = simpleType2;
        }
        return kotlinType;
    }

    private final boolean isProperType(KotlinType $this$isProperType) {
        return !TypeUtilsKt.contains($this$isProperType, (Function1<? super UnwrappedType, Boolean>)((Function1)isProperType.1.INSTANCE));
    }

    private final boolean conventionMethodFound(OverloadResolutionResults<FunctionDescriptor> results) {
        return results.isSuccess() || results.isSingleResult() && results.getResultCode() == OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH;
    }

    public DelegatedPropertyResolver(@NotNull KotlinBuiltIns builtIns, @NotNull FakeCallResolver fakeCallResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull PSICallResolver psiCallResolver, @NotNull PostponedArgumentsAnalyzer postponedArgumentsAnalyzer, @NotNull KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter, @NotNull KotlinCallComponents callComponents) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)fakeCallResolver, (String)"fakeCallResolver");
        Intrinsics.checkNotNullParameter((Object)expressionTypingServices, (String)"expressionTypingServices");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        Intrinsics.checkNotNullParameter((Object)psiCallResolver, (String)"psiCallResolver");
        Intrinsics.checkNotNullParameter((Object)postponedArgumentsAnalyzer, (String)"postponedArgumentsAnalyzer");
        Intrinsics.checkNotNullParameter((Object)kotlinConstraintSystemCompleter, (String)"kotlinConstraintSystemCompleter");
        Intrinsics.checkNotNullParameter((Object)callComponents, (String)"callComponents");
        this.builtIns = builtIns;
        this.fakeCallResolver = fakeCallResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.psiCallResolver = psiCallResolver;
        this.postponedArgumentsAnalyzer = postponedArgumentsAnalyzer;
        this.kotlinConstraintSystemCompleter = kotlinConstraintSystemCompleter;
        this.callComponents = callComponents;
    }

    public static final /* synthetic */ void access$recordDelegateOperatorResults(DelegatedPropertyResolver $this, OverloadResolutionResults result2, VariableDescriptorWithAccessors propertyDescriptor, VariableAccessorDescriptor accessor, BindingTrace trace) {
        $this.recordDelegateOperatorResults(result2, propertyDescriptor, accessor, trace);
    }

    public static final /* synthetic */ void access$reportGetSetValueResolutionError(DelegatedPropertyResolver $this, OverloadResolutionResults result2, VariableAccessorDescriptor accessor, KtExpression delegateExpression2, KotlinType delegateType, BindingTrace trace, boolean isGet) {
        $this.reportGetSetValueResolutionError(result2, accessor, delegateExpression2, delegateType, trace, isGet);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J*\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020&H\u0002J\u001c\u0010'\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)H\u0016J(\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010,\u001a\u00020-H\u0002R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver$ConstraintSystemCompleterImpl;", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemCompleter;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "delegateExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "scopeForDelegate", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "(Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;)V", "getDataFlowInfo", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getDelegateExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getExpectedType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getProperty", "()Lorg/jetbrains/kotlin/psi/KtProperty;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getVariableDescriptor", "()Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "addConstraintForThisValue", "", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;", "typeVariableSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "resultingDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "dispatchReceiverOnly", "", "completeConstraintSystem", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getDelegateType", "byExpressionType", "traceToResolveConventionMethods", "Lorg/jetbrains/kotlin/resolve/TemporaryBindingTrace;", "frontend"})
    public final class ConstraintSystemCompleterImpl
    implements ConstraintSystemCompleter {
        @NotNull
        private final KtProperty property;
        @NotNull
        private final KotlinType expectedType;
        @NotNull
        private final VariableDescriptorWithAccessors variableDescriptor;
        @NotNull
        private final KtExpression delegateExpression;
        private final LexicalScope scopeForDelegate;
        @NotNull
        private final BindingTrace trace;
        @NotNull
        private final DataFlowInfo dataFlowInfo;

        @Override
        public void completeConstraintSystem(@NotNull ConstraintSystem.Builder constraintSystem, @NotNull ResolvedCall<?> resolvedCall2) {
            Intrinsics.checkNotNullParameter((Object)constraintSystem, (String)"constraintSystem");
            Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
            Object obj = resolvedCall2.getCandidateDescriptor();
            Intrinsics.checkNotNullExpressionValue(obj, (String)"resolvedCall.candidateDescriptor");
            KotlinType kotlinType = obj.getReturnType();
            if (kotlinType == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"resolvedCall.candidateDe\u2026ptor.returnType ?: return");
            KotlinType returnType2 = kotlinType;
            Map<CallHandle, TypeSubstitutor> map2 = constraintSystem.getTypeVariableSubstitutors();
            Call call2 = resolvedCall2.getCall();
            Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"resolvedCall.call");
            TypeSubstitutor typeSubstitutor2 = map2.get(TypeVariableKt.toHandle(call2));
            if (typeSubstitutor2 == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No substitutor in the system for call: " + resolvedCall2.getCall())));
            }
            TypeSubstitutor typeVariableSubstitutor = typeSubstitutor2;
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(this.trace, "Trace to resolve delegated property convention methods");
            Intrinsics.checkNotNullExpressionValue((Object)temporaryBindingTrace, (String)"TemporaryBindingTrace.cr\u2026erty convention methods\")");
            TemporaryBindingTrace traceToResolveConventionMethods = temporaryBindingTrace;
            KotlinType delegateType = this.getDelegateType(returnType2, constraintSystem, typeVariableSubstitutor, traceToResolveConventionMethods);
            OverloadResolutionResults getValueResults = DelegatedPropertyResolver.getGetSetValueMethod$default(DelegatedPropertyResolver.this, this.variableDescriptor, this.delegateExpression, delegateType, traceToResolveConventionMethods, this.scopeForDelegate, this.dataFlowInfo, true, false, null, null, 768, null);
            if (DelegatedPropertyResolver.this.conventionMethodFound(getValueResults)) {
                KotlinType returnTypeInSystem;
                Object d = getValueResults.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue(d, (String)"getValueResults.resultingDescriptor");
                FunctionDescriptor getValueDescriptor = (FunctionDescriptor)d;
                KotlinType getValueReturnType = getValueDescriptor.getReturnType();
                if (getValueReturnType != null && !TypeUtils.noExpectedType(this.expectedType) && (returnTypeInSystem = typeVariableSubstitutor.substitute(getValueReturnType, Variance.INVARIANT)) != null) {
                    constraintSystem.addSubtypeConstraint(returnTypeInSystem, this.expectedType, ConstraintPositionKind.FROM_COMPLETER.position());
                }
                ConstraintSystemCompleterImpl.addConstraintForThisValue$default(this, constraintSystem, typeVariableSubstitutor, getValueDescriptor, false, 8, null);
            }
            if (!this.variableDescriptor.isVar()) {
                return;
            }
            if (this.variableDescriptor.getReturnType() instanceof DeferredType) {
                return;
            }
            OverloadResolutionResults setValueResults = DelegatedPropertyResolver.getGetSetValueMethod$default(DelegatedPropertyResolver.this, this.variableDescriptor, this.delegateExpression, delegateType, traceToResolveConventionMethods, this.scopeForDelegate, this.dataFlowInfo, false, false, null, null, 768, null);
            if (DelegatedPropertyResolver.this.conventionMethodFound(setValueResults)) {
                Object d = setValueResults.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue(d, (String)"setValueResults.resultingDescriptor");
                FunctionDescriptor setValueDescriptor = (FunctionDescriptor)d;
                List<ValueParameterDescriptor> list2 = setValueDescriptor.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"setValueDescriptor.valueParameters");
                List<ValueParameterDescriptor> setValueParameters = list2;
                if (setValueParameters.size() == 3) {
                    if (!TypeUtils.noExpectedType(this.expectedType)) {
                        ValueParameterDescriptor valueParameterDescriptor = setValueParameters.get(2);
                        Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"setValueParameters[2]");
                        KotlinType kotlinType2 = valueParameterDescriptor.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"setValueParameters[2].type");
                        KotlinType thisParameterType = kotlinType2;
                        KotlinType substitutedThisParameterType = typeVariableSubstitutor.substitute(thisParameterType, Variance.INVARIANT);
                        constraintSystem.addSubtypeConstraint(this.expectedType, substitutedThisParameterType, ConstraintPositionKind.FROM_COMPLETER.position());
                    }
                    ConstraintSystemCompleterImpl.addConstraintForThisValue$default(this, constraintSystem, typeVariableSubstitutor, setValueDescriptor, false, 8, null);
                }
            }
        }

        private final KotlinType getDelegateType(KotlinType byExpressionType, ConstraintSystem.Builder constraintSystem, TypeSubstitutor typeVariableSubstitutor, TemporaryBindingTrace traceToResolveConventionMethods) {
            OverloadResolutionResults provideDelegateResults;
            if (DelegatedPropertyResolver.this.isOperatorProvideDelegateSupported() && DelegatedPropertyResolver.this.conventionMethodFound(provideDelegateResults = DelegatedPropertyResolver.this.getProvideDelegateMethod(this.variableDescriptor, this.delegateExpression, byExpressionType, traceToResolveConventionMethods, this.scopeForDelegate, this.dataFlowInfo))) {
                Object d = provideDelegateResults.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue(d, (String)"provideDelegateResults.resultingDescriptor");
                FunctionDescriptor provideDelegateDescriptor = (FunctionDescriptor)d;
                KotlinType provideDelegateReturnType = provideDelegateDescriptor.getReturnType();
                if (provideDelegateDescriptor.isOperator()) {
                    this.addConstraintForThisValue(constraintSystem, typeVariableSubstitutor, provideDelegateDescriptor, true);
                    KotlinType kotlinType = provideDelegateReturnType;
                    if (kotlinType == null) {
                        throw (Throwable)((Object)new AssertionError((Object)("No return type fore 'provideDelegate' of " + this.delegateExpression.getText())));
                    }
                    return kotlinType;
                }
            }
            return byExpressionType;
        }

        private final void addConstraintForThisValue(ConstraintSystem.Builder constraintSystem, TypeSubstitutor typeVariableSubstitutor, FunctionDescriptor resultingDescriptor, boolean dispatchReceiverOnly) {
            ValueParameterDescriptor valueParameterForThis;
            Annotated annotated;
            Annotated annotated2;
            ReceiverParameterDescriptor extensionReceiver = this.variableDescriptor.getExtensionReceiverParameter();
            ReceiverParameterDescriptor dispatchReceiver = this.variableDescriptor.getDispatchReceiverParameter();
            if (dispatchReceiverOnly) {
                ReceiverParameterDescriptor receiverParameterDescriptor = dispatchReceiver;
                annotated2 = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
            } else {
                annotated2 = extensionReceiver;
                if (annotated2 == null || (annotated2 = annotated2.getType()) == null) {
                    ReceiverParameterDescriptor receiverParameterDescriptor = dispatchReceiver;
                    annotated2 = annotated = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
                }
            }
            if (annotated2 == null) {
                annotated = DelegatedPropertyResolver.this.builtIns.getNullableNothingType();
            }
            Intrinsics.checkNotNullExpressionValue((Object)annotated, (String)"if (dispatchReceiverOnly\u2026ltIns.nullableNothingType");
            Annotated typeOfThis = annotated;
            List<ValueParameterDescriptor> list2 = resultingDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"resultingDescriptor.valueParameters");
            List<ValueParameterDescriptor> valueParameters2 = list2;
            if (valueParameters2.isEmpty()) {
                return;
            }
            ValueParameterDescriptor valueParameterDescriptor = valueParameterForThis = valueParameters2.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"valueParameterForThis");
            constraintSystem.addSubtypeConstraint((KotlinType)typeOfThis, typeVariableSubstitutor.substitute(valueParameterDescriptor.getType(), Variance.INVARIANT), ConstraintPositionKind.FROM_COMPLETER.position());
        }

        static /* synthetic */ void addConstraintForThisValue$default(ConstraintSystemCompleterImpl constraintSystemCompleterImpl, ConstraintSystem.Builder builder, TypeSubstitutor typeSubstitutor2, FunctionDescriptor functionDescriptor, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            constraintSystemCompleterImpl.addConstraintForThisValue(builder, typeSubstitutor2, functionDescriptor, bl);
        }

        @NotNull
        public final KtProperty getProperty() {
            return this.property;
        }

        @NotNull
        public final KotlinType getExpectedType() {
            return this.expectedType;
        }

        @NotNull
        public final VariableDescriptorWithAccessors getVariableDescriptor() {
            return this.variableDescriptor;
        }

        @NotNull
        public final KtExpression getDelegateExpression() {
            return this.delegateExpression;
        }

        @NotNull
        public final BindingTrace getTrace() {
            return this.trace;
        }

        @NotNull
        public final DataFlowInfo getDataFlowInfo() {
            return this.dataFlowInfo;
        }

        public ConstraintSystemCompleterImpl(@NotNull KtProperty property2, @NotNull KotlinType expectedType2, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KtExpression delegateExpression2, @NotNull LexicalScope scopeForDelegate, @NotNull BindingTrace trace, DataFlowInfo dataFlowInfo) {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            Intrinsics.checkNotNullParameter((Object)expectedType2, (String)"expectedType");
            Intrinsics.checkNotNullParameter((Object)variableDescriptor, (String)"variableDescriptor");
            Intrinsics.checkNotNullParameter((Object)delegateExpression2, (String)"delegateExpression");
            Intrinsics.checkNotNullParameter((Object)scopeForDelegate, (String)"scopeForDelegate");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)dataFlowInfo, (String)"dataFlowInfo");
            this.property = property2;
            this.expectedType = expectedType2;
            this.variableDescriptor = variableDescriptor;
            this.delegateExpression = delegateExpression2;
            this.scopeForDelegate = scopeForDelegate;
            this.trace = trace;
            this.dataFlowInfo = dataFlowInfo;
        }
    }
}

