/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsInheritanceChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "findFakeMethodOverridingExternalWithOptionalParams", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "cls", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isOverridingExternalWithOptionalParams", "", "function", "js.frontend"})
public final class JsInheritanceChecker
implements DeclarationChecker {
    public static final JsInheritanceChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        FunctionDescriptor fakeOverriddenMethod;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (descriptor2 instanceof FunctionDescriptor && !DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2) && this.isOverridingExternalWithOptionalParams((FunctionDescriptor)descriptor2)) {
            context2.getTrace().report(ErrorsJs.OVERRIDING_EXTERNAL_FUN_WITH_OPTIONAL_PARAMS.on((KtElement)((PsiElement)declaration)));
        } else if (descriptor2 instanceof ClassDescriptor && !DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2) && (fakeOverriddenMethod = this.findFakeMethodOverridingExternalWithOptionalParams((ClassDescriptor)descriptor2)) != null) {
            context2.getTrace().report(ErrorsJs.OVERRIDING_EXTERNAL_FUN_WITH_OPTIONAL_PARAMS_WITH_FAKE.on((KtElement)((PsiElement)declaration), fakeOverriddenMethod));
        }
        if (descriptor2 instanceof ClassDescriptor) {
            boolean bl;
            block8: {
                SimpleType simpleType2 = ((ClassDescriptor)descriptor2).getDefaultType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"descriptor.defaultType");
                Iterable $this$any$iv = TypeUtilsKt.immediateSupertypes(simpleType2);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        boolean bl2 = false;
                        if (!FunctionTypesKt.isBuiltinFunctionalTypeOrSubtype(it)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                context2.getTrace().report(ErrorsJs.IMPLEMENTING_FUNCTION_INTERFACE.on((KtClassOrObject)((PsiElement)((KtClassOrObject)declaration))));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isOverridingExternalWithOptionalParams(FunctionDescriptor function2) {
        void $this$filterTo$iv$iv;
        CallableMemberDescriptor.Kind kind = function2.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)kind), (String)"function.kind");
        if (!kind.isReal() && function2.getModality() == Modality.ABSTRACT) {
            return false;
        }
        Collection<? extends FunctionDescriptor> collection = function2.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"function.overriddenDescriptors");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FunctionDescriptor it = (FunctionDescriptor)element$iv$iv;
            boolean bl = false;
            FunctionDescriptor functionDescriptor = it;
            Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"it");
            if (!DescriptorUtilsKt.isEffectivelyExternal(functionDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator2 = ((List)destination$iv$iv).iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            block6: {
                FunctionDescriptor overriddenFunction;
                FunctionDescriptor functionDescriptor = overriddenFunction = (FunctionDescriptor)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"overriddenFunction");
                List<ValueParameterDescriptor> list2 = functionDescriptor.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"overriddenFunction.valueParameters");
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                        boolean bl2 = false;
                        ValueParameterDescriptor valueParameterDescriptor = it;
                        Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"it");
                        if (!ArgumentsUtilsKt.hasDefaultValue(valueParameterDescriptor)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private final FunctionDescriptor findFakeMethodOverridingExternalWithOptionalParams(ClassDescriptor cls) {
        block6: {
            $this$mapNotNull$iv = ResolutionScope.DefaultImpls.getContributedDescriptors$default(cls.getUnsubstitutedMemberScope(), DescriptorKindFilter.CALLABLES, null, 2, null);
            $i$f$mapNotNull = false;
            var5_4 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var10_12 = $this$forEach$iv$iv$iv.iterator();
            while (var10_12.hasNext()) {
                element$iv$iv = element$iv$iv$iv = var10_12.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                it = (DeclarationDescriptor)element$iv$iv;
                $i$a$-mapNotNull-JsInheritanceChecker$findFakeMethodOverridingExternalWithOptionalParams$members$1 = false;
                v0 = it;
                if (!(v0 instanceof FunctionDescriptor)) {
                    v0 = null;
                }
                if ((FunctionDescriptor)v0 == null) continue;
                var17_20 = false;
                var18_21 = false;
                it$iv$iv = var16_19;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (FunctionDescriptor)element$iv$iv;
                $i$a$-filter-JsInheritanceChecker$findFakeMethodOverridingExternalWithOptionalParams$members$2 = false;
                if (!Intrinsics.areEqual((Object)it.getContainingDeclaration(), (Object)cls)) ** GOTO lbl-1000
                v1 = it.getKind();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it.kind");
                if (!v1.isReal() && it.getOverriddenDescriptors().size() > 1) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            members = (List)destination$iv$iv;
            $this$firstOrNull$iv = members;
            $i$f$firstOrNull = false;
            for (E element$iv : $this$firstOrNull$iv) {
                it = (FunctionDescriptor)element$iv;
                $i$a$-firstOrNull-JsInheritanceChecker$findFakeMethodOverridingExternalWithOptionalParams$1 = false;
                if (!JsInheritanceChecker.INSTANCE.isOverridingExternalWithOptionalParams(it)) continue;
                v3 = element$iv;
                break block6;
            }
            v3 = null;
        }
        return v3;
    }

    private JsInheritanceChecker() {
    }

    static {
        JsInheritanceChecker jsInheritanceChecker;
        INSTANCE = jsInheritanceChecker = new JsInheritanceChecker();
    }
}

