/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.wasm.resolve.diagnostics.ErrorsWasm;
import org.jetbrains.kotlin.wasm.resolve.diagnostics.WasmImportAnnotationChecker;
import org.jetbrains.kotlin.wasm.util.JsCodeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/wasm/resolve/diagnostics/WasmExportAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "jsExportFqName", "Lorg/jetbrains/kotlin/name/FqName;", "wasmExportFqName", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "wasm.frontend"})
public final class WasmExportAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final WasmExportAnnotationChecker INSTANCE = new WasmExportAnnotationChecker();
    @NotNull
    private static final FqName wasmExportFqName = new FqName("kotlin.wasm.WasmExport");
    @NotNull
    private static final FqName jsExportFqName = new FqName("kotlin.js.JsExport");

    private WasmExportAnnotationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        PsiElement reportOn;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return;
        }
        if (!descriptor2.getAnnotations().hasAnnotation(wasmExportFqName)) {
            return;
        }
        BindingTrace trace = context.getTrace();
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        if (descriptor2.getAnnotations().hasAnnotation(jsExportFqName)) {
            PsiElement psiElement = SourceLocationUtilsKt.findPsi(descriptor2);
            if (psiElement == null) {
                psiElement = (PsiElement)declaration;
            }
            reportOn = psiElement;
            trace.report(ErrorsWasm.JS_AND_WASM_EXPORTS_ON_SAME_DECLARATION.on(reportOn));
        }
        if (DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2) || JsCodeUtilsKt.hasValidJsCodeBody((FunctionDescriptor)descriptor2, bindingContext2)) {
            PsiElement psiElement = SourceLocationUtilsKt.findPsi(descriptor2);
            if (psiElement == null) {
                psiElement = (PsiElement)declaration;
            }
            reportOn = psiElement;
            trace.report(ErrorsWasm.WASM_EXPORT_ON_EXTERNAL_DECLARATION.on(reportOn));
        }
        if (!DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            PsiElement psiElement = SourceLocationUtilsKt.findPsi(descriptor2);
            if (psiElement == null) {
                psiElement = (PsiElement)declaration;
            }
            reportOn = psiElement;
            trace.report(ErrorsWasm.NESTED_WASM_EXPORT.on(reportOn));
        }
        WasmImportAnnotationChecker.INSTANCE.checkSignatureIsPrimitive((FunctionDescriptor)descriptor2, trace, declaration);
    }
}

