/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsStaticContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrScriptSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0013\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\u0010\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\t2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\f\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\f\u001a\u0012\u0010\r\u001a\u00020\u000b*\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\f\u00a8\u0006\u000f"}, d2={"erase", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "asString", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "getClassRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "getConstructorRef", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nIrTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTypeUtils.kt\norg/jetbrains/kotlin/ir/backend/js/utils/IrTypeUtilsKt\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 IrUtils.kt\norg/jetbrains/kotlin/ir/util/IrUtilsKt\n*L\n1#1,87:1\n180#2:88\n221#2:90\n221#2:91\n1458#3:89\n*S KotlinDebug\n*F\n+ 1 IrTypeUtils.kt\norg/jetbrains/kotlin/ir/backend/js/utils/IrTypeUtilsKt\n*L\n39#1:88\n79#1:90\n86#1:91\n53#1:89\n*E\n"})
public final class IrTypeUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String asString(@NotNull IrType $this$asString, @NotNull JsIrBackendContext context) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrType irType = $this$asString;
        if (irType instanceof IrErrorType) {
            string2 = "$ErrorType$";
        } else if (irType instanceof IrDynamicType) {
            string2 = "dynamic";
        } else if (irType instanceof IrSimpleType) {
            String string3;
            String string4;
            String string5;
            StringBuilder stringBuilder2 = new StringBuilder().append(IrTypeUtilsKt.asString(((IrSimpleType)$this$asString).getClassifier(), context));
            switch (WhenMappings.$EnumSwitchMapping$0[((IrSimpleType)$this$asString).getNullability().ordinal()]) {
                case 1: {
                    string5 = "?";
                    break;
                }
                case 2: {
                    string5 = "";
                    break;
                }
                case 3: {
                    if (((IrSimpleType)$this$asString).getClassifier() instanceof IrTypeParameterSymbol) {
                        string5 = " & Any";
                        break;
                    }
                    string5 = "";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            StringBuilder stringBuilder3 = stringBuilder2.append(string5);
            Collection $this$ifNotEmpty$iv = ((IrSimpleType)$this$asString).getArguments();
            boolean $i$f$ifNotEmpty = false;
            if (!$this$ifNotEmpty$iv.isEmpty()) {
                void $this$asString_u24lambda_u240;
                List list2 = (List)$this$ifNotEmpty$iv;
                StringBuilder stringBuilder4 = stringBuilder3;
                boolean bl = false;
                string4 = CollectionsKt.joinToString$default((Iterable)((Iterable)$this$asString_u24lambda_u240), (CharSequence)",", (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)((Function1)new Function1<IrTypeArgument, CharSequence>(context){
                    final /* synthetic */ JsIrBackendContext $context;
                    {
                        this.$context = $context;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull IrTypeArgument it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return IrTypeUtilsKt.access$asString(it, this.$context);
                    }
                }), (int)24, null);
                stringBuilder3 = stringBuilder4;
            } else {
                string4 = string3 = null;
            }
            if (string4 == null) {
                string3 = "";
            }
            string2 = stringBuilder3.append(string3).toString();
        } else {
            throw new IllegalStateException(("Unexpected kind of IrType: " + $this$asString.getClass().getTypeName()).toString());
        }
        return string2;
    }

    private static final String asString(IrTypeArgument $this$asString, JsIrBackendContext context) {
        String string2;
        IrTypeArgument irTypeArgument = $this$asString;
        if (irTypeArgument instanceof IrStarProjection) {
            string2 = "*";
        } else if (irTypeArgument instanceof IrTypeProjection) {
            string2 = ((IrTypeProjection)$this$asString).getVariance().getLabel() + (((IrTypeProjection)$this$asString).getVariance() != Variance.INVARIANT ? " " : "") + IrTypeUtilsKt.asString(((IrTypeProjection)$this$asString).getType(), context);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    private static final String asString(IrClassifierSymbol $this$asString, JsIrBackendContext context) {
        String string2;
        IrClassifierSymbol irClassifierSymbol = $this$asString;
        if (irClassifierSymbol instanceof IrTypeParameterSymbol) {
            String string3 = ((IrTypeParameter)((IrTypeParameterSymbol)$this$asString).getOwner()).getName().asString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        } else {
            if (irClassifierSymbol instanceof IrScriptSymbol) {
                IrSymbol $this$unexpectedSymbolKind$iv = (IrSymbol)$this$asString;
                boolean $i$f$unexpectedSymbolKind = false;
                throw new IllegalArgumentException("Unexpected kind of " + IrClassifierSymbol.class.getTypeName() + ": " + $this$unexpectedSymbolKind$iv);
            }
            if (irClassifierSymbol instanceof IrClassSymbol) {
                String string4 = context.getClassToItsId().get(((IrClassSymbol)$this$asString).getOwner());
                if (string4 == null && (string4 = context.getLocalClassNames().get(((IrClassSymbol)$this$asString).getOwner())) == null) {
                    FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)((IrClassSymbol)$this$asString).getOwner()));
                    Intrinsics.checkNotNull((Object)fqName2);
                    string4 = fqName2.asString();
                }
                String string5 = string4;
                Intrinsics.checkNotNull((Object)string5);
                string2 = string5;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    @Nullable
    public static final IrClass erase(@NotNull IrType type2) {
        IrClass irClass;
        block4: {
            IrClassifierSymbol classifier;
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            while (true) {
                if ((classifier = IrTypesKt.getClassifierOrFail((IrType)type2)) instanceof IrClassSymbol) {
                    irClass = (IrClass)((IrClassSymbol)classifier).getOwner();
                    break block4;
                }
                if (!(classifier instanceof IrTypeParameterSymbol)) break;
                type2 = (IrType)CollectionsKt.first((List)((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getSuperTypes());
            }
            if (classifier instanceof IrScriptSymbol) {
                irClass = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return irClass;
    }

    @NotNull
    public static final JsExpression getClassRef(@NotNull IrType $this$getClassRef, @NotNull JsStaticContext context) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)$this$getClassRef, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrSymbolOwner klass = IrTypesKt.getClassifierOrFail((IrType)$this$getClassRef).getOwner();
        if (klass instanceof IrClass) {
            jsExpression = IrTypeUtilsKt.getClassRef((IrClass)klass, context);
        } else {
            Intrinsics.checkNotNull((Object)klass, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
            JsNameRef jsNameRef = context.getNameForStaticDeclaration((IrDeclarationWithName)klass).makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"makeRef(...)");
            jsExpression = jsNameRef;
        }
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsExpression getClassRef(@NotNull IrClass $this$getClassRef, @NotNull JsStaticContext context) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)$this$getClassRef, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)((IrPossiblyExternalDeclaration)$this$getClassRef))) {
            jsExpression = context.getRefForExternalClass($this$getClassRef);
        } else {
            JsExpression jsExpression2;
            JsNameRef jsNameRef = context.getNameForClass($this$getClassRef).makeRef();
            boolean condition$iv = context.isPerFile();
            boolean $i$f$butIf = false;
            if (condition$iv) {
                void $this$butIf$iv;
                void it = $this$butIf$iv;
                boolean bl = false;
                jsExpression2 = new JsInvocation((JsExpression)it, new JsExpression[0]);
            } else {
                jsExpression2 = jsNameRef;
            }
            jsExpression = jsExpression2;
        }
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsExpression getConstructorRef(@NotNull IrConstructor $this$getConstructorRef, @NotNull JsStaticContext context) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)$this$getConstructorRef, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsNameRef jsNameRef = context.getNameForConstructor($this$getConstructorRef).makeRef();
        boolean condition$iv = context.isPerFile() && !IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)((IrPossiblyExternalDeclaration)$this$getConstructorRef));
        boolean $i$f$butIf = false;
        if (condition$iv) {
            void $this$butIf$iv;
            void it = $this$butIf$iv;
            boolean bl = false;
            jsExpression = new JsInvocation((JsExpression)it, new JsExpression[0]);
        } else {
            jsExpression = jsNameRef;
        }
        return jsExpression;
    }

    public static final /* synthetic */ String access$asString(IrTypeArgument $receiver, JsIrBackendContext context) {
        return IrTypeUtilsKt.asString($receiver, context);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SimpleTypeNullability.values().length];
            try {
                nArray[SimpleTypeNullability.MARKED_NULLABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleTypeNullability.NOT_SPECIFIED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleTypeNullability.DEFINITELY_NOT_NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

