/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.dce;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.WasmArrayInfo;
import org.jetbrains.kotlin.ir.backend.js.dce.UsefulDeclarationProcessor;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.TypeTranformerKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0011H\u0014J\f\u0010$\u001a\u00020\u0017*\u00020\u0015H\u0002J\u001c\u0010%\u001a\u00020\u0017*\u00020&2\u0006\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u0007H\u0002J\u001c\u0010)\u001a\u00020\u0017*\u00020&2\u0006\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u0007H\u0002J\u0014\u0010*\u001a\u00020\u0017*\u00020+2\u0006\u0010'\u001a\u00020\u0015H\u0002J\u000e\u0010,\u001a\u0004\u0018\u00010&*\u00020&H\u0002R\u0018\u0010\t\u001a\u00060\nR\u00020\u0001X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/dce/WasmUsefulDeclarationProcessor;", "Lorg/jetbrains/kotlin/ir/backend/js/dce/UsefulDeclarationProcessor;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "printReachabilityInfo", "", "dumpReachabilityInfoToFile", "", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;ZLjava/lang/String;)V", "bodyVisitor", "Lorg/jetbrains/kotlin/ir/backend/js/dce/UsefulDeclarationProcessor$BodyVisitorBase;", "getBodyVisitor", "()Lorg/jetbrains/kotlin/ir/backend/js/dce/UsefulDeclarationProcessor$BodyVisitorBase;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "kotlinClosureToJsClosureConvertFunToKotlinClosureCallFun", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "unitGetInstance", "isExported", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "processClass", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "processConstructor", "irConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "processField", "irField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "processIrFunction", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "processSimpleFunction", "enqueueParentClass", "enqueueRuntimeClassOrAny", "Lorg/jetbrains/kotlin/ir/types/IrType;", "from", "info", "enqueueType", "enqueueValueParameterType", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "getInlinedValueTypeIfAny", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmUsefulDeclarationProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmUsefulDeclarationProcessor.kt\norg/jetbrains/kotlin/backend/wasm/dce/WasmUsefulDeclarationProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1179#2,2:193\n1253#2,4:195\n1855#2,2:202\n1855#2,2:204\n20#3,2:199\n1#4:201\n*S KotlinDebug\n*F\n+ 1 WasmUsefulDeclarationProcessor.kt\norg/jetbrains/kotlin/backend/wasm/dce/WasmUsefulDeclarationProcessor\n*L\n29#1:193,2\n29#1:195,4\n166#1:202,2\n176#1:204,2\n146#1:199,2\n*E\n"})
public final class WasmUsefulDeclarationProcessor
extends UsefulDeclarationProcessor {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final IrSimpleFunction unitGetInstance;
    @NotNull
    private final Map<IrSimpleFunction, IrSimpleFunction> kotlinClosureToJsClosureConvertFunToKotlinClosureCallFun;
    @NotNull
    private final UsefulDeclarationProcessor.BodyVisitorBase bodyVisitor;

    /*
     * WARNING - void declaration
     */
    public WasmUsefulDeclarationProcessor(@NotNull WasmBackendContext context, boolean printReachabilityInfo, @Nullable String dumpReachabilityInfoToFile) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(printReachabilityInfo, false, dumpReachabilityInfoToFile);
        this.context = context;
        this.unitGetInstance = MiscKt.findUnitGetInstanceFunction(this.getContext());
        Iterable iterable = this.getContext().getKotlinClosureToJsConverters().entrySet();
        WasmUsefulDeclarationProcessor wasmUsefulDeclarationProcessor = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var7_8 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String k = (String)entry.getKey();
            IrSimpleFunction v = (IrSimpleFunction)entry.getValue();
            entry = TuplesKt.to((Object)v, (Object)this.getContext().getClosureCallExports().get(k));
            map.put(entry.getFirst(), entry.getSecond());
        }
        wasmUsefulDeclarationProcessor.kotlinClosureToJsClosureConvertFunToKotlinClosureCallFun = destination$iv$iv;
        this.bodyVisitor = new UsefulDeclarationProcessor.BodyVisitorBase(this){
            final /* synthetic */ WasmUsefulDeclarationProcessor this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitConst(@NotNull IrConst<?> expression2, @NotNull IrDeclaration data) {
                block1: {
                    IrConstKind irConstKind;
                    block0: {
                        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
                        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                        irConstKind = expression2.getKind();
                        if (!(irConstKind instanceof IrConstKind.Null)) break block0;
                        WasmUsefulDeclarationProcessor.access$enqueueType(this.this$0, expression2.getType(), data, "expression type");
                        break block1;
                    }
                    if (!(irConstKind instanceof IrConstKind.String)) break block1;
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, (IrDeclaration)this.this$0.getContext().getWasmSymbols().getStringGetLiteral().getOwner(), data, "String literal intrinsic getter stringGetLiteral", false, 4, null);
                }
            }

            public void visitVariable(@NotNull IrVariable declaration, @NotNull IrDeclaration data) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                WasmUsefulDeclarationProcessor.access$enqueueType(this.this$0, declaration.getType(), data, "local variable type");
                super.visitVariable(declaration, data);
            }

            /*
             * WARNING - void declaration
             */
            public void visitVararg(@NotNull IrVararg expression2, @NotNull IrDeclaration data) {
                Object v1;
                block2: {
                    void $this$firstOrNull$iv;
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    IrClass irClass = IrTypesKt.getClass((IrType)expression2.getType());
                    Intrinsics.checkNotNull((Object)irClass);
                    Sequence sequence2 = IrUtilsKt.getConstructors((IrClass)irClass);
                    boolean $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        IrConstructor it = (IrConstructor)element$iv;
                        boolean bl = false;
                        if (!AnnotationsKt.hasWasmPrimitiveConstructorAnnotation((IrAnnotationContainer)it)) continue;
                        v1 = element$iv;
                        break block2;
                    }
                    v1 = null;
                }
                IrConstructor irConstructor = v1;
                if (irConstructor != null) {
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, (IrDeclaration)irConstructor, data, "implicit vararg constructor", false, 4, null);
                }
                super.visitVararg(expression2, data);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean tryToProcessIntrinsicCall(IrDeclaration from, IrCall call2) {
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = call2.getSymbol();
                if (Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)this.this$0.getContext().getWasmSymbols().getUnboxIntrinsic())) {
                    IrType fromType = call2.getTypeArgument(0);
                    if (fromType == null) return true;
                    if (IrTypePredicatesKt.isNothing((IrType)fromType)) return true;
                    if (IrTypePredicatesKt.isNullableNothing((IrType)fromType)) return true;
                    IrType irType = call2.getTypeArgument(1);
                    if (irType == null) return true;
                    IrType irType2 = irType;
                    WasmUsefulDeclarationProcessor wasmUsefulDeclarationProcessor = this.this$0;
                    IrType it = irType2;
                    boolean bl = false;
                    IrClass irClass = wasmUsefulDeclarationProcessor.getContext().getInlineClassesUtils().getInlinedClass(it);
                    if (irClass == null) return true;
                    IrClass it2 = irClass;
                    boolean bl2 = false;
                    IrField irField = InlineClassesKt.getInlineClassBackingField((IrClass)it2);
                    IrField backingField = irField;
                    if (backingField == null) return true;
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, (IrDeclaration)backingField, from, "backing inline class field for unboxIntrinsic", false, 4, null);
                    return true;
                }
                if (!((((Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)this.this$0.getContext().getWasmSymbols().getWasmTypeId()) ? true : Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)this.this$0.getContext().getWasmSymbols().getRefCastNull())) ? true : Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)this.this$0.getContext().getWasmSymbols().getRefTest())) ? true : Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)this.this$0.getContext().getWasmSymbols().getBoxIntrinsic())) ? true : Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)this.this$0.getContext().getWasmSymbols().getWasmArrayCopy()))) return false;
                IrType irType = call2.getTypeArgument(0);
                if (irType == null) return true;
                WasmUsefulDeclarationProcessor.access$enqueueRuntimeClassOrAny(this.this$0, irType, from, "intrinsic " + ((IrSimpleFunction)call2.getSymbol().getOwner()).getName());
                return true;
            }

            public void visitCall(@NotNull IrCall expression2, @NotNull IrDeclaration data) {
                boolean isSuperCall;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                super.visitCall(expression2, data);
                IrFunction function2 = (IrFunction)IrResolveUtilsKt.getRealOverrideTarget((IrSimpleFunction)expression2.getSymbol().getOwner());
                if (Intrinsics.areEqual((Object)function2.getReturnType(), (Object)this.this$0.getContext().getIrBuiltIns().getUnitType())) {
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, (IrDeclaration)WasmUsefulDeclarationProcessor.access$getUnitGetInstance$p(this.this$0), data, "function Unit return type", false, 4, null);
                }
                if (this.tryToProcessIntrinsicCall(data, expression2)) {
                    return;
                }
                if (AnnotationsKt.hasWasmNoOpCastAnnotation((IrAnnotationContainer)function2)) {
                    return;
                }
                if (AnnotationsKt.getWasmOpAnnotation((IrAnnotationContainer)function2) != null) {
                    return;
                }
                boolean bl = isSuperCall = expression2.getSuperQualifierSymbol() != null;
                if (function2 instanceof IrSimpleFunction && IrUtilsKt.isOverridable((IrSimpleFunction)((IrSimpleFunction)function2)) && !isSuperCall) {
                    IrClass klass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)function2));
                    if (IrUtilsKt.isInterface((IrClass)klass)) {
                        UsefulDeclarationProcessor.enqueue$default(this.this$0, (IrDeclaration)klass, data, "receiver class", false, 4, null);
                    }
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, (IrDeclaration)function2, data, "method call", false, 4, null);
                }
            }
        };
    }

    @Override
    @NotNull
    public WasmBackendContext getContext() {
        return this.context;
    }

    @Override
    @NotNull
    protected UsefulDeclarationProcessor.BodyVisitorBase getBodyVisitor() {
        return this.bodyVisitor;
    }

    private final IrType getInlinedValueTypeIfAny(IrType $this$getInlinedValueTypeIfAny) {
        IrType irType;
        IrType irType2 = $this$getInlinedValueTypeIfAny;
        if (((((((((Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getBooleanType()) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getByteType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getShortType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getCharType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getIntType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getLongType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getFloatType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getDoubleType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getNothingType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getWasmSymbols().getVoidType())) {
            irType = null;
        } else if (TypeTransformerKt.isBuiltInWasmRefType($this$getInlinedValueTypeIfAny)) {
            irType = null;
        } else {
            IrClass ic;
            IrClass irClass = TypeTranformerKt.getErasedUpperBound($this$getInlinedValueTypeIfAny);
            irType = (irClass != null ? irClass.isExternal() : false) ? null : ((ic = this.getContext().getInlineClassesUtils().getInlinedClass($this$getInlinedValueTypeIfAny)) == null ? $this$getInlinedValueTypeIfAny : this.getInlinedValueTypeIfAny(this.getContext().getInlineClassesUtils().getInlineClassUnderlyingType(ic)));
        }
        return irType;
    }

    private final void enqueueRuntimeClassOrAny(IrType $this$enqueueRuntimeClassOrAny, IrDeclaration from, String info) {
        this.enqueue((IrDeclaration)TypeTransformerKt.getRuntimeClass($this$enqueueRuntimeClassOrAny, this.getContext().getIrBuiltIns()), from, info, false);
    }

    private final void enqueueType(IrType $this$enqueueType, IrDeclaration from, String info) {
        IrType irType = this.getInlinedValueTypeIfAny($this$enqueueType);
        if (irType != null) {
            this.enqueueRuntimeClassOrAny(irType, from, info);
        }
    }

    private final void enqueueParentClass(IrDeclaration $this$enqueueParentClass) {
        block0: {
            IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)$this$enqueueParentClass);
            if (irClass == null) break block0;
            this.enqueue((IrDeclaration)irClass, $this$enqueueParentClass, "parent class", false);
        }
    }

    @Override
    protected void processField(@NotNull IrField irField) {
        Intrinsics.checkNotNullParameter((Object)irField, (String)"irField");
        super.processField(irField);
        this.enqueueParentClass((IrDeclaration)irField);
        this.enqueueType(irField.getType(), (IrDeclaration)irField, "field types");
    }

    @Override
    protected void processClass(@NotNull IrClass irClass) {
        block5: {
            Object v0;
            Object object;
            WasmArrayInfo wasmArrayInfo;
            block4: {
                Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
                super.processClass(irClass);
                wasmArrayInfo = AnnotationsKt.getWasmArrayAnnotation((IrAnnotationContainer)irClass);
                if (wasmArrayInfo != null && (object = wasmArrayInfo.getType()) != null) {
                    this.enqueueType((IrType)object, (IrDeclaration)irClass, "array type for wasm array annotated");
                }
                if (!this.getContext().getInlineClassesUtils().isClassInlineLike(irClass)) break block5;
                Iterable $this$firstIsInstanceOrNull$iv = irClass.getDeclarations();
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof IrConstructor)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            wasmArrayInfo = v0;
            if (wasmArrayInfo != null) {
                WasmArrayInfo wasmArrayInfo2;
                WasmArrayInfo it = wasmArrayInfo2 = wasmArrayInfo;
                boolean bl = false;
                WasmArrayInfo wasmArrayInfo3 = object = it.isPrimary() ? wasmArrayInfo2 : null;
                if (object != null) {
                    UsefulDeclarationProcessor.enqueue$default(this, (IrDeclaration)object, (IrDeclaration)irClass, "inline class primary ctor", false, 4, null);
                }
            }
        }
    }

    private final void enqueueValueParameterType(IrValueParameter $this$enqueueValueParameterType, IrDeclaration from) {
        if (this.getContext().getInlineClassesUtils().shouldValueParameterBeBoxed($this$enqueueValueParameterType)) {
            this.enqueueRuntimeClassOrAny($this$enqueueValueParameterType.getType(), from, "function ValueParameterType");
        } else {
            this.enqueueType($this$enqueueValueParameterType.getType(), from, "function ValueParameterType");
        }
    }

    private final void processIrFunction(IrFunction irFunction) {
        block3: {
            boolean isIntrinsic;
            if (IrFakeOverrideUtilsKt.isFakeOverride((IrDeclaration)((IrDeclaration)irFunction))) {
                return;
            }
            boolean bl = isIntrinsic = AnnotationsKt.hasWasmNoOpCastAnnotation((IrAnnotationContainer)irFunction) || AnnotationsKt.getWasmOpAnnotation((IrAnnotationContainer)irFunction) != null;
            if (isIntrinsic) {
                return;
            }
            Iterable $this$forEach$iv = DeclarationGeneratorKt.getEffectiveValueParameters(irFunction);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl2 = false;
                this.enqueueValueParameterType(it, (IrDeclaration)irFunction);
            }
            this.enqueueType(irFunction.getReturnType(), (IrDeclaration)irFunction, "function return type");
            IrSimpleFunction irSimpleFunction = this.kotlinClosureToJsClosureConvertFunToKotlinClosureCallFun.get(irFunction);
            if (irSimpleFunction == null) break block3;
            this.enqueue((IrDeclaration)irSimpleFunction, (IrDeclaration)irFunction, "kotlin closure to JS closure conversion", false);
        }
    }

    @Override
    protected void processSimpleFunction(@NotNull IrSimpleFunction irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        super.processSimpleFunction(irFunction);
        this.enqueueParentClass((IrDeclaration)irFunction);
        if (irFunction.isFakeOverride()) {
            Iterable $this$forEach$iv = irFunction.getOverriddenSymbols();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrSimpleFunctionSymbol overridden = (IrSimpleFunctionSymbol)element$iv;
                boolean bl = false;
                UsefulDeclarationProcessor.enqueue$default(this, (IrDeclaration)overridden.getOwner(), (IrDeclaration)irFunction, "original for fake-override", false, 4, null);
            }
        }
        this.processIrFunction((IrFunction)irFunction);
    }

    @Override
    protected void processConstructor(@NotNull IrConstructor irConstructor) {
        Intrinsics.checkNotNullParameter((Object)irConstructor, (String)"irConstructor");
        super.processConstructor(irConstructor);
        if (!this.getContext().getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)irConstructor)))) {
            this.processIrFunction((IrFunction)irConstructor);
        }
    }

    @Override
    protected boolean isExported(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return AnnotationUtilsKt.isJsExport((IrAnnotationContainer)declaration);
    }

    public static final /* synthetic */ void access$enqueueType(WasmUsefulDeclarationProcessor $this, IrType $receiver, IrDeclaration from, String info) {
        $this.enqueueType($receiver, from, info);
    }

    public static final /* synthetic */ void access$enqueueRuntimeClassOrAny(WasmUsefulDeclarationProcessor $this, IrType $receiver, IrDeclaration from, String info) {
        $this.enqueueRuntimeClassOrAny($receiver, from, info);
    }

    public static final /* synthetic */ IrSimpleFunction access$getUnitGetInstance$p(WasmUsefulDeclarationProcessor $this) {
        return $this.unitGetInstance;
    }
}

