/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsDynamicDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "js.frontend"})
@SourceDebugExtension(value={"SMAP\nJsDynamicDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsDynamicDeclarationChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsDynamicDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n800#2,11:54\n*S KotlinDebug\n*F\n+ 1 JsDynamicDeclarationChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsDynamicDeclarationChecker\n*L\n44#1:54,11\n*E\n"})
public final class JsDynamicDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final JsDynamicDeclarationChecker INSTANCE = new JsDynamicDeclarationChecker();

    private JsDynamicDeclarationChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        block8: {
            BindingTrace trace;
            block7: {
                KtExpression delegateExpression;
                block10: {
                    boolean bl;
                    KotlinType kotlinType;
                    block9: {
                        boolean bl2;
                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                        trace = context.getTrace();
                        if (!(declaration instanceof KtProperty) || !(descriptor2 instanceof VariableDescriptorWithAccessors)) break block7;
                        KtExpression ktExpression = ((KtProperty)declaration).getDelegateExpression();
                        if (ktExpression == null) break block8;
                        delegateExpression = ktExpression;
                        boolean bl3 = false;
                        ResolvedCall provideDelegateCall = (ResolvedCall)trace.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, descriptor2);
                        if (provideDelegateCall == null) break block9;
                        KotlinType kotlinType2 = kotlinType = ((FunctionDescriptor)provideDelegateCall.getResultingDescriptor()).getReturnType();
                        if (kotlinType2 != null) {
                            Intrinsics.checkNotNull((Object)kotlinType2);
                            bl2 = DynamicTypesKt.isDynamic(kotlinType);
                        } else {
                            bl2 = false;
                        }
                        if (bl2) break block10;
                    }
                    KotlinType kotlinType3 = kotlinType = trace.getType(delegateExpression);
                    if (kotlinType3 != null) {
                        Intrinsics.checkNotNull((Object)kotlinType3);
                        bl = DynamicTypesKt.isDynamic(kotlinType);
                    } else {
                        bl = false;
                    }
                    if (!bl) break block8;
                }
                trace.report(ErrorsJs.PROPERTY_DELEGATION_BY_DYNAMIC.on((PsiElement)delegateExpression));
                break block8;
            }
            if (declaration instanceof KtClassOrObject) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = ((KtClassOrObject)declaration).getSuperTypeListEntries();
                boolean $i$f$filterIsInstance = false;
                Iterable bl3 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof KtDelegatedSuperTypeEntry)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (KtDelegatedSuperTypeEntry delegateDecl : (List)destination$iv$iv) {
                    KtExpression delegateExpr;
                    if (delegateDecl.getDelegateExpression() == null) continue;
                    KotlinType kotlinType = trace.getType(delegateExpr);
                    boolean bl = kotlinType != null ? DynamicTypesKt.isDynamic(kotlinType) : false;
                    if (!bl) continue;
                    trace.report(ErrorsJs.DELEGATION_BY_DYNAMIC.on((PsiElement)delegateExpr));
                }
            }
        }
    }
}

