/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.encodings;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\u0010*\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u001d\u0010\u0013\u001a\u00020\u0014*\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0082\u0002J\u001d\u0010\u0013\u001a\u00020\u0014*\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0082\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/library/encodings/WobblyTF8;", "", "()V", "EMPTY_BYTE_ARRAY", "", "EMPTY_STRING", "", "REPLACEMENT_CHAR", "", "decode", "array", "encode", "string", "isValidContinuation", "", "byteN", "", "readByteAsInt", "index", "set", "", "value", "", "kotlin-util-klib"})
public final class WobblyTF8 {
    private static final byte[] EMPTY_BYTE_ARRAY;
    private static final String EMPTY_STRING = "";
    private static final char REPLACEMENT_CHAR = '\ufffd';
    @NotNull
    public static final WobblyTF8 INSTANCE;

    @NotNull
    public final byte[] encode(@NotNull String string2) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        int stringLength = string2.length();
        if (stringLength == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] buffer = new byte[stringLength * 3];
        int writtenBytes = 0;
        int index2 = 0;
        while (index2 < stringLength) {
            char char2;
            char codePoint;
            char char1;
            if (Intrinsics.compare((int)(char1 = string2.charAt(index2++)), (int)128) < 0) {
                buffer[writtenBytes++] = (byte)char1;
                continue;
            }
            if (Intrinsics.compare((int)char1, (int)2048) < 0) {
                codePoint = char1;
                buffer[writtenBytes++] = (byte)(codePoint >>> 6 | 0xC0);
                buffer[writtenBytes++] = (byte)(codePoint & 0x3F | 0x80);
                continue;
            }
            if (Character.isHighSurrogate(char1) && index2 < stringLength && Character.isLowSurrogate(char2 = string2.charAt(index2))) {
                ++index2;
                int codePoint2 = Character.toCodePoint(char1, char2);
                buffer[writtenBytes++] = (byte)(codePoint2 >>> 18 | 0xF0);
                buffer[writtenBytes++] = (byte)(codePoint2 >>> 12 & 0x3F | 0x80);
                buffer[writtenBytes++] = (byte)(codePoint2 >>> 6 & 0x3F | 0x80);
                buffer[writtenBytes++] = (byte)(codePoint2 & 0x3F | 0x80);
                continue;
            }
            codePoint = char1;
            buffer[writtenBytes++] = (byte)(codePoint >>> 12 | 0xE0);
            buffer[writtenBytes++] = (byte)(codePoint >>> 6 & 0x3F | 0x80);
            buffer[writtenBytes++] = (byte)(codePoint & 0x3F | 0x80);
        }
        if (buffer.length == writtenBytes) {
            byArray = buffer;
        } else {
            byte[] byArray2 = buffer;
            byte[] byArray3 = Arrays.copyOf(byArray2, writtenBytes);
            byArray = byArray3;
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(this, newSize)");
        }
        return byArray;
    }

    @NotNull
    public final String decode(@NotNull byte[] array) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        int arraySize = array.length;
        if (arraySize == 0) {
            return EMPTY_STRING;
        }
        char[] buffer = new char[arraySize];
        int charsWritten = 0;
        int index2 = 0;
        while (index2 < arraySize) {
            int byte4;
            int byte3;
            int byte2;
            int byte1;
            if (((byte1 = this.readByteAsInt(array, index2++)) & 0x80) == 0) {
                buffer[charsWritten++] = (char)byte1;
                continue;
            }
            if (byte1 >>> 5 == 6) {
                if (index2 < arraySize && this.isValidContinuation(byte2 = this.readByteAsInt(array, index2))) {
                    ++index2;
                    buffer[charsWritten++] = (char)((byte1 & 0x1F) << 6 | byte2 & 0x3F);
                    continue;
                }
            } else if (byte1 >>> 4 == 14) {
                if (index2 < arraySize && this.isValidContinuation(byte2 = this.readByteAsInt(array, index2)) && ++index2 < arraySize && this.isValidContinuation(byte3 = this.readByteAsInt(array, index2))) {
                    ++index2;
                    buffer[charsWritten++] = (char)((byte1 & 0xF) << 12 | (byte2 & 0x3F) << 6 | byte3 & 0x3F);
                    continue;
                }
            } else if (byte1 >>> 3 == 30 && index2 < arraySize && this.isValidContinuation(byte2 = this.readByteAsInt(array, index2)) && ++index2 < arraySize && this.isValidContinuation(byte3 = this.readByteAsInt(array, index2)) && ++index2 < arraySize && this.isValidContinuation(byte4 = this.readByteAsInt(array, index2))) {
                ++index2;
                int codePoint = (byte1 & 7) << 18 | (byte2 & 0x3F) << 12 | (byte3 & 0x3F) << 6 | byte4 & 0x3F;
                buffer[charsWritten++] = Character.highSurrogate(codePoint);
                buffer[charsWritten++] = Character.lowSurrogate(codePoint);
                continue;
            }
            buffer[charsWritten++] = 65533;
        }
        if (buffer.length == charsWritten) {
            string2 = new String(buffer);
        } else {
            int n = 0;
            string2 = new String(buffer, n, charsWritten);
        }
        return string2;
    }

    private final int readByteAsInt(byte[] $this$readByteAsInt, int index2) {
        return $this$readByteAsInt[index2] & 0xFF;
    }

    private final void set(byte[] $this$set, int index2, int value2) {
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"$this$set");
        $this$set[index2] = (byte)value2;
    }

    private final void set(char[] $this$set, int index2, int value2) {
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"$this$set");
        $this$set[index2] = (char)value2;
    }

    private final boolean isValidContinuation(int byteN) {
        return byteN >>> 6 == 2;
    }

    private WobblyTF8() {
    }

    static {
        WobblyTF8 wobblyTF8;
        INSTANCE = wobblyTF8 = new WobblyTF8();
        EMPTY_BYTE_ARRAY = new byte[0];
    }
}

