/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\f\u0010\u0007\u001a\u00020\u0004*\u00020\bH\u0002\u001a\f\u0010\t\u001a\u00020\u0004*\u00020\u0001H\u0002\u00a8\u0006\n"}, d2={"getTransitiveKType", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "e", "substituteKTypes", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "checkDoesNotCreateRecursiveKType", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "checkNoInvocationsWithRecursiveKType", "js.translator"})
public final class SubstituteKTypesKt {
    public static final void substituteKTypes(@NotNull JsNode root2) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(){

            public void endVisit(@NotNull JsInvocation invocation, @NotNull JsContext<? super JsNode> ctx) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
                    Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                    SubstituteKTypesKt.access$checkDoesNotCreateRecursiveKType(invocation);
                    JsExpression jsExpression = invocation.getQualifier();
                    JsNameRef jsNameRef = jsExpression instanceof JsNameRef ? (JsNameRef)jsExpression : null;
                    if (jsNameRef == null) {
                        return;
                    }
                    JsNameRef qualifier = jsNameRef;
                    JsName jsName = qualifier.getName();
                    if ((jsName != null ? MetadataProperties.getSpecialFunction(jsName) : null) != SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE) {
                        return;
                    }
                    List<JsExpression> list2 = invocation.getArguments();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"invocation.arguments");
                    JsExpression firstArg = (JsExpression)CollectionsKt.first(list2);
                    Intrinsics.checkNotNullExpressionValue((Object)firstArg, (String)"firstArg");
                    JsExpression jsExpression2 = SubstituteKTypesKt.access$getTransitiveKType(firstArg);
                    if (jsExpression2 == null) break block2;
                    JsExpression it = jsExpression2;
                    boolean bl = false;
                    SubstituteKTypesKt.access$checkNoInvocationsWithRecursiveKType(it);
                    ctx.replaceMe((JsNode)it);
                }
            }
        };
        visitor2.accept(root2);
    }

    private static final JsExpression getTransitiveKType(JsExpression e) {
        JsExpression jsExpression;
        if (MetadataProperties.getKType(e) != null) {
            jsExpression = MetadataProperties.getKType(e);
        } else if (e instanceof JsNameRef) {
            JsName jsName = ((JsNameRef)e).getName();
            JsNode jsNode = jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
            JsExpression jsExpression2 = jsNode instanceof JsExpression ? (JsExpression)jsNode : null;
            if (jsExpression2 == null) {
                return null;
            }
            JsExpression staticRef = jsExpression2;
            jsExpression = SubstituteKTypesKt.getTransitiveKType(staticRef);
        } else {
            jsExpression = null;
        }
        return jsExpression;
    }

    private static final void checkNoInvocationsWithRecursiveKType(JsExpression $this$checkNoInvocationsWithRecursiveKType) {
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(){

            public void endVisit(@NotNull JsInvocation invocation, @NotNull JsContext<? super JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                SubstituteKTypesKt.access$checkDoesNotCreateRecursiveKType(invocation);
            }
        };
        visitor2.accept((JsNode)$this$checkNoInvocationsWithRecursiveKType);
    }

    private static final void checkDoesNotCreateRecursiveKType(JsInvocation $this$checkDoesNotCreateRecursiveKType) {
        if (MetadataProperties.getKTypeWithRecursion($this$checkDoesNotCreateRecursiveKType)) {
            String string2 = "Non-reified type parameters with recursive bounds are not supported yet";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }
    }

    public static final /* synthetic */ void access$checkDoesNotCreateRecursiveKType(JsInvocation $receiver) {
        SubstituteKTypesKt.checkDoesNotCreateRecursiveKType($receiver);
    }

    public static final /* synthetic */ JsExpression access$getTransitiveKType(JsExpression e) {
        return SubstituteKTypesKt.getTransitiveKType(e);
    }

    public static final /* synthetic */ void access$checkNoInvocationsWithRecursiveKType(JsExpression $receiver) {
        SubstituteKTypesKt.checkNoInvocationsWithRecursiveKType($receiver);
    }
}

