/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.config.KotlinSourceRoot;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.extensions.CompilerConfigurationExtension;
import org.jetbrains.kotlin.extensions.PreprocessedFileCreator;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.multiplatform.IsCommonSourceKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a6\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\u001c\u0010\u0011\u001a\u00020\t*\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u001ac\u0010\u0016\u001a\u00020\u0017*\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102/\u0010\u0018\u001a+\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0012\u0015\u0012\u0013\u0018\u00010\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00170\u0019H\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010 \u001a\u00020\u0017*\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b\u001a&\u0010!\u001a\u00020\u0017*\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001c2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0010\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006&"}, d2={"messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getMessageCollector", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "createSourceFilesFromSourceRoots", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "sourceRoots", "", "Lorg/jetbrains/kotlin/cli/common/config/KotlinSourceRoot;", "reportLocation", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocation;", "applyModuleProperties", "module", "Lorg/jetbrains/kotlin/modules/Module;", "buildFile", "Ljava/io/File;", "forAllFiles", "", "body", "Lkotlin/Function3;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "", "Lkotlin/ParameterName;", "name", "moduleName", "registerPluginsSuppliedExtensionsIfNeeded", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "location", "cli-base"})
@SourceDebugExtension(value={"SMAP\ncoreEnvironmentUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coreEnvironmentUtils.kt\norg/jetbrains/kotlin/cli/jvm/compiler/CoreEnvironmentUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n43#1,40:148\n83#1,10:189\n1#2:147\n1#2:188\n*E\n*S KotlinDebug\n*F\n+ 1 coreEnvironmentUtils.kt\norg/jetbrains/kotlin/cli/jvm/compiler/CoreEnvironmentUtilsKt\n*L\n115#1,40:148\n115#1,10:189\n115#1:188\n*E\n"})
public final class CoreEnvironmentUtilsKt {
    public static final void report(@NotNull CompilerConfiguration $this$report, @NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageLocation location) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$report, (String)"$this$report");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            MessageCollector messageCollector = (MessageCollector)$this$report.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            if (messageCollector == null) break block0;
            messageCollector.report(severity, message, location);
        }
    }

    public static /* synthetic */ void report$default(CompilerConfiguration compilerConfiguration, CompilerMessageSeverity compilerMessageSeverity, String string2, CompilerMessageLocation compilerMessageLocation, int n, Object object) {
        if ((n & 4) != 0) {
            compilerMessageLocation = null;
        }
        CoreEnvironmentUtilsKt.report(compilerConfiguration, compilerMessageSeverity, string2, compilerMessageLocation);
    }

    /*
     * WARNING - void declaration
     */
    public static final void forAllFiles(@NotNull List<KotlinSourceRoot> $this$forAllFiles, @NotNull CompilerConfiguration configuration, @NotNull Project project, @Nullable CompilerMessageLocation reportLocation, @NotNull Function3<? super VirtualFile, ? super Boolean, ? super String, Unit> body2) {
        int $i$f$forAllFiles = 0;
        Intrinsics.checkNotNullParameter($this$forAllFiles, (String)"$this$forAllFiles");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        VirtualFileSystem localFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        HashSet<VirtualFile> processedFiles = new HashSet<VirtualFile>();
        PreprocessedFileCreator virtualFileCreator = new PreprocessedFileCreator(project);
        boolean pluginsConfigured = false;
        for (KotlinSourceRoot kotlinSourceRoot : $this$forAllFiles) {
            void sourceRootPath;
            String string2 = kotlinSourceRoot.component1();
            boolean bl = kotlinSourceRoot.component2();
            String hmppModuleName = kotlinSourceRoot.component3();
            File sourceRoot = new File((String)sourceRootPath);
            VirtualFile vFile = localFileSystem.findFileByPath(FilesKt.normalize((File)sourceRoot).getPath());
            if (vFile == null) {
                String message = "Source file or directory not found: " + (String)sourceRootPath;
                File buildFilePath = (File)configuration.get(JVMConfigurationKeys.MODULE_XML_FILE);
                if (buildFilePath != null && Logger.isInitialized()) {
                    Logger.getInstance(KotlinCoreEnvironment.class).warn(message + "\n\nbuild file path: " + buildFilePath + "\ncontent:\n" + FilesKt.readText$default((File)buildFilePath, null, (int)1, null));
                }
                CoreEnvironmentUtilsKt.report(configuration, CompilerMessageSeverity.ERROR, message, reportLocation);
                continue;
            }
            if (!vFile.isDirectory() && Intrinsics.areEqual((Object)vFile.getExtension(), (Object)"kt") ^ true) {
                if (!pluginsConfigured) {
                    CoreEnvironmentUtilsKt.registerPluginsSuppliedExtensionsIfNeeded(vFile, project);
                    pluginsConfigured = true;
                }
                if (Intrinsics.areEqual((Object)vFile.getFileType(), (Object)KotlinFileType.INSTANCE) ^ true) {
                    CoreEnvironmentUtilsKt.report(configuration, CompilerMessageSeverity.ERROR, "Source entry is not a Kotlin file: " + (String)sourceRootPath, reportLocation);
                    continue;
                }
            }
            for (File file2 : FilesKt.walkTopDown((File)sourceRoot)) {
                void isCommon;
                VirtualFile virtualFile;
                VirtualFile virtualFile2;
                if (!file2.isFile()) continue;
                File file3 = file2.getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"file.absoluteFile");
                if (localFileSystem.findFileByPath(FilesKt.normalize((File)file3).getPath()) != null) {
                    VirtualFile virtualFile3;
                    VirtualFile p1 = virtualFile3;
                    boolean bl2 = false;
                    virtualFile2 = virtualFileCreator.create(p1);
                } else {
                    virtualFile2 = null;
                }
                if ((virtualFile = virtualFile2) == null || !processedFiles.add(virtualFile)) continue;
                if (!pluginsConfigured) {
                    CoreEnvironmentUtilsKt.registerPluginsSuppliedExtensionsIfNeeded(virtualFile, project);
                    pluginsConfigured = true;
                }
                body2.invoke((Object)virtualFile, (Object)((boolean)isCommon), (Object)hmppModuleName);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ void forAllFiles$default(List $this$forAllFiles, CompilerConfiguration configuration, Project project, CompilerMessageLocation reportLocation, Function3 body2, int n, Object object) {
        if ((n & 4) != 0) {
            reportLocation = null;
        }
        boolean $i$f$forAllFiles = false;
        Intrinsics.checkNotNullParameter((Object)$this$forAllFiles, (String)"$this$forAllFiles");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        VirtualFileSystem localFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        HashSet<VirtualFile> processedFiles = new HashSet<VirtualFile>();
        PreprocessedFileCreator virtualFileCreator = new PreprocessedFileCreator(project);
        boolean pluginsConfigured = false;
        for (KotlinSourceRoot kotlinSourceRoot : $this$forAllFiles) {
            void sourceRootPath;
            String string2 = kotlinSourceRoot.component1();
            boolean bl = kotlinSourceRoot.component2();
            String hmppModuleName = kotlinSourceRoot.component3();
            File sourceRoot = new File((String)sourceRootPath);
            VirtualFile vFile = localFileSystem.findFileByPath(FilesKt.normalize((File)sourceRoot).getPath());
            if (vFile == null) {
                String message = "Source file or directory not found: " + (String)sourceRootPath;
                File buildFilePath = (File)configuration.get(JVMConfigurationKeys.MODULE_XML_FILE);
                if (buildFilePath != null && Logger.isInitialized()) {
                    Logger.getInstance(KotlinCoreEnvironment.class).warn(message + "\n\nbuild file path: " + buildFilePath + "\ncontent:\n" + FilesKt.readText$default((File)buildFilePath, null, (int)1, null));
                }
                CoreEnvironmentUtilsKt.report(configuration, CompilerMessageSeverity.ERROR, message, reportLocation);
                continue;
            }
            if (!vFile.isDirectory() && Intrinsics.areEqual((Object)vFile.getExtension(), (Object)"kt") ^ true) {
                if (!pluginsConfigured) {
                    CoreEnvironmentUtilsKt.registerPluginsSuppliedExtensionsIfNeeded(vFile, project);
                    pluginsConfigured = true;
                }
                if (Intrinsics.areEqual((Object)vFile.getFileType(), (Object)KotlinFileType.INSTANCE) ^ true) {
                    CoreEnvironmentUtilsKt.report(configuration, CompilerMessageSeverity.ERROR, "Source entry is not a Kotlin file: " + (String)sourceRootPath, reportLocation);
                    continue;
                }
            }
            for (File file2 : FilesKt.walkTopDown((File)sourceRoot)) {
                void isCommon;
                VirtualFile virtualFile;
                VirtualFile virtualFile2;
                if (!file2.isFile()) continue;
                File file3 = file2.getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"file.absoluteFile");
                if (localFileSystem.findFileByPath(FilesKt.normalize((File)file3).getPath()) != null) {
                    VirtualFile virtualFile3;
                    VirtualFile p1 = virtualFile3;
                    boolean bl2 = false;
                    virtualFile2 = virtualFileCreator.create(p1);
                } else {
                    virtualFile2 = null;
                }
                if ((virtualFile = virtualFile2) == null || !processedFiles.add(virtualFile)) continue;
                if (!pluginsConfigured) {
                    CoreEnvironmentUtilsKt.registerPluginsSuppliedExtensionsIfNeeded(virtualFile, project);
                    pluginsConfigured = true;
                }
                body2.invoke((Object)virtualFile, (Object)((boolean)isCommon), (Object)hmppModuleName);
            }
        }
    }

    public static final void registerPluginsSuppliedExtensionsIfNeeded(@NotNull VirtualFile $this$registerPluginsSuppliedExtensionsIfNeeded, @NotNull Project project) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$registerPluginsSuppliedExtensionsIfNeeded, (String)"$this$registerPluginsSuppliedExtensionsIfNeeded");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if ($this$registerPluginsSuppliedExtensionsIfNeeded.getExtension() == null || Intrinsics.areEqual((Object)$this$registerPluginsSuppliedExtensionsIfNeeded.getExtension(), (Object)"kt")) break block3;
                String string2 = $this$registerPluginsSuppliedExtensionsIfNeeded.getExtension();
                JavaFileType javaFileType = JavaFileType.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)javaFileType, (String)"JavaFileType.INSTANCE");
                if (Intrinsics.areEqual((Object)string2, (Object)javaFileType.getDefaultExtension())) break block3;
                String string3 = $this$registerPluginsSuppliedExtensionsIfNeeded.getExtension();
                JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)javaClassFileType, (String)"JavaClassFileType.INSTANCE");
                if (!Intrinsics.areEqual((Object)string3, (Object)javaClassFileType.getDefaultExtension()) && !Intrinsics.areEqual((Object)$this$registerPluginsSuppliedExtensionsIfNeeded.getFileType(), (Object)KotlinFileType.INSTANCE)) break block4;
            }
            return;
        }
        for (CompilerConfigurationExtension extension : CompilerConfigurationExtension.Companion.getInstances(project)) {
            extension.updateFileRegistry();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtFile> createSourceFilesFromSourceRoots(@NotNull CompilerConfiguration configuration, @NotNull Project project, @NotNull List<KotlinSourceRoot> sourceRoots, @Nullable CompilerMessageLocation reportLocation) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(project)");
        PsiManager psiManager2 = psiManager;
        List result2 = new ArrayList();
        List<KotlinSourceRoot> $this$forAllFiles$iv = sourceRoots;
        boolean $i$f$forAllFiles = false;
        VirtualFileSystem localFileSystem$iv = VirtualFileManager.getInstance().getFileSystem("file");
        HashSet<VirtualFile> processedFiles$iv = new HashSet<VirtualFile>();
        PreprocessedFileCreator virtualFileCreator$iv = new PreprocessedFileCreator(project);
        boolean pluginsConfigured$iv = false;
        for (KotlinSourceRoot kotlinSourceRoot : $this$forAllFiles$iv) {
            void sourceRootPath$iv;
            String string2 = kotlinSourceRoot.component1();
            boolean bl = kotlinSourceRoot.component2();
            String hmppModuleName$iv = kotlinSourceRoot.component3();
            File sourceRoot$iv = new File((String)sourceRootPath$iv);
            VirtualFile vFile$iv = localFileSystem$iv.findFileByPath(FilesKt.normalize((File)sourceRoot$iv).getPath());
            if (vFile$iv == null) {
                String message$iv = "Source file or directory not found: " + (String)sourceRootPath$iv;
                File buildFilePath$iv = (File)configuration.get(JVMConfigurationKeys.MODULE_XML_FILE);
                if (buildFilePath$iv != null && Logger.isInitialized()) {
                    Logger.getInstance(KotlinCoreEnvironment.class).warn(message$iv + "\n\nbuild file path: " + buildFilePath$iv + "\ncontent:\n" + FilesKt.readText$default((File)buildFilePath$iv, null, (int)1, null));
                }
                CoreEnvironmentUtilsKt.report(configuration, CompilerMessageSeverity.ERROR, message$iv, reportLocation);
                continue;
            }
            if (!vFile$iv.isDirectory() && Intrinsics.areEqual((Object)vFile$iv.getExtension(), (Object)"kt") ^ true) {
                if (!pluginsConfigured$iv) {
                    CoreEnvironmentUtilsKt.registerPluginsSuppliedExtensionsIfNeeded(vFile$iv, project);
                    pluginsConfigured$iv = true;
                }
                if (Intrinsics.areEqual((Object)vFile$iv.getFileType(), (Object)KotlinFileType.INSTANCE) ^ true) {
                    CoreEnvironmentUtilsKt.report(configuration, CompilerMessageSeverity.ERROR, "Source entry is not a Kotlin file: " + (String)sourceRootPath$iv, reportLocation);
                    continue;
                }
            }
            for (File file$iv : FilesKt.walkTopDown((File)sourceRoot$iv)) {
                void moduleName;
                void isCommon;
                PsiFile psiFile;
                void isCommon$iv;
                VirtualFile virtualFile$iv;
                VirtualFile virtualFile;
                if (!file$iv.isFile()) continue;
                File file2 = file$iv.getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file.absoluteFile");
                if (localFileSystem$iv.findFileByPath(FilesKt.normalize((File)file2).getPath()) != null) {
                    VirtualFile virtualFile2;
                    VirtualFile p1$iv = virtualFile2;
                    boolean bl2 = false;
                    virtualFile = virtualFileCreator$iv.create(p1$iv);
                } else {
                    virtualFile = null;
                }
                if ((virtualFile$iv = virtualFile) == null || !processedFiles$iv.add(virtualFile$iv)) continue;
                if (!pluginsConfigured$iv) {
                    CoreEnvironmentUtilsKt.registerPluginsSuppliedExtensionsIfNeeded(virtualFile$iv, project);
                    pluginsConfigured$iv = true;
                }
                String string3 = hmppModuleName$iv;
                void var26_26 = isCommon$iv;
                VirtualFile virtualFile3 = virtualFile$iv;
                boolean bl3 = false;
                if (psiManager2.findFile(virtualFile3) == null) continue;
                PsiFile it = psiFile;
                boolean bl4 = false;
                if (!(it instanceof KtFile)) continue;
                IsCommonSourceKt.setCommonSource((KtFile)it, (boolean)isCommon);
                if (moduleName != null) {
                    IsCommonSourceKt.setHmppModuleName((KtFile)it, (String)moduleName);
                }
                result2.add(it);
            }
        }
        return result2;
    }

    public static /* synthetic */ List createSourceFilesFromSourceRoots$default(CompilerConfiguration compilerConfiguration, Project project, List list2, CompilerMessageLocation compilerMessageLocation, int n, Object object) {
        if ((n & 8) != 0) {
            compilerMessageLocation = null;
        }
        return CoreEnvironmentUtilsKt.createSourceFilesFromSourceRoots(compilerConfiguration, project, list2, compilerMessageLocation);
    }

    @NotNull
    public static final MessageCollector getMessageCollector(@NotNull KotlinCoreEnvironment $this$messageCollector) {
        Intrinsics.checkNotNullParameter((Object)$this$messageCollector, (String)"$this$messageCollector");
        Object object = $this$messageCollector.getConfiguration().getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        return (MessageCollector)object;
    }

    @NotNull
    public static final CompilerConfiguration applyModuleProperties(@NotNull CompilerConfiguration $this$applyModuleProperties, @NotNull Module module2, @Nullable File buildFile) {
        CompilerConfiguration compilerConfiguration;
        Intrinsics.checkNotNullParameter((Object)$this$applyModuleProperties, (String)"$this$applyModuleProperties");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        CompilerConfiguration $this$apply = compilerConfiguration = $this$applyModuleProperties.copy();
        boolean bl = false;
        if (buildFile != null) {
            Function2 $fun$checkKeyIsNull$1 = new Function2<CompilerConfigurationKey<?>, String, Unit>($this$apply){
                final /* synthetic */ CompilerConfiguration $this_apply;

                public final void invoke(@NotNull CompilerConfigurationKey<?> key, @NotNull String name2) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter(key, (String)"key");
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    boolean bl2 = bl = this.$this_apply.get(key) == null;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl3 = false;
                        String string2 = name2 + " should be null, when buildFile is used";
                        throw new AssertionError((Object)string2);
                    }
                }
                {
                    this.$this_apply = compilerConfiguration;
                    super(2);
                }
            };
            CompilerConfigurationKey compilerConfigurationKey = JVMConfigurationKeys.OUTPUT_DIRECTORY;
            Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey, (String)"JVMConfigurationKeys.OUTPUT_DIRECTORY");
            $fun$checkKeyIsNull$1.invoke(compilerConfigurationKey, "OUTPUT_DIRECTORY");
            CompilerConfigurationKey compilerConfigurationKey2 = JVMConfigurationKeys.OUTPUT_JAR;
            Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey2, (String)"JVMConfigurationKeys.OUTPUT_JAR");
            $fun$checkKeyIsNull$1.invoke(compilerConfigurationKey2, "OUTPUT_JAR");
            $this$apply.put(JVMConfigurationKeys.OUTPUT_DIRECTORY, (Object)new File(module2.getOutputDirectory()));
        }
        CompilerConfiguration compilerConfiguration2 = compilerConfiguration;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfiguration2, (String)"copy().apply {\n        i\u2026ctory()))\n        }\n    }");
        return compilerConfiguration2;
    }
}

