/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.types.CustomTypeParameter;
import org.jetbrains.kotlin.types.DelegatingSimpleType;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.StubTypeForBuilderInference;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeRefinement;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.NewCapturedType;
import org.jetbrains.kotlin.types.checker.NewTypeVariableConstructor;
import org.jetbrains.kotlin.types.checker.NullabilityChecker;
import org.jetbrains.kotlin.types.model.DefinitelyNotNullTypeMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001bB\u0017\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0005H\u0017J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\t\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/types/DefinitelyNotNullType;", "Lorg/jetbrains/kotlin/types/DelegatingSimpleType;", "Lorg/jetbrains/kotlin/types/CustomTypeParameter;", "Lorg/jetbrains/kotlin/types/model/DefinitelyNotNullTypeMarker;", "original", "Lorg/jetbrains/kotlin/types/SimpleType;", "useCorrectedNullabilityForTypeParameters", "", "(Lorg/jetbrains/kotlin/types/SimpleType;Z)V", "delegate", "getDelegate", "()Lorg/jetbrains/kotlin/types/SimpleType;", "isMarkedNullable", "()Z", "isTypeParameter", "getOriginal", "makeNullableAsSpecified", "newNullability", "replaceAttributes", "newAttributes", "Lorg/jetbrains/kotlin/types/TypeAttributes;", "replaceDelegate", "substitutionResult", "Lorg/jetbrains/kotlin/types/KotlinType;", "replacement", "toString", "", "Companion", "descriptors"})
public final class DefinitelyNotNullType
extends DelegatingSimpleType
implements CustomTypeParameter,
DefinitelyNotNullTypeMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleType original;
    private final boolean useCorrectedNullabilityForTypeParameters;

    private DefinitelyNotNullType(SimpleType original, boolean useCorrectedNullabilityForTypeParameters) {
        this.original = original;
        this.useCorrectedNullabilityForTypeParameters = useCorrectedNullabilityForTypeParameters;
    }

    @NotNull
    public final SimpleType getOriginal() {
        return this.original;
    }

    @Override
    @NotNull
    protected SimpleType getDelegate() {
        return this.original;
    }

    @Override
    public boolean isMarkedNullable() {
        return false;
    }

    @Override
    public boolean isTypeParameter() {
        return this.getDelegate().getConstructor() instanceof NewTypeVariableConstructor || this.getDelegate().getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor;
    }

    @Override
    @NotNull
    public KotlinType substitutionResult(@NotNull KotlinType replacement) {
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        return SpecialTypesKt.makeDefinitelyNotNullOrNotNull(replacement.unwrap(), this.useCorrectedNullabilityForTypeParameters);
    }

    @Override
    @NotNull
    public SimpleType replaceAttributes(@NotNull TypeAttributes newAttributes) {
        Intrinsics.checkNotNullParameter((Object)newAttributes, (String)"newAttributes");
        return new DefinitelyNotNullType(this.getDelegate().replaceAttributes(newAttributes), this.useCorrectedNullabilityForTypeParameters);
    }

    @Override
    @NotNull
    public SimpleType makeNullableAsSpecified(boolean newNullability) {
        return newNullability ? this.getDelegate().makeNullableAsSpecified(newNullability) : (SimpleType)this;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getDelegate() + " & Any";
    }

    @Override
    @TypeRefinement
    @NotNull
    public DefinitelyNotNullType replaceDelegate(@NotNull SimpleType delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        return new DefinitelyNotNullType(delegate, this.useCorrectedNullabilityForTypeParameters);
    }

    public /* synthetic */ DefinitelyNotNullType(SimpleType original, boolean useCorrectedNullabilityForTypeParameters, DefaultConstructorMarker $constructor_marker) {
        this(original, useCorrectedNullabilityForTypeParameters);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u0007J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0002J\f\u0010\f\u001a\u00020\b*\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/types/DefinitelyNotNullType$Companion;", "", "()V", "makeDefinitelyNotNull", "Lorg/jetbrains/kotlin/types/DefinitelyNotNullType;", "type", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "useCorrectedNullabilityForTypeParameters", "", "avoidCheckingActualTypeNullability", "makesSenseToBeDefinitelyNotNull", "useCorrectedNullabilityForFlexibleTypeParameters", "canHaveUndefinedNullability", "descriptors"})
    public static final class Companion {
        private Companion() {
        }

        @JvmOverloads
        @Nullable
        public final DefinitelyNotNullType makeDefinitelyNotNull(@NotNull UnwrappedType type2, boolean useCorrectedNullabilityForTypeParameters, boolean avoidCheckingActualTypeNullability) {
            DefinitelyNotNullType definitelyNotNullType;
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            if (type2 instanceof DefinitelyNotNullType) {
                definitelyNotNullType = (DefinitelyNotNullType)type2;
            } else if (avoidCheckingActualTypeNullability || this.makesSenseToBeDefinitelyNotNull(type2, useCorrectedNullabilityForTypeParameters)) {
                if (type2 instanceof FlexibleType) {
                    boolean bl = Intrinsics.areEqual((Object)((FlexibleType)type2).getLowerBound().getConstructor(), (Object)((FlexibleType)type2).getUpperBound().getConstructor());
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl2 = false;
                        String string2 = "DefinitelyNotNullType for flexible type (" + type2 + ") can be created only from type variable with the same constructor for bounds";
                        throw new AssertionError((Object)string2);
                    }
                }
                definitelyNotNullType = new DefinitelyNotNullType(FlexibleTypesKt.lowerIfFlexible(type2).makeNullableAsSpecified(false), useCorrectedNullabilityForTypeParameters, null);
            } else {
                definitelyNotNullType = null;
            }
            return definitelyNotNullType;
        }

        public static /* synthetic */ DefinitelyNotNullType makeDefinitelyNotNull$default(Companion companion, UnwrappedType unwrappedType, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return companion.makeDefinitelyNotNull(unwrappedType, bl, bl2);
        }

        private final boolean makesSenseToBeDefinitelyNotNull(UnwrappedType type2, boolean useCorrectedNullabilityForFlexibleTypeParameters) {
            if (!this.canHaveUndefinedNullability(type2)) {
                return false;
            }
            if (type2 instanceof StubTypeForBuilderInference) {
                return TypeUtils.isNullableType(type2);
            }
            ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
            TypeParameterDescriptorImpl typeParameterDescriptorImpl = classifierDescriptor instanceof TypeParameterDescriptorImpl ? (TypeParameterDescriptorImpl)classifierDescriptor : null;
            boolean bl = typeParameterDescriptorImpl != null ? !typeParameterDescriptorImpl.isInitialized() : false;
            if (bl) {
                return true;
            }
            if (useCorrectedNullabilityForFlexibleTypeParameters && type2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
                return TypeUtils.isNullableType(type2);
            }
            return !NullabilityChecker.INSTANCE.isSubtypeOfAny(type2);
        }

        private final boolean canHaveUndefinedNullability(UnwrappedType $this$canHaveUndefinedNullability) {
            return $this$canHaveUndefinedNullability.getConstructor() instanceof NewTypeVariableConstructor || $this$canHaveUndefinedNullability.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor || $this$canHaveUndefinedNullability instanceof NewCapturedType || $this$canHaveUndefinedNullability instanceof StubTypeForBuilderInference;
        }

        @JvmOverloads
        @Nullable
        public final DefinitelyNotNullType makeDefinitelyNotNull(@NotNull UnwrappedType type2, boolean useCorrectedNullabilityForTypeParameters) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return org.jetbrains.kotlin.types.DefinitelyNotNullType$Companion.makeDefinitelyNotNull$default(this, type2, useCorrectedNullabilityForTypeParameters, false, 4, null);
        }

        @JvmOverloads
        @Nullable
        public final DefinitelyNotNullType makeDefinitelyNotNull(@NotNull UnwrappedType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return org.jetbrains.kotlin.types.DefinitelyNotNullType$Companion.makeDefinitelyNotNull$default(this, type2, false, false, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

