/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.coroutine;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.CoroutineMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.coroutine.CoroutineBlock;
import org.jetbrains.kotlin.js.coroutine.CoroutineBodyTransformer;
import org.jetbrains.kotlin.js.coroutine.CoroutinePassesKt;
import org.jetbrains.kotlin.js.coroutine.CoroutineTransformationContext;
import org.jetbrains.kotlin.js.inline.clean.FunctionPostProcessor;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J4\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0002J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\nH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010 \u001a\u00020\nH\u0002J,\u0010\"\u001a\u00020\u00102\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\b\u0010$\u001a\u00020%H\u0002J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bJ\b\u0010'\u001a\u00020\u0010H\u0002J,\u0010(\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002J\"\u0010.\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+H\u0002J\f\u0010/\u001a\u00020\u0010*\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/js/coroutine/CoroutineFunctionTransformer;", "", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "name", "", "(Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;Ljava/lang/String;)V", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "className", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "functionWithBody", "innerFunction", "localVariables", "", "generateContinuationConstructor", "", "context", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineTransformationContext;", "statements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "globalCatchBlockIndex", "", "survivingLocalVars", "", "generateCoroutineBody", "", "blocks", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "generateCoroutineInstantiation", "generateCoroutineMetadata", "constructorName", "generateCoroutinePrototype", "generateDoResume", "coroutineBlocks", "isTailCall", "", "transform", "transformSimple", "assignToField", "fieldName", "value", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "psiElement", "Lcom/intellij/psi/PsiElement;", "assignToPrototype", "collectAdditionalLocalVariables", "js.translator"})
@SourceDebugExtension(value={"SMAP\nCoroutineFunctionTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineFunctionTransformer.kt\norg/jetbrains/kotlin/js/coroutine/CoroutineFunctionTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n1855#2,2:321\n1855#2,2:323\n1549#2:325\n1620#2,3:326\n1855#2,2:329\n1549#2:332\n1620#2,3:333\n1549#2:336\n1620#2,3:337\n1549#2:340\n1620#2,3:341\n1549#2:344\n1620#2,3:345\n1549#2:348\n1620#2,3:349\n1#3:331\n*S KotlinDebug\n*F\n+ 1 CoroutineFunctionTransformer.kt\norg/jetbrains/kotlin/js/coroutine/CoroutineFunctionTransformer\n*L\n50#1:321,2\n54#1:323,2\n57#1:325\n57#1:326,3\n58#1:329,2\n143#1:332\n143#1:333,3\n156#1:336\n156#1:337,3\n156#1:340\n156#1:341,3\n233#1:344\n233#1:345,3\n281#1:348\n281#1:349,3\n*E\n"})
public final class CoroutineFunctionTransformer {
    @NotNull
    private final JsFunction function;
    @Nullable
    private final JsFunction innerFunction;
    @NotNull
    private final JsFunction functionWithBody;
    @NotNull
    private final JsBlock body;
    @NotNull
    private final Set<JsName> localVariables;
    @NotNull
    private final JsName className;

    public CoroutineFunctionTransformer(@NotNull JsFunction function2, @Nullable String name2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        this.function = function2;
        this.innerFunction = FunctionUtilsKt.getInnerFunction(this.function);
        JsFunction jsFunction = this.innerFunction;
        if (jsFunction == null) {
            jsFunction = this.function;
        }
        this.functionWithBody = jsFunction;
        JsBlock jsBlock = this.functionWithBody.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"functionWithBody.body");
        this.body = jsBlock;
        Set set = SetsKt.plus((Set)CollectUtilsKt.collectLocalVariables$default(this.function, false, 1, null), (Iterable)CollectUtilsKt.collectLocalVariables$default(this.functionWithBody, false, 1, null));
        List<JsParameter> list2 = this.functionWithBody.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"functionWithBody.parameters");
        JsName jsName = ((JsParameter)CollectionsKt.last(list2)).getName();
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"functionWithBody.parameters.last().name");
        this.localVariables = CollectionsKt.toMutableSet((Iterable)SetsKt.minus((Set)set, (Object)jsName));
        StringBuilder stringBuilder2 = new StringBuilder().append("Coroutine$");
        String string2 = name2;
        if (string2 == null) {
            string2 = "anonymous";
        }
        JsName jsName2 = JsScope.declareTemporaryName(stringBuilder2.append(string2).toString());
        Intrinsics.checkNotNullExpressionValue((Object)jsName2, (String)"declareTemporaryName(\"Co\u2026$${name ?: \"anonymous\"}\")");
        this.className = jsName2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JsStatement> transform() {
        Collection<JsName> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (this.isTailCall() && !MetadataProperties.getForceStateMachine(this.function)) {
            this.transformSimple();
            return CollectionsKt.emptyList();
        }
        JsFunctionScope jsFunctionScope = this.function.getScope();
        Intrinsics.checkNotNullExpressionValue((Object)jsFunctionScope, (String)"function.scope");
        CoroutineTransformationContext context = new CoroutineTransformationContext(jsFunctionScope, this.function);
        CoroutineBodyTransformer bodyTransformer = new CoroutineBodyTransformer(context);
        bodyTransformer.preProcess(this.body);
        List<JsStatement> list2 = this.body.getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"body.statements");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsStatement it = (JsStatement)element$iv;
            boolean bl = false;
            it.accept(bodyTransformer);
        }
        List<CoroutineBlock> coroutineBlocks = bodyTransformer.postProcess();
        int globalCatchBlockIndex = coroutineBlocks.indexOf(context.getGlobalCatchBlock());
        Iterable $this$forEach$iv2 = coroutineBlocks;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CoroutineBlock it = (CoroutineBlock)element$iv;
            boolean bl = false;
            this.collectAdditionalLocalVariables(it.getJsBlock());
        }
        List<JsParameter> list3 = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"function.parameters");
        Iterable $i$f$forEach22 = list3;
        Set<JsName> set = this.localVariables;
        List<CoroutineBlock> list4 = coroutineBlocks;
        boolean $i$f$map = false;
        void element$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        Set<JsName> survivingLocalVars = CoroutinePassesKt.collectVariablesSurvivingBetweenBlocks(list4, set, CollectionsKt.toSet((Iterable)collection));
        Iterable $this$forEach$iv3 = coroutineBlocks;
        boolean $i$f$forEach3 = false;
        for (Object element$iv2 : $this$forEach$iv3) {
            CoroutineBlock it = (CoroutineBlock)element$iv2;
            boolean bl = false;
            CoroutinePassesKt.replaceLocalVariables(it.getJsBlock(), context, survivingLocalVars);
        }
        List additionalStatements2 = new ArrayList();
        this.generateDoResume(coroutineBlocks, context, additionalStatements2);
        this.generateContinuationConstructor(context, additionalStatements2, globalCatchBlockIndex, survivingLocalVars);
        this.generateCoroutineInstantiation(context);
        return additionalStatements2;
    }

    private final boolean isTailCall() {
        HashSet<JsExpression> suspendCalls = new HashSet<JsExpression>();
        this.body.accept(new RecursiveJsVisitor(suspendCalls){
            final /* synthetic */ HashSet<JsExpression> $suspendCalls;
            {
                this.$suspendCalls = $suspendCalls;
            }

            protected void visitElement(@NotNull JsNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node instanceof JsExpression && MetadataProperties.isSuspend((JsExpression)node)) {
                    ((Collection)this.$suspendCalls).add(node);
                }
                super.visitElement(node);
            }
        });
        if (suspendCalls.isEmpty()) {
            return true;
        }
        this.body.accept(new RecursiveJsVisitor(this, suspendCalls){
            final /* synthetic */ CoroutineFunctionTransformer this$0;
            final /* synthetic */ HashSet<JsExpression> $suspendCalls;
            {
                this.this$0 = $receiver;
                this.$suspendCalls = $suspendCalls;
            }

            public void visitBlock(@NotNull JsBlock x) {
                block6: {
                    JsExpression suspendExpression;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                        super.visitBlock(x);
                        if (CoroutineFunctionTransformer.access$getBody$p(this.this$0).getStatements().size() < 2) {
                            return;
                        }
                        List<JsStatement> list2 = CoroutineFunctionTransformer.access$getBody$p(this.this$0).getStatements();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"body.statements");
                        Object object = CollectionsKt.last(list2);
                        JsReturn jsReturn = object instanceof JsReturn ? (JsReturn)object : null;
                        if (jsReturn == null) {
                            return;
                        }
                        JsReturn lastStatement2 = jsReturn;
                        if (!CoroutinePassesKt.isStateMachineResult(lastStatement2.getExpression())) {
                            return;
                        }
                        List<JsStatement> list3 = CoroutineFunctionTransformer.access$getBody$p(this.this$0).getStatements();
                        List<JsStatement> list4 = CoroutineFunctionTransformer.access$getBody$p(this.this$0).getStatements();
                        Intrinsics.checkNotNullExpressionValue(list4, (String)"body.statements");
                        JsStatement jsStatement = list3.get(CollectionsKt.getLastIndex(list4) - 1);
                        JsExpressionStatement jsExpressionStatement = jsStatement instanceof JsExpressionStatement ? (JsExpressionStatement)jsStatement : null;
                        if (jsExpressionStatement == null) {
                            return;
                        }
                        JsExpressionStatement statementBeforeLast = jsExpressionStatement;
                        JsExpression jsExpression = statementBeforeLast.getExpression();
                        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"statementBeforeLast.expression");
                        suspendExpression = jsExpression;
                        if (!this.$suspendCalls.contains(suspendExpression)) break block5;
                        ((Collection)this.$suspendCalls).remove(suspendExpression);
                        break block6;
                    }
                    Pair<JsExpression, JsExpression> pair = JsAstUtils.decomposeAssignment(suspendExpression);
                    if (pair == null) break block6;
                    Pair<JsExpression, JsExpression> pair2 = pair;
                    HashSet<JsExpression> hashSet = this.$suspendCalls;
                    Pair<JsExpression, JsExpression> pair3 = pair2;
                    boolean bl = false;
                    JsExpression lhs = (JsExpression)pair3.component1();
                    JsExpression rhs = (JsExpression)pair3.component2();
                    if (hashSet.contains(rhs) && CoroutinePassesKt.isStateMachineResult(lhs)) {
                        ((Collection)hashSet).remove(rhs);
                    }
                }
            }
        });
        return suspendCalls.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final void transformSimple() {
        void $this$transformSimple_u24lambda_u244;
        JsVars jsVars;
        List<JsParameter> list2 = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"function.parameters");
        JsParameter continuationParam = (JsParameter)CollectionsKt.last(list2);
        JsName jsName = JsScope.declareTemporaryName("$result");
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"declareTemporaryName(\"\\$result\")");
        JsName resultVar = jsName;
        Intrinsics.checkNotNullExpressionValue((Object)continuationParam, (String)"continuationParam");
        CoroutinePassesKt.replaceSpecialReferencesInSimpleFunction(this.body, continuationParam, resultVar);
        JsVars jsVars2 = jsVars = JsAstUtils.newVar(resultVar, null);
        int n = 0;
        List<JsStatement> list3 = this.body.getStatements();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$transformSimple_u24lambda_u244, (String)"transformSimple$lambda$4");
        MetadataProperties.setSynthetic((HasMetadata)$this$transformSimple_u24lambda_u244, true);
        Unit unit = Unit.INSTANCE;
        list3.add(n, jsVars);
        new JsVisitorWithContextImpl(resultVar){
            final /* synthetic */ JsName $resultVar;
            {
                this.$resultVar = $resultVar;
            }

            public void endVisit(@NotNull JsExpressionStatement x, @NotNull JsContext<? super JsStatement> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.expression");
                if (MetadataProperties.isSuspend(jsExpression)) {
                    ctx.replaceMe((JsNode)JsAstUtils.assignment(JsAstUtils.pureFqn(this.$resultVar, null), x.getExpression()).source(x.getSource()).makeStmt());
                }
                super.endVisit(x, ctx);
            }
        }.accept((JsNode)this.body);
        new FunctionPostProcessor(this.functionWithBody).apply();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateContinuationConstructor(CoroutineTransformationContext context, List<JsStatement> statements, int globalCatchBlockIndex, Set<? extends JsName> survivingLocalVars) {
        List list2;
        List list3;
        Iterable $this$mapTo$iv$iv;
        JsName jsName;
        JsName lastParameter;
        Collection collection;
        void $this$mapTo$iv$iv2;
        PsiElement psiElement = context.getMetadata().getPsiElement();
        JsFunction constructor = new JsFunction(this.function.getScope().getParent(), new JsBlock(), "Continuation");
        constructor.setSource(psiElement);
        PsiElement psiElement2 = psiElement;
        Object object = psiElement2 != null ? UtilsKt.getFinalElement(psiElement2) : null;
        constructor.getBody().setSource(object instanceof LeafPsiElement ? (LeafPsiElement)object : null);
        constructor.setName(this.className);
        if (context.getMetadata().getHasReceiver()) {
            List<JsParameter> list4 = constructor.getParameters();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"constructor.parameters");
            object = list4;
            object.add(new JsParameter(context.getReceiverFieldName()));
        }
        List<JsParameter> list5 = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue(list5, (String)"function.parameters");
        Collection collection2 = list5;
        JsFunction jsFunction = this.innerFunction;
        List list6 = jsFunction != null ? jsFunction.getParameters() : null;
        if (list6 == null) {
            list6 = CollectionsKt.emptyList();
        }
        List parameters2 = CollectionsKt.plus((Collection)collection2, (Iterable)list6);
        List<JsParameter> list7 = constructor.getParameters();
        Intrinsics.checkNotNullExpressionValue(list7, (String)"constructor.parameters");
        Collection collection3 = list7;
        Iterable $this$map$iv = parameters2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new JsParameter(it.getName()));
        }
        $this$map$iv = (List)destination$iv$iv2;
        CollectionsKt.addAll((Collection)collection3, (Iterable)$this$map$iv);
        JsParameter jsParameter = (JsParameter)CollectionsKt.lastOrNull((List)parameters2);
        JsName jsName2 = lastParameter = jsParameter != null ? jsParameter.getName() : null;
        if (context.getMetadata().getHasController()) {
            JsName $this$generateContinuationConstructor_u24lambda_u246 = $i$f$map = JsScope.declareTemporaryName("controller");
            boolean bl = false;
            List<JsParameter> list8 = constructor.getParameters();
            List<JsParameter> list9 = constructor.getParameters();
            Intrinsics.checkNotNullExpressionValue(list9, (String)"constructor.parameters");
            list8.add(CollectionsKt.getLastIndex(list9), new JsParameter($this$generateContinuationConstructor_u24lambda_u246));
            jsName = $i$f$map;
        } else {
            jsName = null;
        }
        JsName controllerName = jsName;
        JsName jsName3 = lastParameter;
        Intrinsics.checkNotNull((Object)jsName3);
        JsNameRef jsNameRef = jsName3.makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"lastParameter!!.makeRef()");
        JsNameRef interceptorRef = jsNameRef;
        List<JsParameter> list10 = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue(list10, (String)"function.parameters");
        Iterable $this$map$iv2 = list10;
        boolean $i$f$map2 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo222 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsParameter jsParameter2 = (JsParameter)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(it.getName());
        }
        Collection collection4 = (List)destination$iv$iv3;
        Object object2 = this.innerFunction;
        if (object2 != null && (object2 = ((JsFunction)object2).getParameters()) != null) {
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            $this$mapTo$iv$iv = (Iterable)object2;
            collection = collection4;
            boolean $i$f$map3 = false;
            void $i$f$mapTo222 = $this$map$iv3;
            Collection collection5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                JsParameter jsParameter3 = (JsParameter)item$iv$iv;
                Collection collection6 = collection5;
                boolean bl = false;
                collection6.add(it.getName());
            }
            list3 = (List)collection5;
            collection4 = collection;
        } else {
            list3 = list2 = null;
        }
        if (list3 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Set parameterNames = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)collection4, (Iterable)list2));
        List<JsStatement> $this$generateContinuationConstructor_u24lambda_u249 = constructor.getBody().getStatements();
        boolean bl = false;
        JsExpression jsExpression = context.getMetadata().getBaseClassRef().deepCopy();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"context.metadata.baseClassRef.deepCopy()");
        JsExpression baseClass = jsExpression;
        Intrinsics.checkNotNullExpressionValue($this$generateContinuationConstructor_u24lambda_u249, (String)"this");
        Collection collection5 = $this$generateContinuationConstructor_u24lambda_u249;
        JsExpression[] jsExpressionArray = new JsExpression[]{new JsThisRef(), interceptorRef};
        collection5.add(((JsExpression)new JsInvocation((JsExpression)Namer.getFunctionCallRef(baseClass), jsExpressionArray).source(psiElement)).makeStmt());
        if (controllerName != null) {
            JsName jsName4 = context.getControllerFieldName();
            Intrinsics.checkNotNullExpressionValue((Object)jsName4, (String)"context.controllerFieldName");
            JsNameRef jsNameRef2 = controllerName.makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef2, (String)"controllerName.makeRef()");
            this.assignToField($this$generateContinuationConstructor_u24lambda_u249, jsName4, jsNameRef2, psiElement);
        }
        this.assignToField($this$generateContinuationConstructor_u24lambda_u249, context.getMetadata().getExceptionStateName(), new JsIntLiteral(globalCatchBlockIndex), psiElement);
        if (context.getMetadata().getHasReceiver()) {
            JsName jsName5 = context.getReceiverFieldName();
            Intrinsics.checkNotNullExpressionValue((Object)jsName5, (String)"context.receiverFieldName");
            JsNameRef jsNameRef3 = context.getReceiverFieldName().makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef3, (String)"context.receiverFieldName.makeRef()");
            this.assignToField($this$generateContinuationConstructor_u24lambda_u249, jsName5, jsNameRef3, psiElement);
        }
        for (JsName jsName6 : survivingLocalVars) {
            JsExpression value2;
            Intrinsics.checkNotNullExpressionValue((Object)(!parameterNames.contains(jsName6) ? Namer.getUndefinedExpression() : (JsExpression)jsName6.makeRef()), (String)"if (localVariable !in pa\u2026e localVariable.makeRef()");
            value2 = value2;
            this.assignToField($this$generateContinuationConstructor_u24lambda_u249, context.getFieldName(jsName6), value2, psiElement);
        }
        Object[] objectArray = new JsStatement[2];
        objectArray[0] = constructor.makeStmt();
        JsName jsName7 = constructor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)jsName7, (String)"constructor.name");
        objectArray[1] = this.generateCoroutineMetadata(jsName7);
        Collection collection7 = CollectionsKt.listOf((Object[])objectArray);
        JsName jsName8 = constructor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)jsName8, (String)"constructor.name");
        statements.addAll(0, CollectionsKt.plus((Collection)collection7, (Iterable)this.generateCoroutinePrototype(jsName8)));
    }

    private final List<JsStatement> generateCoroutinePrototype(JsName constructorName) {
        JsExpression jsExpression = JsAstUtils.prototypeOf(new JsNameRef(constructorName));
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"prototypeOf(JsNameRef(constructorName))");
        JsExpression prototype = jsExpression;
        CoroutineMetadata coroutineMetadata = MetadataProperties.getCoroutineMetadata(this.function);
        Intrinsics.checkNotNull((Object)coroutineMetadata);
        JsInvocation jsInvocation = Namer.createObjectWithPrototypeFrom(coroutineMetadata.getBaseClassRef().deepCopy());
        Intrinsics.checkNotNullExpressionValue((Object)jsInvocation, (String)"createObjectWithPrototyp\u2026.baseClassRef.deepCopy())");
        JsInvocation baseClass = jsInvocation;
        JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(prototype, baseClass);
        Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperation, (String)"assignment(prototype, baseClass)");
        JsBinaryOperation assignPrototype = jsBinaryOperation;
        JsBinaryOperation jsBinaryOperation2 = JsAstUtils.assignment(new JsNameRef("constructor", prototype.deepCopy()), new JsNameRef(constructorName));
        Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperation2, (String)"assignment(JsNameRef(\"co\u2026NameRef(constructorName))");
        JsBinaryOperation assignConstructor = jsBinaryOperation2;
        Object[] objectArray = new JsStatement[2];
        Intrinsics.checkNotNullExpressionValue((Object)assignPrototype.makeStmt(), (String)"assignPrototype.makeStmt()");
        Intrinsics.checkNotNullExpressionValue((Object)assignConstructor.makeStmt(), (String)"assignConstructor.makeStmt()");
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final JsStatement generateCoroutineMetadata(JsName constructorName) {
        JsObjectLiteral jsObjectLiteral;
        CoroutineMetadata coroutineMetadata = MetadataProperties.getCoroutineMetadata(this.function);
        Intrinsics.checkNotNull((Object)coroutineMetadata);
        JsExpression jsExpression = coroutineMetadata.getBaseClassRef().deepCopy();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"function.coroutineMetada\u2026!.baseClassRef.deepCopy()");
        JsExpression baseClassRefRef = jsExpression;
        JsObjectLiteral $this$generateCoroutineMetadata_u24lambda_u2410 = jsObjectLiteral = new JsObjectLiteral(true);
        boolean bl = false;
        List<JsPropertyInitializer> list2 = $this$generateCoroutineMetadata_u24lambda_u2410.getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"propertyInitializers");
        Collection collection = list2;
        JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(new JsNameRef("kind"), new JsNameRef("CLASS", (JsExpression)new JsNameRef("Kind", "Kotlin")));
        collection.add(jsPropertyInitializer);
        List<JsPropertyInitializer> list3 = $this$generateCoroutineMetadata_u24lambda_u2410.getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"propertyInitializers");
        collection = list3;
        collection.add(new JsPropertyInitializer(new JsNameRef("simpleName"), new JsNullLiteral()));
        List<JsPropertyInitializer> list4 = $this$generateCoroutineMetadata_u24lambda_u2410.getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(list4, (String)"propertyInitializers");
        collection = list4;
        collection.add(new JsPropertyInitializer(new JsNameRef("interfaces"), new JsArrayLiteral(CollectionsKt.listOf((Object)baseClassRefRef))));
        JsObjectLiteral metadataObject = jsObjectLiteral;
        JsStatement jsStatement = JsAstUtils.assignment(new JsNameRef("$metadata$", (JsExpression)constructorName.makeRef()), metadataObject).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"assignment(JsNameRef(Nam\u2026etadataObject).makeStmt()");
        return jsStatement;
    }

    private final void generateDoResume(List<CoroutineBlock> coroutineBlocks, CoroutineTransformationContext context, List<JsStatement> statements) {
        List<JsStatement> list2;
        List<JsStatement> list3;
        JsFunction resumeFunction = new JsFunction(this.function.getScope().getParent(), new JsBlock(), "resume function");
        PsiElement psi = context.getMetadata().getPsiElement();
        resumeFunction.setSource(psi);
        PsiElement psiElement = psi;
        PsiElement psiElement2 = psiElement != null ? UtilsKt.getFinalElement(psiElement) : null;
        resumeFunction.getBody().setSource(psiElement2 instanceof LeafPsiElement ? (LeafPsiElement)psiElement2 : null);
        List<JsStatement> coroutineBody = this.generateCoroutineBody(context, coroutineBlocks);
        this.functionWithBody.getBody().getStatements().clear();
        List<JsStatement> $this$generateDoResume_u24lambda_u2411 = list3 = resumeFunction.getBody().getStatements();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue($this$generateDoResume_u24lambda_u2411, (String)"this");
        CollectionsKt.addAll((Collection)$this$generateDoResume_u24lambda_u2411, (Iterable)coroutineBody);
        JsName resumeName = context.getMetadata().getDoResumeName();
        List<JsStatement> $this$generateDoResume_u24lambda_u2412 = list2 = statements;
        boolean bl2 = false;
        this.assignToPrototype($this$generateDoResume_u24lambda_u2412, resumeName, resumeFunction);
        new FunctionPostProcessor(resumeFunction).apply();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateCoroutineInstantiation(CoroutineTransformationContext context) {
        void $this$mapTo$iv$iv;
        Object object;
        PsiElement psiElement = context.getMetadata().getPsiElement();
        Object $this$generateCoroutineInstantiation_u24lambda_u2413 = object = new JsNew(this.className.makeRef());
        boolean bl = false;
        ((SourceInfoAwareJsNode)$this$generateCoroutineInstantiation_u24lambda_u2413).setSource(psiElement);
        JsNew instantiation = object;
        if (context.getMetadata().getHasReceiver()) {
            List<JsExpression> list2 = instantiation.getArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"instantiation.arguments");
            object = list2;
            object.add(new JsThisRef());
        }
        List<JsParameter> list3 = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"function.parameters");
        Collection collection = list3;
        JsFunction jsFunction = this.innerFunction;
        List list4 = jsFunction != null ? jsFunction.getParameters() : null;
        if (list4 == null) {
            list4 = CollectionsKt.emptyList();
        }
        List parameters2 = CollectionsKt.plus((Collection)collection, (Iterable)list4);
        List<JsExpression> list5 = instantiation.getArguments();
        Intrinsics.checkNotNullExpressionValue(list5, (String)"instantiation.arguments");
        $this$generateCoroutineInstantiation_u24lambda_u2413 = list5;
        JsExpression[] $this$map$iv = (JsExpression[])CollectionsKt.dropLast((List)parameters2, (int)1);
        boolean $i$f$map22 = false;
        JsExpression[] jsExpressionArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(it.getName().makeRef());
        }
        $this$map$iv = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)$this$generateCoroutineInstantiation_u24lambda_u2413, (Iterable)$this$map$iv);
        CoroutineMetadata coroutineMetadata = MetadataProperties.getCoroutineMetadata(this.function);
        Intrinsics.checkNotNull((Object)coroutineMetadata);
        if (coroutineMetadata.getHasController()) {
            List<JsExpression> list6 = instantiation.getArguments();
            Intrinsics.checkNotNullExpressionValue(list6, (String)"instantiation.arguments");
            $this$generateCoroutineInstantiation_u24lambda_u2413 = list6;
            $this$generateCoroutineInstantiation_u24lambda_u2413.add(new JsThisRef());
        }
        List<JsExpression> list7 = instantiation.getArguments();
        Intrinsics.checkNotNullExpressionValue(list7, (String)"instantiation.arguments");
        $this$generateCoroutineInstantiation_u24lambda_u2413 = list7;
        $this$generateCoroutineInstantiation_u24lambda_u2413.add(((JsParameter)CollectionsKt.last((List)parameters2)).getName().makeRef());
        JsName jsName = JsScope.declareTemporaryName("suspended");
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"declareTemporaryName(\"suspended\")");
        JsName suspendedName = jsName;
        List<JsParameter> list8 = this.functionWithBody.getParameters();
        Intrinsics.checkNotNullExpressionValue(list8, (String)"functionWithBody.parameters");
        Collection $i$f$map22 = list8;
        $i$f$map22.add(new JsParameter(suspendedName));
        JsName jsName2 = JsScope.declareTemporaryName("instance");
        Intrinsics.checkNotNullExpressionValue((Object)jsName2, (String)"declareTemporaryName(\"instance\")");
        JsName instanceName = jsName2;
        List<JsStatement> list9 = this.functionWithBody.getBody().getStatements();
        Intrinsics.checkNotNullExpressionValue(list9, (String)"functionWithBody.body.statements");
        jsExpressionArray = list9;
        jsExpressionArray.add(JsAstUtils.newVar(instanceName, instantiation));
        jsExpressionArray = new JsExpression[]{new JsNullLiteral()};
        JsReturn invokeResume = new JsReturn((JsExpression)new JsInvocation((JsExpression)new JsNameRef(context.getMetadata().getDoResumeName(), (JsExpression)instanceName.makeRef()), jsExpressionArray).source(psiElement));
        List<JsStatement> list10 = this.functionWithBody.getBody().getStatements();
        Intrinsics.checkNotNullExpressionValue(list10, (String)"functionWithBody.body.statements");
        Collection collection3 = list10;
        collection3.add(new JsIf(suspendedName.makeRef().source(psiElement), new JsReturn(instanceName.makeRef().source(psiElement)), invokeResume));
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsStatement> generateCoroutineBody(CoroutineTransformationContext context, List<CoroutineBlock> blocks) {
        void $this$mapTo$iv$iv;
        int indexOfGlobalCatch = blocks.indexOf(context.getGlobalCatchBlock());
        JsNameRef stateRef = new JsNameRef(context.getMetadata().getStateName(), (JsExpression)new JsThisRef());
        JsNameRef exceptionStateRef = new JsNameRef(context.getMetadata().getExceptionStateName(), (JsExpression)new JsThisRef());
        JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(stateRef, new JsIntLiteral(indexOfGlobalCatch));
        Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperation, (String)"equality(stateRef, JsInt\u2026eral(indexOfGlobalCatch))");
        JsBinaryOperation isFromGlobalCatch = jsBinaryOperation;
        JsCatch jsCatch = new JsCatch(this.functionWithBody.getScope(), "e");
        JsStatement[] jsStatementArray = new JsStatement[]{JsAstUtils.assignment(stateRef.deepCopy(), exceptionStateRef.deepCopy()).makeStmt(), JsAstUtils.assignment(new JsNameRef(context.getMetadata().getExceptionName(), (JsExpression)new JsThisRef()), jsCatch.getParameter().getName().makeRef()).makeStmt()};
        JsBlock continueWithException = new JsBlock(jsStatementArray);
        JsStatement jsStatement = JsAstUtils.assignment(exceptionStateRef.deepCopy(), stateRef.deepCopy()).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"assignment(exceptionStat\u2026ef.deepCopy()).makeStmt()");
        JsStatement adjustExceptionState = jsStatement;
        JsStatement[] jsStatementArray2 = new JsStatement[]{adjustExceptionState, new JsThrow(jsCatch.getParameter().getName().makeRef())};
        jsCatch.setBody(new JsBlock((JsStatement)new JsIf(isFromGlobalCatch, new JsBlock(jsStatementArray2), continueWithException)));
        JsNameRef throwResultRef = new JsNameRef(context.getMetadata().getExceptionName(), (JsExpression)new JsThisRef());
        ((Collection)context.getGlobalCatchBlock().getStatements()).add(new JsThrow(throwResultRef));
        Iterable $this$map$iv = CollectionsKt.withIndex((Iterable)blocks);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JsCase jsCase;
            IndexedValue indexedValue = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int index2 = indexedValue.component1();
            CoroutineBlock block = (CoroutineBlock)indexedValue.component2();
            JsCase $this$generateCoroutineBody_u24lambda_u2416_u24lambda_u2415 = jsCase = new JsCase();
            boolean bl2 = false;
            $this$generateCoroutineBody_u24lambda_u2416_u24lambda_u2415.setCaseExpression(new JsIntLiteral(index2));
            List<JsStatement> list2 = $this$generateCoroutineBody_u24lambda_u2416_u24lambda_u2415.getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"statements");
            Collection collection2 = list2;
            CollectionsKt.addAll((Collection)collection2, (Iterable)block.getStatements());
            collection.add(jsCase);
        }
        List cases = (List)destination$iv$iv;
        JsDefault $this$generateCoroutineBody_u24lambda_u2417 = $i$f$map = new JsDefault();
        boolean bl = false;
        JsStatement[] jsStatementArray3 = new JsStatement[]{JsAstUtils.assignment(stateRef, new JsIntLiteral(indexOfGlobalCatch)).makeStmt(), new JsThrow(new JsNew(new JsNameRef("Error"), CollectionsKt.listOf((Object)new JsStringLiteral("State Machine Unreachable execution"))))};
        JsBlock block = new JsBlock(jsStatementArray3);
        List<JsStatement> list3 = $this$generateCoroutineBody_u24lambda_u2417.getStatements();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"statements");
        ((Collection)list3).add(block);
        JsDefault defaultCase = $i$f$map;
        JsSwitch switchStatement = new JsSwitch(stateRef.deepCopy(), CollectionsKt.plus((Collection)cases, (Object)defaultCase));
        JsDoWhile loop = new JsDoWhile(new JsBooleanLiteral(true), new JsTry(new JsBlock((JsStatement)switchStatement), jsCatch, null));
        return CollectionsKt.listOf((Object)loop);
    }

    private final void collectAdditionalLocalVariables(JsBlock $this$collectAdditionalLocalVariables) {
        $this$collectAdditionalLocalVariables.accept(new RecursiveJsVisitor(this){
            final /* synthetic */ CoroutineFunctionTransformer this$0;
            {
                this.this$0 = $receiver;
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                super.visit(x);
                ((Collection)CoroutineFunctionTransformer.access$getLocalVariables$p(this.this$0)).add(x.getName());
            }
        });
    }

    private final void assignToField(List<JsStatement> $this$assignToField, JsName fieldName, JsExpression value2, PsiElement psiElement) {
        ((Collection)$this$assignToField).add(JsAstUtils.assignment(new JsNameRef(fieldName, (JsExpression)new JsThisRef()), value2).source(psiElement).makeStmt());
    }

    private final void assignToPrototype(List<JsStatement> $this$assignToPrototype, JsName fieldName, JsExpression value2) {
        ((Collection)$this$assignToPrototype).add(JsAstUtils.assignment(new JsNameRef(fieldName, JsAstUtils.prototypeOf(this.className.makeRef())), value2).makeStmt());
    }

    public static final /* synthetic */ JsBlock access$getBody$p(CoroutineFunctionTransformer $this) {
        return $this.body;
    }

    public static final /* synthetic */ Set access$getLocalVariables$p(CoroutineFunctionTransformer $this) {
        return $this.localVariables;
    }
}

