/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.coroutine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDebugger;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.coroutine.CoroutineBlock;
import org.jetbrains.kotlin.js.coroutine.CoroutineMetadataPropertiesKt;
import org.jetbrains.kotlin.js.coroutine.CoroutinePassesKt;
import org.jetbrains.kotlin.js.coroutine.CoroutineTransformationContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002deB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0&2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020 H\u0002J\b\u0010)\u001a\u00020*H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020,H\u0002J\u0018\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020,H\u0002J\b\u00101\u001a\u00020\u001aH\u0002J\b\u00102\u001a\u00020\u0007H\u0002J \u00103\u001a\u00020*2\u0006\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u00020\r2\u0006\u0010(\u001a\u00020 H\u0002J\f\u00106\u001a\b\u0012\u0004\u0012\u00020\r0&J\u000e\u00107\u001a\u00020*2\u0006\u00108\u001a\u00020 J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\r0&2\u0006\u00104\u001a\u00020\u0014H\u0002J\u001f\u0010:\u001a\u00020*2\u0006\u0010;\u001a\u00020\b2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020*0=H\u0082\bJ\u001e\u0010>\u001a\b\u0012\u0004\u0012\u00020\b0&2\u0006\u0010'\u001a\u00020\r2\u0006\u0010?\u001a\u00020 H\u0002J\u001e\u0010@\u001a\b\u0012\u0004\u0012\u00020\b0&2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020 H\u0002J\u001c\u0010A\u001a\b\u0012\u0004\u0012\u00020\b0&2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\r0&H\u0002J\u0010\u0010C\u001a\u00020*2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020*2\u0006\u0010D\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020*2\u0006\u0010D\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020*2\u0006\u0010D\u001a\u00020\u0007H\u0016J\u0010\u0010K\u001a\u00020*2\u0006\u0010D\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020*2\u0006\u0010D\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020*2\u0006\u0010D\u001a\u00020PH\u0016J\u0010\u0010Q\u001a\u00020*2\u0006\u0010D\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020*2\u0006\u0010D\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u00020*2\u0006\u0010D\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u00020*2\u0006\u0010D\u001a\u00020XH\u0016J\u0010\u0010Y\u001a\u00020*2\u0006\u0010D\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020*2\u0006\u0010D\u001a\u00020\\H\u0016J\u0010\u0010]\u001a\u00020*2\u0006\u0010D\u001a\u00020^H\u0016J\u0010\u0010_\u001a\u00020*2\u0006\u0010D\u001a\u00020`H\u0016J2\u0010a\u001a\u00020*2\u0006\u0010;\u001a\u00020\b2\u0006\u0010b\u001a\u00020\r2\n\b\u0002\u0010c\u001a\u0004\u0018\u00010\r2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020*0=H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lorg/jetbrains/kotlin/js/coroutine/CoroutineBodyTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "context", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineTransformationContext;", "(Lorg/jetbrains/kotlin/js/coroutine/CoroutineTransformationContext;)V", "breakContinueTargetStatements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "breakTargets", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBodyTransformer$JumpTarget;", "continueTargets", "currentBlock", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "currentCatchBlock", "currentStatements", "", "getCurrentStatements", "()Ljava/util/List;", "currentTryDepth", "", "getCurrentTryDepth", "()I", "entryBlock", "globalCatchBlock", "<set-?>", "", "hasFinallyBlocks", "getHasFinallyBlocks", "()Z", "nodesToSplit", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "referencedBlocks", "", "tryStack", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBodyTransformer$TryBlock;", "exceptionState", "", "target", "fromNode", "generateFinallyExit", "", "handleExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "expression", "handleSuspend", "invocation", "sourceNode", "hasEnclosingFinallyBlock", "jump", "jumpWithFinally", "targetTryDepth", "successor", "postProcess", "preProcess", "node", "relativeFinallyPath", "splitIfNecessary", "statement", "action", "Lkotlin/Function0;", "state", "fromExpression", "stateAndJump", "updateFinallyPath", "path", "visit", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsSwitch;", "visitBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "visitBreak", "Lorg/jetbrains/kotlin/js/backend/ast/JsBreak;", "visitContinue", "visitDebugger", "Lorg/jetbrains/kotlin/js/backend/ast/JsDebugger;", "visitDoWhile", "Lorg/jetbrains/kotlin/js/backend/ast/JsDoWhile;", "visitExpressionStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpressionStatement;", "visitFor", "Lorg/jetbrains/kotlin/js/backend/ast/JsFor;", "visitIf", "Lorg/jetbrains/kotlin/js/backend/ast/JsIf;", "visitLabel", "Lorg/jetbrains/kotlin/js/backend/ast/JsLabel;", "visitReturn", "Lorg/jetbrains/kotlin/js/backend/ast/JsReturn;", "visitThrow", "Lorg/jetbrains/kotlin/js/backend/ast/JsThrow;", "visitTry", "Lorg/jetbrains/kotlin/js/backend/ast/JsTry;", "visitVars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "visitWhile", "Lorg/jetbrains/kotlin/js/backend/ast/JsWhile;", "withBreakAndContinue", "breakBlock", "continueBlock", "JumpTarget", "TryBlock", "js.translator"})
@SourceDebugExtension(value={"SMAP\nCoroutineBodyTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineBodyTransformer.kt\norg/jetbrains/kotlin/js/coroutine/CoroutineBodyTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,462:1\n426#1,7:463\n426#1,7:470\n426#1,7:477\n426#1,7:484\n426#1,2:491\n430#1,3:494\n426#1,7:497\n426#1,7:504\n426#1,2:511\n430#1,3:519\n1#2:493\n1#2:532\n1855#3,2:513\n1855#3,2:515\n1855#3,2:517\n1603#3,9:522\n1855#3:531\n1856#3:533\n1612#3:534\n1747#3,3:535\n*S KotlinDebug\n*F\n+ 1 CoroutineBodyTransformer.kt\norg/jetbrains/kotlin/js/coroutine/CoroutineBodyTransformer\n*L\n62#1:463,7\n68#1:470,7\n91#1:477,7\n124#1:484,7\n137#1:491,2\n137#1:494,3\n155#1:497,7\n174#1:504,7\n241#1:511,2\n241#1:519,3\n453#1:532\n255#1:513,2\n282#1:515,2\n299#1:517,2\n453#1:522,9\n453#1:531\n453#1:533\n453#1:534\n456#1:535,3\n*E\n"})
public final class CoroutineBodyTransformer
extends RecursiveJsVisitor {
    @NotNull
    private final CoroutineTransformationContext context;
    @NotNull
    private final CoroutineBlock entryBlock;
    @NotNull
    private final CoroutineBlock globalCatchBlock;
    @NotNull
    private CoroutineBlock currentBlock;
    @NotNull
    private final Map<JsContinue, JsStatement> breakContinueTargetStatements;
    @NotNull
    private final Map<JsStatement, JumpTarget> breakTargets;
    @NotNull
    private final Map<JsStatement, JumpTarget> continueTargets;
    @NotNull
    private final Set<CoroutineBlock> referencedBlocks;
    private Set<? extends JsNode> nodesToSplit;
    @NotNull
    private CoroutineBlock currentCatchBlock;
    @NotNull
    private final List<TryBlock> tryStack;
    private boolean hasFinallyBlocks;

    public CoroutineBodyTransformer(@NotNull CoroutineTransformationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.entryBlock = this.context.getEntryBlock();
        this.globalCatchBlock = this.context.getGlobalCatchBlock();
        this.currentBlock = this.entryBlock;
        this.breakContinueTargetStatements = new LinkedHashMap();
        this.breakTargets = new LinkedHashMap();
        this.continueTargets = new LinkedHashMap();
        this.referencedBlocks = new LinkedHashSet();
        this.currentCatchBlock = this.globalCatchBlock;
        Object[] objectArray = new TryBlock[]{new TryBlock(this.globalCatchBlock, null)};
        this.tryStack = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    private final List<JsStatement> getCurrentStatements() {
        return this.currentBlock.getStatements();
    }

    public final boolean getHasFinallyBlocks() {
        return this.hasFinallyBlocks;
    }

    private final int getCurrentTryDepth() {
        return CollectionsKt.getLastIndex(this.tryStack);
    }

    public final void preProcess(@NotNull JsNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.breakContinueTargetStatements.putAll(CollectUtilsKt.collectBreakContinueTargets(node));
        this.nodesToSplit = CoroutinePassesKt.collectNodesToSplit(node, this.breakContinueTargetStatements);
    }

    @NotNull
    public final List<CoroutineBlock> postProcess() {
        ((Collection)this.currentBlock.getStatements()).add(new JsReturn());
        Map<CoroutineBlock, Set<CoroutineBlock>> graph = CoroutinePassesKt.buildGraph(this.entryBlock, this.globalCatchBlock);
        List orderedBlocks = DFS.topologicalOrder((Iterable)CollectionsKt.listOf((Object)this.entryBlock), arg_0 -> CoroutineBodyTransformer.postProcess$lambda$0(graph, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)orderedBlocks, (String)"orderedBlocks");
        CoroutinePassesKt.replaceCoroutineFlowStatements(orderedBlocks, this.context);
        return orderedBlocks;
    }

    @Override
    public void visitBlock(@NotNull JsBlock x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        CoroutineBodyTransformer this_$iv = this;
        boolean $i$f$splitIfNecessary = false;
        Set<? extends JsNode> set = this_$iv.nodesToSplit;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nodesToSplit");
            set = null;
        }
        if (set.contains(x)) {
            boolean bl = false;
            for (JsStatement statement2 : x.getStatements()) {
                statement2.accept(this);
            }
        } else {
            ((Collection)this_$iv.getCurrentStatements()).add((JsStatement)x);
        }
    }

    @Override
    public void visitIf(@NotNull JsIf x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        CoroutineBodyTransformer this_$iv = this;
        boolean $i$f$splitIfNecessary = false;
        Set<? extends JsNode> set = this_$iv.nodesToSplit;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nodesToSplit");
            set = null;
        }
        if (set.contains(x)) {
            CoroutineBlock elseEntryBlock;
            CoroutineBlock thenEntryBlock;
            boolean bl = false;
            CoroutineBlock ifBlock = this.currentBlock;
            this.currentBlock = thenEntryBlock = new CoroutineBlock();
            x.getThenStatement().accept(this);
            CoroutineBlock thenExitBlock = this.currentBlock;
            this.currentBlock = elseEntryBlock = new CoroutineBlock();
            JsStatement jsStatement = x.getElseStatement();
            if (jsStatement != null) {
                jsStatement.accept(this);
            }
            CoroutineBlock elseExitBlock = this.currentBlock;
            x.setThenStatement(new JsBlock(thenEntryBlock.getStatements()));
            x.setElseStatement(new JsBlock(elseEntryBlock.getStatements()));
            ((Collection)ifBlock.getStatements()).add(x);
            CoroutineBlock jointBlock = new CoroutineBlock();
            CollectionsKt.addAll((Collection)thenExitBlock.getStatements(), (Iterable)this.stateAndJump(jointBlock, x));
            CollectionsKt.addAll((Collection)elseExitBlock.getStatements(), (Iterable)this.stateAndJump(jointBlock, x));
            this.currentBlock = jointBlock;
        } else {
            ((Collection)this_$iv.getCurrentStatements()).add((JsStatement)x);
        }
    }

    @Override
    public void visit(@NotNull JsSwitch x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        CoroutineBodyTransformer this_$iv = this;
        boolean $i$f$splitIfNecessary = false;
        Set<? extends JsNode> set = this_$iv.nodesToSplit;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nodesToSplit");
            set = null;
        }
        if (set.contains(x)) {
            boolean bl = false;
            CoroutineBlock switchBlock = this.currentBlock;
            CoroutineBlock jointBlock = new CoroutineBlock();
            this.withBreakAndContinue(x, jointBlock, null, (Function0<Unit>)((Function0)new Function0<Unit>(x, this){
                final /* synthetic */ JsSwitch $x;
                final /* synthetic */ CoroutineBodyTransformer this$0;
                {
                    this.$x = $x;
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    for (JsSwitchMember jsCase : this.$x.getCases()) {
                        void $this$forEach$iv;
                        CoroutineBlock caseBlock = new CoroutineBlock();
                        CoroutineBodyTransformer.access$setCurrentBlock$p(this.this$0, caseBlock);
                        List<JsStatement> list2 = jsCase.getStatements();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"jsCase.statements");
                        Iterable iterable = list2;
                        CoroutineBodyTransformer coroutineBodyTransformer = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            JsStatement it = (JsStatement)element$iv;
                            boolean bl = false;
                            coroutineBodyTransformer.accept((JsNode)it);
                        }
                        jsCase.getStatements().clear();
                        List<JsStatement> list3 = jsCase.getStatements();
                        Intrinsics.checkNotNullExpressionValue(list3, (String)"jsCase.statements");
                        iterable = list3;
                        CollectionsKt.addAll((Collection)iterable, (Iterable)caseBlock.getStatements());
                    }
                }
            }));
            ((Collection)switchBlock.getStatements()).add(x);
            this.currentBlock = jointBlock;
        } else {
            ((Collection)this_$iv.getCurrentStatements()).add((JsStatement)x);
        }
    }

    @Override
    public void visitLabel(@NotNull JsLabel x) {
        JsStatement inner;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        JsStatement jsStatement = inner = x.getStatement();
        if ((jsStatement instanceof JsWhile ? true : jsStatement instanceof JsDoWhile) ? true : jsStatement instanceof JsFor) {
            Set<? extends JsNode> set = this.nodesToSplit;
            if (set == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"nodesToSplit");
                set = null;
            }
            if (set.contains(x)) {
                inner.accept(this);
            } else {
                ((Collection)this.getCurrentStatements()).add(x);
            }
        } else {
            CoroutineBodyTransformer this_$iv = this;
            boolean $i$f$splitIfNecessary = false;
            Set<? extends JsNode> set = this_$iv.nodesToSplit;
            if (set == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"nodesToSplit");
                set = null;
            }
            if (set.contains(x)) {
                boolean bl = false;
                CoroutineBlock successor = new CoroutineBlock();
                JsStatement jsStatement2 = x.getStatement();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"x.statement");
                this.withBreakAndContinue(jsStatement2, successor, null, (Function0<Unit>)((Function0)new Function0<Unit>(this, inner){
                    final /* synthetic */ CoroutineBodyTransformer this$0;
                    final /* synthetic */ JsStatement $inner;
                    {
                        this.this$0 = $receiver;
                        this.$inner = $inner;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.accept((JsNode)this.$inner);
                    }
                }));
                if (this.referencedBlocks.contains(successor)) {
                    CollectionsKt.addAll((Collection)this.currentBlock.getStatements(), (Iterable)this.stateAndJump(successor, x));
                    this.currentBlock = successor;
                }
            } else {
                ((Collection)this_$iv.getCurrentStatements()).add((JsStatement)x);
            }
        }
    }

    @Override
    public void visitWhile(@NotNull JsWhile x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        CoroutineBodyTransformer this_$iv = this;
        boolean $i$f$splitIfNecessary = false;
        Set<? extends JsNode> set = this_$iv.nodesToSplit;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nodesToSplit");
            set = null;
        }
        if (set.contains(x)) {
            boolean bl = false;
            CoroutineBlock successor = new CoroutineBlock();
            CoroutineBlock bodyEntryBlock = new CoroutineBlock();
            CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.stateAndJump(bodyEntryBlock, x));
            this.currentBlock = bodyEntryBlock;
            if (!JsBooleanLiteral.isTrue(x.getCondition())) {
                JsIf jsIf;
                Collection collection = this.getCurrentStatements();
                JsIf $this$visitWhile_u24lambda_u246_u24lambda_u245 = jsIf = new JsIf(JsAstUtils.notOptimized(x.getCondition()), new JsBlock(this.stateAndJump(successor, x)));
                boolean bl2 = false;
                $this$visitWhile_u24lambda_u246_u24lambda_u245.setSource(x.getSource());
                collection.add(jsIf);
            }
            this.withBreakAndContinue(x, successor, bodyEntryBlock, (Function0<Unit>)((Function0)new Function0<Unit>(x, this){
                final /* synthetic */ JsWhile $x;
                final /* synthetic */ CoroutineBodyTransformer this$0;
                {
                    this.$x = $x;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.$x.getBody().accept(this.this$0);
                }
            }));
            CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.stateAndJump(bodyEntryBlock, x));
            this.currentBlock = successor;
        } else {
            ((Collection)this_$iv.getCurrentStatements()).add((JsStatement)x);
        }
    }

    @Override
    public void visitDoWhile(@NotNull JsDoWhile x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        CoroutineBodyTransformer this_$iv = this;
        boolean $i$f$splitIfNecessary = false;
        Set<? extends JsNode> set = this_$iv.nodesToSplit;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nodesToSplit");
            set = null;
        }
        if (set.contains(x)) {
            boolean bl = false;
            CoroutineBlock successor = new CoroutineBlock();
            CoroutineBlock bodyEntryBlock = new CoroutineBlock();
            CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.stateAndJump(bodyEntryBlock, x));
            this.currentBlock = bodyEntryBlock;
            this.withBreakAndContinue(x, successor, bodyEntryBlock, (Function0<Unit>)((Function0)new Function0<Unit>(x, this){
                final /* synthetic */ JsDoWhile $x;
                final /* synthetic */ CoroutineBodyTransformer this$0;
                {
                    this.$x = $x;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.$x.getBody().accept(this.this$0);
                }
            }));
            if (!JsBooleanLiteral.isTrue(x.getCondition())) {
                JsIf jsIf;
                JsIf $this$visitDoWhile_u24lambda_u248_u24lambda_u247 = jsIf = new JsIf(JsAstUtils.notOptimized(x.getCondition()), new JsBlock(this.stateAndJump(successor, x)));
                boolean bl2 = false;
                $this$visitDoWhile_u24lambda_u248_u24lambda_u247.setSource(x.getSource());
                JsIf jsIf2 = jsIf;
                this.getCurrentStatements().add(jsIf2);
            }
            CollectionsKt.addAll((Collection)this.currentBlock.getStatements(), (Iterable)this.stateAndJump(bodyEntryBlock, x));
            this.currentBlock = successor;
        } else {
            ((Collection)this_$iv.getCurrentStatements()).add((JsStatement)x);
        }
    }

    @Override
    public void visitFor(@NotNull JsFor x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        CoroutineBodyTransformer this_$iv = this;
        boolean $i$f$splitIfNecessary = false;
        Set<? extends JsNode> set = this_$iv.nodesToSplit;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nodesToSplit");
            set = null;
        }
        if (set.contains(x)) {
            JsExpression jsExpression;
            boolean bl = false;
            SourceInfoAwareJsNode sourceInfoAwareJsNode = x.getInitExpression();
            JsExpression jsExpression2 = sourceInfoAwareJsNode;
            if (jsExpression2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"initExpression");
                JsExpression it = sourceInfoAwareJsNode;
                boolean bl2 = false;
                new JsExpressionStatement(it).accept(this);
            }
            SourceInfoAwareJsNode sourceInfoAwareJsNode2 = sourceInfoAwareJsNode = x.getInitVars();
            if (sourceInfoAwareJsNode2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)sourceInfoAwareJsNode2, (String)"initVars");
                SourceInfoAwareJsNode initVars = sourceInfoAwareJsNode;
                boolean bl3 = false;
                List<JsVars.JsVar> list2 = ((JsVars)initVars).getVars();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"initVars.vars");
                if (!((Collection)list2).isEmpty()) {
                    ((JsVars)initVars).accept(this);
                }
            }
            CoroutineBlock increment = new CoroutineBlock();
            CoroutineBlock successor = new CoroutineBlock();
            CoroutineBlock bodyEntryBlock = new CoroutineBlock();
            CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.stateAndJump(bodyEntryBlock, x));
            this.currentBlock = bodyEntryBlock;
            if (x.getCondition() != null && !JsBooleanLiteral.isTrue(x.getCondition())) {
                JsIf jsIf;
                Collection collection = this.getCurrentStatements();
                JsIf $this$visitFor_u24lambda_u2413_u24lambda_u2411 = jsIf = new JsIf(JsAstUtils.notOptimized(x.getCondition()), new JsBlock(this.stateAndJump(successor, x)));
                boolean bl4 = false;
                $this$visitFor_u24lambda_u2413_u24lambda_u2411.setSource(x.getSource());
                collection.add(jsIf);
            }
            this.withBreakAndContinue(x, successor, increment, (Function0<Unit>)((Function0)new Function0<Unit>(x, this){
                final /* synthetic */ JsFor $x;
                final /* synthetic */ CoroutineBodyTransformer this$0;
                {
                    this.$x = $x;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.$x.getBody().accept(this.this$0);
                }
            }));
            CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.stateAndJump(increment, x));
            this.currentBlock = increment;
            JsExpression jsExpression3 = jsExpression = x.getIncrementExpression();
            if (jsExpression3 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression3, (String)"incrementExpression");
                JsExpression it = jsExpression;
                boolean bl5 = false;
                new JsExpressionStatement(it).accept(this);
            }
            CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.stateAndJump(bodyEntryBlock, x));
            this.currentBlock = successor;
        } else {
            ((Collection)this_$iv.getCurrentStatements()).add((JsStatement)x);
        }
    }

    @Override
    public void visitBreak(@NotNull JsBreak x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        JsStatement jsStatement = this.breakContinueTargetStatements.get(x);
        Intrinsics.checkNotNull((Object)jsStatement);
        JsStatement targetStatement = jsStatement;
        JumpTarget jumpTarget = this.breakTargets.get(targetStatement);
        Intrinsics.checkNotNull((Object)jumpTarget);
        JumpTarget jumpTarget2 = jumpTarget;
        CoroutineBlock targetBlock = jumpTarget2.component1();
        int targetTryDepth = jumpTarget2.component2();
        ((Collection)this.referencedBlocks).add(targetBlock);
        this.jumpWithFinally(targetTryDepth + 1, targetBlock, x);
        ((Collection)this.getCurrentStatements()).add(this.jump());
    }

    @Override
    public void visitContinue(@NotNull JsContinue x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        JsStatement jsStatement = this.breakContinueTargetStatements.get(x);
        Intrinsics.checkNotNull((Object)jsStatement);
        JsStatement targetStatement = jsStatement;
        JumpTarget jumpTarget = this.continueTargets.get(targetStatement);
        Intrinsics.checkNotNull((Object)jumpTarget);
        JumpTarget jumpTarget2 = jumpTarget;
        CoroutineBlock targetBlock = jumpTarget2.component1();
        int targetTryDepth = jumpTarget2.component2();
        ((Collection)this.referencedBlocks).add(targetBlock);
        this.jumpWithFinally(targetTryDepth + 1, targetBlock, x);
        ((Collection)this.getCurrentStatements()).add(this.jump());
    }

    private final void jumpWithFinally(int targetTryDepth, CoroutineBlock successor, JsNode fromNode) {
        List<CoroutineBlock> relativeFinallyPath;
        List fullPath;
        if (targetTryDepth < this.tryStack.size()) {
            TryBlock tryBlock = this.tryStack.get(targetTryDepth);
            CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.exceptionState(tryBlock.getCatchBlock(), fromNode));
        }
        if ((fullPath = CollectionsKt.plus((Collection)(relativeFinallyPath = this.relativeFinallyPath(targetTryDepth)), (Object)successor)).size() > 1) {
            CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.updateFinallyPath(CollectionsKt.drop((Iterable)fullPath, (int)1)));
        }
        CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.state((CoroutineBlock)fullPath.get(0), fromNode));
    }

    @Override
    public void visitTry(@NotNull JsTry x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        CoroutineBodyTransformer this_$iv = this;
        boolean $i$f$splitIfNecessary = false;
        Set<? extends JsNode> set = this_$iv.nodesToSplit;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nodesToSplit");
            set = null;
        }
        if (set.contains(x)) {
            JsStatement it;
            boolean bl = false;
            List<JsCatch> list2 = x.getCatches();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"x.catches");
            JsCatch catchNode = (JsCatch)CollectionsKt.firstOrNull(list2);
            JsBlock finallyNode = x.getFinallyBlock();
            CoroutineBlock successor = new CoroutineBlock();
            CoroutineBlock catchBlock = new CoroutineBlock();
            CoroutineBlock finallyBlock = new CoroutineBlock();
            ((Collection)this.tryStack).add(new TryBlock(catchBlock, finallyNode != null ? finallyBlock : null));
            CoroutineBlock oldCatchBlock = this.currentCatchBlock;
            this.currentCatchBlock = catchBlock;
            CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.exceptionState(catchBlock, x));
            List<JsStatement> list3 = x.getTryBlock().getStatements();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"x.tryBlock.statements");
            Iterable $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (JsStatement)element$iv;
                boolean bl2 = false;
                it.accept(this);
            }
            CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.exceptionState(oldCatchBlock, x));
            this.currentCatchBlock = oldCatchBlock;
            if (finallyNode != null) {
                CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.updateFinallyPath(CollectionsKt.listOf((Object)successor)));
                CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.stateAndJump(finallyBlock, x));
            } else {
                CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.stateAndJump(successor, x));
            }
            this.currentBlock = catchBlock;
            if (finallyNode != null) {
                CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.updateFinallyPath(CollectionsKt.listOf((Object)oldCatchBlock)));
                CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)(catchNode != null ? this.exceptionState(finallyBlock, x) : this.stateAndJump(finallyBlock, x)));
            } else {
                CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)(catchNode != null ? this.exceptionState(oldCatchBlock, x) : this.stateAndJump(oldCatchBlock, x)));
            }
            if (catchNode != null) {
                ((Collection)this.getCurrentStatements()).add(JsAstUtils.newVar(catchNode.getParameter().getName(), new JsNameRef(this.context.getMetadata().getExceptionName(), JsAstUtils.stateMachineReceiver())));
                List<JsStatement> list4 = catchNode.getBody().getStatements();
                Intrinsics.checkNotNullExpressionValue(list4, (String)"catchNode.body.statements");
                $this$forEach$iv = list4;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (JsStatement)element$iv;
                    boolean bl3 = false;
                    it.accept(this);
                }
                if (finallyNode == null) {
                    CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.stateAndJump(successor, x));
                } else {
                    CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.updateFinallyPath(CollectionsKt.listOf((Object)successor)));
                    CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.stateAndJump(finallyBlock, x));
                }
            }
            this.tryStack.remove(CollectionsKt.getLastIndex(this.tryStack));
            if (finallyNode != null) {
                this.currentBlock = finallyBlock;
                CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.exceptionState(oldCatchBlock, x));
                List<JsStatement> list5 = finallyNode.getStatements();
                Intrinsics.checkNotNullExpressionValue(list5, (String)"finallyNode.statements");
                $this$forEach$iv = list5;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (JsStatement)element$iv;
                    boolean bl4 = false;
                    it.accept(this);
                }
                this.generateFinallyExit();
                this.hasFinallyBlocks = true;
            }
            this.currentBlock = successor;
        } else {
            ((Collection)this_$iv.getCurrentStatements()).add((JsStatement)x);
        }
    }

    private final void generateFinallyExit() {
        JsNameRef finallyPathRef = new JsNameRef(this.context.getMetadata().getFinallyPathName(), JsAstUtils.stateMachineReceiver());
        JsNameRef stateRef = new JsNameRef(this.context.getMetadata().getStateName(), JsAstUtils.stateMachineReceiver());
        JsInvocation nextState = new JsInvocation((JsExpression)new JsNameRef("shift", (JsExpression)finallyPathRef), new JsExpression[0]);
        ((Collection)this.getCurrentStatements()).add(JsAstUtils.assignment(stateRef, nextState).makeStmt());
        ((Collection)this.getCurrentStatements()).add(this.jump());
    }

    @Override
    public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        JsExpression jsExpression = x.getExpression();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.expression");
        JsExpression expression2 = jsExpression;
        JsExpression splitExpression = this.handleExpression(expression2);
        if (Intrinsics.areEqual((Object)splitExpression, (Object)expression2)) {
            ((Collection)this.getCurrentStatements()).add(x);
        } else if (splitExpression != null) {
            JsExpressionStatement jsExpressionStatement;
            Collection collection = this.getCurrentStatements();
            JsExpressionStatement $this$visitExpressionStatement_u24lambda_u2418 = jsExpressionStatement = new JsExpressionStatement(splitExpression);
            boolean bl = false;
            MetadataProperties.setSynthetic($this$visitExpressionStatement_u24lambda_u2418, true);
            collection.add(jsExpressionStatement);
        }
    }

    @Override
    public void visitVars(@NotNull JsVars x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        ((Collection)this.getCurrentStatements()).add(x);
    }

    @Override
    public void visitReturn(@NotNull JsReturn x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        boolean isInFinally = this.hasEnclosingFinallyBlock();
        if (isInFinally) {
            JsNameRef jsNameRef;
            CoroutineBlock returnBlock = new CoroutineBlock();
            this.jumpWithFinally(0, returnBlock, x);
            JsExpression returnExpression = x.getExpression();
            if (returnExpression != null) {
                JsNameRef ref = new JsNameRef(this.context.getReturnValueFieldName(), JsAstUtils.stateMachineReceiver());
                ((Collection)this.getCurrentStatements()).add(JsAstUtils.assignment(ref, x.getExpression()).makeStmt());
                jsNameRef = ref;
            } else {
                jsNameRef = null;
            }
            JsNameRef returnFieldRef = jsNameRef;
            ((Collection)this.getCurrentStatements()).add(this.jump());
            this.currentBlock = returnBlock;
            JsNameRef jsNameRef2 = returnFieldRef;
            ((Collection)this.getCurrentStatements()).add(new JsReturn(jsNameRef2 != null ? jsNameRef2.deepCopy() : null));
        } else {
            ((Collection)this.getCurrentStatements()).add(x);
        }
    }

    @Override
    public void visitThrow(@NotNull JsThrow x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        ((Collection)this.getCurrentStatements()).add(x);
    }

    @Override
    public void visitDebugger(@NotNull JsDebugger x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        ((Collection)this.getCurrentStatements()).add(x);
    }

    private final JsExpression handleExpression(JsExpression expression2) {
        Pair<JsExpression, JsExpression> assignment = JsAstUtils.decomposeAssignment(expression2);
        if (assignment != null) {
            JsExpression rhs = (JsExpression)assignment.getSecond();
            Intrinsics.checkNotNullExpressionValue((Object)rhs, (String)"rhs");
            if (MetadataProperties.isSuspend(rhs)) {
                this.handleSuspend(expression2, rhs);
                return null;
            }
        } else if (MetadataProperties.isSuspend(expression2)) {
            this.handleSuspend(expression2, expression2);
            return null;
        }
        return expression2;
    }

    /*
     * WARNING - void declaration
     */
    private final void handleSuspend(JsExpression invocation, JsExpression sourceNode) {
        void $this$handleSuspend_u24lambda_u2420;
        JsContinue jsContinue;
        JsNameRef jsNameRef;
        Object object = sourceNode.getSource();
        if (object == null) {
            object = invocation.getSource();
        }
        Object psi = object;
        CoroutineBlock nextBlock = new CoroutineBlock();
        CollectionsKt.addAll((Collection)this.getCurrentStatements(), (Iterable)this.state(nextBlock, invocation));
        JsNameRef $this$handleSuspend_u24lambda_u2419 = jsNameRef = new JsNameRef(this.context.getMetadata().getResultName(), JsAstUtils.stateMachineReceiver());
        boolean bl = false;
        MetadataProperties.setSideEffects($this$handleSuspend_u24lambda_u2419, SideEffectKind.DEPENDS_ON_STATE);
        JsNameRef resultRef = jsNameRef;
        JsStatement jsStatement = JsAstUtils.assignment(resultRef, invocation).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"assignment(resultRef, invocation).makeStmt()");
        JsStatement invocationStatement = jsStatement;
        JsExpression suspendCondition = JsAstUtils.equality(resultRef.deepCopy(), this.context.getMetadata().getSuspendObjectRef().deepCopy()).source(psi);
        JsIf suspendIfNeeded = new JsIf(suspendCondition, new JsReturn(this.context.getMetadata().getSuspendObjectRef().deepCopy().source(psi)));
        Collection collection = this.getCurrentStatements();
        Object[] objectArray = new JsStatement[3];
        objectArray[0] = invocationStatement;
        objectArray[1] = suspendIfNeeded;
        JsContinue jsContinue2 = jsContinue = new JsContinue();
        int n = 2;
        Object[] objectArray2 = objectArray;
        boolean bl2 = false;
        $this$handleSuspend_u24lambda_u2420.setSource(psi);
        Unit unit = Unit.INSTANCE;
        objectArray2[n] = jsContinue;
        CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        this.currentBlock = nextBlock;
    }

    private final List<JsStatement> state(CoroutineBlock target, JsNode fromExpression) {
        JsDebugger placeholder = new JsDebugger();
        CoroutineMetadataPropertiesKt.setTargetBlock(placeholder, target);
        placeholder.setSource(fromExpression.getSource());
        return CollectionsKt.listOf((Object)placeholder);
    }

    private final JsContinue jump() {
        return new JsContinue();
    }

    private final List<JsStatement> stateAndJump(CoroutineBlock target, JsNode fromNode) {
        return CollectionsKt.plus((Collection)this.state(target, fromNode), (Object)this.jump());
    }

    private final List<JsStatement> exceptionState(CoroutineBlock target, JsNode fromNode) {
        JsDebugger placeholder = new JsDebugger();
        CoroutineMetadataPropertiesKt.setTargetExceptionBlock(placeholder, target);
        placeholder.setSource(fromNode);
        return CollectionsKt.listOf((Object)placeholder);
    }

    private final List<JsStatement> updateFinallyPath(List<CoroutineBlock> path2) {
        JsDebugger placeholder = new JsDebugger();
        CoroutineMetadataPropertiesKt.setFinallyPath(placeholder, path2);
        return CollectionsKt.listOf((Object)placeholder);
    }

    private final void splitIfNecessary(JsStatement statement2, Function0<Unit> action) {
        boolean $i$f$splitIfNecessary = false;
        Set<? extends JsNode> set = this.nodesToSplit;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nodesToSplit");
            set = null;
        }
        if (set.contains(statement2)) {
            action.invoke();
        } else {
            ((Collection)this.getCurrentStatements()).add(statement2);
        }
    }

    private final void withBreakAndContinue(JsStatement statement2, CoroutineBlock breakBlock, CoroutineBlock continueBlock, Function0<Unit> action) {
        this.breakTargets.put(statement2, new JumpTarget(breakBlock, this.getCurrentTryDepth()));
        if (continueBlock != null) {
            this.continueTargets.put(statement2, new JumpTarget(continueBlock, this.getCurrentTryDepth()));
        }
        action.invoke();
        ((Collection)this.breakTargets.keySet()).remove(statement2);
        ((Collection)this.continueTargets.keySet()).remove(statement2);
    }

    static /* synthetic */ void withBreakAndContinue$default(CoroutineBodyTransformer coroutineBodyTransformer, JsStatement jsStatement, CoroutineBlock coroutineBlock, CoroutineBlock coroutineBlock2, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            coroutineBlock2 = null;
        }
        coroutineBodyTransformer.withBreakAndContinue(jsStatement, coroutineBlock, coroutineBlock2, (Function0<Unit>)function0);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CoroutineBlock> relativeFinallyPath(int targetTryDepth) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.tryStack.subList(targetTryDepth, this.tryStack.size());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CoroutineBlock it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            TryBlock it = (TryBlock)element$iv$iv;
            boolean bl2 = false;
            if (it.getFinallyBlock() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
    }

    private final boolean hasEnclosingFinallyBlock() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.tryStack;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TryBlock it = (TryBlock)element$iv;
                    boolean bl2 = false;
                    if (!(it.getFinallyBlock() != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Iterable postProcess$lambda$0(Map $graph, CoroutineBlock it) {
        Intrinsics.checkNotNullParameter((Object)$graph, (String)"$graph");
        Set set = (Set)$graph.get(it);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public static final /* synthetic */ void access$setCurrentBlock$p(CoroutineBodyTransformer $this, CoroutineBlock coroutineBlock) {
        $this.currentBlock = coroutineBlock;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/coroutine/CoroutineBodyTransformer$JumpTarget;", "", "block", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "tryDepth", "", "(Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;I)V", "getBlock", "()Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "getTryDepth", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "js.translator"})
    private static final class JumpTarget {
        @NotNull
        private final CoroutineBlock block;
        private final int tryDepth;

        public JumpTarget(@NotNull CoroutineBlock block, int tryDepth) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            this.block = block;
            this.tryDepth = tryDepth;
        }

        @NotNull
        public final CoroutineBlock getBlock() {
            return this.block;
        }

        public final int getTryDepth() {
            return this.tryDepth;
        }

        @NotNull
        public final CoroutineBlock component1() {
            return this.block;
        }

        public final int component2() {
            return this.tryDepth;
        }

        @NotNull
        public final JumpTarget copy(@NotNull CoroutineBlock block, int tryDepth) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            return new JumpTarget(block, tryDepth);
        }

        public static /* synthetic */ JumpTarget copy$default(JumpTarget jumpTarget, CoroutineBlock coroutineBlock, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                coroutineBlock = jumpTarget.block;
            }
            if ((n2 & 2) != 0) {
                n = jumpTarget.tryDepth;
            }
            return jumpTarget.copy(coroutineBlock, n);
        }

        @NotNull
        public String toString() {
            return "JumpTarget(block=" + this.block + ", tryDepth=" + this.tryDepth + ')';
        }

        public int hashCode() {
            int result2 = this.block.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.tryDepth);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JumpTarget)) {
                return false;
            }
            JumpTarget jumpTarget = (JumpTarget)other;
            if (!Intrinsics.areEqual((Object)this.block, (Object)jumpTarget.block)) {
                return false;
            }
            return this.tryDepth == jumpTarget.tryDepth;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/coroutine/CoroutineBodyTransformer$TryBlock;", "", "catchBlock", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "finallyBlock", "(Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;)V", "getCatchBlock", "()Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "getFinallyBlock", "js.translator"})
    private static final class TryBlock {
        @NotNull
        private final CoroutineBlock catchBlock;
        @Nullable
        private final CoroutineBlock finallyBlock;

        public TryBlock(@NotNull CoroutineBlock catchBlock, @Nullable CoroutineBlock finallyBlock) {
            Intrinsics.checkNotNullParameter((Object)catchBlock, (String)"catchBlock");
            this.catchBlock = catchBlock;
            this.finallyBlock = finallyBlock;
        }

        @NotNull
        public final CoroutineBlock getCatchBlock() {
            return this.catchBlock;
        }

        @Nullable
        public final CoroutineBlock getFinallyBlock() {
            return this.finallyBlock;
        }
    }
}

