/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.EnumClassLowering;
import org.jetbrains.kotlin.backend.jvm.lower.EnumClassLowering$EnumClassTransformer$run$;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBodyKind;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "EnumClassTransformer", "backend.jvm.lower"})
final class EnumClassLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public EnumClassLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        if (!IrUtilsKt.isEnumClass((IrClass)irClass)) {
            return;
        }
        new EnumClassTransformer(irClass, this.context.getState().getLanguageVersionSettings().supportsFeature(LanguageFeature.EnumEntries)).run();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0002'(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\nH\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J\u0006\u0010%\u001a\u00020&R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0010j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\u00020\u0005*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\u00020\u0005*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "supportsEnumEntries", "", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Z)V", "declarationToEnumEntry", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "enumArrayType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "enumEntryOrdinals", "Lgnu/trove/TObjectIntHashMap;", "loweredEnumConstructorParameters", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lkotlin/collections/HashMap;", "loweredEnumConstructors", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "hasGetEntriesFunction", "getHasGetEntriesFunction", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "isGetEntriesFunction", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Z", "buildEntriesField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "valuesField", "buildEnumEntryField", "enumEntry", "buildValuesField", "valuesHelperFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "buildValuesHelperFunction", "run", "", "EnumClassCallTransformer", "EnumClassDeclarationsTransformer", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nEnumClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 6 IrArrayBuilder.kt\norg/jetbrains/kotlin/backend/jvm/ir/IrArrayBuilderKt\n*L\n1#1,323:1\n473#2:324\n1313#2:325\n1314#2:327\n1#3:326\n1#3:344\n1747#4,3:328\n800#4,11:345\n191#5:331\n185#5:332\n179#5,10:333\n61#5:356\n55#5,10:357\n61#5:367\n55#5,10:368\n20#6:343\n*S KotlinDebug\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer\n*L\n104#1:324\n104#1:325\n104#1:327\n158#1:344\n140#1:328,3\n159#1:345,11\n151#1:331\n151#1:332\n151#1:333,10\n166#1:356\n166#1:357,10\n181#1:367\n181#1:368,10\n158#1:343\n*E\n"})
    private final class EnumClassTransformer {
        @NotNull
        private final IrClass irClass;
        private final boolean supportsEnumEntries;
        @NotNull
        private final HashMap<IrConstructorSymbol, IrConstructor> loweredEnumConstructors;
        @NotNull
        private final HashMap<IrValueParameterSymbol, IrValueParameter> loweredEnumConstructorParameters;
        @NotNull
        private final TObjectIntHashMap<IrEnumEntry> enumEntryOrdinals;
        @NotNull
        private final Map<IrDeclaration, IrEnumEntry> declarationToEnumEntry;
        @NotNull
        private final IrSimpleType enumArrayType;

        public EnumClassTransformer(IrClass irClass, boolean supportsEnumEntries) {
            Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
            this.irClass = irClass;
            this.supportsEnumEntries = supportsEnumEntries;
            this.loweredEnumConstructors = new HashMap();
            this.loweredEnumConstructorParameters = new HashMap();
            this.enumEntryOrdinals = new TObjectIntHashMap();
            this.declarationToEnumEntry = new LinkedHashMap();
            IrType[] irTypeArray = new IrType[]{IrUtilsKt.getDefaultType((IrClass)this.irClass)};
            this.enumArrayType = IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)EnumClassLowering.this.context.getIrBuiltIns().getArrayClass()), (IrType[])irTypeArray);
        }

        public final void run() {
            IrField irField;
            Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)this.irClass.getDeclarations());
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)EnumClassTransformer$run$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$forEach$iv = SequencesKt.withIndex((Sequence)sequence2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IndexedValue indexedValue = (IndexedValue)element$iv;
                boolean bl = false;
                int index2 = indexedValue.component1();
                IrEnumEntry enumEntry = (IrEnumEntry)indexedValue.component2();
                this.enumEntryOrdinals.put((Object)enumEntry, index2);
                if (enumEntry.getCorrespondingClass() != null) {
                    IrClass entryClass;
                    boolean bl2 = false;
                    this.declarationToEnumEntry.put((IrDeclaration)entryClass, enumEntry);
                }
                this.declarationToEnumEntry.put((IrDeclaration)this.buildEnumEntryField(enumEntry), enumEntry);
            }
            CollectionsKt.removeAll((List)this.irClass.getDeclarations(), (Function1)run.2.INSTANCE);
            CollectionsKt.addAll((Collection)this.irClass.getDeclarations(), (Iterable)this.declarationToEnumEntry.keySet());
            IrFunction valuesHelperFunction = this.buildValuesHelperFunction();
            IrField valuesField = this.buildValuesField(valuesHelperFunction);
            if (!this.getHasGetEntriesFunction(this.irClass)) {
                irField = null;
            } else {
                if (!this.supportsEnumEntries) {
                    throw new IllegalStateException("The frontend must have checked if the feature is supported while emitting the IR".toString());
                }
                irField = this.buildEntriesField(valuesField);
            }
            IrField entriesField = irField;
            IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)this.irClass), (IrElementTransformerVoid)new EnumClassDeclarationsTransformer(valuesField, entriesField));
            IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)this.irClass), (IrElementTransformerVoid)((IrElementTransformerVoid)new EnumClassCallTransformer()));
        }

        private final boolean getHasGetEntriesFunction(IrClass $this$hasGetEntriesFunction) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = $this$hasGetEntriesFunction.getDeclarations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrDeclaration it = (IrDeclaration)element$iv;
                        boolean bl2 = false;
                        if (!this.isGetEntriesFunction(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean isGetEntriesFunction(IrDeclaration $this$isGetEntriesFunction) {
            return $this$isGetEntriesFunction instanceof IrFunction && Intrinsics.areEqual((Object)((IrFunction)$this$isGetEntriesFunction).getName(), (Object)SpecialNames.ENUM_GET_ENTRIES) && Intrinsics.areEqual((Object)$this$isGetEntriesFunction.getOrigin(), (Object)IrDeclarationOrigin.ENUM_CLASS_SPECIAL_MEMBER.INSTANCE);
        }

        private final IrField buildEnumEntryField(IrEnumEntry enumEntry) {
            IrField irField;
            IrField $this$buildEnumEntryField_u24lambda_u243 = irField = EnumClassLowering.this.context.getCachedDeclarations().getFieldForEnumEntry(enumEntry);
            boolean bl = false;
            IrExpressionBody irExpressionBody = enumEntry.getInitializerExpression();
            Intrinsics.checkNotNull((Object)irExpressionBody);
            $this$buildEnumEntryField_u24lambda_u243.setInitializer((IrExpressionBody)new IrExpressionBodyImpl((IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrElement)irExpressionBody.getExpression()), (IrDeclarationParent)((IrDeclarationParent)$this$buildEnumEntryField_u24lambda_u243))));
            $this$buildEnumEntryField_u24lambda_u243.setAnnotations(CollectionsKt.plus((Collection)$this$buildEnumEntryField_u24lambda_u243.getAnnotations(), (Iterable)enumEntry.getAnnotations()));
            return irField;
        }

        /*
         * WARNING - void declaration
         */
        private final IrFunction buildValuesHelperFunction() {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$irArray$iv;
            IrArrayBuilder irArrayBuilder;
            void $this$buildValuesHelperFunction_u24lambda_u247_u24lambda_u246;
            IrClass $this$addFunction$iv = this.irClass;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2418$iv$iv$iv = new IrFunctionBuilder();
            boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv$iv$iv22 = false;
            IrFunctionBuilder $this$buildValuesHelperFunction_u24lambda_u244 = $this$buildFun_u24lambda_u2418$iv$iv$iv;
            boolean bl = false;
            Name name2 = Name.identifier((String)"$values");
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(VALUES_HELPER_FUNCTION_NAME)");
            $this$buildValuesHelperFunction_u24lambda_u244.setName(name2);
            $this$buildValuesHelperFunction_u24lambda_u244.setReturnType((IrType)this.enumArrayType);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
            $this$buildValuesHelperFunction_u24lambda_u244.setVisibility(descriptorVisibility);
            $this$buildValuesHelperFunction_u24lambda_u244.setOrigin((IrDeclarationOrigin)IrDeclarationOrigin.SYNTHETIC_HELPER_FOR_ENUM_VALUES.INSTANCE);
            IrFactory function$iv$iv = $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2418$iv$iv$iv);
            boolean bl2 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add(function$iv$iv);
            function$iv$iv.setParent((IrDeclarationParent)((IrDeclarationContainer)$this$addFunction$iv));
            IrFactory irFactory = $this$buildFun$iv$iv$iv;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            IrFactory $this$buildValuesHelperFunction_u24lambda_u247 = irFactory;
            boolean bl3 = false;
            $this$buildFun$iv$iv$iv = JvmIrBuilderKt.createJvmIrBuilder$default(enumClassLowering.context, (IrSymbol)$this$buildValuesHelperFunction_u24lambda_u247.getSymbol(), 0, 0, 6, null);
            IrFactory irFactory2 = $this$buildValuesHelperFunction_u24lambda_u247;
            boolean bl4 = false;
            void $i$a$-run-DeclarationBuildersKt$buildFun$1$iv$iv$iv22 = $this$buildValuesHelperFunction_u24lambda_u247_u24lambda_u246;
            IrType arrayType$iv = $this$buildValuesHelperFunction_u24lambda_u247.getReturnType();
            boolean $i$f$irArray = false;
            IrArrayBuilder $this$irArray_u24lambda_u240$iv = irArrayBuilder = new IrArrayBuilder((JvmIrBuilder)$this$irArray$iv, arrayType$iv);
            boolean bl5 = false;
            IrArrayBuilder irArrayBuilder2 = $this$irArray_u24lambda_u240$iv;
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildValuesHelperFunction_u24lambda_u247_u24lambda_u246;
            boolean bl6 = false;
            Iterable $this$filterIsInstance$iv = this.declarationToEnumEntry.keySet();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrField)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (IrField irField : (List)destination$iv$iv) {
                void $this$buildValuesHelperFunction_u24lambda_u247_u24lambda_u246_u24lambda_u245;
                $this$buildValuesHelperFunction_u24lambda_u247_u24lambda_u246_u24lambda_u245.unaryPlus((IrExpression)ExpressionHelpersKt.irGetField$default((IrBuilderWithScope)((IrBuilderWithScope)$this$buildValuesHelperFunction_u24lambda_u247_u24lambda_u246), null, (IrField)irField, null, (int)4, null));
            }
            irFactory2.setBody((IrBody)ExpressionHelpersKt.irExprBody((IrBuilderWithScope)irBuilderWithScope, (IrExpression)irArrayBuilder.build()));
            return (IrFunction)irFactory;
        }

        /*
         * WARNING - void declaration
         */
        private final IrField buildValuesField(IrFunction valuesHelperFunction) {
            void $this$buildValuesField_u24lambda_u2410_u24lambda_u249;
            IrClass $this$addField$iv = this.irClass;
            boolean $i$f$addField = false;
            IrFactory $this$buildField$iv$iv = $this$addField$iv.getFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv = new IrFieldBuilder();
            boolean bl = false;
            IrFieldBuilder $this$buildValuesField_u24lambda_u248 = $this$buildField_u24lambda_u244$iv$iv;
            boolean bl2 = false;
            Name name2 = Name.identifier((String)"$VALUES");
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(Implementatio\u2026n.ENUM_VALUES_FIELD_NAME)");
            $this$buildValuesField_u24lambda_u248.setName(name2);
            $this$buildValuesField_u24lambda_u248.setType((IrType)this.enumArrayType);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
            $this$buildValuesField_u24lambda_u248.setVisibility(descriptorVisibility);
            $this$buildValuesField_u24lambda_u248.setOrigin((IrDeclarationOrigin)IrDeclarationOrigin.FIELD_FOR_ENUM_VALUES.INSTANCE);
            $this$buildValuesField_u24lambda_u248.setFinal(true);
            $this$buildValuesField_u24lambda_u248.setStatic(true);
            IrFactory field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, (IrFieldBuilder)$this$buildField_u24lambda_u244$iv$iv);
            boolean $i$a$-also-DeclarationBuildersKt$addField$1$iv22 = false;
            field$iv.setParent((IrDeclarationParent)$this$addField$iv);
            $this$addField$iv.getDeclarations().add(field$iv);
            IrFactory irFactory = $this$buildField$iv$iv;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            IrFactory $this$buildValuesField_u24lambda_u2410 = irFactory;
            boolean bl3 = false;
            JvmIrBuilder $i$a$-also-DeclarationBuildersKt$addField$1$iv22 = JvmIrBuilderKt.createJvmIrBuilder$default(enumClassLowering.context, (IrSymbol)$this$buildValuesField_u24lambda_u2410.getSymbol(), 0, 0, 6, null);
            IrFactory irFactory2 = $this$buildValuesField_u24lambda_u2410;
            boolean bl4 = false;
            irFactory2.setInitializer(ExpressionHelpersKt.irExprBody((IrBuilderWithScope)((IrBuilderWithScope)$this$buildValuesField_u24lambda_u2410_u24lambda_u249), (IrExpression)((IrExpression)ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$buildValuesField_u24lambda_u2410_u24lambda_u249), (IrFunctionSymbol)valuesHelperFunction.getSymbol()))));
            return irFactory;
        }

        /*
         * WARNING - void declaration
         */
        private final IrField buildEntriesField(IrField valuesField) {
            void $this$buildEntriesField_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412;
            void $this$buildEntriesField_u24lambda_u2414_u24lambda_u2413;
            IrCall irCall;
            void $this$addField$iv;
            IrClass irClass = this.irClass;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            boolean $i$f$addField = false;
            IrFactory $this$buildField$iv$iv = $this$addField$iv.getFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv = new IrFieldBuilder();
            boolean bl = false;
            IrFieldBuilder $this$buildEntriesField_u24lambda_u2411 = $this$buildField_u24lambda_u244$iv$iv;
            boolean $i$a$-addField-EnumClassLowering$EnumClassTransformer$buildEntriesField$22 = false;
            Name name2 = Name.identifier((String)"$ENTRIES");
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(ENTRIES_FIELD_NAME)");
            $this$buildEntriesField_u24lambda_u2411.setName(name2);
            $this$buildEntriesField_u24lambda_u2411.setType(IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)enumClassLowering.context.getIr().getSymbols().getEnumEntries())));
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
            $this$buildEntriesField_u24lambda_u2411.setVisibility(descriptorVisibility);
            $this$buildEntriesField_u24lambda_u2411.setOrigin((IrDeclarationOrigin)IrDeclarationOrigin.FIELD_FOR_ENUM_ENTRIES.INSTANCE);
            $this$buildEntriesField_u24lambda_u2411.setFinal(true);
            $this$buildEntriesField_u24lambda_u2411.setStatic(true);
            Object field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, (IrFieldBuilder)$this$buildField_u24lambda_u244$iv$iv);
            boolean bl2 = false;
            field$iv.setParent((IrDeclarationParent)$this$addField$iv);
            $this$addField$iv.getDeclarations().add(field$iv);
            irClass = $this$buildField$iv$iv;
            enumClassLowering = EnumClassLowering.this;
            IrClass $this$buildEntriesField_u24lambda_u2414 = irClass;
            boolean bl3 = false;
            field$iv = JvmIrBuilderKt.createJvmIrBuilder$default(enumClassLowering.context, (IrSymbol)$this$buildEntriesField_u24lambda_u2414.getSymbol(), 0, 0, 6, null);
            IrClass irClass2 = $this$buildEntriesField_u24lambda_u2414;
            boolean bl4 = false;
            IrCall $i$a$-addField-EnumClassLowering$EnumClassTransformer$buildEntriesField$22 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$buildEntriesField_u24lambda_u2414_u24lambda_u2413), (IrSimpleFunctionSymbol)enumClassLowering.context.getIr().getSymbols().getCreateEnumEntries());
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildEntriesField_u24lambda_u2414_u24lambda_u2413;
            boolean bl5 = false;
            $this$buildEntriesField_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irGetField$default((IrBuilderWithScope)((IrBuilderWithScope)$this$buildEntriesField_u24lambda_u2414_u24lambda_u2413), null, (IrField)valuesField, null, (int)4, null));
            irClass2.setInitializer(ExpressionHelpersKt.irExprBody((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)irCall)));
            return irClass;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassCallTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;)V", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "passConstructorArguments", "", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "original", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "backend.jvm.lower"})
        @SourceDebugExtension(value={"SMAP\nEnumClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassCallTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,323:1\n1#2:324\n*E\n"})
        private final class EnumClassCallTransformer
        extends IrElementTransformerVoidWithContext {
            @NotNull
            public IrStatement visitClassNew(@NotNull IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                return IrUtilsKt.isEnumEntry((IrClass)declaration) ? super.visitClassNew(declaration) : (IrStatement)declaration;
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrValueParameter irValueParameter = (IrValueParameter)((Map)EnumClassTransformer.this.loweredEnumConstructorParameters).get(expression2.getSymbol());
                if (irValueParameter != null) {
                    IrValueParameter it = irValueParameter;
                    boolean bl = false;
                    irExpression = (IrExpression)new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), (IrValueSymbol)it.getSymbol(), expression2.getOrigin());
                } else {
                    irExpression = (IrExpression)expression2;
                }
                return irExpression;
            }

            @NotNull
            public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.transformChildrenVoid((IrElement)expression2);
                IrValueParameter irValueParameter = (IrValueParameter)((Map)EnumClassTransformer.this.loweredEnumConstructorParameters).get(expression2.getSymbol());
                if (irValueParameter != null) {
                    IrValueParameter it = irValueParameter;
                    boolean bl = false;
                    irExpression = (IrExpression)new IrSetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), (IrValueSymbol)it.getSymbol(), expression2.getValue(), expression2.getOrigin());
                } else {
                    irExpression = (IrExpression)expression2;
                }
                return irExpression;
            }

            @NotNull
            public IrExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrFunctionAccessExpression irFunctionAccessExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)scopeWithIr);
                IrSymbol scopeOwnerSymbol = scopeWithIr.getScope().getScopeOwnerSymbol();
                IrBuilder irBuilder = LowerUtilsKt.at((IrBuilder)((IrBuilder)LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)EnumClassLowering.this.context), (IrSymbol)scopeOwnerSymbol, (int)0, (int)0, (int)6, null)), (IrElement)((IrElement)expression2));
                EnumClassTransformer enumClassTransformer = EnumClassTransformer.this;
                DeclarationIrBuilder $this$visitEnumConstructorCall_u24lambda_u243 = (DeclarationIrBuilder)irBuilder;
                boolean bl = false;
                IrConstructor irConstructor = (IrConstructor)enumClassTransformer.loweredEnumConstructors.get(expression2.getSymbol());
                if (irConstructor == null) {
                    irConstructor = (IrConstructor)expression2.getSymbol().getOwner();
                }
                Intrinsics.checkNotNullExpressionValue((Object)irConstructor, (String)"loweredEnumConstructors[\u2026: expression.symbol.owner");
                IrConstructor constructor = irConstructor;
                IrFunctionAccessExpression it = irFunctionAccessExpression = scopeOwnerSymbol instanceof IrConstructorSymbol ? (IrFunctionAccessExpression)ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)((IrBuilderWithScope)$this$visitEnumConstructorCall_u24lambda_u243), (IrConstructor)constructor) : ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$visitEnumConstructorCall_u24lambda_u243), (IrFunction)((IrFunction)constructor));
                boolean bl2 = false;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$visitEnumConstructorCall_u24lambda_u243;
                IrFunctionAccessExpression irFunctionAccessExpression2 = (IrFunctionAccessExpression)expression2;
                Map map = enumClassTransformer.declarationToEnumEntry;
                IrSymbolOwner irSymbolOwner = scopeOwnerSymbol.getOwner();
                Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
                this.passConstructorArguments(irBuilderWithScope, it, irFunctionAccessExpression2, (IrEnumEntry)map.get((IrDeclaration)irSymbolOwner));
                return (IrExpression)irFunctionAccessExpression;
            }

            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrDelegatingConstructorCall irDelegatingConstructorCall;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
                IrConstructor irConstructor = (IrConstructor)EnumClassTransformer.this.loweredEnumConstructors.get(expression2.getSymbol());
                if (irConstructor == null) {
                    return (IrExpression)expression2;
                }
                IrConstructor replacement = irConstructor;
                BackendContext backendContext = (BackendContext)EnumClassLowering.this.context;
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)scopeWithIr);
                DeclarationIrBuilder $this$visitDelegatingConstructorCall_u24lambda_u245 = (DeclarationIrBuilder)LowerUtilsKt.at((IrBuilder)((IrBuilder)LowerUtilsKt.createIrBuilder$default((BackendContext)backendContext, (IrSymbol)scopeWithIr.getScope().getScopeOwnerSymbol(), (int)0, (int)0, (int)6, null)), (IrElement)((IrElement)expression2));
                boolean bl = false;
                IrDelegatingConstructorCall it = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)((IrBuilderWithScope)$this$visitDelegatingConstructorCall_u24lambda_u245), (IrConstructor)replacement);
                boolean bl2 = false;
                EnumClassCallTransformer.passConstructorArguments$default(this, (IrBuilderWithScope)$this$visitDelegatingConstructorCall_u24lambda_u245, (IrFunctionAccessExpression)it, (IrFunctionAccessExpression)expression2, null, 4, null);
                return (IrExpression)irDelegatingConstructorCall;
            }

            private final void passConstructorArguments(IrBuilderWithScope $this$passConstructorArguments, IrFunctionAccessExpression call2, IrFunctionAccessExpression original, IrEnumEntry enumEntry) {
                IrExpressionsKt.copyTypeArgumentsFrom$default((IrMemberAccessExpression)((IrMemberAccessExpression)call2), (IrMemberAccessExpression)((IrMemberAccessExpression)original), (int)0, (int)2, null);
                if (enumEntry != null) {
                    String string2 = enumEntry.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"enumEntry.name.asString()");
                    call2.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)$this$passConstructorArguments, (String)string2));
                    call2.putValueArgument(1, (IrExpression)ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$passConstructorArguments, (int)EnumClassTransformer.this.enumEntryOrdinals.get((Object)enumEntry), null, (int)2, null));
                } else {
                    ScopeWithIr scopeWithIr = this.getCurrentScope();
                    Intrinsics.checkNotNull((Object)scopeWithIr);
                    IrSymbol irSymbol = scopeWithIr.getScope().getScopeOwnerSymbol();
                    Intrinsics.checkNotNull((Object)irSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol");
                    IrConstructorSymbol constructor = (IrConstructorSymbol)irSymbol;
                    call2.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$passConstructorArguments, (IrValueDeclaration)((IrValueDeclaration)((IrConstructor)constructor.getOwner()).getValueParameters().get(0))));
                    call2.putValueArgument(1, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$passConstructorArguments, (IrValueDeclaration)((IrValueDeclaration)((IrConstructor)constructor.getOwner()).getValueParameters().get(1))));
                }
                int n = original.getValueArgumentsCount();
                for (int index2 = 0; index2 < n; ++index2) {
                    IrExpression it;
                    if (original.getValueArgument(index2) == null) continue;
                    boolean bl = false;
                    call2.putValueArgument(index2 + 2, it);
                }
            }

            static /* synthetic */ void passConstructorArguments$default(EnumClassCallTransformer enumClassCallTransformer, IrBuilderWithScope irBuilderWithScope, IrFunctionAccessExpression irFunctionAccessExpression, IrFunctionAccessExpression irFunctionAccessExpression2, IrEnumEntry irEnumEntry, int n, Object object) {
                if ((n & 4) != 0) {
                    irEnumEntry = null;
                }
                enumClassCallTransformer.passConstructorArguments(irBuilderWithScope, irFunctionAccessExpression, irFunctionAccessExpression2, irEnumEntry);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "valuesField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "entriesField", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;Lorg/jetbrains/kotlin/ir/declarations/IrField;Lorg/jetbrains/kotlin/ir/declarations/IrField;)V", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "backend.jvm.lower"})
        @SourceDebugExtension(value={"SMAP\nEnumClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,323:1\n225#2,4:324\n1549#3:328\n1620#3,3:329\n*S KotlinDebug\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer\n*L\n206#1:324,4\n219#1:328\n219#1:329,3\n*E\n"})
        private final class EnumClassDeclarationsTransformer
        extends IrElementTransformerVoid {
            @NotNull
            private final IrField valuesField;
            @Nullable
            private final IrField entriesField;

            public EnumClassDeclarationsTransformer(@Nullable IrField valuesField, IrField entriesField) {
                Intrinsics.checkNotNullParameter((Object)valuesField, (String)"valuesField");
                this.valuesField = valuesField;
                this.entriesField = entriesField;
            }

            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                return IrUtilsKt.isEnumEntry((IrClass)declaration) ? super.visitClass(declaration) : (IrStatement)declaration;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrStatement visitConstructor(@NotNull IrConstructor declaration) {
                Collection<IrValueParameter> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrFactory $this$buildConstructor$iv = EnumClassLowering.this.context.getIrFactory();
                boolean $i$f$buildConstructor = false;
                IrFunctionBuilder $this$buildConstructor_u24lambda_u2422$iv = new IrFunctionBuilder();
                boolean bl = false;
                IrFunctionBuilder $this$visitConstructor_u24lambda_u240 = $this$buildConstructor_u24lambda_u2422$iv;
                boolean $i$a$-buildConstructor-EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer$visitConstructor$22 = false;
                $this$visitConstructor_u24lambda_u240.updateFrom((IrFunction)declaration);
                $this$visitConstructor_u24lambda_u240.setReturnType(declaration.getReturnType());
                IrConstructor irConstructor = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u2422$iv);
                EnumClassLowering enumClassLowering = EnumClassLowering.this;
                EnumClassTransformer enumClassTransformer = EnumClassTransformer.this;
                IrConstructor $this$visitConstructor_u24lambda_u243 = irConstructor;
                boolean bl2 = false;
                $this$visitConstructor_u24lambda_u243.setParent(declaration.getParent());
                $this$visitConstructor_u24lambda_u243.setAnnotations(declaration.getAnnotations());
                DeclarationBuildersKt.addValueParameter((IrFunction)((IrFunction)$this$visitConstructor_u24lambda_u243), (String)"$enum$name", (IrType)enumClassLowering.context.getIrBuiltIns().getStringType(), (IrDeclarationOrigin)((IrDeclarationOrigin)JvmLoweredDeclarationOrigin.ENUM_CONSTRUCTOR_SYNTHETIC_PARAMETER.INSTANCE));
                DeclarationBuildersKt.addValueParameter((IrFunction)((IrFunction)$this$visitConstructor_u24lambda_u243), (String)"$enum$ordinal", (IrType)enumClassLowering.context.getIrBuiltIns().getIntType(), (IrDeclarationOrigin)((IrDeclarationOrigin)JvmLoweredDeclarationOrigin.ENUM_CONSTRUCTOR_SYNTHETIC_PARAMETER.INSTANCE));
                Iterable $i$a$-buildConstructor-EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer$visitConstructor$22 = declaration.getValueParameters();
                Collection collection2 = $this$visitConstructor_u24lambda_u243.getValueParameters();
                IrConstructor irConstructor2 = $this$visitConstructor_u24lambda_u243;
                boolean $i$f$map = false;
                void var11_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void param;
                    IrValueParameter irValueParameter;
                    IrValueParameter irValueParameter2 = (IrValueParameter)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    IrValueParameter newParam = irValueParameter = IrUtilsKt.copyTo$default((IrValueParameter)param, (IrFunction)((IrFunction)$this$visitConstructor_u24lambda_u243), null, (int)(param.getIndex() + 2), (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (int)8186, null);
                    boolean bl4 = false;
                    ((Map)enumClassTransformer.loweredEnumConstructorParameters).put(param.getSymbol(), newParam);
                    collection.add(irValueParameter);
                }
                collection = (List)destination$iv$iv;
                irConstructor2.setValueParameters(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
                IrBody irBody = declaration.getBody();
                $this$visitConstructor_u24lambda_u243.setBody(irBody != null ? (IrBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrElement)irBody), (IrDeclarationParent)((IrDeclarationParent)$this$visitConstructor_u24lambda_u243)) : null);
                ((Map)enumClassTransformer.loweredEnumConstructors).put(declaration.getSymbol(), $this$visitConstructor_u24lambda_u243);
                $this$visitConstructor_u24lambda_u243.setMetadata(declaration.getMetadata());
                return (IrStatement)irConstructor;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
                IrDeclarationReference irDeclarationReference;
                void $this$visitSimpleFunction_u24lambda_u246;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Object object = declaration.getBody();
                IrSyntheticBody irSyntheticBody = object instanceof IrSyntheticBody ? (IrSyntheticBody)object : null;
                if (irSyntheticBody == null) {
                    return (IrStatement)declaration;
                }
                IrSyntheticBody body2 = irSyntheticBody;
                JvmIrBuilder jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder$default(EnumClassLowering.this.context, (IrSymbol)declaration.getSymbol(), 0, 0, 6, null);
                object = EnumClassLowering.this;
                EnumClassTransformer enumClassTransformer = EnumClassTransformer.this;
                JvmIrBuilder jvmIrBuilder2 = jvmIrBuilder;
                IrSimpleFunction irSimpleFunction = declaration;
                boolean bl = false;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246;
                switch (WhenMappings.$EnumSwitchMapping$0[body2.getKind().ordinal()]) {
                    case 1: {
                        void $this$visitSimpleFunction_u24lambda_u246_u24lambda_u244;
                        IrCall irCall;
                        IrCall irCall2 = irCall = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246), (IrSimpleFunctionSymbol)((EnumClassLowering)object).context.getIr().getSymbols().getObjectCloneFunction(), (IrType)declaration.getReturnType(), (int)0, (int)0, null, (int)28, null);
                        IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
                        boolean bl2 = false;
                        $this$visitSimpleFunction_u24lambda_u246_u24lambda_u244.setDispatchReceiver((IrExpression)ExpressionHelpersKt.irGetField$default((IrBuilderWithScope)((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246), null, (IrField)this.valuesField, null, (int)4, null));
                        irBuilderWithScope = irBuilderWithScope2;
                        irDeclarationReference = (IrDeclarationReference)irCall;
                        break;
                    }
                    case 2: {
                        void $this$visitSimpleFunction_u24lambda_u246_u24lambda_u245;
                        IrCall irCall;
                        IrCall $this$visitSimpleFunction_u24lambda_u246_u24lambda_u244 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246), (IrSimpleFunctionSymbol)$this$visitSimpleFunction_u24lambda_u246.getBackendContext().getIr().getSymbols().getEnumValueOfFunction());
                        IrBuilderWithScope irBuilderWithScope3 = irBuilderWithScope;
                        boolean bl3 = false;
                        $this$visitSimpleFunction_u24lambda_u246_u24lambda_u245.putValueArgument(0, (IrExpression)JvmIrUtilsKt.javaClassReference((JvmIrBuilder)$this$visitSimpleFunction_u24lambda_u246, (IrType)IrUtilsKt.getDefaultType((IrClass)enumClassTransformer.irClass)));
                        $this$visitSimpleFunction_u24lambda_u246_u24lambda_u245.putValueArgument(1, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246), (IrValueDeclaration)((IrValueDeclaration)declaration.getValueParameters().get(0))));
                        irBuilderWithScope = irBuilderWithScope3;
                        irDeclarationReference = (IrDeclarationReference)irCall;
                        break;
                    }
                    case 3: {
                        IrBuilderWithScope irBuilderWithScope4 = (IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246;
                        IrField irField = this.entriesField;
                        Intrinsics.checkNotNull((Object)irField);
                        irDeclarationReference = (IrDeclarationReference)ExpressionHelpersKt.irGetField$default((IrBuilderWithScope)irBuilderWithScope4, null, (IrField)irField, null, (int)4, null);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                irSimpleFunction.setBody((IrBody)ExpressionHelpersKt.irExprBody((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)irDeclarationReference)));
                return (IrStatement)declaration;
            }

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[IrSyntheticBodyKind.values().length];
                    try {
                        nArray[IrSyntheticBodyKind.ENUM_VALUES.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[IrSyntheticBodyKind.ENUM_VALUEOF.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[IrSyntheticBodyKind.ENUM_ENTRIES.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }
}

