/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBodyKind;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000bH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u000bH\u0002J\f\u0010\u0013\u001a\u00020\u0012*\u00020\u000bH\u0002J\f\u0010\u0014\u001a\u00020\u0012*\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ExcludeSyntheticDeclarationsFromExportLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "generateJsExportIgnoreCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "excludeFromJsExport", "", "getOriginalFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isComponentMethodOfDataClass", "", "isExportedSyntheticEnumEntriesProperty", "shouldBeExcludedFromExport", "backend.js"})
public final class ExcludeSyntheticDeclarationsFromExportLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public ExcludeSyntheticDeclarationsFromExportLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.shouldBeExcludedFromExport(declaration)) {
            IrPropertySymbol irPropertySymbol;
            if (declaration instanceof IrSimpleFunction && (irPropertySymbol = ((IrSimpleFunction)declaration).getCorrespondingPropertySymbol()) != null && (irPropertySymbol = (IrProperty)irPropertySymbol.getOwner()) != null) {
                this.excludeFromJsExport((IrDeclaration)irPropertySymbol);
            }
            this.excludeFromJsExport(declaration);
        }
        return null;
    }

    private final boolean shouldBeExcludedFromExport(IrDeclaration $this$shouldBeExcludedFromExport) {
        return this.isExportedSyntheticEnumEntriesProperty($this$shouldBeExcludedFromExport) || this.isComponentMethodOfDataClass($this$shouldBeExcludedFromExport);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isComponentMethodOfDataClass(IrDeclaration $this$isComponentMethodOfDataClass) {
        if (!($this$isComponentMethodOfDataClass instanceof IrSimpleFunction)) {
            return false;
        }
        IrSimpleFunction original = this.getOriginalFunction((IrSimpleFunction)$this$isComponentMethodOfDataClass);
        IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)((IrDeclaration)original));
        if (irClass == null) {
            return false;
        }
        IrClass parent2 = irClass;
        if (!ExportModelGeneratorKt.isExported((IrDeclaration)parent2, this.context)) return false;
        if (!Intrinsics.areEqual((Object)original.getOrigin(), (Object)IrDeclarationOrigin.GENERATED_DATA_CLASS_MEMBER.INSTANCE)) return false;
        String string2 = original.getName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"original.name.identifier");
        if (!StringsKt.startsWith$default((String)string2, (String)StandardNames.DATA_CLASS_COMPONENT_PREFIX, (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isExportedSyntheticEnumEntriesProperty(IrDeclaration $this$isExportedSyntheticEnumEntriesProperty) {
        if (!($this$isExportedSyntheticEnumEntriesProperty instanceof IrSimpleFunction)) return false;
        IrClass irClass = IrJsUtilsKt.getParentEnumClassOrNull($this$isExportedSyntheticEnumEntriesProperty);
        if (irClass == null) return false;
        if (!ExportModelGeneratorKt.isExported((IrDeclaration)irClass, this.context)) return false;
        boolean bl = true;
        if (!bl) return false;
        IrBody irBody = ((IrSimpleFunction)$this$isExportedSyntheticEnumEntriesProperty).getBody();
        IrSyntheticBody irSyntheticBody = irBody instanceof IrSyntheticBody ? (IrSyntheticBody)irBody : null;
        if ((irSyntheticBody != null ? irSyntheticBody.getKind() : null) != IrSyntheticBodyKind.ENUM_ENTRIES) return false;
        return true;
    }

    private final void excludeFromJsExport(IrDeclaration $this$excludeFromJsExport) {
        $this$excludeFromJsExport.setAnnotations(CollectionsKt.plus((Collection)$this$excludeFromJsExport.getAnnotations(), (Object)this.generateJsExportIgnoreCall()));
    }

    private final IrConstructorCall generateJsExportIgnoreCall() {
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor((IrClass)((IrClass)this.context.getIntrinsics().getJsExportIgnoreAnnotationSymbol().getOwner()));
        Intrinsics.checkNotNull((Object)irConstructor);
        return JsIrBuilder.buildConstructorCall$default(JsIrBuilder.INSTANCE, irConstructor.getSymbol(), null, null, null, 14, null);
    }

    private final IrSimpleFunction getOriginalFunction(IrSimpleFunction $this$getOriginalFunction) {
        return $this$getOriginalFunction.getOverriddenSymbols().isEmpty() ? $this$getOriginalFunction : this.getOriginalFunction((IrSimpleFunction)((IrSimpleFunctionSymbol)CollectionsKt.first((List)$this$getOriginalFunction.getOverriddenSymbols())).getOwner());
    }
}

