/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.phaser.NamedCompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseBuildersKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.ToArrayLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u000e\u001a\u00020\b*\u00020\u000fH\u0002\u001a\u001c\u0010\u0010\u001a\u00020\b*\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0014\u0010\u0014\u001a\u00020\b*\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0002H\u0000\u001a\f\u0010\u0016\u001a\u00020\b*\u00020\u0015H\u0000\"0\u0010\u0000\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\"\u001a\u0010\u000b\u001a\u0004\u0018\u00010\t*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"toArrayPhase", "Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/backend/common/phaser/SameTypeNamedCompilerPhase;", "getToArrayPhase", "()Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "isCollectionSubClass", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "superClass", "getSuperClass", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isArrayOrNullableArray", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isArrayOrNullableArrayOf", "context", "element", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "isGenericToArray", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isNonGenericToArray", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nToArrayLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToArrayLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ToArrayLoweringKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1603#2,9:172\n1855#2:181\n1856#2:184\n1612#2:185\n1#3:182\n1#3:183\n*S KotlinDebug\n*F\n+ 1 ToArrayLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ToArrayLoweringKt\n*L\n144#1:172,9\n144#1:181\n144#1:184\n144#1:185\n144#1:183\n*E\n"})
public final class ToArrayLoweringKt {
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrFile> toArrayPhase = PhaseBuildersKt.makeIrFilePhase$default((Function1)toArrayPhase.1.INSTANCE, (String)"ToArray", (String)"Handle toArray functions", null, null, null, null, null, (int)248, null);

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrFile> getToArrayPhase() {
        return toArrayPhase;
    }

    /*
     * WARNING - void declaration
     */
    private static final IrClass getSuperClass(IrClass $this$superClass) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = $this$superClass.getSuperTypes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrType it = (IrType)element$iv$iv;
            boolean bl2 = false;
            if (IrTypesKt.getClass((IrType)it) != null) {
                IrClass irClass;
                IrClass superClass = irClass;
                boolean bl3 = false;
                object = IrUtilsKt.isClass((IrClass)superClass) ? irClass : null;
            } else {
                object = null;
            }
            if (object == null) continue;
            IrClass it$iv$iv = object;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (IrClass)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
    }

    public static final boolean isCollectionSubClass(@NotNull IrClass $this$isCollectionSubClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isCollectionSubClass, (String)"<this>");
        Boolean bl = DFS.ifAny((Collection)$this$isCollectionSubClass.getSuperTypes(), ToArrayLoweringKt::_get_isCollectionSubClass_$lambda$2, (Function1)isCollectionSubClass.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"ifAny(superTypes, { it.g\u2026 }) { it.isCollection() }");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isArrayOrNullableArrayOf(IrType $this$isArrayOrNullableArrayOf, JvmBackendContext context, IrClassifierSymbol element) {
        IrClassifierSymbol irClassifierSymbol;
        if (!($this$isArrayOrNullableArrayOf instanceof IrSimpleType)) return false;
        if (!IrTypePredicatesKt.isArray((IrType)$this$isArrayOrNullableArrayOf)) {
            if (!IrTypePredicatesKt.isNullableArray((IrType)$this$isArrayOrNullableArrayOf)) return false;
        }
        if (((IrSimpleType)$this$isArrayOrNullableArrayOf).getArguments().size() != 1) return false;
        IrTypeArgument it = (IrTypeArgument)((IrSimpleType)$this$isArrayOrNullableArrayOf).getArguments().get(0);
        if (it instanceof IrStarProjection) {
            irClassifierSymbol = (IrClassifierSymbol)context.getIrBuiltIns().getAnyClass();
        } else {
            if (!(it instanceof IrTypeProjection)) throw new NoWhenBranchMatchedException();
            irClassifierSymbol = ((IrTypeProjection)it).getVariance() == Variance.IN_VARIANCE ? (IrClassifierSymbol)context.getIrBuiltIns().getAnyClass() : IrTypesKt.getClassifierOrNull((IrType)((IrTypeProjection)it).getType());
        }
        if (!Intrinsics.areEqual((Object)element, (Object)irClassifierSymbol)) return false;
        return true;
    }

    public static final boolean isGenericToArray(@NotNull IrSimpleFunction $this$isGenericToArray, @NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$isGenericToArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Intrinsics.areEqual((Object)$this$isGenericToArray.getName().asString(), (Object)"toArray") && $this$isGenericToArray.getTypeParameters().size() == 1 && $this$isGenericToArray.getValueParameters().size() == 1 && $this$isGenericToArray.getExtensionReceiverParameter() == null && ToArrayLoweringKt.isArrayOrNullableArrayOf($this$isGenericToArray.getReturnType(), context, (IrClassifierSymbol)((IrTypeParameter)$this$isGenericToArray.getTypeParameters().get(0)).getSymbol()) && ToArrayLoweringKt.isArrayOrNullableArrayOf(((IrValueParameter)$this$isGenericToArray.getValueParameters().get(0)).getType(), context, (IrClassifierSymbol)((IrTypeParameter)$this$isGenericToArray.getTypeParameters().get(0)).getSymbol());
    }

    public static final boolean isNonGenericToArray(@NotNull IrSimpleFunction $this$isNonGenericToArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isNonGenericToArray, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isNonGenericToArray.getName().asString(), (Object)"toArray") && $this$isNonGenericToArray.getTypeParameters().isEmpty() && $this$isNonGenericToArray.getValueParameters().isEmpty() && $this$isNonGenericToArray.getExtensionReceiverParameter() == null && ToArrayLoweringKt.isArrayOrNullableArray($this$isNonGenericToArray.getReturnType());
    }

    private static final boolean isArrayOrNullableArray(IrType $this$isArrayOrNullableArray) {
        return $this$isArrayOrNullableArray instanceof IrSimpleType && (IrTypePredicatesKt.isArray((IrType)$this$isArrayOrNullableArray) || IrTypePredicatesKt.isNullableArray((IrType)$this$isArrayOrNullableArray));
    }

    private static final Iterable _get_isCollectionSubClass_$lambda$2(IrType it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        Object object = IrTypesKt.getClass((IrType)it);
        return object != null && (object = object.getSuperTypes()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList();
    }

    public static final /* synthetic */ IrClass access$getSuperClass(IrClass $receiver) {
        return ToArrayLoweringKt.getSuperClass($receiver);
    }
}

