/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformerKt;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReporterWithContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.descriptors.IrBasedDescriptorsKt;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ConflictingJvmDeclarationsData;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmBackendErrors;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.MemberKind;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.RawSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\bH\u0002J\u001e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\bH\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0006\u0010\u001d\u001a\u00020\u000eJ\b\u0010\u001e\u001a\u00020\u000eH\u0002J,\u0010\u001f\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010#\u001a\u00020\u0015H\u0002J\b\u0010$\u001a\u00020\u000eH\u0002J\b\u0010%\u001a\u00020\u000eH\u0002J\u000e\u0010&\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\u0016\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0007J\u0016\u0010)\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0007J\f\u0010*\u001a\u00020+*\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0005\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u000b\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\b`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/JvmSignatureClashDetector;", "", "classCodegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "(Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;)V", "fieldsBySignature", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/resolve/jvm/diagnostics/RawSignature;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lkotlin/collections/LinkedHashMap;", "methodsBySignature", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "collectOverridesOf", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "result", "collectOverridesTree", "visited", "getConflictingJvmDeclarationsData", "Lorg/jetbrains/kotlin/resolve/jvm/diagnostics/ConflictingJvmDeclarationsData;", "rawSignature", "methods", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getOverriddenFunctions", "", "mapRawSignature", "reportErrors", "reportFieldSignatureConflicts", "reportJvmSignatureClash", "diagnosticFactory1", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;", "irDeclarations", "conflictingJvmDeclarationsData", "reportMethodSignatureConflicts", "reportPredefinedMethodSignatureConflicts", "trackFakeOverrideMethod", "trackField", "irField", "trackMethod", "isSpecialOverride", "", "Companion", "backend.jvm.codegen"})
@SourceDebugExtension(value={"SMAP\nJvmSignatureClashDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmSignatureClashDetector.kt\norg/jetbrains/kotlin/backend/jvm/codegen/JvmSignatureClashDetector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n372#2,7:184\n372#2,7:191\n1774#3,4:198\n1774#3,4:202\n1747#3,3:206\n766#3:209\n857#3,2:210\n766#3:212\n857#3,2:213\n1549#3:215\n1620#3,3:216\n1611#3:219\n1855#3:220\n1856#3:222\n1612#3:223\n1855#3,2:224\n1549#3:226\n1620#3,3:227\n1#4:221\n*S KotlinDebug\n*F\n+ 1 JvmSignatureClashDetector.kt\norg/jetbrains/kotlin/backend/jvm/codegen/JvmSignatureClashDetector\n*L\n29#1:184,7\n33#1:191,7\n81#1:198,4\n82#1:202,4\n101#1:206,3\n115#1:209\n115#1:210,2\n126#1:212\n126#1:213,2\n129#1:215\n129#1:216,3\n148#1:219\n148#1:220\n148#1:222\n148#1:223\n150#1:224,2\n160#1:226\n160#1:227,3\n148#1:221\n*E\n"})
public final class JvmSignatureClashDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassCodegen classCodegen;
    @NotNull
    private final LinkedHashMap<RawSignature, Set<IrFunction>> methodsBySignature;
    @NotNull
    private final LinkedHashMap<RawSignature, Set<IrField>> fieldsBySignature;
    @NotNull
    private static final Set<IrDeclarationOriginImpl> SPECIAL_BRIDGES_AND_OVERRIDES;
    @NotNull
    private static final List<RawSignature> PREDEFINED_SIGNATURES;

    public JvmSignatureClashDetector(@NotNull ClassCodegen classCodegen) {
        Intrinsics.checkNotNullParameter((Object)classCodegen, (String)"classCodegen");
        this.classCodegen = classCodegen;
        this.methodsBySignature = new LinkedHashMap();
        this.fieldsBySignature = new LinkedHashMap();
    }

    public final void trackField(@NotNull IrField irField, @NotNull RawSignature rawSignature) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)irField, (String)"irField");
        Intrinsics.checkNotNullParameter((Object)rawSignature, (String)"rawSignature");
        Map $this$getOrPut$iv = this.fieldsBySignature;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(rawSignature);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = (Set)SmartSet.Companion.create();
            $this$getOrPut$iv.put(rawSignature, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((Set)object).add(irField);
    }

    public final void trackMethod(@NotNull IrFunction irFunction, @NotNull RawSignature rawSignature) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)rawSignature, (String)"rawSignature");
        Map $this$getOrPut$iv = this.methodsBySignature;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(rawSignature);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = (Set)SmartSet.Companion.create();
            $this$getOrPut$iv.put(rawSignature, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((Set)object).add(irFunction);
    }

    public final void trackFakeOverrideMethod(@NotNull IrFunction irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        if (irFunction.getDispatchReceiverParameter() != null) {
            for (IrFunction overriddenFunction : this.getOverriddenFunctions((IrSimpleFunction)irFunction)) {
                this.trackMethod(irFunction, this.mapRawSignature(overriddenFunction));
            }
        } else {
            this.trackMethod(irFunction, this.mapRawSignature(irFunction));
        }
    }

    private final RawSignature mapRawSignature(IrFunction irFunction) {
        JvmMethodSignature jvmSignature = this.classCodegen.getMethodSignatureMapper().mapFakeOverrideSignatureSkipGeneric(irFunction);
        String string2 = jvmSignature.getAsmMethod().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jvmSignature.asmMethod.name");
        String string3 = jvmSignature.getAsmMethod().getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jvmSignature.asmMethod.descriptor");
        return new RawSignature(string2, string3, MemberKind.METHOD);
    }

    private final Set<IrFunction> getOverriddenFunctions(IrSimpleFunction irFunction) {
        LinkedHashSet result2 = new LinkedHashSet();
        this.collectOverridesOf(irFunction, result2);
        return result2;
    }

    private final void collectOverridesOf(IrSimpleFunction irFunction, Set<IrFunction> result2) {
        for (IrSimpleFunctionSymbol overriddenSymbol : irFunction.getOverriddenSymbols()) {
            this.collectOverridesTree((IrSimpleFunction)overriddenSymbol.getOwner(), result2);
        }
    }

    private final void collectOverridesTree(IrSimpleFunction irFunction, Set<IrFunction> visited2) {
        if (!visited2.add((IrFunction)irFunction)) {
            return;
        }
        this.collectOverridesOf(irFunction, visited2);
    }

    private final boolean isSpecialOverride(IrFunction $this$isSpecialOverride) {
        return CollectionsKt.contains((Iterable)SPECIAL_BRIDGES_AND_OVERRIDES, (Object)$this$isSpecialOverride.getOrigin());
    }

    public final void reportErrors() {
        this.reportMethodSignatureConflicts();
        this.reportPredefinedMethodSignatureConflicts();
        this.reportFieldSignatureConflicts();
    }

    /*
     * WARNING - void declaration
     */
    private final void reportMethodSignatureConflicts() {
        for (Map.Entry entry : ((Map)this.methodsBySignature).entrySet()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable $this$any$iv;
            Object element$iv;
            int n;
            int n2;
            RawSignature rawSignature = (RawSignature)entry.getKey();
            Set methods2 = (Set)entry.getValue();
            if (methods2.size() <= 1) continue;
            Iterable $this$count$iv = methods2;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv2 : $this$count$iv) {
                    IrFunction it = (IrFunction)element$iv2;
                    boolean bl = false;
                    if (!IrFakeOverrideUtilsKt.isFakeOverride((IrDeclaration)((IrDeclaration)it)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            int fakeOverridesCount = n2;
            Iterable $this$count$iv2 = methods2;
            boolean $i$f$count2 = false;
            if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                n = 0;
            } else {
                Object element$iv2;
                int count$iv = 0;
                element$iv2 = $this$count$iv2.iterator();
                while (element$iv2.hasNext()) {
                    element$iv = element$iv2.next();
                    IrFunction it = (IrFunction)element$iv;
                    boolean bl = false;
                    if (!this.isSpecialOverride(it) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int specialOverridesCount = n;
            int realMethodsCount = methods2.size() - fakeOverridesCount - specialOverridesCount;
            ConflictingJvmDeclarationsData conflictingJvmDeclarationsData = this.getConflictingJvmDeclarationsData(rawSignature, methods2);
            if (realMethodsCount == 0 && (fakeOverridesCount > 1 || specialOverridesCount > 1)) {
                if (Intrinsics.areEqual((Object)this.classCodegen.getIrClass().getOrigin(), (Object)((Object)JvmLoweredDeclarationOrigin.DEFAULT_IMPLS.INSTANCE))) continue;
                this.reportJvmSignatureClash((KtDiagnosticFactory1<ConflictingJvmDeclarationsData>)JvmBackendErrors.INSTANCE.getCONFLICTING_INHERITED_JVM_DECLARATIONS(), CollectionsKt.listOf((Object)this.classCodegen.getIrClass()), conflictingJvmDeclarationsData);
                continue;
            }
            if (fakeOverridesCount == 0 && specialOverridesCount == 0) {
                if (Intrinsics.areEqual((Object)this.classCodegen.getIrClass().getOrigin(), (Object)((Object)JvmLoweredDeclarationOrigin.DEFAULT_IMPLS.INSTANCE))) {
                    boolean bl;
                    block14: {
                        $this$any$iv = methods2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv3 : $this$any$iv) {
                                IrFunction it = (IrFunction)element$iv3;
                                boolean bl2 = false;
                                if (!DescriptorVisibilities.isPrivate(it.getVisibility())) continue;
                                bl = true;
                                break block14;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                }
                this.reportJvmSignatureClash((KtDiagnosticFactory1<ConflictingJvmDeclarationsData>)JvmBackendErrors.INSTANCE.getCONFLICTING_JVM_DECLARATIONS(), methods2, conflictingJvmDeclarationsData);
                continue;
            }
            if (Intrinsics.areEqual((Object)this.classCodegen.getIrClass().getOrigin(), (Object)((Object)JvmLoweredDeclarationOrigin.DEFAULT_IMPLS.INSTANCE))) continue;
            $this$any$iv = methods2;
            KtDiagnosticFactory1 ktDiagnosticFactory1 = JvmBackendErrors.INSTANCE.getACCIDENTAL_OVERRIDE();
            JvmSignatureClashDetector jvmSignatureClashDetector = this;
            boolean $i$f$filter = false;
            element$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IrFunction it = (IrFunction)element$iv$iv;
                boolean bl = false;
                if (!(!IrFakeOverrideUtilsKt.isFakeOverride((IrDeclaration)((IrDeclaration)it)) && !this.isSpecialOverride(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            jvmSignatureClashDetector.reportJvmSignatureClash((KtDiagnosticFactory1<ConflictingJvmDeclarationsData>)ktDiagnosticFactory1, list2, conflictingJvmDeclarationsData);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportPredefinedMethodSignatureConflicts() {
        for (RawSignature predefinedSignature : PREDEFINED_SIGNATURES) {
            String string2;
            Collection<FunctionDescriptor> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Set<IrFunction> knownMethods;
            if (this.methodsBySignature.get(predefinedSignature) == null) continue;
            Iterable $this$filter$iv = knownMethods;
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IrFunction it = (IrFunction)element$iv$iv;
                boolean bl = false;
                if (!(!IrFakeOverrideUtilsKt.isFakeOverride((IrDeclaration)((IrDeclaration)it)) && !this.isSpecialOverride(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List methods2 = (List)destination$iv$iv;
            if (methods2.isEmpty()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)this.classCodegen.getType().getInternalName(), (String)"classCodegen.type.internalName");
            Iterable $i$f$filter22 = methods2;
            Collection collection2 = null;
            RawSignature rawSignature = predefinedSignature;
            JvmDeclarationOrigin jvmDeclarationOrigin = null;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                IrFunction bl = (IrFunction)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(IrBasedDescriptorsKt.toIrBasedDescriptor((IrFunction)p0));
            }
            collection = (List)destination$iv$iv2;
            Collection collection3 = collection;
            Collection collection4 = collection2;
            RawSignature rawSignature2 = rawSignature;
            JvmDeclarationOrigin jvmDeclarationOrigin2 = jvmDeclarationOrigin;
            String string3 = string2;
            ConflictingJvmDeclarationsData conflictingJvmDeclarationsData = new ConflictingJvmDeclarationsData(string3, jvmDeclarationOrigin2, rawSignature2, collection4, collection3);
            this.reportJvmSignatureClash((KtDiagnosticFactory1<ConflictingJvmDeclarationsData>)JvmBackendErrors.INSTANCE.getACCIDENTAL_OVERRIDE(), methods2, conflictingJvmDeclarationsData);
        }
    }

    private final void reportFieldSignatureConflicts() {
        for (Map.Entry entry : ((Map)this.fieldsBySignature).entrySet()) {
            RawSignature rawSignature = (RawSignature)entry.getKey();
            Set fields2 = (Set)entry.getValue();
            if (fields2.size() <= 1) continue;
            ConflictingJvmDeclarationsData conflictingJvmDeclarationsData = this.getConflictingJvmDeclarationsData(rawSignature, fields2);
            this.reportJvmSignatureClash((KtDiagnosticFactory1<ConflictingJvmDeclarationsData>)JvmBackendErrors.INSTANCE.getCONFLICTING_JVM_DECLARATIONS(), fields2, conflictingJvmDeclarationsData);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportJvmSignatureClash(KtDiagnosticFactory1<ConflictingJvmDeclarationsData> diagnosticFactory1, Collection<? extends IrDeclaration> irDeclarations2, ConflictingJvmDeclarationsData conflictingJvmDeclarationsData) {
        void $this$forEach$iv;
        Iterable $this$mapNotNullTo$iv;
        Iterable iterable = irDeclarations2;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtDiagnosticReporterWithContext.DiagnosticContextImpl it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            IrDeclaration irDeclaration2 = (IrDeclaration)element$iv;
            boolean bl2 = false;
            IrElement[] irElementArray = new IrElement[]{irDeclaration2, this.classCodegen.getIrClass()};
            if (this.classCodegen.getContext().getKtDiagnosticReporter().atFirstValidFrom(irElementArray, IrUtilsKt.getFile((IrDeclaration)irDeclaration2)) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        $this$mapNotNullTo$iv = destination$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            KtDiagnosticReporterWithContext.DiagnosticContextImpl it = (KtDiagnosticReporterWithContext.DiagnosticContextImpl)element$iv;
            boolean bl = false;
            it.report(diagnosticFactory1, (Object)conflictingJvmDeclarationsData);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ConflictingJvmDeclarationsData getConflictingJvmDeclarationsData(RawSignature rawSignature, Collection<? extends IrDeclaration> methods2) {
        Collection<DeclarationDescriptor> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string2 = this.classCodegen.getType().getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classCodegen.type.internalName");
        Iterable iterable = methods2;
        Collection collection2 = null;
        RawSignature rawSignature2 = rawSignature;
        JvmDeclarationOrigin jvmDeclarationOrigin = null;
        String string3 = string2;
        boolean $i$f$map = false;
        void var5_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            IrDeclaration irDeclaration2 = (IrDeclaration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(IrBasedDescriptorsKt.toIrBasedDescriptor((IrDeclaration)p0));
        }
        collection = (List)destination$iv$iv;
        Collection collection3 = collection;
        Collection collection4 = collection2;
        RawSignature rawSignature3 = rawSignature2;
        JvmDeclarationOrigin jvmDeclarationOrigin2 = jvmDeclarationOrigin;
        String string4 = string3;
        return new ConflictingJvmDeclarationsData(string4, jvmDeclarationOrigin2, rawSignature3, collection4, collection3);
    }

    static {
        Object[] objectArray = new IrDeclarationOriginImpl[]{IrDeclarationOrigin.BRIDGE.INSTANCE, IrDeclarationOrigin.BRIDGE_SPECIAL.INSTANCE, IrDeclarationOrigin.IR_BUILTINS_STUB.INSTANCE, JvmLoweredDeclarationOrigin.TO_ARRAY.INSTANCE, JvmLoweredDeclarationOrigin.SUPER_INTERFACE_METHOD_BRIDGE.INSTANCE, AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION()};
        SPECIAL_BRIDGES_AND_OVERRIDES = SetsKt.setOf((Object[])objectArray);
        objectArray = new RawSignature[]{new RawSignature("getClass", "()Ljava/lang/Class;", MemberKind.METHOD), new RawSignature("notify", "()V", MemberKind.METHOD), new RawSignature("notifyAll", "()V", MemberKind.METHOD), new RawSignature("wait", "()V", MemberKind.METHOD), new RawSignature("wait", "(J)V", MemberKind.METHOD), new RawSignature("wait", "(JI)V", MemberKind.METHOD)};
        PREDEFINED_SIGNATURES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/JvmSignatureClashDetector$Companion;", "", "()V", "PREDEFINED_SIGNATURES", "", "Lorg/jetbrains/kotlin/resolve/jvm/diagnostics/RawSignature;", "getPREDEFINED_SIGNATURES", "()Ljava/util/List;", "SPECIAL_BRIDGES_AND_OVERRIDES", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "getSPECIAL_BRIDGES_AND_OVERRIDES", "()Ljava/util/Set;", "backend.jvm.codegen"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<IrDeclarationOriginImpl> getSPECIAL_BRIDGES_AND_OVERRIDES() {
            return SPECIAL_BRIDGES_AND_OVERRIDES;
        }

        @NotNull
        public final List<RawSignature> getPREDEFINED_SIGNATURES() {
            return PREDEFINED_SIGNATURES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

