/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.OverloadFilter;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u001e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015H\u0002J\u0016\u0010\u001b\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015H\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JS\u0010\u001e\u001a\u00020\u00102\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001c0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u001e\u0010$\u001a\u001a\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00150%H\u0082\bJ\u001c\u0010(\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u001a0 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015H\u0002J?\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00152\u0006\u0010,\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u00052\u001e\u0010$\u001a\u001a\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00150%H\u0082\bJ\"\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00150\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015H\u0002J$\u0010.\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001c0 2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020#H\u0002J\u0018\u00103\u001a\u0002002\u0006\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u001cH\u0002J\u0018\u00104\u001a\u0002002\u0006\u00105\u001a\u00020#2\u0006\u00106\u001a\u00020#H\u0002J\u0018\u00107\u001a\u0002002\u0006\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020#H\u0002J\u0016\u00108\u001a\u00020\u00102\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015H\u0002J\f\u0010:\u001a\u000200*\u00020#H\u0002J\f\u0010;\u001a\u000200*\u00020#H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/resolve/OverloadResolver;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "overloadFilter", "Lorg/jetbrains/kotlin/resolve/OverloadFilter;", "overloadChecker", "Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "mainFunctionDetectorFactory", "Lorg/jetbrains/kotlin/idea/MainFunctionDetector$Factory;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/OverloadFilter;Lorg/jetbrains/kotlin/resolve/OverloadChecker;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/idea/MainFunctionDetector$Factory;)V", "mainFunctionDetector", "Lorg/jetbrains/kotlin/idea/MainFunctionDetector;", "checkOverloads", "", "c", "Lorg/jetbrains/kotlin/resolve/BodiesResolveContext;", "checkOverloadsInClass", "members", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "nestedClassConstructors", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkOverloadsInPackage", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorNonRoot;", "checkOverloadsInPackages", "collectModulePackageMembersWithSameName", "packageMembersByName", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "interestingDescriptors", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getMembersByName", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "Lorg/jetbrains/kotlin/name/Name;", "findConstructorsInNestedClassesAndTypeAliases", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "findRedeclarations", "getModulePackageMembersWithSameName", "descriptor", "getPossibleRedeclarationGroups", "groupModulePackageMembersByFqName", "isConstructorsOfDifferentRedeclaredClasses", "", "member1", "member2", "isDefinitionsForDifferentPlatforms", "isExpectDeclarationAndDefinition", "declaration", "definition", "isTopLevelMainInDifferentFiles", "reportRedeclarations", "redeclarations", "isPrivate", "isSynthesized", "frontend"})
@SourceDebugExtension(value={"SMAP\nOverloadResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverloadResolver.kt\norg/jetbrains/kotlin/resolve/OverloadResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 diagnosticUtils.kt\norg/jetbrains/kotlin/diagnostics/DiagnosticUtilsKt\n*L\n1#1,312:1\n131#1,32:313\n164#1:347\n161#1,7:349\n140#1,3:356\n131#1,32:359\n164#1:393\n161#1,7:395\n140#1,3:402\n149#1,14:405\n164#1:421\n161#1,7:423\n766#2:345\n857#2:346\n858#2:348\n766#2:391\n857#2:392\n858#2:394\n766#2:419\n857#2:420\n858#2:422\n766#2:430\n857#2,2:431\n1855#2:433\n1856#2:441\n766#2:442\n857#2,2:443\n1477#2:445\n1502#2,3:446\n1505#2,3:456\n1747#2,3:459\n372#3,7:434\n372#3,7:449\n163#4,4:462\n163#4,4:466\n*S KotlinDebug\n*F\n+ 1 OverloadResolver.kt\norg/jetbrains/kotlin/resolve/OverloadResolver\n*L\n96#1:313,32\n96#1:347\n96#1:349,7\n96#1:356,3\n116#1:359,32\n116#1:393\n116#1:395,7\n116#1:402,3\n139#1:405,14\n139#1:421\n139#1:423,7\n96#1:345\n96#1:346\n96#1:348\n116#1:391\n116#1:392\n116#1:394\n139#1:419\n139#1:420\n139#1:422\n162#1:430\n162#1:431,2\n196#1:433\n196#1:441\n213#1:442\n213#1:443,2\n215#1:445\n215#1:446,3\n215#1:456,3\n220#1:459,3\n197#1:434,7\n215#1:449,7\n305#1:462,4\n307#1:466,4\n*E\n"})
public final class OverloadResolver {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final OverloadFilter overloadFilter;
    @NotNull
    private final OverloadChecker overloadChecker;
    @NotNull
    private final MainFunctionDetector mainFunctionDetector;

    public OverloadResolver(@NotNull BindingTrace trace, @NotNull OverloadFilter overloadFilter, @NotNull OverloadChecker overloadChecker, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull MainFunctionDetector.Factory mainFunctionDetectorFactory) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)overloadFilter, (String)"overloadFilter");
        Intrinsics.checkNotNullParameter((Object)overloadChecker, (String)"overloadChecker");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)mainFunctionDetectorFactory, (String)"mainFunctionDetectorFactory");
        this.trace = trace;
        this.overloadFilter = overloadFilter;
        this.overloadChecker = overloadChecker;
        this.mainFunctionDetector = mainFunctionDetectorFactory.createMainFunctionDetector(this.trace, languageVersionSettings2);
    }

    public final void checkOverloads(@NotNull BodiesResolveContext c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        MultiMap<ClassDescriptor, FunctionDescriptor> inClasses = this.findConstructorsInNestedClassesAndTypeAliases(c);
        for (ClassDescriptorWithResolutionScopes value2 : c.getDeclaredClasses().values()) {
            Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
            Collection collection = inClasses.get((Object)value2);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"inClasses.get(value)");
            this.checkOverloadsInClass(value2, collection);
        }
        this.checkOverloadsInPackages(c);
    }

    private final MultiMap<ClassDescriptor, FunctionDescriptor> findConstructorsInNestedClassesAndTypeAliases(BodiesResolveContext c) {
        DeclarationDescriptor containingDeclaration;
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create<ClassDescriptor, FunctionDescriptor>()");
        MultiMap constructorsByOuterClass = multiMap;
        for (ClassDescriptorWithResolutionScopes klass : c.getDeclaredClasses().values()) {
            if (klass.getKind().isSingleton() || klass.getName().isSpecial()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)klass.getContainingDeclaration(), (String)"klass.containingDeclaration");
            if (containingDeclaration instanceof ScriptDescriptor) continue;
            if (containingDeclaration instanceof ClassDescriptor) {
                constructorsByOuterClass.putValues((Object)containingDeclaration, klass.getConstructors());
                continue;
            }
            if (containingDeclaration instanceof FunctionDescriptor || containingDeclaration instanceof PropertyDescriptor || containingDeclaration instanceof PackageFragmentDescriptor) continue;
            throw new IllegalStateException("Illegal class container: " + containingDeclaration);
        }
        for (TypeAliasDescriptor typeAlias : c.getTypeAliases().values()) {
            Intrinsics.checkNotNullExpressionValue((Object)typeAlias.getContainingDeclaration(), (String)"typeAlias.containingDeclaration");
            if (!(containingDeclaration instanceof ClassDescriptor)) continue;
            constructorsByOuterClass.putValues((Object)containingDeclaration, typeAlias.getConstructors());
        }
        return constructorsByOuterClass;
    }

    private final void checkOverloadsInPackages(BodiesResolveContext c) {
        MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot> membersByName = this.groupModulePackageMembersByFqName(c, this.overloadFilter);
        for (Map.Entry e : membersByName.entrySet()) {
            Object v = e.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"e.value");
            this.checkOverloadsInPackage((Collection)v);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot> groupModulePackageMembersByFqName(BodiesResolveContext c, OverloadFilter overloadFilter) {
        List possibleOverloads$iv$iv;
        Object $this$filter$iv$iv$iv;
        ClassifierDescriptor classifier;
        Name name2;
        Object scope;
        Object containingPackageScope$iv$iv;
        Object containingModule$iv$iv;
        DeclarationDescriptor containingPackage$iv$iv;
        boolean $i$f$getModulePackageMembersWithSameName;
        OverloadResolver this_$iv$iv;
        OverloadResolver this_$iv;
        FqNameUnsafe descriptorFQN$iv;
        Collection<PropertyDescriptor> interestingDescriptors$iv;
        MultiMap packageMembersByName = new MultiMap();
        OverloadResolver overloadResolver = this;
        Collection<SimpleFunctionDescriptor> collection = c.getFunctions().values();
        Intrinsics.checkNotNull(collection, (String)"null cannot be cast to non-null type kotlin.collections.Collection<org.jetbrains.kotlin.descriptors.DeclarationDescriptor>");
        Collection collection2 = CollectionsKt.plus((Collection)CollectionsKt.plus(collection, (Iterable)c.getDeclaredClasses().values()), (Iterable)c.getTypeAliases().values());
        boolean $i$f$collectModulePackageMembersWithSameName = false;
        HashSet<FqNameUnsafe> observedFQNs$iv = new HashSet<FqNameUnsafe>();
        for (DeclarationDescriptor declarationDescriptor : interestingDescriptors$iv) {
            Collection<DeclarationDescriptorNonRoot> collection3;
            if (!(declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)DescriptorUtils.getFqName(declarationDescriptor), (String)"getFqName(descriptor)");
            if (observedFQNs$iv.contains(descriptorFQN$iv)) continue;
            observedFQNs$iv.add(descriptorFQN$iv);
            this_$iv$iv = this_$iv;
            $i$f$getModulePackageMembersWithSameName = false;
            containingPackage$iv$iv = declarationDescriptor.getContainingDeclaration();
            if (!(containingPackage$iv$iv instanceof PackageFragmentDescriptor)) {
                throw new AssertionError((Object)(declarationDescriptor + " is not a top-level package member"));
            }
            if (DescriptorUtils.getContainingModuleOrNull(declarationDescriptor) == null) {
                DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
                if (declarationDescriptor2 instanceof CallableMemberDescriptor) {
                    collection3 = CollectionsKt.listOf((Object)declarationDescriptor);
                } else {
                    if (!(declarationDescriptor2 instanceof ClassDescriptor)) throw new AssertionError((Object)("Unexpected descriptor kind: " + declarationDescriptor));
                    Collection<ClassConstructorDescriptor> collection4 = ((ClassDescriptor)declarationDescriptor).getConstructors();
                    collection3 = collection4;
                    Intrinsics.checkNotNullExpressionValue(collection4, (String)"descriptor.constructors");
                }
            } else {
                void $this$filterTo$iv$iv$iv$iv;
                Collection collection5;
                ModuleDescriptor moduleDescriptor;
                Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"DescriptorUtils.getConta\u2026: $descriptor\")\n        }");
                containingModule$iv$iv = moduleDescriptor;
                containingPackageScope$iv$iv = containingModule$iv$iv.getPackage(((PackageFragmentDescriptor)containingPackage$iv$iv).getFqName()).getMemberScope();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor.getName(), (String)"descriptor.name");
                scope = containingPackageScope$iv$iv;
                boolean bl = false;
                Collection functions2 = scope.getContributedFunctions(name2, (LookupLocation)NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                ClassifierDescriptor classifierDescriptor = classifier = scope.getContributedClassifier(name2, (LookupLocation)NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                if (classifierDescriptor instanceof ClassDescriptor) {
                    if (!((ClassDescriptor)classifier).getKind().isSingleton()) {
                        Collection<ClassConstructorDescriptor> collection6 = ((ClassDescriptor)classifier).getConstructors();
                        Intrinsics.checkNotNullExpressionValue(collection6, (String)"classifier.constructors");
                        collection5 = CollectionsKt.plus((Collection)functions2, (Iterable)collection6);
                    } else {
                        collection5 = functions2;
                    }
                } else {
                    collection5 = classifierDescriptor instanceof TypeAliasDescriptor ? (Collection)CollectionsKt.plus(functions2, (Iterable)((TypeAliasDescriptor)classifier).getConstructors()) : functions2;
                }
                $this$filter$iv$iv$iv = collection5;
                boolean $i$f$filter2 = false;
                Object object = $this$filter$iv$iv$iv;
                Collection destination$iv$iv$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                    DeclarationDescriptorNonRoot it$iv$iv = (DeclarationDescriptorNonRoot)element$iv$iv$iv$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtils.getContainingModule(it$iv$iv), (Object)containingModule$iv$iv)) continue;
                    destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                }
                possibleOverloads$iv$iv = (List)destination$iv$iv$iv$iv;
                collection3 = overloadFilter.filterPackageMemberOverloads(possibleOverloads$iv$iv);
            }
            Collection<ClassConstructorDescriptor> packageMembersWithSameName$iv = collection3;
            packageMembersByName.putValues((Object)descriptorFQN$iv, packageMembersWithSameName$iv);
        }
        this_$iv = this;
        interestingDescriptors$iv = c.getProperties().values();
        $i$f$collectModulePackageMembersWithSameName = false;
        observedFQNs$iv = new HashSet();
        for (DeclarationDescriptor declarationDescriptor : interestingDescriptors$iv) {
            Collection<DeclarationDescriptorNonRoot> collection7;
            if (!(declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)DescriptorUtils.getFqName(declarationDescriptor), (String)"getFqName(descriptor)");
            if (observedFQNs$iv.contains(descriptorFQN$iv)) continue;
            observedFQNs$iv.add(descriptorFQN$iv);
            this_$iv$iv = this_$iv;
            $i$f$getModulePackageMembersWithSameName = false;
            containingPackage$iv$iv = declarationDescriptor.getContainingDeclaration();
            if (!(containingPackage$iv$iv instanceof PackageFragmentDescriptor)) {
                throw new AssertionError((Object)(declarationDescriptor + " is not a top-level package member"));
            }
            ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModuleOrNull(declarationDescriptor);
            if (moduleDescriptor == null) {
                $this$filter$iv$iv$iv = declarationDescriptor;
                if ($this$filter$iv$iv$iv instanceof CallableMemberDescriptor) {
                    collection7 = CollectionsKt.listOf((Object)declarationDescriptor);
                } else {
                    if (!($this$filter$iv$iv$iv instanceof ClassDescriptor)) throw new AssertionError((Object)("Unexpected descriptor kind: " + declarationDescriptor));
                    Collection<ClassConstructorDescriptor> collection8 = ((ClassDescriptor)declarationDescriptor).getConstructors();
                    collection7 = collection8;
                    Intrinsics.checkNotNullExpressionValue(collection8, (String)"descriptor.constructors");
                }
            } else {
                void $this$filterTo$iv$iv$iv$iv;
                containingPackageScope$iv$iv = moduleDescriptor;
                Intrinsics.checkNotNullExpressionValue((Object)containingPackageScope$iv$iv, (String)"DescriptorUtils.getConta\u2026: $descriptor\")\n        }");
                containingModule$iv$iv = containingPackageScope$iv$iv;
                containingPackageScope$iv$iv = containingModule$iv$iv.getPackage(((PackageFragmentDescriptor)containingPackage$iv$iv).getFqName()).getMemberScope();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor.getName(), (String)"descriptor.name");
                scope = containingPackageScope$iv$iv;
                boolean bl = false;
                Collection<? extends PropertyDescriptor> variables2 = scope.getContributedVariables(name2, (LookupLocation)NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                classifier = scope.getContributedClassifier(name2, (LookupLocation)NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                $this$filter$iv$iv$iv = CollectionsKt.plus(variables2, (Iterable)CollectionsKt.listOfNotNull((Object)classifier));
                boolean $i$f$filter = false;
                Object $i$f$filter2 = $this$filter$iv$iv$iv;
                Collection destination$iv$iv$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                    DeclarationDescriptorNonRoot it$iv$iv = (DeclarationDescriptorNonRoot)element$iv$iv$iv$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtils.getContainingModule(it$iv$iv), (Object)containingModule$iv$iv)) continue;
                    destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                }
                possibleOverloads$iv$iv = (List)destination$iv$iv$iv$iv;
                collection7 = overloadFilter.filterPackageMemberOverloads(possibleOverloads$iv$iv);
            }
            Collection<ClassConstructorDescriptor> packageMembersWithSameName$iv = collection7;
            packageMembersByName.putValues((Object)descriptorFQN$iv, packageMembersWithSameName$iv);
        }
        return packageMembersByName;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void collectModulePackageMembersWithSameName(MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot> packageMembersByName, Collection<? extends DeclarationDescriptor> interestingDescriptors, OverloadFilter overloadFilter, Function2<? super MemberScope, ? super Name, ? extends Collection<? extends DeclarationDescriptorNonRoot>> getMembersByName) {
        boolean $i$f$collectModulePackageMembersWithSameName = false;
        HashSet<FqNameUnsafe> observedFQNs = new HashSet<FqNameUnsafe>();
        for (DeclarationDescriptor declarationDescriptor : interestingDescriptors) {
            Collection<DeclarationDescriptorNonRoot> collection;
            FqNameUnsafe descriptorFQN;
            if (!(declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)DescriptorUtils.getFqName(declarationDescriptor), (String)"getFqName(descriptor)");
            if (observedFQNs.contains(descriptorFQN)) continue;
            observedFQNs.add(descriptorFQN);
            OverloadResolver this_$iv = this;
            boolean $i$f$getModulePackageMembersWithSameName = false;
            DeclarationDescriptor containingPackage$iv = declarationDescriptor.getContainingDeclaration();
            if (!(containingPackage$iv instanceof PackageFragmentDescriptor)) {
                throw new AssertionError((Object)(declarationDescriptor + " is not a top-level package member"));
            }
            if (DescriptorUtils.getContainingModuleOrNull(declarationDescriptor) == null) {
                DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
                if (declarationDescriptor2 instanceof CallableMemberDescriptor) {
                    collection = CollectionsKt.listOf((Object)declarationDescriptor);
                } else {
                    if (!(declarationDescriptor2 instanceof ClassDescriptor)) throw new AssertionError((Object)("Unexpected descriptor kind: " + declarationDescriptor));
                    Collection<ClassConstructorDescriptor> collection2 = ((ClassDescriptor)declarationDescriptor).getConstructors();
                    collection = collection2;
                    Intrinsics.checkNotNullExpressionValue(collection2, (String)"descriptor.constructors");
                }
            } else {
                void $this$filterTo$iv$iv$iv;
                ModuleDescriptor moduleDescriptor;
                Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"DescriptorUtils.getConta\u2026: $descriptor\")\n        }");
                ModuleDescriptor containingModule$iv = moduleDescriptor;
                MemberScope containingPackageScope$iv = containingModule$iv.getPackage(((PackageFragmentDescriptor)containingPackage$iv).getFqName()).getMemberScope();
                Name name2 = declarationDescriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"descriptor.name");
                Iterable $this$filter$iv$iv = (Iterable)getMembersByName.invoke((Object)containingPackageScope$iv, (Object)name2);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
                    DeclarationDescriptorNonRoot it$iv = (DeclarationDescriptorNonRoot)element$iv$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtils.getContainingModule(it$iv), (Object)containingModule$iv)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                List possibleOverloads$iv = (List)destination$iv$iv$iv;
                collection = overloadFilter.filterPackageMemberOverloads(possibleOverloads$iv);
            }
            Collection<ClassConstructorDescriptor> packageMembersWithSameName = collection;
            packageMembersByName.putValues((Object)descriptorFQN, packageMembersWithSameName);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<DeclarationDescriptorNonRoot> getModulePackageMembersWithSameName(DeclarationDescriptor descriptor2, OverloadFilter overloadFilter, Function2<? super MemberScope, ? super Name, ? extends Collection<? extends DeclarationDescriptorNonRoot>> getMembersByName) {
        void $this$filterTo$iv$iv;
        boolean $i$f$getModulePackageMembersWithSameName = false;
        DeclarationDescriptor containingPackage = descriptor2.getContainingDeclaration();
        if (!(containingPackage instanceof PackageFragmentDescriptor)) {
            throw new AssertionError((Object)(descriptor2 + " is not a top-level package member"));
        }
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModuleOrNull(descriptor2);
        if (moduleDescriptor == null) {
            Collection<ClassConstructorDescriptor> collection;
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof CallableMemberDescriptor) {
                collection = CollectionsKt.listOf((Object)descriptor2);
            } else if (declarationDescriptor instanceof ClassDescriptor) {
                Collection<ClassConstructorDescriptor> collection2 = ((ClassDescriptor)descriptor2).getConstructors();
                collection = collection2;
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"descriptor.constructors");
            } else {
                throw new AssertionError((Object)("Unexpected descriptor kind: " + descriptor2));
            }
            return collection;
        }
        ModuleDescriptor containingModule = moduleDescriptor;
        MemberScope containingPackageScope = containingModule.getPackage(((PackageFragmentDescriptor)containingPackage).getFqName()).getMemberScope();
        Name name2 = descriptor2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"descriptor.name");
        Iterable $this$filter$iv = (Iterable)getMembersByName.invoke((Object)containingPackageScope, (Object)name2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)DescriptorUtils.getContainingModule(it), (Object)containingModule)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List possibleOverloads = (List)destination$iv$iv;
        return overloadFilter.filterPackageMemberOverloads(possibleOverloads);
    }

    private final void checkOverloadsInClass(ClassDescriptorWithResolutionScopes classDescriptor2, Collection<? extends FunctionDescriptor> nestedClassConstructors) {
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create<Name, CallableMemberDescriptor>()");
        MultiMap functionsByName2 = multiMap;
        for (CallableMemberDescriptor callableMemberDescriptor : classDescriptor2.getDeclaredCallableMembers()) {
            functionsByName2.putValue((Object)callableMemberDescriptor.getName(), (Object)callableMemberDescriptor);
        }
        for (FunctionDescriptor functionDescriptor : nestedClassConstructors) {
            Name name2;
            Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor.getContainingDeclaration().getName(), (String)"nestedConstructor.containingDeclaration.name");
            functionsByName2.putValue((Object)name2, (Object)functionDescriptor);
        }
        for (Map.Entry entry : functionsByName2.entrySet()) {
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"e.value");
            this.checkOverloadsInClass((Collection)v);
        }
    }

    private final void checkOverloadsInPackage(Collection<? extends DeclarationDescriptorNonRoot> members) {
        if (members.size() == 1) {
            return;
        }
        LinkedHashMap redeclarationsMap = new LinkedHashMap();
        for (Collection<DeclarationDescriptorNonRoot> redeclarationGroup : this.getPossibleRedeclarationGroups(members)) {
            Collection<DeclarationDescriptorNonRoot> redeclarations = this.findRedeclarations(redeclarationGroup);
            Iterable $this$forEach$iv = redeclarations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv;
                boolean bl = false;
                Map $this$getOrPut$iv = redeclarationsMap;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(it);
                if (value$iv == null) {
                    boolean bl2 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(it, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).addAll(redeclarations);
            }
        }
        HashSet reported = new HashSet();
        for (Map.Entry entry : ((Map)redeclarationsMap).entrySet()) {
            DeclarationDescriptorNonRoot member2 = (DeclarationDescriptorNonRoot)entry.getKey();
            Set conflicting = (Set)entry.getValue();
            if (reported.contains(member2)) continue;
            reported.addAll(conflicting);
            this.reportRedeclarations(conflicting);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Collection<DeclarationDescriptorNonRoot>> getPossibleRedeclarationGroups(Collection<? extends DeclarationDescriptorNonRoot> members) {
        void $this$groupByTo$iv$iv;
        void $this$filterTo$iv$iv;
        ArrayList result2 = new ArrayList();
        Iterable $this$filter$iv = members;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv$iv;
            boolean bl = false;
            if (!(!this.isPrivate(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonPrivates = (List)destination$iv$iv;
        Iterable $this$groupBy$iv = members;
        boolean $i$f$groupBy = false;
        destination$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv$iv;
            boolean bl = false;
            SourceFile key$iv$iv = DescriptorUtils.getContainingSourceFile(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map bySourceFile = destination$iv$iv2;
        boolean hasGroupIncludingNonPrivateMembers = false;
        for (List membersInFile : bySourceFile.values()) {
            boolean bl;
            block9: {
                Iterable $this$any$iv = membersInFile;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv;
                        boolean bl3 = false;
                        if (!this.isPrivate(it)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            hasGroupIncludingNonPrivateMembers = true;
            Set group = SetsKt.plus((Set)new LinkedHashSet(nonPrivates), (Iterable)membersInFile);
            result2.add(group);
        }
        if (!hasGroupIncludingNonPrivateMembers && nonPrivates.size() > 1) {
            result2.add(nonPrivates);
        }
        return result2;
    }

    private final boolean isPrivate(DeclarationDescriptor $this$isPrivate) {
        return $this$isPrivate instanceof DeclarationDescriptorWithVisibility && DescriptorVisibilities.isPrivate(((DeclarationDescriptorWithVisibility)$this$isPrivate).getVisibility());
    }

    private final void checkOverloadsInClass(Collection<? extends CallableMemberDescriptor> members) {
        if (members.size() == 1) {
            return;
        }
        this.reportRedeclarations(this.findRedeclarations(members));
    }

    private final boolean isSynthesized(DeclarationDescriptor $this$isSynthesized) {
        return $this$isSynthesized instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)$this$isSynthesized).getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED;
    }

    private final Collection<DeclarationDescriptorNonRoot> findRedeclarations(Collection<? extends DeclarationDescriptorNonRoot> members) {
        LinkedHashSet<DeclarationDescriptorNonRoot> redeclarations = new LinkedHashSet<DeclarationDescriptorNonRoot>();
        for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot : members) {
            if (this.isSynthesized(declarationDescriptorNonRoot)) continue;
            for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot2 : members) {
                if (Intrinsics.areEqual((Object)declarationDescriptorNonRoot, (Object)declarationDescriptorNonRoot2) || this.isConstructorsOfDifferentRedeclaredClasses(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isTopLevelMainInDifferentFiles(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isDefinitionsForDifferentPlatforms(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isExpectDeclarationAndDefinition(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isExpectDeclarationAndDefinition(declarationDescriptorNonRoot2, declarationDescriptorNonRoot) || this.overloadChecker.isOverloadable(declarationDescriptorNonRoot, declarationDescriptorNonRoot2)) continue;
                redeclarations.add(declarationDescriptorNonRoot);
            }
        }
        return redeclarations;
    }

    private final boolean isConstructorsOfDifferentRedeclaredClasses(DeclarationDescriptor member1, DeclarationDescriptor member2) {
        if (!(member1 instanceof ConstructorDescriptor) || !(member2 instanceof ConstructorDescriptor)) {
            return false;
        }
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)member1).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptorWithTypeParameters, (String)"member1.containingDeclaration");
        ClassifierDescriptorWithTypeParameters parent1 = classifierDescriptorWithTypeParameters;
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters2 = ((ConstructorDescriptor)member2).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptorWithTypeParameters2, (String)"member2.containingDeclaration");
        ClassifierDescriptorWithTypeParameters parent2 = classifierDescriptorWithTypeParameters2;
        return parent1 != parent2 && Intrinsics.areEqual((Object)parent1.getContainingDeclaration(), (Object)parent2.getContainingDeclaration());
    }

    private final boolean isTopLevelMainInDifferentFiles(DeclarationDescriptor member1, DeclarationDescriptor member2) {
        if (!MainFunctionDetector.isMain$default(this.mainFunctionDetector, member1, false, false, false, 14, null) || !MainFunctionDetector.isMain$default(this.mainFunctionDetector, member2, false, false, false, 14, null)) {
            return false;
        }
        KtFile file1 = DescriptorToSourceUtils.getContainingFile(member1);
        KtFile file2 = DescriptorToSourceUtils.getContainingFile(member2);
        return file1 == null || file2 == null || file1 != file2;
    }

    private final boolean isExpectDeclarationAndDefinition(DeclarationDescriptor declaration, DeclarationDescriptor definition) {
        return declaration instanceof MemberDescriptor && ((MemberDescriptor)declaration).isExpect() && definition instanceof MemberDescriptor && !((MemberDescriptor)definition).isExpect();
    }

    private final boolean isDefinitionsForDifferentPlatforms(DeclarationDescriptorNonRoot member1, DeclarationDescriptorNonRoot member2) {
        if (!(member1 instanceof MemberDescriptor) || !(member2 instanceof MemberDescriptor)) {
            return false;
        }
        return ((MemberDescriptor)member1).isActual() && ((MemberDescriptor)member2).isActual() && !Intrinsics.areEqual((Object)DescriptorUtilsKt.getPlatform(member1), (Object)DescriptorUtilsKt.getPlatform(member2));
    }

    private final void reportRedeclarations(Collection<? extends DeclarationDescriptorNonRoot> redeclarations) {
        if (redeclarations.isEmpty()) {
            return;
        }
        for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot : redeclarations) {
            PsiElement it;
            BindingTrace bindingTrace;
            PsiElement psiElement$iv;
            boolean $i$f$reportOnDeclaration;
            BindingTrace trace$iv;
            DeclarationDescriptorNonRoot declarationDescriptorNonRoot2 = declarationDescriptorNonRoot;
            if (declarationDescriptorNonRoot2 instanceof PropertyDescriptor ? true : declarationDescriptorNonRoot2 instanceof ClassifierDescriptor) {
                trace$iv = this.trace;
                $i$f$reportOnDeclaration = false;
                if (DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptorNonRoot) != null) {
                    boolean bl = false;
                    PsiElement psiElement = psiElement$iv;
                    bindingTrace = trace$iv;
                    boolean bl2 = false;
                    ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.REDECLARATION.on(it, redeclarations);
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"REDECLARATION.on(it, redeclarations)");
                    bindingTrace.report(parametrizedDiagnostic);
                }
                continue;
            }
            if (!(declarationDescriptorNonRoot2 instanceof FunctionDescriptor)) continue;
            trace$iv = this.trace;
            $i$f$reportOnDeclaration = false;
            if (DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptorNonRoot) == null) continue;
            boolean bl = false;
            it = psiElement$iv;
            bindingTrace = trace$iv;
            boolean bl3 = false;
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.CONFLICTING_OVERLOADS.on(it, redeclarations);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"CONFLICTING_OVERLOADS.on(it, redeclarations)");
            bindingTrace.report(parametrizedDiagnostic);
        }
    }
}

