/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensions;
import org.jetbrains.kotlin.backend.jvm.JvmReflectSymbols;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocatorKt;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineScopeResolver;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.SyntheticAccessorLowering;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.StubGeneratorExtensions;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001bH\u0002J\u001e\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0006\u0012\u0004\u0018\u00010 0\u001e2\u0006\u0010!\u001a\u00020\bH\u0002J\u0018\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\tH\u0002J\u0010\u0010%\u001a\u00020 2\u0006\u0010!\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002J\u0010\u0010(\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002J\u0010\u0010)\u001a\u00020 2\u0006\u0010!\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020-H\u0002J2\u0010+\u001a\u00020 2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u001f2\b\u00102\u001a\u0004\u0018\u00010 2\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020 2\u0006\u00106\u001a\u000207H\u0002J:\u00105\u001a\u00020 2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u0002002\u0006\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020\u001f2\b\u00102\u001a\u0004\u0018\u00010 2\u0006\u00103\u001a\u000204H\u0002J\u0010\u0010:\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002JN\u0010:\u001a\u00020 2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010;\u001a\u0002002\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001f0=2\b\u0010>\u001a\u0004\u0018\u00010 2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020 0=2\u0006\u0010@\u001a\u00020\u001f2\u0006\u00103\u001a\u000204H\u0002J\u0010\u0010A\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002J\u0010\u0010B\u001a\u00020 2\u0006\u00106\u001a\u000207H\u0002J\u0010\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020D2\u0006\u0010#\u001a\u00020\bH\u0002J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0002J\u0010\u0010L\u001a\u00020 2\u0006\u0010#\u001a\u00020\bH\u0016J\u0010\u0010M\u001a\u00020 2\u0006\u0010#\u001a\u00020*H\u0016J\u0010\u0010N\u001a\u00020 2\u0006\u0010#\u001a\u00020-H\u0016J\u0010\u0010O\u001a\u00020 2\u0006\u0010#\u001a\u00020&H\u0016J\u0010\u0010P\u001a\u00020 2\u0006\u0010#\u001a\u000207H\u0016J\"\u0010Q\u001a\u00020 *\u00020R2\u0006\u0010S\u001a\u00020 2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020 0=H\u0002J\u0014\u0010T\u001a\u00020 *\u00020R2\u0006\u0010S\u001a\u00020 H\u0002J\u001c\u0010U\u001a\u00020 *\u00020R2\u0006\u0010V\u001a\u00020 2\u0006\u0010>\u001a\u00020 H\u0002J$\u0010W\u001a\u00020 *\u00020R2\u0006\u0010V\u001a\u00020 2\u0006\u0010>\u001a\u00020 2\u0006\u00108\u001a\u00020 H\u0002J\u0014\u0010X\u001a\u00020 *\u00020R2\u0006\u0010Y\u001a\u00020 H\u0002J\"\u0010Z\u001a\u00020 *\u00020R2\u0006\u0010.\u001a\u00020 2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001f0=H\u0002J\u001c\u0010[\u001a\u00020 *\u00020R2\u0006\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u000200H\u0002J*\u0010\\\u001a\u00020 *\u00020R2\u0006\u0010.\u001a\u00020 2\u0006\u0010;\u001a\u0002002\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001f0=H\u0002J\u0012\u0010]\u001a\b\u0012\u0004\u0012\u00020 0=*\u00020^H\u0002J\"\u0010_\u001a\u00020 *\u00020R2\u0006\u0010`\u001a\u00020\u001f2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020 0=H\u0002J\u0016\u0010b\u001a\u00020I*\u0002042\b\b\u0002\u0010c\u001a\u00020IH\u0002J\u0014\u0010d\u001a\u00020 *\u00020R2\u0006\u0010e\u001a\u00020\u001fH\u0002J*\u0010f\u001a\u00020 *\u00020R2\u0006\u0010g\u001a\u00020 2\u0006\u0010>\u001a\u00020 2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020 0=H\u0002J\u0014\u0010h\u001a\u00020 *\u00020R2\u0006\u0010g\u001a\u00020 H\u0002J\u0012\u0010i\u001a\b\u0012\u0004\u0012\u00020\u001f0=*\u00020^H\u0002R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ReflectiveAccessLowering;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "callsOnCompanionObjects", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getCallsOnCompanionObjects", "()Ljava/util/Map;", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "inlineScopeResolver", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "getInlineScopeResolver", "()Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "setInlineScopeResolver", "(Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;)V", "reflectSymbols", "Lorg/jetbrains/kotlin/backend/jvm/JvmReflectSymbols;", "symbols", "Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;", "createBuilder", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "startOffset", "", "endOffset", "fieldLocationAndReceiver", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "generateInvokeSpecialForCall", "expression", "superQualifier", "generateReflectiveAccessForCompanion", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "generateReflectiveAccessForGetter", "generateReflectiveAccessForSetter", "generateReflectiveConstructorInvocation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "generateReflectiveFieldGet", "getField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "declaringClass", "fieldName", "", "fieldType", "instance", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "generateReflectiveFieldSet", "setField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "value", "type", "generateReflectiveMethodInvocation", "methodName", "parameterTypes", "", "receiver", "arguments", "returnType", "generateReflectiveStaticCall", "generateThrowIllegalAccessException", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "recordCompanionObjectAsDispatchReceiver", "shouldUseAccessor", "", "accessor", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitCall", "visitConstructorCall", "visitGetField", "visitGetObjectValue", "visitSetField", "constructorNewInstance", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "constructor", "constructorSetAccessible", "fieldGet", "fieldObject", "fieldSet", "fieldSetAccessible", "field", "getDeclaredConstructor", "getDeclaredField", "getDeclaredMethod", "getValueArguments", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "irVararg", "elementType", "values", "isAccessible", "withSuper", "javaClassObject", "klass", "methodInvoke", "method", "methodSetAccessible", "valueParameterTypes", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nReflectiveAccess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectiveAccess.kt\norg/jetbrains/kotlin/backend/jvm/lower/ReflectiveAccessLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,539:1\n1549#2:540\n1620#2,3:541\n1549#2:544\n1620#2,3:545\n1549#2:563\n1620#2,3:564\n1549#2:567\n1620#2,3:568\n377#3,13:548\n377#3,13:572\n377#3,13:587\n377#3,13:602\n377#3,13:617\n98#4,2:561\n98#4,2:585\n98#4,2:600\n98#4,2:615\n98#4,2:630\n1#5:571\n*S KotlinDebug\n*F\n+ 1 ReflectiveAccess.kt\norg/jetbrains/kotlin/backend/jvm/lower/ReflectiveAccessLowering\n*L\n232#1:540\n232#1:541,3\n258#1:544\n258#1:545,3\n303#1:563\n303#1:564,3\n306#1:567\n306#1:568,3\n287#1:548,13\n340#1:572,13\n362#1:587,13\n395#1:602,13\n500#1:617,13\n287#1:561,2\n340#1:585,2\n362#1:600,2\n395#1:615,2\n500#1:630,2\n*E\n"})
public final class ReflectiveAccessLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    public IrInlineScopeResolver inlineScopeResolver;
    @NotNull
    private final Map<IrCall, IrClassSymbol> callsOnCompanionObjects;
    @NotNull
    private final JvmSymbols symbols;
    @NotNull
    private final JvmReflectSymbols reflectSymbols;

    public ReflectiveAccessLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.callsOnCompanionObjects = new LinkedHashMap();
        this.symbols = this.context.getIr().getSymbols();
        this.reflectSymbols = this.symbols.getJavaLangReflectSymbols();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrInlineScopeResolver getInlineScopeResolver() {
        IrInlineScopeResolver irInlineScopeResolver = this.inlineScopeResolver;
        if (irInlineScopeResolver != null) {
            return irInlineScopeResolver;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"inlineScopeResolver");
        return null;
    }

    public final void setInlineScopeResolver(@NotNull IrInlineScopeResolver irInlineScopeResolver) {
        Intrinsics.checkNotNullParameter((Object)irInlineScopeResolver, (String)"<set-?>");
        this.inlineScopeResolver = irInlineScopeResolver;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.setInlineScopeResolver(IrInlineReferenceLocatorKt.findInlineCallSites(irFile, this.context));
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irFile), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
    }

    private final boolean isAccessible(IrSymbol $this$isAccessible, boolean withSuper) {
        return SyntheticAccessorLowering.Companion.isAccessible($this$isAccessible, this.context, this.getCurrentScope(), this.getInlineScopeResolver(), withSuper, null, true);
    }

    static /* synthetic */ boolean isAccessible$default(ReflectiveAccessLowering reflectiveAccessLowering2, IrSymbol irSymbol, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return reflectiveAccessLowering2.isAccessible(irSymbol, bl);
    }

    @NotNull
    public final Map<IrCall, IrClassSymbol> getCallsOnCompanionObjects() {
        return this.callsOnCompanionObjects;
    }

    private final void recordCompanionObjectAsDispatchReceiver(IrCall expression2) {
        IrExpression irExpression = expression2.getDispatchReceiver();
        IrGetField irGetField = irExpression instanceof IrGetField ? (IrGetField)irExpression : null;
        if (irGetField == null) {
            return;
        }
        IrGetField dispatchReceiver = irGetField;
        IrType irType = ((IrField)dispatchReceiver.getSymbol().getOwner()).getType();
        IrSimpleType irSimpleType = irType instanceof IrSimpleType ? (IrSimpleType)irType : null;
        if (irSimpleType == null) {
            return;
        }
        IrSimpleType dispatchReceiverType = irSimpleType;
        IrClassSymbol klass = IrTypesKt.getClassOrNull((IrType)((IrType)dispatchReceiverType));
        if (klass != null && ((IrClass)klass.getOwner()).isCompanion()) {
            this.callsOnCompanionObjects.put(expression2, klass);
        }
    }

    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.recordCompanionObjectAsDispatchReceiver(expression2);
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        IrClassSymbol superQualifier = expression2.getSuperQualifierSymbol();
        IrSimpleFunctionSymbol callee = expression2.getSymbol();
        if (this.isAccessible((IrSymbol)callee, superQualifier != null)) {
            return (IrExpression)expression2;
        }
        if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.GET_PROPERTY.INSTANCE)) {
            irExpression = this.generateReflectiveAccessForGetter(expression2);
        } else {
            IrStatementOrigin irStatementOrigin = expression2.getOrigin();
            irExpression = (irStatementOrigin != null ? IrStatementOriginKt.isAssignmentOperator((IrStatementOrigin)irStatementOrigin) : false) ? this.generateReflectiveAccessForSetter(expression2) : (expression2.getDispatchReceiver() == null && expression2.getExtensionReceiver() == null ? this.generateReflectiveStaticCall(expression2) : (superQualifier != null ? this.generateInvokeSpecialForCall(expression2, superQualifier) : this.generateReflectiveMethodInvocation(expression2)));
        }
        return irExpression;
    }

    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        IrFieldSymbol field = expression2.getSymbol();
        return ReflectiveAccessLowering.isAccessible$default(this, (IrSymbol)field, false, 1, null) ? (IrExpression)expression2 : this.generateReflectiveFieldGet(expression2);
    }

    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2) {
        IrPropertySymbol irPropertySymbol;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        IrFieldSymbol field = expression2.getSymbol();
        return ReflectiveAccessLowering.isAccessible$default(this, (IrSymbol)field, false, 1, null) ? (IrExpression)expression2 : (((irPropertySymbol = ((IrField)field.getOwner()).getCorrespondingPropertySymbol()) != null && (irPropertySymbol = (IrProperty)irPropertySymbol.getOwner()) != null ? irPropertySymbol.isConst() : false) || IrUtilsKt.isFromJava((IrDeclaration)((IrDeclaration)field.getOwner())) && ((IrField)field.getOwner()).isFinal() ? this.generateThrowIllegalAccessException(expression2) : this.generateReflectiveFieldSet(expression2));
    }

    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        IrConstructorSymbol callee = expression2.getSymbol();
        return ReflectiveAccessLowering.isAccessible$default(this, (IrSymbol)callee, false, 1, null) ? (IrExpression)expression2 : this.generateReflectiveConstructorInvocation(expression2);
    }

    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        IrClassSymbol callee = expression2.getSymbol();
        return ReflectiveAccessLowering.isAccessible$default(this, (IrSymbol)callee, false, 1, null) ? (IrExpression)expression2 : this.generateReflectiveAccessForCompanion(expression2);
    }

    private final IrExpression javaClassObject(IrBuilderWithScope $this$javaClassObject, IrType klass) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrFunctionAccessExpression $this$javaClassObject_u24lambda_u240 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$javaClassObject, (IrFunction)((IrFunction)this.symbols.getKClassJavaPropertyGetter()));
        boolean bl = false;
        $this$javaClassObject_u24lambda_u240.setExtensionReceiver((IrExpression)new IrClassReferenceImpl($this$javaClassObject_u24lambda_u240.getStartOffset(), $this$javaClassObject_u24lambda_u240.getEndOffset(), (IrType)IrTypesKt.getStarProjectedType((IrClassSymbol)$this$javaClassObject.getContext().getIrBuiltIns().getKClassClass()), (IrClassifierSymbol)$this$javaClassObject.getContext().getIrBuiltIns().getKClassClass(), klass));
        return (IrExpression)irFunctionAccessExpression;
    }

    private final IrExpression getDeclaredField(IrBuilderWithScope $this$getDeclaredField, IrExpression declaringClass, String fieldName) {
        IrCall irCall;
        IrCall $this$getDeclaredField_u24lambda_u241 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$getDeclaredField, (IrSimpleFunctionSymbol)this.reflectSymbols.getGetDeclaredField());
        boolean bl = false;
        $this$getDeclaredField_u24lambda_u241.setDispatchReceiver(declaringClass);
        $this$getDeclaredField_u24lambda_u241.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)$this$getDeclaredField, (String)fieldName));
        return (IrExpression)irCall;
    }

    private final IrExpression fieldSetAccessible(IrBuilderWithScope $this$fieldSetAccessible, IrExpression field) {
        IrCall irCall;
        IrCall $this$fieldSetAccessible_u24lambda_u242 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$fieldSetAccessible, (IrSimpleFunctionSymbol)this.reflectSymbols.getJavaLangReflectFieldSetAccessible());
        boolean bl = false;
        $this$fieldSetAccessible_u24lambda_u242.setDispatchReceiver(field);
        $this$fieldSetAccessible_u24lambda_u242.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irTrue((IrBuilderWithScope)$this$fieldSetAccessible));
        return (IrExpression)irCall;
    }

    private final IrExpression fieldSet(IrBuilderWithScope $this$fieldSet, IrExpression fieldObject, IrExpression receiver, IrExpression value2) {
        IrCall irCall;
        IrCall $this$fieldSet_u24lambda_u243 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$fieldSet, (IrSimpleFunctionSymbol)this.reflectSymbols.getJavaLangReflectFieldSet());
        boolean bl = false;
        $this$fieldSet_u24lambda_u243.setDispatchReceiver(fieldObject);
        $this$fieldSet_u24lambda_u243.putValueArgument(0, receiver);
        $this$fieldSet_u24lambda_u243.putValueArgument(1, value2);
        return (IrExpression)irCall;
    }

    private final IrExpression fieldGet(IrBuilderWithScope $this$fieldGet, IrExpression fieldObject, IrExpression receiver) {
        IrCall irCall;
        IrCall $this$fieldGet_u24lambda_u244 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$fieldGet, (IrSimpleFunctionSymbol)this.reflectSymbols.getJavaLangReflectFieldGet());
        boolean bl = false;
        $this$fieldGet_u24lambda_u244.setDispatchReceiver(fieldObject);
        $this$fieldGet_u24lambda_u244.putValueArgument(0, receiver);
        return (IrExpression)irCall;
    }

    private final JvmIrBuilder createBuilder(int startOffset, int endOffset) {
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        return JvmIrBuilderKt.createJvmIrBuilder(this.context, scopeWithIr, startOffset, endOffset);
    }

    static /* synthetic */ JvmIrBuilder createBuilder$default(ReflectiveAccessLowering reflectiveAccessLowering2, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        return reflectiveAccessLowering2.createBuilder(n, n2);
    }

    private final IrExpression irVararg(IrBuilderWithScope $this$irVararg, IrType elementType, List<? extends IrExpression> values) {
        Object object = new IrType[]{elementType};
        Object $this$irVararg_u24lambda_u245 = object = new IrArrayBuilder(ReflectiveAccessLowering.createBuilder$default(this, 0, 0, 3, null), (IrType)IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)$this$irVararg.getContext().getIrBuiltIns().getArrayClass()), (IrType[])object));
        boolean bl = false;
        for (IrExpression irExpression : values) {
            ((IrArrayBuilder)$this$irVararg_u24lambda_u245).unaryPlus(irExpression);
        }
        return ((IrArrayBuilder)object).build();
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression getDeclaredMethod(IrBuilderWithScope $this$getDeclaredMethod, IrExpression declaringClass, String methodName, List<? extends IrType> parameterTypes) {
        Collection<IrExpression> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrCall irCall;
        IrCall $this$getDeclaredMethod_u24lambda_u247 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$getDeclaredMethod, (IrSimpleFunctionSymbol)this.reflectSymbols.getGetDeclaredMethod());
        boolean bl = false;
        $this$getDeclaredMethod_u24lambda_u247.setDispatchReceiver(declaringClass);
        $this$getDeclaredMethod_u24lambda_u247.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)$this$getDeclaredMethod, (String)methodName));
        Iterable iterable = parameterTypes;
        IrType irType = IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)this.symbols.getJavaLangClass()));
        IrBuilderWithScope irBuilderWithScope = $this$getDeclaredMethod;
        ReflectiveAccessLowering reflectiveAccessLowering2 = this;
        int n = 1;
        IrCall irCall2 = $this$getDeclaredMethod_u24lambda_u247;
        boolean $i$f$map = false;
        void var15_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrType irType2 = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.javaClassObject($this$getDeclaredMethod, (IrType)it));
        }
        collection = (List)destination$iv$iv;
        irCall2.putValueArgument(n, reflectiveAccessLowering2.irVararg(irBuilderWithScope, irType, (List<? extends IrExpression>)collection));
        return (IrExpression)irCall;
    }

    private final IrExpression methodSetAccessible(IrBuilderWithScope $this$methodSetAccessible, IrExpression method) {
        IrCall irCall;
        IrCall $this$methodSetAccessible_u24lambda_u248 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$methodSetAccessible, (IrSimpleFunctionSymbol)this.reflectSymbols.getJavaLangReflectMethodSetAccessible());
        boolean bl = false;
        $this$methodSetAccessible_u24lambda_u248.setDispatchReceiver(method);
        $this$methodSetAccessible_u24lambda_u248.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irTrue((IrBuilderWithScope)$this$methodSetAccessible));
        return (IrExpression)irCall;
    }

    private final IrExpression methodInvoke(IrBuilderWithScope $this$methodInvoke, IrExpression method, IrExpression receiver, List<? extends IrExpression> arguments2) {
        IrCall irCall;
        IrCall $this$methodInvoke_u24lambda_u249 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$methodInvoke, (IrSimpleFunctionSymbol)this.reflectSymbols.getJavaLangReflectMethodInvoke());
        boolean bl = false;
        $this$methodInvoke_u24lambda_u249.setDispatchReceiver(method);
        $this$methodInvoke_u24lambda_u249.putValueArgument(0, receiver);
        $this$methodInvoke_u24lambda_u249.putValueArgument(1, this.irVararg($this$methodInvoke, $this$methodInvoke.getContext().getIrBuiltIns().getAnyNType(), arguments2));
        return (IrExpression)irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression getDeclaredConstructor(IrBuilderWithScope $this$getDeclaredConstructor, IrExpression declaringClass, List<? extends IrType> parameterTypes) {
        Collection<IrExpression> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrCall irCall;
        IrCall $this$getDeclaredConstructor_u24lambda_u2411 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$getDeclaredConstructor, (IrSimpleFunctionSymbol)this.reflectSymbols.getGetDeclaredConstructor());
        boolean bl = false;
        $this$getDeclaredConstructor_u24lambda_u2411.setDispatchReceiver(declaringClass);
        Iterable iterable = parameterTypes;
        IrType irType = IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)this.symbols.getJavaLangClass()));
        IrBuilderWithScope irBuilderWithScope = $this$getDeclaredConstructor;
        ReflectiveAccessLowering reflectiveAccessLowering2 = this;
        int n = 0;
        IrCall irCall2 = $this$getDeclaredConstructor_u24lambda_u2411;
        boolean $i$f$map = false;
        void var14_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrType irType2 = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.javaClassObject($this$getDeclaredConstructor, (IrType)it));
        }
        collection = (List)destination$iv$iv;
        irCall2.putValueArgument(n, reflectiveAccessLowering2.irVararg(irBuilderWithScope, irType, (List<? extends IrExpression>)collection));
        return (IrExpression)irCall;
    }

    private final IrExpression constructorSetAccessible(IrBuilderWithScope $this$constructorSetAccessible, IrExpression constructor) {
        IrCall irCall;
        IrCall $this$constructorSetAccessible_u24lambda_u2412 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$constructorSetAccessible, (IrSimpleFunctionSymbol)this.reflectSymbols.getJavaLangReflectConstructorSetAccessible());
        boolean bl = false;
        $this$constructorSetAccessible_u24lambda_u2412.setDispatchReceiver(constructor);
        $this$constructorSetAccessible_u24lambda_u2412.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irTrue((IrBuilderWithScope)$this$constructorSetAccessible));
        return (IrExpression)irCall;
    }

    private final IrExpression constructorNewInstance(IrBuilderWithScope $this$constructorNewInstance, IrExpression constructor, List<? extends IrExpression> arguments2) {
        IrCall irCall;
        IrCall $this$constructorNewInstance_u24lambda_u2413 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$constructorNewInstance, (IrSimpleFunctionSymbol)this.reflectSymbols.getJavaLangReflectConstructorNewInstance());
        boolean bl = false;
        $this$constructorNewInstance_u24lambda_u2413.setDispatchReceiver(constructor);
        $this$constructorNewInstance_u24lambda_u2413.putValueArgument(0, this.irVararg($this$constructorNewInstance, $this$constructorNewInstance.getContext().getIrBuiltIns().getAnyNType(), arguments2));
        return (IrExpression)irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveMethodInvocation(IrType declaringClass, String methodName, List<? extends IrType> parameterTypes, IrExpression receiver, List<? extends IrExpression> arguments2, IrType returnType2, IrSymbol symbol2) {
        void this_$iv$iv;
        IrBuilderWithScope $this$irBlock_u24default$iv = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, symbol2, 0, 0, 6, null);
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, returnType2, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateReflectiveMethodInvocation_u24lambda_u2414 = this_$iv$iv;
        boolean bl = false;
        IrVariable methodVar = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)((IrStatementsBuilder)$this$generateReflectiveMethodInvocation_u24lambda_u2414), (IrExpression)this.getDeclaredMethod((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2414, this.javaClassObject((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2414, declaringClass), methodName, parameterTypes), (String)"method", (boolean)false, null, (IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)this.reflectSymbols.getJavaLangReflectMethod())), (int)12, null);
        $this$generateReflectiveMethodInvocation_u24lambda_u2414.unaryPlus((IrStatement)this.methodSetAccessible((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2414, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2414), (IrValueDeclaration)((IrValueDeclaration)methodVar))));
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2414;
        IrExpression irExpression = (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2414), (IrValueDeclaration)((IrValueDeclaration)methodVar));
        IrExpression irExpression2 = receiver;
        if (irExpression2 == null) {
            irExpression2 = (IrExpression)ExpressionHelpersKt.irNull((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2414));
        }
        $this$generateReflectiveMethodInvocation_u24lambda_u2414.unaryPlus((IrStatement)this.methodInvoke(irBuilderWithScope, irExpression, irExpression2, arguments2));
        return (IrExpression)this_$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrExpression> getValueArguments(IrFunctionAccessExpression $this$getValueArguments) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)$this$getValueArguments.getValueArgumentsCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrExpression irExpression = $this$getValueArguments.getValueArgument((int)it);
            Intrinsics.checkNotNull((Object)irExpression);
            collection.add(irExpression);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrType> valueParameterTypes(IrFunctionAccessExpression $this$valueParameterTypes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ((IrFunctionSymbol)$this$valueParameterTypes.getSymbol()).getOwner().getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveMethodInvocation(IrCall call2) {
        void $this$generateReflectiveMethodInvocation_u24lambda_u2420;
        List $this$generateReflectiveMethodInvocation_u24lambda_u2418;
        IrValueParameter it;
        List list2;
        IrClassSymbol irClassSymbol = call2.getSuperQualifierSymbol();
        if (irClassSymbol == null || (irClassSymbol = IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)irClassSymbol))) == null) {
            IrExpression irExpression = call2.getDispatchReceiver();
            irClassSymbol = irExpression != null ? irExpression.getType() : (IrType)IrUtilsKt.getDefaultType((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)call2.getSymbol().getOwner())));
        }
        String string2 = ((IrSimpleFunction)call2.getSymbol().getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"call.symbol.owner.name.asString()");
        List list3 = list2 = (List)new ArrayList();
        String string3 = string2;
        IrClassSymbol irClassSymbol2 = irClassSymbol;
        ReflectiveAccessLowering reflectiveAccessLowering2 = this;
        boolean bl = false;
        IrValueParameter irValueParameter = ((IrSimpleFunction)call2.getSymbol().getOwner()).getExtensionReceiverParameter();
        if (irValueParameter != null) {
            it = irValueParameter;
            boolean bl2 = false;
            $this$generateReflectiveMethodInvocation_u24lambda_u2418.add(it.getType());
        }
        $this$generateReflectiveMethodInvocation_u24lambda_u2418.addAll((Collection)this.valueParameterTypes((IrFunctionAccessExpression)call2));
        Object object = Unit.INSTANCE;
        List list4 = list2;
        $this$generateReflectiveMethodInvocation_u24lambda_u2418 = list2 = (List)new ArrayList();
        IrExpression irExpression = call2.getDispatchReceiver();
        object = list4;
        boolean bl3 = false;
        IrExpression irExpression2 = call2.getExtensionReceiver();
        if (irExpression2 != null) {
            it = irExpression2;
            boolean bl4 = false;
            $this$generateReflectiveMethodInvocation_u24lambda_u2420.add(it);
        }
        $this$generateReflectiveMethodInvocation_u24lambda_u2420.addAll((Collection)this.getValueArguments((IrFunctionAccessExpression)call2));
        Unit unit = Unit.INSTANCE;
        return reflectiveAccessLowering2.generateReflectiveMethodInvocation((IrType)irClassSymbol2, string3, (List<? extends IrType>)object, irExpression, list2, call2.getType(), (IrSymbol)call2.getSymbol());
    }

    private final IrExpression generateReflectiveStaticCall(IrCall call2) {
        boolean bl;
        boolean bl2 = bl = call2.getDispatchReceiver() == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Assumed-to-be static call with a dispatch receiver";
            throw new AssertionError((Object)string2);
        }
        IrType irType = (IrType)IrUtilsKt.getDefaultType((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)call2.getSymbol().getOwner())));
        String string3 = ((IrSimpleFunction)call2.getSymbol().getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"call.symbol.owner.name.asString()");
        return this.generateReflectiveMethodInvocation(irType, string3, this.valueParameterTypes((IrFunctionAccessExpression)call2), null, this.getValueArguments((IrFunctionAccessExpression)call2), call2.getType(), (IrSymbol)call2.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveConstructorInvocation(IrConstructorCall call2) {
        void this_$iv$iv;
        void $this$irBlock_u24default$iv;
        IrBuilderWithScope irBuilderWithScope = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, (IrSymbol)call2.getSymbol(), 0, 0, 6, null);
        IrType resultType$iv = call2.getType();
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateReflectiveConstructorInvocation_u24lambda_u2422 = this_$iv$iv;
        boolean bl = false;
        IrVariable constructorVar = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)((IrStatementsBuilder)$this$generateReflectiveConstructorInvocation_u24lambda_u2422), (IrExpression)this.getDeclaredConstructor((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2422, this.javaClassObject((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2422, (IrType)IrUtilsKt.getDefaultType((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)call2.getSymbol().getOwner())))), this.valueParameterTypes((IrFunctionAccessExpression)call2)), (String)"constructor", (boolean)false, null, (IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)this.reflectSymbols.getJavaLangReflectConstructor())), (int)12, null);
        $this$generateReflectiveConstructorInvocation_u24lambda_u2422.unaryPlus((IrStatement)this.constructorSetAccessible((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2422, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2422), (IrValueDeclaration)((IrValueDeclaration)constructorVar))));
        $this$generateReflectiveConstructorInvocation_u24lambda_u2422.unaryPlus((IrStatement)this.constructorNewInstance((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2422, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2422), (IrValueDeclaration)((IrValueDeclaration)constructorVar)), this.getValueArguments((IrFunctionAccessExpression)call2)));
        return (IrExpression)this_$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveFieldGet(IrType declaringClass, String fieldName, IrType fieldType, IrExpression instance2, IrSymbol symbol2) {
        void this_$iv$iv;
        void $this$irBlock_u24default$iv;
        IrBuilderWithScope irBuilderWithScope = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, symbol2, 0, 0, 6, null);
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, fieldType, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateReflectiveFieldGet_u24lambda_u2423 = this_$iv$iv;
        boolean bl = false;
        IrVariable classVar = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)((IrStatementsBuilder)$this$generateReflectiveFieldGet_u24lambda_u2423), (IrExpression)this.javaClassObject((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2423, declaringClass), (String)"klass", (boolean)false, null, (IrType)this.symbols.getKClassJavaPropertyGetter().getReturnType(), (int)12, null);
        IrVariable fieldVar = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)((IrStatementsBuilder)$this$generateReflectiveFieldGet_u24lambda_u2423), (IrExpression)this.getDeclaredField((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2423, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2423), (IrValueDeclaration)((IrValueDeclaration)classVar)), fieldName), (String)"field", (boolean)false, null, (IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)this.reflectSymbols.getJavaLangReflectField())), (int)12, null);
        $this$generateReflectiveFieldGet_u24lambda_u2423.unaryPlus((IrStatement)this.fieldSetAccessible((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2423, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2423), (IrValueDeclaration)((IrValueDeclaration)fieldVar))));
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2423;
        IrExpression irExpression = (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2423), (IrValueDeclaration)((IrValueDeclaration)fieldVar));
        IrExpression irExpression2 = instance2;
        if (irExpression2 == null) {
            irExpression2 = (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2423), (IrValueDeclaration)((IrValueDeclaration)classVar));
        }
        $this$generateReflectiveFieldGet_u24lambda_u2423.unaryPlus((IrStatement)this.fieldGet(irBuilderWithScope2, irExpression, irExpression2));
        return (IrExpression)this_$iv$iv.doBuild();
    }

    private final IrExpression generateReflectiveFieldGet(IrGetField getField) {
        IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)((IrDeclaration)getField.getSymbol().getOwner()));
        Intrinsics.checkNotNull((Object)irClass);
        IrType irType = (IrType)IrUtilsKt.getDefaultType((IrClass)irClass);
        String string2 = ((IrField)getField.getSymbol().getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getField.symbol.owner.name.asString()");
        return this.generateReflectiveFieldGet(irType, string2, getField.getType(), getField.getReceiver(), (IrSymbol)getField.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveFieldSet(IrType declaringClass, String fieldName, IrExpression value2, IrType type2, IrExpression instance2, IrSymbol symbol2) {
        void this_$iv$iv;
        void $this$irBlock_u24default$iv;
        IrBuilderWithScope irBuilderWithScope = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, symbol2, 0, 0, 6, null);
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, type2, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateReflectiveFieldSet_u24lambda_u2424 = this_$iv$iv;
        boolean bl = false;
        IrVariable fieldVar = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)((IrStatementsBuilder)$this$generateReflectiveFieldSet_u24lambda_u2424), (IrExpression)this.getDeclaredField((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2424, this.javaClassObject((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2424, declaringClass), fieldName), (String)"field", (boolean)false, null, (IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)this.reflectSymbols.getJavaLangReflectField())), (int)12, null);
        $this$generateReflectiveFieldSet_u24lambda_u2424.unaryPlus((IrStatement)this.fieldSetAccessible((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2424, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2424), (IrValueDeclaration)((IrValueDeclaration)fieldVar))));
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2424;
        IrExpression irExpression = (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2424), (IrValueDeclaration)((IrValueDeclaration)fieldVar));
        IrExpression irExpression2 = instance2;
        if (irExpression2 == null) {
            irExpression2 = (IrExpression)ExpressionHelpersKt.irNull((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2424));
        }
        $this$generateReflectiveFieldSet_u24lambda_u2424.unaryPlus((IrStatement)this.fieldSet(irBuilderWithScope2, irExpression, irExpression2, value2));
        return (IrExpression)this_$iv$iv.doBuild();
    }

    private final IrExpression generateReflectiveFieldSet(IrSetField setField) {
        IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)((IrDeclaration)setField.getSymbol().getOwner()));
        Intrinsics.checkNotNull((Object)irClass);
        IrType irType = (IrType)IrUtilsKt.getDefaultType((IrClass)irClass);
        String string2 = ((IrField)setField.getSymbol().getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"setField.symbol.owner.name.asString()");
        return this.generateReflectiveFieldSet(irType, string2, setField.getValue(), setField.getType(), setField.getReceiver(), (IrSymbol)setField.getSymbol());
    }

    private final boolean shouldUseAccessor(IrSimpleFunction accessor) {
        JvmGeneratorExtensions jvmGeneratorExtensions = this.context.getGeneratorExtensions();
        Intrinsics.checkNotNull((Object)jvmGeneratorExtensions, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.util.StubGeneratorExtensions");
        return ((StubGeneratorExtensions)jvmGeneratorExtensions).isAccessorWithExplicitImplementation(accessor);
    }

    private final Pair<IrType, IrExpression> fieldLocationAndReceiver(IrCall call2) {
        IrClassSymbol irClassSymbol = this.callsOnCompanionObjects.get(call2);
        if (irClassSymbol != null) {
            IrClassSymbol it = irClassSymbol;
            boolean bl = false;
            IrClass parentAsClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)it.getOwner()));
            if (!JvmIrUtilsKt.isJvmInterface(parentAsClass)) {
                return TuplesKt.to((Object)IrUtilsKt.getDefaultType((IrClass)parentAsClass), null);
            }
        }
        IrExpression irExpression = call2.getDispatchReceiver();
        Intrinsics.checkNotNull((Object)irExpression);
        IrType irType = irExpression.getType();
        IrExpression irExpression2 = call2.getDispatchReceiver();
        Intrinsics.checkNotNull((Object)irExpression2);
        return TuplesKt.to((Object)irType, (Object)irExpression2);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveAccessForGetter(IrCall call2) {
        IrProperty property;
        IrSimpleFunction getter2;
        block2: {
            Object object;
            String string2;
            IrType irType;
            ReflectiveAccessLowering reflectiveAccessLowering2;
            block4: {
                block3: {
                    void it;
                    getter2 = (IrSimpleFunction)call2.getSymbol().getOwner();
                    IrPropertySymbol irPropertySymbol = getter2.getCorrespondingPropertySymbol();
                    Intrinsics.checkNotNull((Object)irPropertySymbol);
                    property = (IrProperty)irPropertySymbol.getOwner();
                    if (!this.shouldUseAccessor(getter2)) break block2;
                    reflectiveAccessLowering2 = this;
                    irType = (IrType)IrUtilsKt.getDefaultType((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)getter2)));
                    String string3 = property.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"property.name.asString()");
                    string2 = JvmAbi.getterName((String)string3);
                    object = getter2.getExtensionReceiverParameter();
                    if (object == null) break block3;
                    IrValueParameter irValueParameter = object;
                    String string4 = string2;
                    IrType irType2 = irType;
                    ReflectiveAccessLowering reflectiveAccessLowering3 = reflectiveAccessLowering2;
                    boolean bl = false;
                    List list2 = CollectionsKt.listOf((Object)it.getType());
                    reflectiveAccessLowering2 = reflectiveAccessLowering3;
                    irType = irType2;
                    string2 = string4;
                    List list3 = list2;
                    object = list3;
                    if (list3 != null) break block4;
                }
                object = CollectionsKt.emptyList();
            }
            return reflectiveAccessLowering2.generateReflectiveMethodInvocation(irType, string2, (List<? extends IrType>)object, call2.getDispatchReceiver(), CollectionsKt.listOfNotNull((Object)call2.getExtensionReceiver()), getter2.getReturnType(), (IrSymbol)call2.getSymbol());
        }
        Pair<IrType, IrExpression> pair = this.fieldLocationAndReceiver(call2);
        IrType fieldLocation = (IrType)pair.component1();
        IrExpression instance2 = (IrExpression)pair.component2();
        String string5 = property.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"property.name.asString()");
        return this.generateReflectiveFieldGet(fieldLocation, string5, getter2.getReturnType(), instance2, (IrSymbol)call2.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveAccessForSetter(IrCall call2) {
        IrSimpleFunction setter2 = (IrSimpleFunction)call2.getSymbol().getOwner();
        IrPropertySymbol irPropertySymbol = setter2.getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        IrProperty property = (IrProperty)irPropertySymbol.getOwner();
        if (this.shouldUseAccessor(setter2)) {
            void $this$generateReflectiveAccessForSetter_u24lambda_u2430;
            List $this$generateReflectiveAccessForSetter_u24lambda_u2428;
            IrValueParameter it;
            List list2;
            IrType irType = (IrType)IrUtilsKt.getDefaultType((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)setter2)));
            String string2 = property.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"property.name.asString()");
            List list3 = list2 = (List)new ArrayList();
            String string3 = JvmAbi.setterName((String)string2);
            IrType irType2 = irType;
            ReflectiveAccessLowering reflectiveAccessLowering2 = this;
            boolean bl = false;
            IrValueParameter irValueParameter = setter2.getExtensionReceiverParameter();
            if (irValueParameter != null) {
                it = irValueParameter;
                boolean bl2 = false;
                $this$generateReflectiveAccessForSetter_u24lambda_u2428.add(it.getType());
            }
            $this$generateReflectiveAccessForSetter_u24lambda_u2428.addAll((Collection)this.valueParameterTypes((IrFunctionAccessExpression)call2));
            Object object = Unit.INSTANCE;
            List list4 = list2;
            $this$generateReflectiveAccessForSetter_u24lambda_u2428 = list2 = (List)new ArrayList();
            IrExpression irExpression = call2.getDispatchReceiver();
            object = list4;
            boolean bl3 = false;
            IrExpression irExpression2 = call2.getExtensionReceiver();
            if (irExpression2 != null) {
                it = irExpression2;
                boolean bl4 = false;
                $this$generateReflectiveAccessForSetter_u24lambda_u2430.add(it);
            }
            $this$generateReflectiveAccessForSetter_u24lambda_u2430.addAll((Collection)this.getValueArguments((IrFunctionAccessExpression)call2));
            Unit unit = Unit.INSTANCE;
            return reflectiveAccessLowering2.generateReflectiveMethodInvocation(irType2, string3, (List<? extends IrType>)object, irExpression, list2, setter2.getReturnType(), (IrSymbol)call2.getSymbol());
        }
        Pair<IrType, IrExpression> pair = this.fieldLocationAndReceiver(call2);
        IrType fieldLocation = (IrType)pair.component1();
        IrExpression receiver = (IrExpression)pair.component2();
        String string4 = property.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"property.name.asString()");
        IrExpression irExpression = call2.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression);
        return this.generateReflectiveFieldSet(fieldLocation, string4, irExpression, call2.getType(), receiver, (IrSymbol)call2.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateThrowIllegalAccessException(IrSetField setField) {
        void $this$generateThrowIllegalAccessException_u24lambda_u2432_u24lambda_u2431;
        IrCall irCall;
        void this_$iv$iv;
        IrBuilderWithScope $this$irBlock_u24default$iv = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, (IrSymbol)setField.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateThrowIllegalAccessException_u24lambda_u2432 = this_$iv$iv;
        boolean bl = false;
        IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$generateThrowIllegalAccessException_u24lambda_u2432), (IrSimpleFunctionSymbol)this.symbols.getThrowIllegalAccessException());
        void var14_14 = $this$generateThrowIllegalAccessException_u24lambda_u2432;
        boolean bl2 = false;
        $this$generateThrowIllegalAccessException_u24lambda_u2432_u24lambda_u2431.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)((IrBuilderWithScope)$this$generateThrowIllegalAccessException_u24lambda_u2432), (String)"Can not set final field"));
        var14_14.unaryPlus((IrStatement)irCall);
        return (IrExpression)this_$iv$iv.doBuild();
    }

    private final IrExpression generateInvokeSpecialForCall(IrCall expression2, IrClassSymbol superQualifier) {
        IrCall irCall;
        JvmMethodSignature jvmSignature = this.context.getDefaultMethodSignatureMapper().mapSignatureSkipGeneric(expression2.getSymbol().getOwner());
        IrClass owner = (IrClass)superQualifier.getOwner();
        JvmIrBuilder builder2 = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, (IrSymbol)expression2.getSymbol(), 0, 0, 6, null);
        IrCall $this$generateInvokeSpecialForCall_u24lambda_u2433 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)builder2, (IrSimpleFunctionSymbol)this.symbols.getJvmDebuggerInvokeSpecialIntrinsic());
        boolean bl = false;
        $this$generateInvokeSpecialForCall_u24lambda_u2433.setDispatchReceiver(expression2.getDispatchReceiver());
        $this$generateInvokeSpecialForCall_u24lambda_u2433.setType(((IrSimpleFunction)expression2.getSymbol().getOwner()).getReturnType());
        $this$generateInvokeSpecialForCall_u24lambda_u2433.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)builder2, (String)("" + AdditionalIrUtilsKt.getPackageFqName((IrClass)owner) + '/' + owner.getName())));
        IrBuilderWithScope irBuilderWithScope = builder2;
        String string2 = jvmSignature.getAsmMethod().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jvmSignature.asmMethod.name");
        $this$generateInvokeSpecialForCall_u24lambda_u2433.putValueArgument(1, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)irBuilderWithScope, (String)string2));
        IrBuilderWithScope irBuilderWithScope2 = builder2;
        String string3 = jvmSignature.getAsmMethod().getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jvmSignature.asmMethod.descriptor");
        $this$generateInvokeSpecialForCall_u24lambda_u2433.putValueArgument(2, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)irBuilderWithScope2, (String)string3));
        $this$generateInvokeSpecialForCall_u24lambda_u2433.putValueArgument(3, (IrExpression)ExpressionHelpersKt.irFalse((IrBuilderWithScope)builder2));
        return (IrExpression)irCall;
    }

    private final IrExpression generateReflectiveAccessForCompanion(IrGetObjectValue call2) {
        return this.generateReflectiveFieldGet((IrType)IrUtilsKt.getDefaultType((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)call2.getSymbol().getOwner()))), "Companion", call2.getType(), null, (IrSymbol)call2.getSymbol());
    }
}

