/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.incremental.CompilationTransaction;
import org.jetbrains.kotlin.incremental.RecoverableCompilationTransaction;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002R.\u0010\u0007\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\bj\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/incremental/RecoverableCompilationTransaction;", "Lorg/jetbrains/kotlin/incremental/CompilationTransaction;", "reporter", "Lorg/jetbrains/kotlin/build/report/BuildReporter;", "stashDir", "Ljava/nio/file/Path;", "(Lorg/jetbrains/kotlin/build/report/BuildReporter;Ljava/nio/file/Path;)V", "fileRelocationRegistry", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "filesCounter", "", "successful", "", "cleanupStash", "", "close", "deleteFile", "outputFile", "getNextRelocatedFilePath", "isFileRelocationIsAlreadyRegisteredFor", "markAsSuccessful", "registerAddedOrChangedFile", "revertChanges", "stashFile", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nCompilationTransaction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilationTransaction.kt\norg/jetbrains/kotlin/incremental/RecoverableCompilationTransaction\n+ 2 BuildMetricsReporter.kt\norg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 File.kt\norg/jetbrains/kotlin/konan/file/FileKt\n*L\n1#1,197:1\n24#2,5:198\n24#2,5:203\n24#2,5:209\n24#2,3:214\n28#2:230\n1#3:208\n197#4,13:217\n*S KotlinDebug\n*F\n+ 1 CompilationTransaction.kt\norg/jetbrains/kotlin/incremental/RecoverableCompilationTransaction\n*L\n102#1:198,5\n124#1:203,5\n146#1:209,5\n164#1:214,3\n164#1:230\n165#1:217,13\n*E\n"})
public final class RecoverableCompilationTransaction
implements CompilationTransaction {
    @NotNull
    private final BuildReporter reporter;
    @NotNull
    private final Path stashDir;
    @NotNull
    private final HashMap<Path, Path> fileRelocationRegistry;
    private int filesCounter;
    private boolean successful;

    public RecoverableCompilationTransaction(@NotNull BuildReporter reporter, @NotNull Path stashDir) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)stashDir, (String)"stashDir");
        this.reporter = reporter;
        this.stashDir = stashDir;
        this.fileRelocationRegistry = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void registerAddedOrChangedFile(@NotNull Path outputFile) {
        void $this$measure$iv;
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        if (this.isFileRelocationIsAlreadyRegisteredFor(outputFile)) {
            return;
        }
        BuildMetricsReporter buildMetricsReporter = this.reporter;
        BuildTime time$iv = BuildTime.PRECISE_BACKUP_OUTPUT;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            boolean bl = false;
            if (Files.exists(outputFile, new LinkOption[0])) {
                this.stashFile(outputFile);
            } else {
                ICReporterKt.debug(this.reporter, (Function0<String>)((Function0)new Function0<String>(outputFile){
                    final /* synthetic */ Path $outputFile;
                    {
                        this.$outputFile = $outputFile;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Marking the " + this.$outputFile + " file as newly added";
                    }
                }));
                ((Map)this.fileRelocationRegistry).put(outputFile, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void deleteFile(@NotNull Path outputFile) {
        void $this$measure$iv;
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        if (!Files.exists(outputFile, new LinkOption[0])) {
            return;
        }
        if (this.isFileRelocationIsAlreadyRegisteredFor(outputFile)) {
            ICReporterKt.debug(this.reporter, (Function0<String>)((Function0)new Function0<String>(outputFile){
                final /* synthetic */ Path $outputFile;
                {
                    this.$outputFile = $outputFile;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Deleting " + this.$outputFile;
                }
            }));
            Files.delete(outputFile);
            return;
        }
        BuildMetricsReporter buildMetricsReporter = this.reporter;
        BuildTime time$iv = BuildTime.PRECISE_BACKUP_OUTPUT;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            boolean bl = false;
            this.stashFile(outputFile);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
    }

    private final void stashFile(Path outputFile) {
        Path relocatedFilePath = this.getNextRelocatedFilePath();
        ICReporterKt.debug(this.reporter, (Function0<String>)((Function0)new Function0<String>(outputFile, relocatedFilePath){
            final /* synthetic */ Path $outputFile;
            final /* synthetic */ Path $relocatedFilePath;
            {
                this.$outputFile = $outputFile;
                this.$relocatedFilePath = $relocatedFilePath;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Moving " + this.$outputFile + " to the stash as " + this.$relocatedFilePath;
            }
        }));
        ((Map)this.fileRelocationRegistry).put(outputFile, relocatedFilePath);
        Files.move(outputFile, relocatedFilePath, new CopyOption[0]);
    }

    private final Path getNextRelocatedFilePath() {
        Path path2;
        Path it = path2 = this.stashDir.resolve(this.filesCounter + ".backup");
        boolean bl = false;
        int n = this.filesCounter;
        this.filesCounter = n + 1;
        Path path3 = path2;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"stashDir.resolve(\"$files\u2026).also { filesCounter++ }");
        return path3;
    }

    private final boolean isFileRelocationIsAlreadyRegisteredFor(Path outputFile) {
        return ((Map)this.fileRelocationRegistry).containsKey(outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void revertChanges() {
        void $this$measure$iv;
        ICReporterKt.debug(this.reporter, (Function0<String>)((Function0)revertChanges.1.INSTANCE));
        BuildMetricsReporter buildMetricsReporter = this.reporter;
        BuildTime time$iv = BuildTime.RESTORE_OUTPUT_FROM_BACKUP;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            boolean bl = false;
            for (Map.Entry entry : ((Map)this.fileRelocationRegistry).entrySet()) {
                Path originPath = (Path)entry.getKey();
                Path relocatedPath = (Path)entry.getValue();
                if (relocatedPath == null) {
                    if (!Files.exists(originPath, new LinkOption[0])) continue;
                    Files.delete(originPath);
                    continue;
                }
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.move(relocatedPath, originPath, copyOptionArray);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void cleanupStash() {
        void $this$measure$iv;
        ICReporterKt.debug(this.reporter, (Function0<String>)((Function0)cleanupStash.1.INSTANCE));
        BuildMetricsReporter buildMetricsReporter = this.reporter;
        BuildTime time$iv = BuildTime.CLEAN_BACKUP_STASH;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            boolean bl = false;
            AutoCloseable $this$use$iv = Files.walk(this.stashDir, new FileVisitOption[0]);
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                Stream it = (Stream)$this$use$iv;
                boolean bl2 = false;
                it.sorted(Comparator.reverseOrder()).forEach(arg_0 -> RecoverableCompilationTransaction.cleanupStash$lambda$6$lambda$5$lambda$4(cleanupStash.2.1.1.INSTANCE, arg_0));
                it = Unit.INSTANCE;
            }
            catch (Exception e$iv) {
                try {
                    closed$iv = true;
                    try {
                        AutoCloseable autoCloseable = $this$use$iv;
                        if (autoCloseable != null) {
                            autoCloseable.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw (Throwable)e$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        AutoCloseable autoCloseable = $this$use$iv;
                        if (autoCloseable != null) {
                            autoCloseable.close();
                        }
                    }
                    throw throwable;
                }
            }
            AutoCloseable autoCloseable = $this$use$iv;
            if (autoCloseable != null) {
                autoCloseable.close();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
    }

    @Override
    public void markAsSuccessful() {
        this.successful = true;
    }

    @Override
    public void close() {
        if (this.successful) {
            this.cleanupStash();
        } else {
            this.revertChanges();
            this.cleanupStash();
        }
    }

    private static final void cleanupStash$lambda$6$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

