/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.io.Closeable;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.container.ComponentContainer;
import org.jetbrains.kotlin.container.ComponentDescriptor;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.ComponentResolveContext;
import org.jetbrains.kotlin.container.ComponentStorage;
import org.jetbrains.kotlin.container.ConstructorBinding;
import org.jetbrains.kotlin.container.DynamicComponentDescriptor;
import org.jetbrains.kotlin.container.IterableDescriptor;
import org.jetbrains.kotlin.container.PlatformExtensionsClashResolver;
import org.jetbrains.kotlin.container.ResolveKt;
import org.jetbrains.kotlin.container.ValueDescriptor;
import org.jetbrains.kotlin.container.ValueResolveContext;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0000J!\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eJ\u001f\u0010\u001f\u001a\u00020\u00002\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0!H\u0000\u00a2\u0006\u0002\b#J\u001b\u0010$\u001a\u00020\u00002\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0!H\u0000\u00a2\u0006\u0002\b'J\u0012\u0010(\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0015\u001a\u00020)H\u0016J\u0018\u0010(\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0015\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0019J\u001a\u0010+\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0015\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0019H\u0002J\"\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0-2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\b\b\u0002\u0010*\u001a\u00020\u0019J\b\u0010.\u001a\u00020\u0005H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/container/StorageComponentContainer;", "Lorg/jetbrains/kotlin/container/ComponentContainer;", "Lorg/jetbrains/kotlin/container/ComponentProvider;", "Ljava/io/Closeable;", "id", "", "parent", "(Ljava/lang/String;Lorg/jetbrains/kotlin/container/StorageComponentContainer;)V", "componentStorage", "Lorg/jetbrains/kotlin/container/ComponentStorage;", "unknownContext", "Lorg/jetbrains/kotlin/container/ComponentResolveContext;", "getUnknownContext", "()Lorg/jetbrains/kotlin/container/ComponentResolveContext;", "unknownContext$delegate", "Lkotlin/Lazy;", "close", "", "compose", "create", "T", "request", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "createResolveContext", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "requestingDescriptor", "Lorg/jetbrains/kotlin/container/ValueDescriptor;", "dump", "printer", "Ljava/io/PrintStream;", "registerClashResolvers", "resolvers", "", "Lorg/jetbrains/kotlin/container/PlatformExtensionsClashResolver;", "registerClashResolvers$container", "registerDescriptors", "descriptors", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "registerDescriptors$container", "resolve", "Ljava/lang/reflect/Type;", "context", "resolveIterable", "resolveMultiple", "", "toString", "container"})
@SourceDebugExtension(value={"SMAP\nContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Container.kt\norg/jetbrains/kotlin/container/StorageComponentContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 reflectHelpers.kt\norg/jetbrains/kotlin/container/ReflectHelpersKt\n*L\n1#1,137:1\n1549#2:138\n1620#2,3:139\n37#3,2:142\n11#4,5:144\n*S KotlinDebug\n*F\n+ 1 Container.kt\norg/jetbrains/kotlin/container/StorageComponentContainer\n*L\n112#1:138\n112#1:139,3\n112#1:142,2\n113#1:144,5\n*E\n"})
public final class StorageComponentContainer
implements ComponentContainer,
ComponentProvider,
Closeable {
    @NotNull
    private final String id;
    @NotNull
    private final Lazy unknownContext$delegate;
    @NotNull
    private final ComponentStorage componentStorage;

    public StorageComponentContainer(@NotNull String id, @Nullable StorageComponentContainer parent2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.unknownContext$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ComponentResolveContext>(parent2, this){
            final /* synthetic */ StorageComponentContainer $parent;
            final /* synthetic */ StorageComponentContainer this$0;
            {
                this.$parent = $parent;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ComponentResolveContext invoke() {
                ComponentResolveContext componentResolveContext;
                StorageComponentContainer storageComponentContainer2 = this.$parent;
                if (storageComponentContainer2 != null) {
                    StorageComponentContainer it = storageComponentContainer2;
                    boolean bl = false;
                    componentResolveContext = new ComponentResolveContext(it, DynamicComponentDescriptor.INSTANCE, null, 4, null);
                } else {
                    componentResolveContext = null;
                }
                ComponentResolveContext parentContext = componentResolveContext;
                return new ComponentResolveContext(this.this$0, DynamicComponentDescriptor.INSTANCE, parentContext);
            }
        }));
        StorageComponentContainer storageComponentContainer2 = parent2;
        this.componentStorage = new ComponentStorage(this.id, storageComponentContainer2 != null ? storageComponentContainer2.componentStorage : null);
    }

    public /* synthetic */ StorageComponentContainer(String string2, StorageComponentContainer storageComponentContainer2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            storageComponentContainer2 = null;
        }
        this(string2, storageComponentContainer2);
    }

    @NotNull
    public final ComponentResolveContext getUnknownContext() {
        Lazy lazy = this.unknownContext$delegate;
        return (ComponentResolveContext)lazy.getValue();
    }

    @Override
    @NotNull
    public ValueResolveContext createResolveContext(@NotNull ValueDescriptor requestingDescriptor) {
        Intrinsics.checkNotNullParameter((Object)requestingDescriptor, (String)"requestingDescriptor");
        if (Intrinsics.areEqual((Object)requestingDescriptor, (Object)DynamicComponentDescriptor.INSTANCE)) {
            return this.getUnknownContext();
        }
        return new ComponentResolveContext(this, requestingDescriptor, null, 4, null);
    }

    @NotNull
    public final StorageComponentContainer compose() {
        this.componentStorage.compose(this.getUnknownContext());
        return this;
    }

    public final void dump(@NotNull PrintStream printer) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        this.componentStorage.dump(printer);
    }

    @Override
    public void close() {
        this.componentStorage.dispose();
    }

    @Nullable
    public final ValueDescriptor resolve(@NotNull Type request, @NotNull ValueResolveContext context) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ValueDescriptor valueDescriptor = this.componentStorage.resolve(request, context);
        if (valueDescriptor == null) {
            valueDescriptor = this.resolveIterable(request, context);
        }
        return valueDescriptor;
    }

    @Override
    @Nullable
    public ValueDescriptor resolve(@NotNull Type request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.resolve(request, this.getUnknownContext());
    }

    private final ValueDescriptor resolveIterable(Type request, ValueResolveContext context) {
        Type type2;
        if (!(request instanceof ParameterizedType)) {
            return null;
        }
        Type rawType = ((ParameterizedType)request).getRawType();
        if (!Intrinsics.areEqual((Object)rawType, Iterable.class)) {
            return null;
        }
        Type[] typeArguments = ((ParameterizedType)request).getActualTypeArguments();
        if (typeArguments.length != 1) {
            return null;
        }
        Type iterableTypeArgument = typeArguments[0];
        Type type3 = iterableTypeArgument;
        if (type3 instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)iterableTypeArgument).getUpperBounds();
            if (upperBounds.length != 1) {
                return null;
            }
            type2 = upperBounds[0];
        } else if (type3 instanceof Class) {
            type2 = iterableTypeArgument;
        } else if (type3 instanceof ParameterizedType) {
            type2 = iterableTypeArgument;
        } else {
            return null;
        }
        Type iterableType = type2;
        Intrinsics.checkNotNullExpressionValue((Object)iterableType, (String)"iterableType");
        return new IterableDescriptor(this.componentStorage.resolveMultiple(iterableType, context));
    }

    @NotNull
    public final Iterable<ValueDescriptor> resolveMultiple(@NotNull Class<?> request, @NotNull ValueResolveContext context) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.componentStorage.resolveMultiple(request, context);
    }

    public static /* synthetic */ Iterable resolveMultiple$default(StorageComponentContainer storageComponentContainer2, Class clazz, ValueResolveContext valueResolveContext, int n, Object object) {
        if ((n & 2) != 0) {
            valueResolveContext = storageComponentContainer2.getUnknownContext();
        }
        return storageComponentContainer2.resolveMultiple(clazz, valueResolveContext);
    }

    @NotNull
    public final StorageComponentContainer registerDescriptors$container(@NotNull List<? extends ComponentDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        this.componentStorage.registerDescriptors$container(this.getUnknownContext(), descriptors);
        return this;
    }

    @NotNull
    public final StorageComponentContainer registerClashResolvers$container(@NotNull List<? extends PlatformExtensionsClashResolver<?>> resolvers) {
        Intrinsics.checkNotNullParameter(resolvers, (String)"resolvers");
        this.componentStorage.registerClashResolvers$container(resolvers);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T create(@NotNull Class<T> request) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(request, (String)"request");
        ConstructorBinding constructorBinding = ResolveKt.bindToConstructor(request, this.getUnknownContext());
        Iterable $this$map$iv = constructorBinding.getArgumentDescriptors();
        boolean $i$f$map = false;
        Iterable<Object> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueDescriptor valueDescriptor = (ValueDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] args = thisCollection$iv.toArray(new Object[0]);
        boolean $i$f$runWithUnwrappingInvocationException = false;
        try {
            boolean bl = false;
            iterable = constructorBinding.getConstructor().newInstance(Arrays.copyOf(args, args.length));
        }
        catch (InvocationTargetException e$iv) {
            Throwable throwable;
            Throwable throwable2;
            Throwable throwable3 = throwable2 = e$iv.getTargetException();
            if (throwable3 == null) {
                throwable = e$iv;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)throwable3, (String)"e.targetException ?: e");
                throwable = throwable2;
            }
            throw throwable;
        }
        return (T)iterable;
    }

    @NotNull
    public String toString() {
        return "Container " + this.id;
    }
}

