/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.google.common.collect.ImmutableBiMap;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartFMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.ControlFlowBuilder;
import org.jetbrains.kotlin.cfg.ControlFlowProcessor;
import org.jetbrains.kotlin.cfg.GenerationTrigger;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.LoopInfo;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.pseudocode.ControlFlowInstructionsGenerator;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tower.TowerLevelsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0015H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "builder", "Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;", "generate", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "subroutine", "Lorg/jetbrains/kotlin/psi/KtElement;", "eventOccurrencesRange", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "generateImplicitReturnValue", "", "bodyExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "generatePseudocode", "processLocalDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "CFPVisitor", "CatchFinallyLabels", "cfg"})
public final class ControlFlowProcessor {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final ControlFlowBuilder builder;

    public ControlFlowProcessor(@NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings2) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        this.trace = trace;
        this.languageVersionSettings = languageVersionSettings2;
        this.builder = new ControlFlowInstructionsGenerator();
    }

    @NotNull
    public final Pseudocode generatePseudocode(@NotNull KtElement subroutine) {
        Intrinsics.checkNotNullParameter((Object)subroutine, (String)"subroutine");
        Pseudocode pseudocode = this.generate(subroutine, null);
        Intrinsics.checkNotNull((Object)pseudocode, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
        ((PseudocodeImpl)pseudocode).postProcess();
        return pseudocode;
    }

    private final Pseudocode generate(KtElement subroutine, EventOccurrencesRange eventOccurrencesRange) {
        this.builder.enterSubroutine(subroutine, eventOccurrencesRange);
        CFPVisitor cfpVisitor = new CFPVisitor(this.builder);
        if (subroutine instanceof KtDeclarationWithBody && !(subroutine instanceof KtSecondaryConstructor)) {
            List list2 = ((KtDeclarationWithBody)subroutine).getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"subroutine.valueParameters");
            List valueParameters2 = list2;
            for (KtParameter valueParameter2 : valueParameters2) {
                cfpVisitor.generateInstructions((KtElement)valueParameter2);
            }
            KtExpression bodyExpression = ((KtDeclarationWithBody)subroutine).getBodyExpression();
            if (bodyExpression != null) {
                cfpVisitor.generateInstructions((KtElement)bodyExpression);
                if (!((KtDeclarationWithBody)subroutine).hasBlockBody()) {
                    this.generateImplicitReturnValue(bodyExpression, subroutine);
                }
            }
        } else {
            cfpVisitor.generateInstructions(subroutine);
        }
        return this.builder.exitSubroutine(subroutine, eventOccurrencesRange);
    }

    static /* synthetic */ Pseudocode generate$default(ControlFlowProcessor controlFlowProcessor, KtElement ktElement, EventOccurrencesRange eventOccurrencesRange, int n, Object object) {
        if ((n & 2) != 0) {
            eventOccurrencesRange = null;
        }
        return controlFlowProcessor.generate(ktElement, eventOccurrencesRange);
    }

    private final void generateImplicitReturnValue(KtExpression bodyExpression, KtElement subroutine) {
        CallableDescriptor callableDescriptor = (CallableDescriptor)this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, subroutine);
        if (callableDescriptor == null) {
            return;
        }
        CallableDescriptor subroutineDescriptor = callableDescriptor;
        KotlinType returnType2 = subroutineDescriptor.getReturnType();
        if (returnType2 != null && KotlinBuiltIns.isUnit(returnType2) && subroutineDescriptor instanceof AnonymousFunctionDescriptor) {
            return;
        }
        PseudoValue pseudoValue = this.builder.getBoundValue((KtElement)bodyExpression);
        if (pseudoValue == null) {
            return;
        }
        PseudoValue returnValue = pseudoValue;
        this.builder.returnValue(bodyExpression, returnValue, subroutine);
    }

    private final void processLocalDeclaration(KtDeclaration subroutine) {
        Label afterDeclaration = this.builder.createUnboundLabel("after local declaration");
        this.builder.nondeterministicJump(afterDeclaration, (KtElement)subroutine, null);
        this.generate((KtElement)subroutine, null);
        this.builder.bindLabel(afterDeclaration);
    }

    public static final /* synthetic */ Pseudocode access$generate(ControlFlowProcessor $this, KtElement subroutine, EventOccurrencesRange eventOccurrencesRange) {
        return $this.generate(subroutine, eventOccurrencesRange);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c3\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\t\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0002\u00ef\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010\u001f\u001a\u00020\u000e2\b\u0010 \u001a\u0004\u0018\u00010\u00162\u0006\u0010!\u001a\u00020\u0016H\u0002J(\u0010\"\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00162\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160#2\u0006\u0010$\u001a\u00020%H\u0002J5\u0010\"\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\u0016\u0010 \u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160&\"\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010'J1\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160&\"\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010'J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,H\u0002J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0#2\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160#H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010+\u001a\u00020/H\u0002J\u001e\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u0002022\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0002J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020/0#2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00104\u001a\u00020\u000e2\u0006\u00101\u001a\u000202H\u0002J(\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u0002022\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c082\u0006\u00109\u001a\u00020/H\u0002J\u0010\u0010:\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020;H\u0002J\u0010\u0010=\u001a\u00020\u00112\u0006\u0010>\u001a\u00020\u0016H\u0002J\u0014\u0010=\u001a\u00020?2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u0010\u0010@\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020EH\u0002J\u0018\u0010G\u001a\u00020\u000e2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u001cH\u0002J\u0010\u0010K\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020LH\u0002J\u0010\u0010M\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\b\u0010N\u001a\u00020\u000eH\u0002J,\u0010O\u001a\u00020\u000e2\b\u0010P\u001a\u0004\u0018\u00010/2\u0018\u0010Q\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u00020S0\u00130RH\u0002J\u0018\u0010T\u001a\u00020\u00112\u0006\u0010+\u001a\u00020/2\u0006\u0010U\u001a\u00020VH\u0002J\u0012\u0010W\u001a\u0004\u0018\u00010X2\u0006\u0010+\u001a\u00020YH\u0002J8\u0010Z\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\\0[2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\\2\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\\0[H\u0002J2\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\\0[2\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c082\f\u0010b\u001a\b\u0012\u0004\u0012\u00020S0\u0013H\u0002J\u0014\u0010c\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0012\u0010d\u001a\u0004\u0018\u00010e2\u0006\u0010+\u001a\u00020fH\u0002J\u0012\u0010g\u001a\u0004\u0018\u00010e2\u0006\u0010+\u001a\u00020/H\u0002J\u0010\u0010h\u001a\u00020i2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010j\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c082\b\u0010+\u001a\u0004\u0018\u00010/H\u0002J\u0012\u0010k\u001a\u0004\u0018\u00010e2\u0006\u0010+\u001a\u00020/H\u0002J:\u0010l\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020m0[2\u0006\u0010>\u001a\u00020\u00162\b\u0010n\u001a\u0004\u0018\u00010m2\u0012\u0010o\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020m0[H\u0002J \u0010l\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020m0p2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u0012\u0010q\u001a\u00020i2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u001a\u0010r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c082\b\u0010s\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010t\u001a\u00020\u00112\u0006\u0010+\u001a\u00020uH\u0002J\u0010\u0010v\u001a\u00020\u00112\u0006\u0010w\u001a\u00020xH\u0002J\u0018\u0010y\u001a\u00020\u00112\u0006\u0010z\u001a\u00020f2\u0006\u0010{\u001a\u00020|H\u0002J\u0018\u0010}\u001a\u00020\u00112\u0006\u0010z\u001a\u00020f2\u0006\u0010{\u001a\u00020eH\u0002J\u0010\u0010~\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u007f\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020/0#2\u0006\u0010!\u001a\u00020/H\u0002J\u0012\u0010\u0080\u0001\u001a\u00020\u000e2\u0007\u0010\u0081\u0001\u001a\u00020EH\u0002J\u0018\u0010\u0082\u0001\u001a\u00020\u000e2\r\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020\u001e0#H\u0002J\u0011\u0010\u0084\u0001\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u0085\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u0086\u0001H\u0016J\u0013\u0010\u0087\u0001\u001a\u00020\u000e2\b\u0010\u0088\u0001\u001a\u00030\u0089\u0001H\u0016J\u0011\u0010\u008a\u0001\u001a\u00020\u000e2\u0006\u0010+\u001a\u000202H\u0016J+\u0010\u008b\u0001\u001a\u00020\u000e2\b\u00106\u001a\u0004\u0018\u00010/2\u000e\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c082\u0006\u00109\u001a\u00020/H\u0002J\u0011\u0010\u008c\u0001\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020;H\u0016J\u0012\u0010\u008d\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u008e\u0001H\u0016J\u0011\u0010\u008f\u0001\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020uH\u0016J\u0012\u0010\u0090\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u0091\u0001H\u0016J\u0012\u0010\u0092\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u0093\u0001H\u0016J\u0013\u0010\u0094\u0001\u001a\u00020\u000e2\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0016J\u0012\u0010\u0097\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u0098\u0001H\u0016J\u0012\u0010\u0099\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u009a\u0001H\u0016J\u0013\u0010\u009b\u0001\u001a\u00020\u000e2\b\u0010\u009c\u0001\u001a\u00030\u009d\u0001H\u0016J\u0012\u0010\u009e\u0001\u001a\u00020\u000e2\u0007\u0010H\u001a\u00030\u009f\u0001H\u0016J\u001b\u0010\u009e\u0001\u001a\u00020\u000e2\u0007\u0010H\u001a\u00030\u009f\u00012\u0007\u0010\u00a0\u0001\u001a\u00020\u0011H\u0002J\u0012\u0010\u00a1\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00a2\u0001H\u0016J\u0012\u0010\u00a3\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00a4\u0001H\u0016J\u0011\u0010\u00a5\u0001\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,H\u0016J!\u0010\u00a6\u0001\u001a\u00020\u000e2\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u00012\f\b\u0002\u0010\u00a9\u0001\u001a\u0005\u0018\u00010\u00aa\u0001H\u0002J\u0012\u0010\u00ab\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00ac\u0001H\u0016J\u0013\u0010\u00ad\u0001\u001a\u00020\u000e2\b\u0010\u00ae\u0001\u001a\u00030\u00af\u0001H\u0016J\u001d\u0010\u00b0\u0001\u001a\u00020\u000e2\b\u0010\u00b1\u0001\u001a\u00030\u00a8\u00012\b\u0010\u00a9\u0001\u001a\u00030\u00aa\u0001H\u0002J\u0012\u0010\u00b2\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00b3\u0001H\u0016J\u0011\u0010\u00b4\u0001\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0013\u0010\u00b5\u0001\u001a\u00020\u000e2\b\u0010\u00b6\u0001\u001a\u00030\u00b7\u0001H\u0016J\u0012\u0010\u00b8\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00b9\u0001H\u0016J\u0013\u0010\u00ba\u0001\u001a\u00020\u000e2\b\u0010\u00bb\u0001\u001a\u00030\u00bc\u0001H\u0016J\u0013\u0010\u00bd\u0001\u001a\u00020\u000e2\b\u0010\u00a7\u0001\u001a\u00030\u00be\u0001H\u0016J\u0013\u0010\u00bf\u0001\u001a\u00020\u000e2\b\u0010\u00c0\u0001\u001a\u00030\u00c1\u0001H\u0016J\u0012\u0010\u00c2\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00c3\u0001H\u0016J\u0011\u0010\u00c4\u0001\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u00c5\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00c6\u0001H\u0016J\u0013\u0010\u00c7\u0001\u001a\u00020\u000e2\b\u0010\u00c8\u0001\u001a\u00030\u00c9\u0001H\u0016J\u0013\u0010\u00ca\u0001\u001a\u00020\u000e2\b\u0010\u00cb\u0001\u001a\u00030\u00cc\u0001H\u0016J\u0012\u0010\u00cd\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00ce\u0001H\u0016J\u0011\u0010\u00cf\u0001\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u0019H\u0016J\u0013\u0010\u00d0\u0001\u001a\u00020\u000e2\b\u0010\u00d1\u0001\u001a\u00030\u00d2\u0001H\u0016J\u0013\u0010\u00d3\u0001\u001a\u00020\u000e2\b\u0010\u00d4\u0001\u001a\u00030\u00d5\u0001H\u0016J\u0012\u0010\u00d6\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00d7\u0001H\u0016J\u0012\u0010\u00d8\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00d9\u0001H\u0016J\u0012\u0010\u00da\u0001\u001a\u00020\u000e2\u0007\u0010A\u001a\u00030\u00db\u0001H\u0016J\u0013\u0010\u00dc\u0001\u001a\u00020\u000e2\b\u0010\u009c\u0001\u001a\u00030\u00dd\u0001H\u0016J\u0013\u0010\u00de\u0001\u001a\u00020\u000e2\b\u0010\u00ae\u0001\u001a\u00030\u00df\u0001H\u0016J\u0012\u0010\u00e0\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00e1\u0001H\u0016J\u0012\u0010\u00e2\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00e3\u0001H\u0016J\u0011\u0010\u00e4\u0001\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020YH\u0016J\u0013\u0010\u00e5\u0001\u001a\u00020\u000e2\b\u0010\u00e6\u0001\u001a\u00030\u00e7\u0001H\u0016J\u0012\u0010\u00e8\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00e9\u0001H\u0016J\u0012\u0010\u00ea\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00eb\u0001H\u0016J\u0012\u0010\u00ec\u0001\u001a\u00020\u000e2\u0007\u0010+\u001a\u00030\u00ed\u0001H\u0016J\u0011\u0010\u00ee\u0001\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR*\u0010\u000b\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u000f0\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00f0\u0001"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "builder", "Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;", "(Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor;Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;)V", "catchFinallyStack", "Ljava/util/Stack;", "Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CatchFinallyLabels;", "conditionVisitor", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$conditionVisitor$1", "Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$conditionVisitor$1;", "deferredGeneratorsStack", "", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/cfg/DeferredGenerator;", "checkAndGenerateCall", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "checkNothingType", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "checkReturnLabelTarget", "returnExpression", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "labeledElement", "computePseudoValueForParameter", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "copyValue", "from", "to", "createNonSyntheticValue", "", "kind", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MagicKind;", "", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MagicKind;[Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "createSyntheticValue", "instructionElement", "declareLoopParameter", "expression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "elementsToValues", "generateAndGetReceiverIfAny", "Lorg/jetbrains/kotlin/psi/KtExpression;", "generateArrayAccess", "arrayAccessExpression", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "generateArrayAccessArguments", "generateArrayAccessWithoutCall", "generateArrayAssignment", "lhs", "rhsDeferredValue", "Lkotlin/Function0;", "parentExpression", "generateBooleanOperation", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "generateBothArgumentsAndMark", "generateCall", "callElement", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/InstructionWithValue;", "generateCallOrMarkUnresolved", "call", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "generateDeclarationForLocalClassOrObjectIfNeeded", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "generateHeaderDelegationSpecifiers", "generateInitializer", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "initValue", "generateInitializersForClassOrObject", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "generateInstructions", "generateJumpsToCatchAndFinally", "generateLoopConventionCall", "loopRange", "callSlice", "Lorg/jetbrains/kotlin/util/slicedMap/ReadOnlySlice;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateQualifier", "qualifier", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;", "generateTryAndCatches", "Lorg/jetbrains/kotlin/cfg/Label;", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "generateValueArgument", "Lcom/intellij/util/SmartFMap;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "parameterDescriptor", "parameterValuesArg", "getArraySetterArguments", "setResolvedCall", "getBoundOrUnreachableValue", "getCorrespondingLoop", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "getCorrespondingLoopWithoutLabel", "getDeclarationAccessTarget", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/AccessTarget;", "getDeferredValue", "getNearestLoopExpression", "getReceiverValues", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "receiver", "receiverValuesArg", "", "getResolvedCallAccessTarget", "getValueAsFunction", "value", "isBlockInDoWhile", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "isIncrementOrDecrement", "operationType", "Lcom/intellij/psi/tree/IElementType;", "jumpCrossesTryCatchBoundary", "jumpExpression", "jumpTarget", "Lcom/intellij/psi/PsiElement;", "jumpDoesNotCrossFunctionBoundary", "mark", "mergeValues", "processEntryOrObject", "entryOrObject", "processParameters", "parameters", "returnCrossesTryCatchBoundary", "visitAnnotatedExpression", "Lorg/jetbrains/kotlin/psi/KtAnnotatedExpression;", "visitAnonymousInitializer", "classInitializer", "Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;", "visitArrayAccessExpression", "visitAssignment", "visitBinaryExpression", "visitBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "visitBlockExpression", "visitBreakExpression", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "visitContinueExpression", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "visitDelegatedSuperTypeEntry", "specifier", "Lorg/jetbrains/kotlin/psi/KtDelegatedSuperTypeEntry;", "visitDestructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "generateWriteForEntries", "visitDoWhileExpression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "visitDoubleColonExpression", "Lorg/jetbrains/kotlin/psi/KtDoubleColonExpression;", "visitForExpression", "visitFunction", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "eventOccurrencesRange", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitInitializerList", "list", "Lorg/jetbrains/kotlin/psi/KtInitializerList;", "visitInlinedFunction", "lambdaFunctionLiteral", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "visitKtElement", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitLabeledExpression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitObjectDeclaration", "objectDeclaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "visitObjectLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "visitParameter", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitPropertyAccessor", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "visitQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "visitReturnExpression", "visitScript", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "visitSecondaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "visitSuperTypeCallEntry", "Lorg/jetbrains/kotlin/psi/KtSuperTypeCallEntry;", "visitSuperTypeEntry", "Lorg/jetbrains/kotlin/psi/KtSuperTypeEntry;", "visitSuperTypeList", "Lorg/jetbrains/kotlin/psi/KtSuperTypeList;", "visitThisExpression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "visitThrowExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "visitTryExpression", "visitTypeProjection", "typeProjection", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "writeLoopParameterAssignment", "FinallyBlockGenerator", "cfg"})
    @SourceDebugExtension(value={"SMAP\nControlFlowProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlFlowProcessor.kt\norg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,1700:1\n1#2:1701\n1#2:1712\n1#2:1736\n1603#3,9:1702\n1855#3:1711\n1856#3:1713\n1612#3:1714\n1446#3,5:1715\n1855#3,2:1721\n1603#3,9:1726\n1855#3:1735\n1856#3:1737\n1612#3:1738\n1855#3,2:1739\n142#4:1720\n154#4:1723\n158#4:1724\n154#4:1725\n*S KotlinDebug\n*F\n+ 1 ControlFlowProcessor.kt\norg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor\n*L\n227#1:1712\n1500#1:1736\n227#1:1702,9\n227#1:1711\n227#1:1713\n227#1:1714\n480#1:1715,5\n1416#1:1721,2\n1500#1:1726,9\n1500#1:1735\n1500#1:1737\n1500#1:1738\n1605#1:1739,2\n862#1:1720\n1434#1:1723\n1435#1:1724\n1436#1:1725\n*E\n"})
    private final class CFPVisitor
    extends KtVisitorVoid {
        @NotNull
        private final ControlFlowBuilder builder;
        @NotNull
        private final Stack<CatchFinallyLabels> catchFinallyStack;
        @NotNull
        private final Stack<List<Function1<ControlFlowBuilder, Unit>>> deferredGeneratorsStack;
        @NotNull
        private final conditionVisitor.1 conditionVisitor;

        public CFPVisitor(ControlFlowBuilder builder2) {
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            this.builder = builder2;
            this.catchFinallyStack = new Stack();
            this.deferredGeneratorsStack = new Stack();
            this.conditionVisitor = new KtVisitorVoid(this){
                final /* synthetic */ CFPVisitor this$0;
                {
                    this.this$0 = $receiver;
                }

                private final KtExpression getSubjectExpression(KtWhenCondition condition) {
                    PsiElement $this$getStrictParentOfType$iv = (PsiElement)condition;
                    boolean $i$f$getStrictParentOfType = false;
                    KtWhenExpression ktWhenExpression = (KtWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtWhenExpression.class, (boolean)true);
                    return ktWhenExpression != null ? ktWhenExpression.getSubjectExpression() : null;
                }

                public void visitWhenConditionInRange(@NotNull KtWhenConditionInRange condition) {
                    Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
                    KtOperationReferenceExpression ktOperationReferenceExpression = condition.getOperationReference();
                    Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"condition.operationReference");
                    if (!CFPVisitor.access$generateCall(this.this$0, (KtElement)ktOperationReferenceExpression)) {
                        KtExpression rangeExpression = condition.getRangeExpression();
                        this.this$0.generateInstructions((KtElement)rangeExpression);
                        KtElement[] ktElementArray = new KtElement[]{rangeExpression};
                        CFPVisitor.access$createNonSyntheticValue(this.this$0, (KtElement)condition, MagicKind.UNRESOLVED_CALL, ktElementArray);
                    }
                }

                public void visitWhenConditionIsPattern(@NotNull KtWhenConditionIsPattern condition) {
                    Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
                    CFPVisitor.access$mark(this.this$0, (KtElement)condition);
                    KtElement[] ktElementArray = new KtElement[]{this.getSubjectExpression((KtWhenCondition)condition)};
                    CFPVisitor.access$createNonSyntheticValue(this.this$0, (KtElement)condition, MagicKind.IS, ktElementArray);
                }

                public void visitWhenConditionWithExpression(@NotNull KtWhenConditionWithExpression condition) {
                    Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
                    CFPVisitor.access$mark(this.this$0, (KtElement)condition);
                    KtExpression expression2 = condition.getExpression();
                    this.this$0.generateInstructions((KtElement)expression2);
                    KtExpression subjectExpression = this.getSubjectExpression((KtWhenCondition)condition);
                    if (subjectExpression != null) {
                        KtElement[] ktElementArray = new KtElement[]{subjectExpression, expression2};
                        CFPVisitor.access$createNonSyntheticValue(this.this$0, (KtElement)condition, MagicKind.EQUALS_IN_WHEN_CONDITION, ktElementArray);
                    } else {
                        CFPVisitor.access$copyValue(this.this$0, (KtElement)expression2, (KtElement)condition);
                    }
                }

                public void visitKtElement(@NotNull KtElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    throw new UnsupportedOperationException("[ControlFlowProcessor] " + element);
                }
            };
        }

        private final void mark(KtElement element) {
            this.builder.mark(element);
        }

        public final void generateInstructions(@Nullable KtElement element) {
            if (element == null) {
                return;
            }
            element.accept((PsiElementVisitor)this);
            this.checkNothingType(element);
        }

        private final void checkNothingType(KtElement element) {
            if (!(element instanceof KtExpression)) {
                return;
            }
            KtExpression ktExpression = KtPsiUtil.deparenthesize((KtExpression)((KtExpression)element));
            if (ktExpression == null) {
                return;
            }
            KtExpression expression2 = ktExpression;
            if (expression2 instanceof KtStatementExpression || expression2 instanceof KtTryExpression || expression2 instanceof KtIfExpression || expression2 instanceof KtWhenExpression) {
                return;
            }
            KotlinType type2 = ControlFlowProcessor.this.trace.getBindingContext().getType(expression2);
            if (type2 != null && KotlinBuiltIns.isNothing(type2)) {
                this.builder.jumpToError((KtElement)expression2);
            }
        }

        private final PseudoValue createSyntheticValue(KtElement instructionElement, MagicKind kind, KtElement ... from) {
            return this.builder.magic(instructionElement, null, this.elementsToValues(ArraysKt.asList((Object[])from)), kind).getOutputValue();
        }

        private final PseudoValue createNonSyntheticValue(KtElement to, List<? extends KtElement> from, MagicKind kind) {
            return this.builder.magic(to, to, this.elementsToValues(from), kind).getOutputValue();
        }

        private final PseudoValue createNonSyntheticValue(KtElement to, MagicKind kind, KtElement ... from) {
            return this.createNonSyntheticValue(to, ArraysKt.asList((Object[])from), kind);
        }

        private final void mergeValues(List<? extends KtExpression> from, KtExpression to) {
            this.builder.merge(to, this.elementsToValues(from));
        }

        private final void copyValue(KtElement from, KtElement to) {
            block0: {
                PseudoValue pseudoValue = this.getBoundOrUnreachableValue(from);
                if (pseudoValue == null) break block0;
                PseudoValue it = pseudoValue;
                boolean bl = false;
                this.builder.bindValue(it, to);
            }
        }

        private final PseudoValue getBoundOrUnreachableValue(KtElement element) {
            if (element == null) {
                return null;
            }
            PseudoValue value2 = this.builder.getBoundValue(element);
            return value2 != null || element instanceof KtDeclaration ? value2 : this.builder.newValue(element);
        }

        /*
         * WARNING - void declaration
         */
        private final List<PseudoValue> elementsToValues(List<? extends KtElement> from) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = from;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PseudoValue it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtElement element = (KtElement)element$iv$iv;
                boolean bl2 = false;
                if (this.getBoundOrUnreachableValue(element) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final void generateInitializer(KtDeclaration declaration, PseudoValue initValue) {
            this.builder.write((KtElement)declaration, (KtElement)declaration, initValue, this.getDeclarationAccessTarget((KtElement)declaration), MapsKt.emptyMap());
        }

        private final AccessTarget getResolvedCallAccessTarget(KtElement element) {
            AccessTarget accessTarget;
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(element, bindingContext);
            if (resolvedCall2 != null) {
                ResolvedCall<? extends CallableDescriptor> it = resolvedCall2;
                boolean bl = false;
                accessTarget = new AccessTarget.Call(it);
            } else {
                accessTarget = AccessTarget.BlackBox.INSTANCE;
            }
            return accessTarget;
        }

        private final AccessTarget getDeclarationAccessTarget(KtElement element) {
            DeclarationDescriptor descriptor2 = ControlFlowProcessor.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
            return descriptor2 instanceof VariableDescriptor ? (AccessTarget)new AccessTarget.Declaration((VariableDescriptor)descriptor2) : (AccessTarget)AccessTarget.BlackBox.INSTANCE;
        }

        public void visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark((KtElement)expression2);
            KtExpression innerExpression = expression2.getExpression();
            if (innerExpression != null) {
                this.generateInstructions((KtElement)innerExpression);
                this.copyValue((KtElement)innerExpression, (KtElement)expression2);
            }
        }

        public void visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtExpression baseExpression = expression2.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions((KtElement)baseExpression);
                this.copyValue((KtElement)baseExpression, (KtElement)expression2);
            }
        }

        public void visitThisExpression(@NotNull KtThisExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtElement ktElement = (KtElement)expression2;
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            if (resolvedCall2 == null) {
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, new KtElement[0]);
                return;
            }
            CallableDescriptor resultingDescriptor = resolvedCall2.getResultingDescriptor();
            if (resultingDescriptor instanceof ReceiverParameterDescriptor) {
                this.builder.readVariable((KtExpression)expression2, resolvedCall2, this.getReceiverValues(resolvedCall2));
            }
            KtElement ktElement2 = (KtElement)expression2;
            KtReferenceExpression ktReferenceExpression = expression2.getInstanceReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktReferenceExpression, (String)"expression.instanceReference");
            this.copyValue(ktElement2, (KtElement)ktReferenceExpression);
        }

        public void visitConstantExpression(@NotNull KtConstantExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtExpression ktExpression = (KtExpression)expression2;
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            CompileTimeConstant<?> constant = ConstantExpressionEvaluator.Companion.getConstant(ktExpression, bindingContext);
            this.builder.loadConstant((KtExpression)expression2, constant);
        }

        public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtElement ktElement = (KtElement)expression2;
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                this.generateCall(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall());
            } else {
                if (resolvedCall2 == null) {
                    KtExpression ktExpression;
                    boolean bl = ControlFlowProcessor.this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitQualifiedAccessToUninitializedEnumEntry);
                    if (bl) {
                        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector((KtSimpleNameExpression)expression2);
                        ktExpression = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)expression2;
                    } else if (!bl) {
                        ktExpression = (KtExpression)expression2;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    KtExpression qualifierExpression = ktExpression;
                    Qualifier qualifier = (Qualifier)ControlFlowProcessor.this.trace.getBindingContext().get(BindingContext.QUALIFIER, qualifierExpression);
                    if (qualifier != null && this.generateQualifier((KtExpression)expression2, qualifier)) {
                        return;
                    }
                }
                if (!this.generateCall((KtElement)expression2) && !(expression2.getParent() instanceof KtCallExpression)) {
                    KtElement[] ktElementArray = new KtElement[]{this.generateAndGetReceiverIfAny((KtExpression)expression2)};
                    this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, ktElementArray);
                }
            }
        }

        public void visitLabeledExpression(@NotNull KtLabeledExpression expression2) {
            KtExpression deparenthesizedBaseExpression;
            KtSimpleNameExpression labelNameExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark((KtElement)expression2);
            KtExpression baseExpression = expression2.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions((KtElement)baseExpression);
                this.copyValue((KtElement)baseExpression, (KtElement)expression2);
            }
            if (!((labelNameExpression = expression2.getTargetLabel()) == null || (deparenthesizedBaseExpression = KtPsiUtil.deparenthesize((KtExpression)((KtExpression)expression2))) instanceof KtLambdaExpression || deparenthesizedBaseExpression instanceof KtLoopExpression || deparenthesizedBaseExpression instanceof KtNamedFunction)) {
                ControlFlowProcessor.this.trace.report(Errors.REDUNDANT_LABEL_WARNING.on((KtElement)((PsiElement)labelNameExpression)));
            }
        }

        public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtOperationReferenceExpression ktOperationReferenceExpression = expression2.getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"expression.operationReference");
            KtOperationReferenceExpression operationReference = ktOperationReferenceExpression;
            IElementType operationType = operationReference.getReferencedNameElementType();
            KtExpression left = expression2.getLeft();
            KtExpression right = expression2.getRight();
            if (operationType == KtTokens.ANDAND || operationType == KtTokens.OROR) {
                this.generateBooleanOperation(expression2);
            } else if (operationType == KtTokens.EQ) {
                this.visitAssignment(left, this.getDeferredValue(right), (KtExpression)expression2);
            } else {
                ImmutableBiMap immutableBiMap = OperatorConventions.ASSIGNMENT_OPERATIONS;
                Intrinsics.checkNotNullExpressionValue((Object)immutableBiMap, (String)"ASSIGNMENT_OPERATIONS");
                if (((Map)immutableBiMap).containsKey(operationType)) {
                    KtElement ktElement = (KtElement)expression2;
                    BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
                    if (resolvedCall2 != null) {
                        PseudoValue rhsValue = this.generateCall(resolvedCall2).getOutputValue();
                        IElementType iElementType = expression2.getOperationToken();
                        Intrinsics.checkNotNull((Object)iElementType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtToken");
                        Name assignMethodName = OperatorConventions.getNameForOperationSymbol((KtToken)((KtToken)iElementType));
                        if (!Intrinsics.areEqual((Object)resolvedCall2.getResultingDescriptor().getName(), (Object)assignMethodName)) {
                            this.visitAssignment(left, this.getValueAsFunction(rhsValue), (KtExpression)expression2);
                        }
                    } else {
                        this.generateBothArgumentsAndMark(expression2);
                    }
                } else if (operationType == KtTokens.ELVIS) {
                    this.generateInstructions((KtElement)left);
                    this.mark((KtElement)expression2);
                    Label afterElvis = this.builder.createUnboundLabel("after elvis operator");
                    this.builder.jumpOnTrue(afterElvis, (KtElement)expression2, this.builder.getBoundValue((KtElement)left));
                    this.generateInstructions((KtElement)right);
                    this.builder.bindLabel(afterElvis);
                    Object[] objectArray = new KtExpression[]{left, right};
                    this.mergeValues(CollectionsKt.listOfNotNull((Object[])objectArray), (KtExpression)expression2);
                    if (right != null && ControlFlowProcessor.this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitNonExhaustiveIfInRhsOfElvis)) {
                        BindingContextUtilsKt.recordUsedAsExpression((KtElement)right, ControlFlowProcessor.this.trace, true);
                    }
                } else if (!this.generateCall((KtElement)expression2)) {
                    this.generateBothArgumentsAndMark(expression2);
                }
            }
        }

        private final void generateBooleanOperation(KtBinaryExpression expression2) {
            IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
            KtExpression left = expression2.getLeft();
            KtExpression right = expression2.getRight();
            Label resultLabel = this.builder.createUnboundLabel("result of boolean operation");
            this.generateInstructions((KtElement)left);
            if (operationType == KtTokens.ANDAND) {
                this.builder.jumpOnFalse(resultLabel, (KtElement)expression2, this.builder.getBoundValue((KtElement)left));
            } else {
                this.builder.jumpOnTrue(resultLabel, (KtElement)expression2, this.builder.getBoundValue((KtElement)left));
            }
            this.generateInstructions((KtElement)right);
            this.builder.bindLabel(resultLabel);
            ControlFlowBuilder.PredefinedOperation operation = operationType == KtTokens.ANDAND ? ControlFlowBuilder.PredefinedOperation.AND : ControlFlowBuilder.PredefinedOperation.OR;
            Object[] objectArray = new KtExpression[]{left, right};
            this.builder.predefinedOperation((KtExpression)expression2, operation, this.elementsToValues(CollectionsKt.listOfNotNull((Object[])objectArray)));
        }

        private final Function0<PseudoValue> getValueAsFunction(PseudoValue value2) {
            return (Function0)new Function0<PseudoValue>(value2){
                final /* synthetic */ PseudoValue $value;
                {
                    this.$value = $value;
                    super(0);
                }

                @Nullable
                public final PseudoValue invoke() {
                    return this.$value;
                }
            };
        }

        private final Function0<PseudoValue> getDeferredValue(KtExpression expression2) {
            return (Function0)new Function0<PseudoValue>(this, expression2){
                final /* synthetic */ CFPVisitor this$0;
                final /* synthetic */ KtExpression $expression;
                {
                    this.this$0 = $receiver;
                    this.$expression = $expression;
                    super(0);
                }

                @Nullable
                public final PseudoValue invoke() {
                    this.this$0.generateInstructions((KtElement)this.$expression);
                    return CFPVisitor.access$getBoundOrUnreachableValue(this.this$0, (KtElement)this.$expression);
                }
            };
        }

        private final void generateBothArgumentsAndMark(KtBinaryExpression expression2) {
            KtExpression right;
            KtExpression left = KtPsiUtil.deparenthesize((KtExpression)expression2.getLeft());
            if (left != null) {
                this.generateInstructions((KtElement)left);
            }
            if ((right = expression2.getRight()) != null) {
                this.generateInstructions((KtElement)right);
            }
            this.mark((KtElement)expression2);
            KtElement[] ktElementArray = new KtElement[]{left, right};
            this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, ktElementArray);
        }

        private final void visitAssignment(KtExpression lhs, Function0<? extends PseudoValue> rhsDeferredValue, KtExpression parentExpression) {
            PseudoValue rightValue;
            PseudoValue pseudoValue;
            KtExpression left;
            block11: {
                Object object;
                block13: {
                    block12: {
                        left = KtPsiUtil.deparenthesize((KtExpression)lhs);
                        if (left != null) break block11;
                        object = (PseudoValue)rhsDeferredValue.invoke();
                        if (object == null) break block12;
                        PseudoValue it = object;
                        boolean bl = false;
                        List list2 = CollectionsKt.listOf((Object)it);
                        object = list2;
                        if (list2 != null) break block13;
                    }
                    object = CollectionsKt.emptyList();
                }
                Object arguments2 = object;
                this.builder.magic((KtElement)parentExpression, (KtElement)parentExpression, (List<? extends PseudoValue>)arguments2, MagicKind.UNSUPPORTED_ELEMENT);
                return;
            }
            if (left instanceof KtArrayAccessExpression) {
                this.generateArrayAssignment((KtArrayAccessExpression)left, rhsDeferredValue, parentExpression);
                return;
            }
            SmartFMap smartFMap = SmartFMap.emptyMap();
            Intrinsics.checkNotNullExpressionValue((Object)smartFMap, (String)"emptyMap()");
            Map<PseudoValue, ReceiverValue> receiverValues = (Map<PseudoValue, ReceiverValue>)smartFMap;
            AccessTarget accessTarget = AccessTarget.BlackBox.INSTANCE;
            if (left instanceof KtSimpleNameExpression || left instanceof KtQualifiedExpression) {
                accessTarget = this.getResolvedCallAccessTarget(KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)left)));
                if (accessTarget instanceof AccessTarget.Call) {
                    receiverValues = this.getReceiverValues(((AccessTarget.Call)accessTarget).getResolvedCall());
                }
            } else if (left instanceof KtProperty) {
                accessTarget = this.getDeclarationAccessTarget((KtElement)left);
            }
            if (accessTarget == AccessTarget.BlackBox.INSTANCE && !(left instanceof KtProperty)) {
                this.generateInstructions((KtElement)left);
                KtElement[] ktElementArray = new KtElement[]{left};
                this.createSyntheticValue((KtElement)left, MagicKind.VALUE_CONSUMER, ktElementArray);
            }
            if ((pseudoValue = (rightValue = (PseudoValue)rhsDeferredValue.invoke())) == null) {
                pseudoValue = this.createSyntheticValue((KtElement)parentExpression, MagicKind.UNRECOGNIZED_WRITE_RHS, new KtElement[0]);
            }
            PseudoValue rValue = pseudoValue;
            this.builder.write((KtElement)parentExpression, (KtElement)left, rValue, accessTarget, receiverValues);
        }

        private final void generateArrayAssignment(KtArrayAccessExpression lhs, Function0<? extends PseudoValue> rhsDeferredValue, KtExpression parentExpression) {
            ResolvedCall setResolvedCall = (ResolvedCall)ControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_SET, lhs);
            if (setResolvedCall == null) {
                this.generateArrayAccess(lhs, null);
                Object[] objectArray = new PseudoValue[]{this.getBoundOrUnreachableValue((KtElement)lhs), rhsDeferredValue.invoke()};
                List arguments2 = CollectionsKt.listOfNotNull((Object[])objectArray);
                this.builder.magic((KtElement)parentExpression, (KtElement)parentExpression, arguments2, MagicKind.UNRESOLVED_CALL);
                return;
            }
            Intrinsics.checkNotNull((Object)parentExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtOperationExpression");
            if (((KtOperationExpression)parentExpression).getOperationReference().getReferencedNameElementType() == KtTokens.EQ) {
                this.mark((KtElement)lhs);
            }
            this.generateInstructions((KtElement)lhs.getArrayExpression());
            Map<PseudoValue, ReceiverValue> receiverValues = this.getReceiverValues(setResolvedCall);
            SmartFMap<PseudoValue, ValueParameterDescriptor> argumentValues = this.getArraySetterArguments(rhsDeferredValue, setResolvedCall);
            this.builder.call((KtElement)parentExpression, setResolvedCall, receiverValues, (Map)argumentValues);
        }

        /*
         * WARNING - void declaration
         */
        private final SmartFMap<PseudoValue, ValueParameterDescriptor> getArraySetterArguments(Function0<? extends PseudoValue> rhsDeferredValue, ResolvedCall<FunctionDescriptor> setResolvedCall) {
            void destination$iv;
            void $this$flatMapTo$iv;
            List<ValueParameterDescriptor> list2 = setResolvedCall.getResultingDescriptor().getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"setResolvedCall.resultin\u2026escriptor.valueParameters");
            Iterable iterable = list2;
            Collection collection = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                List<ValueArgument> list3;
                List<ValueArgument> list4;
                ValueParameterDescriptor descriptor2 = (ValueParameterDescriptor)element$iv;
                boolean bl = false;
                ResolvedValueArgument resolvedValueArgument = setResolvedCall.getValueArguments().get(descriptor2);
                List<ValueArgument> list5 = list4 = resolvedValueArgument != null ? resolvedValueArgument.getArguments() : null;
                if (list5 == null) {
                    list3 = CollectionsKt.emptyList();
                } else {
                    Intrinsics.checkNotNullExpressionValue(list5, (String)"setResolvedCall.valueArg\u2026.arguments ?: emptyList()");
                    list3 = list4;
                }
                Iterable list$iv = list3;
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            ArrayList valueArguments = (ArrayList)destination$iv;
            ValueArgument rhsArgument = (ValueArgument)CollectionsKt.lastOrNull((List)valueArguments);
            SmartFMap smartFMap = SmartFMap.emptyMap();
            Intrinsics.checkNotNullExpressionValue((Object)smartFMap, (String)"emptyMap<PseudoValue, ValueParameterDescriptor>()");
            SmartFMap argumentValues = smartFMap;
            for (ValueArgument valueArgument : valueArguments) {
                ArgumentMatch argumentMapping;
                ArgumentMapping bl = setResolvedCall.getArgumentMapping(valueArgument);
                if ((bl instanceof ArgumentMatch ? (ArgumentMatch)bl : null) == null) continue;
                argumentMapping = argumentMapping;
                ValueParameterDescriptor parameterDescriptor = argumentMapping.getValueParameter();
                if (valueArgument != rhsArgument) {
                    Intrinsics.checkNotNullExpressionValue((Object)valueArgument, (String)"valueArgument");
                    argumentValues = this.generateValueArgument(valueArgument, parameterDescriptor, (SmartFMap<PseudoValue, ValueParameterDescriptor>)argumentValues);
                    continue;
                }
                PseudoValue rhsValue = (PseudoValue)rhsDeferredValue.invoke();
                if (rhsValue == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)argumentValues.plus((Object)rhsValue, (Object)parameterDescriptor), (String)"argumentValues.plus(rhsValue, parameterDescriptor)");
            }
            return argumentValues;
        }

        private final void generateArrayAccess(KtArrayAccessExpression arrayAccessExpression, ResolvedCall<?> resolvedCall2) {
            if (this.builder.getBoundValue((KtElement)arrayAccessExpression) != null) {
                return;
            }
            this.mark((KtElement)arrayAccessExpression);
            if (!this.checkAndGenerateCall(resolvedCall2)) {
                this.generateArrayAccessWithoutCall(arrayAccessExpression);
            }
        }

        private final void generateArrayAccessWithoutCall(KtArrayAccessExpression arrayAccessExpression) {
            this.createNonSyntheticValue((KtElement)arrayAccessExpression, this.generateArrayAccessArguments(arrayAccessExpression), MagicKind.UNRESOLVED_CALL);
        }

        private final List<KtExpression> generateArrayAccessArguments(KtArrayAccessExpression arrayAccessExpression) {
            ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
            KtExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            if (arrayExpression != null) {
                inputExpressions.add(arrayExpression);
            }
            this.generateInstructions((KtElement)arrayExpression);
            for (KtExpression index2 : arrayAccessExpression.getIndexExpressions()) {
                this.generateInstructions((KtElement)index2);
                inputExpressions.add(index2);
            }
            return inputExpressions;
        }

        public void visitUnaryExpression(@NotNull KtUnaryExpression expression2) {
            PseudoValue rhsValue;
            PseudoValue pseudoValue;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtSimpleNameExpression ktSimpleNameExpression = expression2.getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"expression.operationReference");
            KtSimpleNameExpression operationSign = ktSimpleNameExpression;
            IElementType operationType = operationSign.getReferencedNameElementType();
            KtExpression ktExpression = expression2.getBaseExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression baseExpression = ktExpression;
            if (KtTokens.EXCLEXCL == operationType) {
                this.generateInstructions((KtElement)baseExpression);
                this.builder.predefinedOperation((KtExpression)expression2, ControlFlowBuilder.PredefinedOperation.NOT_NULL_ASSERTION, this.elementsToValues(CollectionsKt.listOf((Object)baseExpression)));
                return;
            }
            boolean incrementOrDecrement = this.isIncrementOrDecrement(operationType);
            KtElement ktElement = (KtElement)expression2;
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            if (resolvedCall2 != null) {
                pseudoValue = this.generateCall(resolvedCall2).getOutputValue();
            } else {
                this.generateInstructions((KtElement)baseExpression);
                KtElement[] ktElementArray = new KtElement[]{baseExpression};
                pseudoValue = rhsValue = this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, ktElementArray);
            }
            if (incrementOrDecrement && resolvedCall2 != null) {
                this.visitAssignment(baseExpression, this.getValueAsFunction(rhsValue), (KtExpression)expression2);
                if (expression2 instanceof KtPostfixExpression) {
                    this.copyValue((KtElement)baseExpression, (KtElement)expression2);
                }
            }
        }

        private final boolean isIncrementOrDecrement(IElementType operationType) {
            return operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS;
        }

        public void visitIfExpression(@NotNull KtIfExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark((KtElement)expression2);
            ArrayList<KtExpression> branches = new ArrayList<KtExpression>(2);
            KtExpression condition = expression2.getCondition();
            this.generateInstructions((KtElement)condition);
            Label elseLabel = this.builder.createUnboundLabel("else branch");
            this.builder.jumpOnFalse(elseLabel, (KtElement)expression2, this.builder.getBoundValue((KtElement)condition));
            KtExpression thenBranch = expression2.getThen();
            if (thenBranch != null) {
                branches.add(thenBranch);
                this.generateInstructions((KtElement)thenBranch);
            } else {
                this.builder.loadUnit((KtExpression)expression2);
            }
            Label resultLabel = this.builder.createUnboundLabel("'if' expression result");
            this.builder.jump(resultLabel, (KtElement)expression2);
            this.builder.bindLabel(elseLabel);
            KtExpression elseBranch = expression2.getElse();
            if (elseBranch != null) {
                branches.add(elseBranch);
                this.generateInstructions((KtElement)elseBranch);
            } else {
                this.builder.loadUnit((KtExpression)expression2);
            }
            this.builder.bindLabel(resultLabel);
            this.mergeValues((List<? extends KtExpression>)branches, (KtExpression)expression2);
        }

        public void visitTryExpression(@NotNull KtTryExpression expression2) {
            boolean hasFinally;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark((KtElement)expression2);
            KtFinallySection finallyBlock = expression2.getFinallyBlock();
            FinallyBlockGenerator finallyBlockGenerator = new FinallyBlockGenerator(finallyBlock);
            boolean bl = hasFinally = finallyBlock != null;
            if (hasFinally) {
                this.builder.enterTryFinally(new GenerationTrigger(finallyBlockGenerator){
                    private boolean working;
                    final /* synthetic */ FinallyBlockGenerator $finallyBlockGenerator;
                    {
                        this.$finallyBlockGenerator = $finallyBlockGenerator;
                    }

                    public void generate() {
                        if (this.working) {
                            return;
                        }
                        this.working = true;
                        this.$finallyBlockGenerator.generate();
                        this.working = false;
                    }
                });
            }
            Label onExceptionToFinallyBlock = this.generateTryAndCatches(expression2);
            if (hasFinally) {
                boolean bl2;
                boolean bl3 = bl2 = onExceptionToFinallyBlock != null;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl4 = false;
                    String string2 = "No finally label generated: " + expression2.getText();
                    throw new AssertionError((Object)string2);
                }
                this.builder.exitTryFinally();
                Label skipFinallyToErrorBlock = this.builder.createUnboundLabel("skipFinallyToErrorBlock");
                this.builder.jump(skipFinallyToErrorBlock, (KtElement)expression2);
                Label label = onExceptionToFinallyBlock;
                Intrinsics.checkNotNull((Object)label);
                this.builder.bindLabel(label);
                finallyBlockGenerator.generate();
                this.builder.jumpToError((KtElement)expression2);
                this.builder.bindLabel(skipFinallyToErrorBlock);
                finallyBlockGenerator.generate();
            }
            ArrayList<Object> branches = new ArrayList<Object>();
            branches.add(expression2.getTryBlock());
            for (KtCatchClause catchClause : expression2.getCatchClauses()) {
                KtExpression it;
                if (catchClause.getCatchBody() == null) continue;
                boolean bl5 = false;
                branches.add(it);
            }
            this.mergeValues((List<? extends KtExpression>)branches, (KtExpression)expression2);
        }

        private final Label generateTryAndCatches(KtTryExpression expression2) {
            List list2 = expression2.getCatchClauses();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"expression.catchClauses");
            List catchClauses = list2;
            boolean hasCatches = !((Collection)catchClauses).isEmpty();
            Label onException = null;
            if (hasCatches) {
                onException = this.builder.createUnboundLabel("onException");
                this.builder.nondeterministicJump(onException, (KtElement)expression2, null);
            }
            Label onExceptionToFinallyBlock = null;
            if (expression2.getFinallyBlock() != null) {
                onExceptionToFinallyBlock = this.builder.createUnboundLabel("onExceptionToFinallyBlock");
                this.builder.nondeterministicJump(onExceptionToFinallyBlock, (KtElement)expression2, null);
            }
            KtBlockExpression ktBlockExpression = expression2.getTryBlock();
            Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression, (String)"expression.tryBlock");
            KtBlockExpression tryBlock = ktBlockExpression;
            this.catchFinallyStack.push(new CatchFinallyLabels(onException, onExceptionToFinallyBlock, expression2));
            this.generateInstructions((KtElement)tryBlock);
            this.generateJumpsToCatchAndFinally();
            this.catchFinallyStack.pop();
            if (hasCatches && onException != null) {
                Label afterCatches = this.builder.createUnboundLabel("afterCatches");
                this.builder.jump(afterCatches, (KtElement)expression2);
                this.builder.bindLabel(onException);
                LinkedList<Label> catchLabels = new LinkedList<Label>();
                int catchClausesSize = catchClauses.size();
                int n = catchClausesSize - 1;
                for (int i = 0; i < n; ++i) {
                    catchLabels.add(this.builder.createUnboundLabel("catch " + i));
                }
                if (!catchLabels.isEmpty()) {
                    this.builder.nondeterministicJump((List<? extends Label>)catchLabels, (KtElement)expression2);
                }
                boolean isFirst = true;
                for (KtCatchClause catchClause : catchClauses) {
                    Intrinsics.checkNotNullExpressionValue((Object)catchClause, (String)"catchClause");
                    this.builder.enterBlockScope((KtElement)catchClause);
                    if (!isFirst) {
                        Object e = catchLabels.remove();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"catchLabels.remove()");
                        this.builder.bindLabel((Label)e);
                    } else {
                        isFirst = false;
                    }
                    KtParameter catchParameter = catchClause.getCatchParameter();
                    if (catchParameter != null) {
                        this.builder.declareParameter(catchParameter);
                        this.generateInitializer((KtDeclaration)catchParameter, this.createSyntheticValue((KtElement)catchParameter, MagicKind.FAKE_INITIALIZER, new KtElement[0]));
                    }
                    this.generateInstructions((KtElement)catchClause.getCatchBody());
                    this.builder.jump(afterCatches, (KtElement)expression2);
                    this.builder.exitBlockScope((KtElement)catchClause);
                }
                this.builder.bindLabel(afterCatches);
            }
            return onExceptionToFinallyBlock;
        }

        public void visitWhileExpression(@NotNull KtWhileExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            LoopInfo loopInfo = this.builder.enterLoop((KtLoopExpression)expression2);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            KtExpression condition = expression2.getCondition();
            this.generateInstructions((KtElement)condition);
            this.mark((KtElement)expression2);
            if (!CompileTimeConstantUtils.canBeReducedToBooleanConstant(condition, ControlFlowProcessor.this.trace.getBindingContext(), true)) {
                this.builder.jumpOnFalse(loopInfo.getExitPoint(), (KtElement)expression2, this.builder.getBoundValue((KtElement)condition));
            } else {
                boolean bl;
                boolean bl2 = bl = condition != null;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "Invalid while condition: " + expression2.getText();
                    throw new AssertionError((Object)string2);
                }
                KtExpression ktExpression = condition;
                Intrinsics.checkNotNull((Object)ktExpression);
                KtElement[] ktElementArray = new KtElement[]{condition};
                this.createSyntheticValue((KtElement)ktExpression, MagicKind.VALUE_CONSUMER, ktElementArray);
            }
            this.builder.enterLoopBody((KtLoopExpression)expression2);
            this.generateInstructions((KtElement)expression2.getBody());
            this.builder.jump(loopInfo.getEntryPoint(), (KtElement)expression2);
            this.builder.exitLoopBody((KtLoopExpression)expression2);
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit((KtExpression)expression2);
        }

        public void visitDoWhileExpression(@NotNull KtDoWhileExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.builder.enterBlockScope((KtElement)expression2);
            this.mark((KtElement)expression2);
            LoopInfo loopInfo = this.builder.enterLoop((KtLoopExpression)expression2);
            this.builder.enterLoopBody((KtLoopExpression)expression2);
            this.generateInstructions((KtElement)expression2.getBody());
            this.builder.exitLoopBody((KtLoopExpression)expression2);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            KtExpression condition = expression2.getCondition();
            this.generateInstructions((KtElement)condition);
            this.builder.exitBlockScope((KtElement)expression2);
            if (!CompileTimeConstantUtils.canBeReducedToBooleanConstant(condition, ControlFlowProcessor.this.trace.getBindingContext(), true)) {
                this.builder.jumpOnTrue(loopInfo.getEntryPoint(), (KtElement)expression2, this.builder.getBoundValue((KtElement)expression2.getCondition()));
            } else {
                boolean bl;
                boolean bl2 = bl = condition != null;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "Invalid do / while condition: " + expression2.getText();
                    throw new AssertionError((Object)string2);
                }
                KtExpression ktExpression = condition;
                Intrinsics.checkNotNull((Object)ktExpression);
                KtElement[] ktElementArray = new KtElement[]{condition};
                this.createSyntheticValue((KtElement)ktExpression, MagicKind.VALUE_CONSUMER, ktElementArray);
                this.builder.jump(loopInfo.getEntryPoint(), (KtElement)expression2);
            }
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit((KtExpression)expression2);
        }

        public void visitForExpression(@NotNull KtForExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.builder.enterBlockScope((KtElement)expression2);
            KtExpression loopRange = expression2.getLoopRange();
            this.generateInstructions((KtElement)loopRange);
            WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL;
            Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"LOOP_RANGE_ITERATOR_RESOLVED_CALL");
            this.generateLoopConventionCall(loopRange, (ReadOnlySlice<KtExpression, ResolvedCall<FunctionDescriptor>>)writableSlice);
            this.declareLoopParameter(expression2);
            LoopInfo loopInfo = this.builder.enterLoop((KtLoopExpression)expression2);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice2 = BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL;
            Intrinsics.checkNotNullExpressionValue(writableSlice2, (String)"LOOP_RANGE_HAS_NEXT_RESOLVED_CALL");
            this.generateLoopConventionCall(loopRange, (ReadOnlySlice<KtExpression, ResolvedCall<FunctionDescriptor>>)writableSlice2);
            this.builder.nondeterministicJump(loopInfo.getExitPoint(), (KtElement)expression2, null);
            WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice3 = BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL;
            Intrinsics.checkNotNullExpressionValue(writableSlice3, (String)"LOOP_RANGE_NEXT_RESOLVED_CALL");
            this.generateLoopConventionCall(loopRange, (ReadOnlySlice<KtExpression, ResolvedCall<FunctionDescriptor>>)writableSlice3);
            this.writeLoopParameterAssignment(expression2);
            this.mark((KtElement)expression2);
            this.builder.enterLoopBody((KtLoopExpression)expression2);
            this.generateInstructions((KtElement)expression2.getBody());
            this.builder.jump(loopInfo.getEntryPoint(), (KtElement)expression2);
            this.builder.exitLoopBody((KtLoopExpression)expression2);
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit((KtExpression)expression2);
            this.builder.exitBlockScope((KtElement)expression2);
        }

        private final void generateLoopConventionCall(KtExpression loopRange, ReadOnlySlice<KtExpression, ResolvedCall<FunctionDescriptor>> callSlice) {
            if (loopRange == null) {
                return;
            }
            ResolvedCall<FunctionDescriptor> resolvedCall2 = ControlFlowProcessor.this.trace.getBindingContext().get(callSlice, loopRange);
            if (resolvedCall2 == null) {
                return;
            }
            ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
            this.generateCall(resolvedCall3);
        }

        private final void declareLoopParameter(KtForExpression expression2) {
            KtParameter loopParameter = expression2.getLoopParameter();
            if (loopParameter != null) {
                KtDestructuringDeclaration destructuringDeclaration = loopParameter.getDestructuringDeclaration();
                if (destructuringDeclaration != null) {
                    this.visitDestructuringDeclaration(destructuringDeclaration, false);
                } else {
                    this.builder.declareParameter(loopParameter);
                }
            }
        }

        private final void writeLoopParameterAssignment(KtForExpression expression2) {
            KtParameter loopParameter = expression2.getLoopParameter();
            KtExpression loopRange = expression2.getLoopRange();
            KtExpression ktExpression = loopRange;
            if (ktExpression == null) {
                ktExpression = (KtExpression)expression2;
            }
            KtElement ktElement = (KtElement)ktExpression;
            List list2 = ContainerUtil.createMaybeSingletonList((Object)this.builder.getBoundValue((KtElement)loopRange));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createMaybeSingletonList\u2026getBoundValue(loopRange))");
            PseudoValue value2 = this.builder.magic(ktElement, null, list2, MagicKind.LOOP_RANGE_ITERATION).getOutputValue();
            if (loopParameter != null) {
                KtDestructuringDeclaration destructuringDeclaration = loopParameter.getDestructuringDeclaration();
                if (destructuringDeclaration != null) {
                    for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                        Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
                        this.generateInitializer((KtDeclaration)entry, value2);
                    }
                } else {
                    this.generateInitializer((KtDeclaration)loopParameter, value2);
                }
            }
        }

        public void visitBreakExpression(@NotNull KtBreakExpression expression2) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                KtLoopExpression loop = this.getCorrespondingLoop((KtExpressionWithLabel)expression2);
                if (loop == null) break block3;
                if (this.jumpCrossesTryCatchBoundary((KtExpressionWithLabel)expression2, (PsiElement)loop)) {
                    this.generateJumpsToCatchAndFinally();
                }
                if (this.jumpDoesNotCrossFunctionBoundary((KtExpressionWithLabel)expression2, loop)) {
                    Label label = this.builder.getLoopExitPoint(loop);
                    if (label != null) {
                        Label it = label;
                        boolean bl = false;
                        this.builder.jump(it, (KtElement)expression2);
                    }
                }
            }
        }

        public void visitContinueExpression(@NotNull KtContinueExpression expression2) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                KtLoopExpression loop = this.getCorrespondingLoop((KtExpressionWithLabel)expression2);
                if (loop == null) break block3;
                if (this.jumpCrossesTryCatchBoundary((KtExpressionWithLabel)expression2, (PsiElement)loop)) {
                    this.generateJumpsToCatchAndFinally();
                }
                if (this.jumpDoesNotCrossFunctionBoundary((KtExpressionWithLabel)expression2, loop)) {
                    Label label = this.builder.getLoopConditionEntryPoint(loop);
                    if (label != null) {
                        Label it = label;
                        boolean bl = false;
                        this.builder.jump(it, (KtElement)expression2);
                    }
                }
            }
        }

        private final KtLoopExpression getNearestLoopExpression(KtExpression expression2) {
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)expression2;
            boolean $i$f$getStrictParentOfType = false;
            return (KtLoopExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtLoopExpression.class, (boolean)true);
        }

        private final KtLoopExpression getCorrespondingLoopWithoutLabel(KtExpression expression2) {
            KtLoopExpression ktLoopExpression = this.getNearestLoopExpression(expression2);
            if (ktLoopExpression == null) {
                return null;
            }
            KtLoopExpression parentLoop = ktLoopExpression;
            KtExpression parentBody = parentLoop.getBody();
            return parentBody != null && parentBody.getTextRange().contains(expression2.getTextRange()) ? parentLoop : this.getNearestLoopExpression((KtExpression)parentLoop);
        }

        private final KtLoopExpression getCorrespondingLoop(KtExpressionWithLabel expression2) {
            KtLoopExpression ktLoopExpression;
            KtLoopExpression ktLoopExpression2;
            String labelName = expression2.getLabelName();
            KtLoopExpression loop = null;
            if (labelName != null) {
                KtLoopExpression ktLoopExpression3;
                KtSimpleNameExpression ktSimpleNameExpression = expression2.getTargetLabel();
                Intrinsics.checkNotNull((Object)ktSimpleNameExpression);
                KtSimpleNameExpression targetLabel = ktSimpleNameExpression;
                PsiElement labeledElement = (PsiElement)ControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, targetLabel);
                if (labeledElement instanceof KtLoopExpression) {
                    ktLoopExpression3 = (KtLoopExpression)labeledElement;
                } else {
                    ControlFlowProcessor.this.trace.report(Errors.NOT_A_LOOP_LABEL.on((KtExpressionWithLabel)((PsiElement)expression2), targetLabel.getText()));
                    ktLoopExpression3 = null;
                }
                loop = ktLoopExpression3;
            } else {
                KtWhenExpression whenExpression;
                loop = this.getCorrespondingLoopWithoutLabel((KtExpression)expression2);
                if (loop == null) {
                    ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on((KtExpressionWithLabel)((PsiElement)expression2)));
                } else if (!ControlFlowProcessor.this.languageVersionSettings.supportsFeature(LanguageFeature.AllowBreakAndContinueInsideWhen) && (whenExpression = (KtWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression2), KtWhenExpression.class, (boolean)true, (Class[])(ktLoopExpression2 = new KtLoopExpression[]{KtLoopExpression.class}))) != null) {
                    ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_IN_WHEN.on((KtExpressionWithLabel)((PsiElement)expression2)));
                }
            }
            if ((ktLoopExpression = loop) != null && (ktLoopExpression = ktLoopExpression.getBody()) != null) {
                ktLoopExpression2 = ktLoopExpression;
                ControlFlowProcessor controlFlowProcessor = ControlFlowProcessor.this;
                KtLoopExpression it = ktLoopExpression2;
                boolean bl = false;
                if (!it.getTextRange().contains(expression2.getTextRange())) {
                    controlFlowProcessor.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on((KtExpressionWithLabel)((PsiElement)expression2)));
                    return null;
                }
            }
            return loop;
        }

        private final boolean returnCrossesTryCatchBoundary(KtReturnExpression returnExpression) {
            KtSimpleNameExpression ktSimpleNameExpression = returnExpression.getTargetLabel();
            if (ktSimpleNameExpression == null) {
                return true;
            }
            KtSimpleNameExpression targetLabel = ktSimpleNameExpression;
            PsiElement psiElement = (PsiElement)ControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, targetLabel);
            if (psiElement == null) {
                return true;
            }
            PsiElement labeledElement = psiElement;
            return this.jumpCrossesTryCatchBoundary((KtExpressionWithLabel)returnExpression, labeledElement);
        }

        private final boolean jumpCrossesTryCatchBoundary(KtExpressionWithLabel jumpExpression, PsiElement jumpTarget) {
            PsiElement current = jumpExpression.getParent();
            PsiElement psiElement;
            while (!Intrinsics.areEqual((Object)(psiElement = current), (Object)jumpTarget)) {
                if (psiElement instanceof KtTryExpression) {
                    return true;
                }
                current = current.getParent();
            }
            return false;
        }

        private final boolean jumpDoesNotCrossFunctionBoundary(KtExpressionWithLabel jumpExpression, KtLoopExpression jumpTarget) {
            boolean bl;
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            BindingContext bindingContext2 = bindingContext;
            boolean skipInlineFunctions = ControlFlowProcessor.this.languageVersionSettings.supportsFeature(LanguageFeature.BreakContinueInInlineLambdas);
            FunctionDescriptor labelExprEnclosingFunc = BindingContextUtilsKt.getEnclosingFunctionDescriptor(bindingContext2, (KtElement)jumpExpression, skipInlineFunctions);
            FunctionDescriptor labelTargetEnclosingFunc = BindingContextUtilsKt.getEnclosingFunctionDescriptor(bindingContext2, (KtElement)jumpTarget, skipInlineFunctions);
            if (labelExprEnclosingFunc != labelTargetEnclosingFunc) {
                if (this.builder.getLoopExitPoint(jumpTarget) != null || labelExprEnclosingFunc instanceof ConstructorDescriptor && !((ConstructorDescriptor)labelExprEnclosingFunc).isPrimary()) {
                    boolean dependsOnInlineLambdas;
                    boolean bl2 = dependsOnInlineLambdas = !skipInlineFunctions && Intrinsics.areEqual((Object)BindingContextUtilsKt.getEnclosingFunctionDescriptor(bindingContext2, (KtElement)jumpExpression, true), (Object)BindingContextUtilsKt.getEnclosingFunctionDescriptor(bindingContext2, (KtElement)jumpTarget, true));
                    if (dependsOnInlineLambdas) {
                        ControlFlowProcessor.this.trace.report(Errors.UNSUPPORTED_FEATURE.on((PsiElement)jumpExpression, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)LanguageFeature.BreakContinueInInlineLambdas, (Object)ControlFlowProcessor.this.languageVersionSettings)));
                    } else {
                        ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_JUMPS_ACROSS_FUNCTION_BOUNDARY.on((KtExpressionWithLabel)((PsiElement)jumpExpression)));
                    }
                }
                bl = false;
            } else {
                bl = true;
            }
            return bl;
        }

        public void visitReturnExpression(@NotNull KtReturnExpression expression2) {
            KtElement ktElement;
            KtExpression returnedExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (this.returnCrossesTryCatchBoundary(expression2)) {
                this.generateJumpsToCatchAndFinally();
            }
            if ((returnedExpression = expression2.getReturnedExpression()) != null) {
                this.generateInstructions((KtElement)returnedExpression);
            }
            KtSimpleNameExpression labelElement = expression2.getTargetLabel();
            KtElement subroutine = null;
            String labelName = expression2.getLabelName();
            if (labelElement != null && labelName != null) {
                PsiElement psiElement = (PsiElement)ControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, labelElement);
                if (psiElement != null) {
                    PsiElement labeledElement = psiElement;
                    boolean bl = false;
                    KtElement labeledKtElement = (KtElement)labeledElement;
                    this.checkReturnLabelTarget(expression2, labeledKtElement);
                    ktElement = labeledKtElement;
                } else {
                    ktElement = null;
                }
            } else {
                ktElement = subroutine = this.builder.getReturnSubroutine();
            }
            if (subroutine instanceof KtFunction || subroutine instanceof KtPropertyAccessor) {
                PseudoValue returnValue;
                PseudoValue pseudoValue = returnValue = returnedExpression != null ? this.builder.getBoundValue((KtElement)returnedExpression) : null;
                if (returnValue == null) {
                    this.builder.returnNoValue(expression2, subroutine);
                } else {
                    this.builder.returnValue((KtExpression)expression2, returnValue, subroutine);
                }
            } else {
                KtElement[] ktElementArray = new KtElement[]{returnedExpression};
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, ktElementArray);
            }
        }

        private final void checkReturnLabelTarget(KtReturnExpression returnExpression, KtElement labeledElement) {
            if (!(labeledElement instanceof KtFunctionLiteral) && !(labeledElement instanceof KtNamedFunction)) {
                if (ControlFlowProcessor.this.languageVersionSettings.supportsFeature(LanguageFeature.RestrictReturnStatementTarget)) {
                    ControlFlowProcessor.this.trace.report(Errors.NOT_A_FUNCTION_LABEL.on((KtExpressionWithLabel)((PsiElement)returnExpression)));
                } else {
                    ControlFlowProcessor.this.trace.report(Errors.NOT_A_FUNCTION_LABEL_WARNING.on((KtExpressionWithLabel)((PsiElement)returnExpression)));
                }
            }
        }

        public void visitParameter(@NotNull KtParameter parameter) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                this.builder.declareParameter(parameter);
                KtExpression defaultValue = parameter.getDefaultValue();
                if (defaultValue != null) {
                    StringBuilder stringBuilder2 = new StringBuilder().append("after default value for parameter ");
                    String string2 = parameter.getName();
                    if (string2 == null) {
                        string2 = "<anonymous>";
                    }
                    Label skipDefaultValue = this.builder.createUnboundLabel(stringBuilder2.append(string2).toString());
                    this.builder.nondeterministicJump(skipDefaultValue, (KtElement)defaultValue, null);
                    this.generateInstructions((KtElement)defaultValue);
                    this.builder.bindLabel(skipDefaultValue);
                }
                this.generateInitializer((KtDeclaration)parameter, this.computePseudoValueForParameter(parameter));
                KtDestructuringDeclaration ktDestructuringDeclaration = parameter.getDestructuringDeclaration();
                if (ktDestructuringDeclaration == null) break block2;
                KtDestructuringDeclaration it = ktDestructuringDeclaration;
                boolean bl = false;
                this.visitDestructuringDeclaration(it, true);
            }
        }

        private final PseudoValue computePseudoValueForParameter(KtParameter parameter) {
            PseudoValue syntheticValue = this.createSyntheticValue((KtElement)parameter, MagicKind.FAKE_INITIALIZER, new KtElement[0]);
            PseudoValue pseudoValue = this.builder.getBoundValue((KtElement)parameter.getDefaultValue());
            if (pseudoValue == null) {
                return syntheticValue;
            }
            PseudoValue defaultValue = pseudoValue;
            Object[] objectArray = new PseudoValue[]{defaultValue, syntheticValue};
            return this.builder.merge((KtExpression)parameter, CollectionsKt.arrayListOf((Object[])objectArray)).getOutputValue();
        }

        public void visitBlockExpression(@NotNull KtBlockExpression expression2) {
            boolean declareBlockScope;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            boolean bl = declareBlockScope = !this.isBlockInDoWhile(expression2);
            if (declareBlockScope) {
                this.builder.enterBlockScope((KtElement)expression2);
            }
            this.mark((KtElement)expression2);
            List list2 = expression2.getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"expression.statements");
            List statements = list2;
            for (KtExpression statement2 : statements) {
                Label afterClassLabel;
                Label label;
                if ((statement2 instanceof KtClassOrObject ? (KtClassOrObject)statement2 : null) != null) {
                    KtClassOrObject it;
                    it = it;
                    boolean bl2 = false;
                    label = this.builder.createUnboundLabel("after local class");
                } else {
                    label = afterClassLabel = null;
                }
                if (afterClassLabel != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)statement2, (String)"statement");
                    this.builder.nondeterministicJump(afterClassLabel, (KtElement)statement2, null);
                }
                this.generateInstructions((KtElement)statement2);
                if (afterClassLabel == null) continue;
                this.builder.bindLabel(afterClassLabel);
            }
            if (statements.isEmpty()) {
                this.builder.loadUnit((KtExpression)expression2);
            } else {
                this.copyValue((KtElement)CollectionsKt.lastOrNull((List)statements), (KtElement)expression2);
            }
            if (declareBlockScope) {
                this.builder.exitBlockScope((KtElement)expression2);
            }
        }

        private final boolean isBlockInDoWhile(KtBlockExpression expression2) {
            PsiElement parent2 = expression2.getParent();
            return parent2.getParent() instanceof KtDoWhileExpression;
        }

        private final void visitFunction(KtFunction function2, EventOccurrencesRange eventOccurrencesRange) {
            boolean isAnonymousFunction;
            if (eventOccurrencesRange == null) {
                ControlFlowProcessor.this.processLocalDeclaration((KtDeclaration)function2);
            } else {
                this.visitInlinedFunction(function2, eventOccurrencesRange);
            }
            boolean bl = isAnonymousFunction = function2 instanceof KtFunctionLiteral || function2.getName() == null;
            if (isAnonymousFunction || function2.isLocal() && !(function2.getParent() instanceof KtBlockExpression)) {
                this.builder.createLambda(function2);
            }
        }

        static /* synthetic */ void visitFunction$default(CFPVisitor cFPVisitor, KtFunction ktFunction, EventOccurrencesRange eventOccurrencesRange, int n, Object object) {
            if ((n & 2) != 0) {
                eventOccurrencesRange = null;
            }
            cFPVisitor.visitFunction(ktFunction, eventOccurrencesRange);
        }

        private final void visitInlinedFunction(KtFunction lambdaFunctionLiteral, EventOccurrencesRange eventOccurrencesRange) {
            this.deferredGeneratorsStack.peek().add(new Function1<ControlFlowBuilder, Unit>(eventOccurrencesRange, lambdaFunctionLiteral, ControlFlowProcessor.this){
                final /* synthetic */ EventOccurrencesRange $eventOccurrencesRange;
                final /* synthetic */ KtFunction $lambdaFunctionLiteral;
                final /* synthetic */ ControlFlowProcessor this$0;
                {
                    this.$eventOccurrencesRange = $eventOccurrencesRange;
                    this.$lambdaFunctionLiteral = $lambdaFunctionLiteral;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ControlFlowBuilder builder2) {
                    Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                    Label beforeDeclaration = builder2.createUnboundLabel("before inlined declaration");
                    Label afterDeclaration = builder2.createUnboundLabel("after inlined declaration");
                    builder2.bindLabel(beforeDeclaration);
                    if (!EventOccurrencesRangeKt.isDefinitelyVisited((EventOccurrencesRange)this.$eventOccurrencesRange)) {
                        builder2.nondeterministicJump(afterDeclaration, (KtElement)this.$lambdaFunctionLiteral, null);
                    }
                    ControlFlowProcessor.access$generate(this.this$0, (KtElement)this.$lambdaFunctionLiteral, this.$eventOccurrencesRange);
                    if (EventOccurrencesRangeKt.canBeRevisited((EventOccurrencesRange)this.$eventOccurrencesRange)) {
                        builder2.nondeterministicJump(beforeDeclaration, (KtElement)this.$lambdaFunctionLiteral, null);
                    }
                    builder2.bindLabel(afterDeclaration);
                }
            });
        }

        public void visitNamedFunction(@NotNull KtNamedFunction function2) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            CFPVisitor.visitFunction$default(this, (KtFunction)function2, null, 2, null);
        }

        public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
            Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
            this.mark((KtElement)lambdaExpression);
            KtFunctionLiteral ktFunctionLiteral = lambdaExpression.getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"lambdaExpression.functionLiteral");
            KtFunctionLiteral functionLiteral = ktFunctionLiteral;
            this.visitFunction((KtFunction)functionLiteral, (EventOccurrencesRange)ControlFlowProcessor.this.trace.get(BindingContext.LAMBDA_INVOCATIONS, lambdaExpression));
            this.copyValue((KtElement)functionLiteral, (KtElement)lambdaExpression);
        }

        public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark((KtElement)expression2);
            KtExpression selectorExpression = expression2.getSelectorExpression();
            KtExpression receiverExpression = expression2.getReceiverExpression();
            boolean safe = expression2 instanceof KtSafeQualifiedExpression;
            if (selectorExpression instanceof KtCallExpression || selectorExpression instanceof KtSimpleNameExpression) {
                if (!safe) {
                    this.generateInstructions((KtElement)selectorExpression);
                } else {
                    Label resultLabel = this.builder.createUnboundLabel("result of call");
                    this.builder.jumpOnFalse(resultLabel, (KtElement)expression2, null);
                    this.generateInstructions((KtElement)selectorExpression);
                    this.builder.bindLabel(resultLabel);
                }
                this.copyValue((KtElement)selectorExpression, (KtElement)expression2);
            } else {
                this.generateInstructions((KtElement)receiverExpression);
                KtElement[] ktElementArray = new KtElement[]{receiverExpression};
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, ktElementArray);
            }
        }

        public void visitCallExpression(@NotNull KtCallExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (!this.generateCall((KtElement)expression2)) {
                ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
                for (KtValueArgument argument2 : expression2.getValueArguments()) {
                    KtExpression argumentExpression = argument2.getArgumentExpression();
                    if (argumentExpression == null) continue;
                    this.generateInstructions((KtElement)argumentExpression);
                    inputExpressions.add(argumentExpression);
                }
                KtExpression calleeExpression = expression2.getCalleeExpression();
                this.generateInstructions((KtElement)calleeExpression);
                if (calleeExpression != null) {
                    inputExpressions.add(calleeExpression);
                    KtExpression ktExpression = this.generateAndGetReceiverIfAny((KtExpression)expression2);
                    if (ktExpression != null) {
                        KtExpression it = ktExpression;
                        boolean bl = false;
                        inputExpressions.add(it);
                    }
                }
                this.mark((KtElement)expression2);
                this.createNonSyntheticValue((KtElement)expression2, (List<? extends KtElement>)inputExpressions, MagicKind.UNRESOLVED_CALL);
            }
        }

        private final KtExpression generateAndGetReceiverIfAny(KtExpression expression2) {
            PsiElement psiElement = expression2.getParent();
            KtQualifiedExpression ktQualifiedExpression = psiElement instanceof KtQualifiedExpression ? (KtQualifiedExpression)psiElement : null;
            if (ktQualifiedExpression == null) {
                return null;
            }
            KtQualifiedExpression parent2 = ktQualifiedExpression;
            if (parent2.getSelectorExpression() != expression2) {
                return null;
            }
            KtExpression receiverExpression = parent2.getReceiverExpression();
            this.generateInstructions((KtElement)receiverExpression);
            return receiverExpression;
        }

        public void visitProperty(@NotNull KtProperty property) {
            KtExpression delegate;
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            this.builder.declareVariable((KtVariableDeclaration)property);
            KtExpression initializer = property.getInitializer();
            if (initializer != null) {
                this.visitAssignment((KtExpression)property, this.getDeferredValue(initializer), (KtExpression)property);
            }
            if ((delegate = property.getDelegateExpression()) != null) {
                this.visitAssignment((KtExpression)property, this.getDeferredValue(null), (KtExpression)property);
                this.generateInstructions((KtElement)delegate);
                if (property.isLocal()) {
                    this.generateInitializer((KtDeclaration)property, this.createSyntheticValue((KtElement)property, MagicKind.FAKE_INITIALIZER, new KtElement[0]));
                }
                if (this.builder.getBoundValue((KtElement)delegate) != null) {
                    KtElement[] ktElementArray = new KtElement[]{delegate};
                    this.createSyntheticValue((KtElement)property, MagicKind.VALUE_CONSUMER, ktElementArray);
                }
            }
            if (KtPsiUtil.isLocal((KtDeclaration)((KtDeclaration)property))) {
                for (KtPropertyAccessor accessor : property.getAccessors()) {
                    this.generateInstructions((KtElement)accessor);
                }
            }
        }

        public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            this.visitDestructuringDeclaration(declaration, true);
        }

        private final void visitDestructuringDeclaration(KtDestructuringDeclaration declaration, boolean generateWriteForEntries) {
            KtExpression initializer = declaration.getInitializer();
            this.generateInstructions((KtElement)initializer);
            for (KtDestructuringDeclarationEntry entry : declaration.getEntries()) {
                PseudoValue writtenValue;
                PseudoValue pseudoValue;
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
                this.builder.declareVariable((KtVariableDeclaration)entry);
                ResolvedCall resolvedCall2 = (ResolvedCall)ControlFlowProcessor.this.trace.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                if (resolvedCall2 != null) {
                    pseudoValue = this.builder.call((KtElement)entry, resolvedCall2, this.getReceiverValues(resolvedCall2), MapsKt.emptyMap()).getOutputValue();
                } else if (initializer != null) {
                    KtExpression it;
                    boolean bl = false;
                    KtElement[] ktElementArray = new KtElement[]{it};
                    pseudoValue = this.createSyntheticValue((KtElement)entry, MagicKind.UNRESOLVED_CALL, ktElementArray);
                } else {
                    pseudoValue = writtenValue = null;
                }
                if (!generateWriteForEntries) continue;
                KtDeclaration ktDeclaration = (KtDeclaration)entry;
                PseudoValue pseudoValue2 = writtenValue;
                if (pseudoValue2 == null) {
                    pseudoValue2 = this.createSyntheticValue((KtElement)entry, MagicKind.FAKE_INITIALIZER, new KtElement[0]);
                }
                this.generateInitializer(ktDeclaration, pseudoValue2);
            }
        }

        public void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor) {
            Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
            ControlFlowProcessor.this.processLocalDeclaration((KtDeclaration)accessor);
        }

        public void visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark((KtElement)expression2);
            IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
            KtExpression ktExpression = expression2.getLeft();
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"expression.left");
            KtExpression left = ktExpression;
            if (operationType == KtTokens.AS_KEYWORD || operationType == KtTokens.AS_SAFE) {
                this.generateInstructions((KtElement)left);
                if (this.getBoundOrUnreachableValue((KtElement)left) != null) {
                    KtElement[] ktElementArray = new KtElement[]{left};
                    this.createNonSyntheticValue((KtElement)expression2, MagicKind.CAST, ktElementArray);
                }
            } else {
                this.visitKtElement((KtElement)expression2);
                KtElement[] ktElementArray = new KtElement[]{left};
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, ktElementArray);
            }
        }

        private final void generateJumpsToCatchAndFinally() {
            block3: {
                if (!(!((Collection)this.catchFinallyStack).isEmpty())) break block3;
                CatchFinallyLabels $this$generateJumpsToCatchAndFinally_u24lambda_u2419 = this.catchFinallyStack.peek();
                boolean bl = false;
                if ($this$generateJumpsToCatchAndFinally_u24lambda_u2419.getTryExpression() != null) {
                    Label it;
                    Label label = $this$generateJumpsToCatchAndFinally_u24lambda_u2419.getOnException();
                    if (label != null) {
                        it = label;
                        boolean bl2 = false;
                        this.builder.nondeterministicJump(it, (KtElement)$this$generateJumpsToCatchAndFinally_u24lambda_u2419.getTryExpression(), null);
                    }
                    Label label2 = $this$generateJumpsToCatchAndFinally_u24lambda_u2419.getToFinally();
                    if (label2 != null) {
                        it = label2;
                        boolean bl3 = false;
                        this.builder.nondeterministicJump(it, (KtElement)$this$generateJumpsToCatchAndFinally_u24lambda_u2419.getTryExpression(), null);
                    }
                }
            }
        }

        public void visitThrowExpression(@NotNull KtThrowExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark((KtElement)expression2);
            this.generateJumpsToCatchAndFinally();
            KtExpression ktExpression = expression2.getThrownExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression thrownExpression = ktExpression;
            this.generateInstructions((KtElement)thrownExpression);
            PseudoValue pseudoValue = this.builder.getBoundValue((KtElement)thrownExpression);
            if (pseudoValue == null) {
                return;
            }
            PseudoValue thrownValue = pseudoValue;
            this.builder.throwException(expression2, thrownValue);
        }

        public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.generateArrayAccess(expression2, (ResolvedCall)ControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_GET, expression2));
        }

        public void visitIsExpression(@NotNull KtIsExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark((KtElement)expression2);
            KtExpression ktExpression = expression2.getLeftHandSide();
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"expression.leftHandSide");
            KtExpression left = ktExpression;
            this.generateInstructions((KtElement)left);
            KtElement[] ktElementArray = new KtElement[]{left};
            this.createNonSyntheticValue((KtElement)expression2, MagicKind.IS, ktElementArray);
        }

        public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark((KtElement)expression2);
            KtExpression subjectExpression = expression2.getSubjectExpression();
            if (subjectExpression != null) {
                this.generateInstructions((KtElement)subjectExpression);
            }
            ArrayList<KtExpression> branches = new ArrayList<KtExpression>();
            Label doneLabel = this.builder.createUnboundLabel("after 'when' expression");
            Label nextLabel = null;
            Iterator iterator2 = expression2.getEntries().iterator();
            while (iterator2.hasNext()) {
                Object[] conditions2;
                KtWhenEntry whenEntry = (KtWhenEntry)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)whenEntry, (String)"whenEntry");
                this.mark((KtElement)whenEntry);
                boolean isElse = whenEntry.isElse();
                if (isElse && iterator2.hasNext()) {
                    ControlFlowProcessor.this.trace.report(Errors.ELSE_MISPLACED_IN_WHEN.on((KtWhenEntry)((PsiElement)whenEntry)));
                }
                Label bodyLabel = this.builder.createUnboundLabel("'when' entry body");
                Intrinsics.checkNotNullExpressionValue((Object)whenEntry.getConditions(), (String)"whenEntry.conditions");
                int n = conditions2.length;
                for (int i = 0; i < n; ++i) {
                    KtWhenCondition condition = conditions2[i];
                    condition.accept((PsiElementVisitor)this.conditionVisitor);
                    if (i + 1 >= conditions2.length) continue;
                    this.builder.nondeterministicJump(bodyLabel, (KtElement)expression2, this.builder.getBoundValue((KtElement)condition));
                }
                if (!isElse) {
                    nextLabel = this.builder.createUnboundLabel("next 'when' entry");
                    KtWhenCondition lastCondition = (KtWhenCondition)ArraysKt.lastOrNull((Object[])conditions2);
                    this.builder.nondeterministicJump(nextLabel, (KtElement)expression2, this.builder.getBoundValue((KtElement)lastCondition));
                }
                this.builder.bindLabel(bodyLabel);
                KtExpression whenEntryExpression = whenEntry.getExpression();
                if (whenEntryExpression != null) {
                    this.generateInstructions((KtElement)whenEntryExpression);
                    branches.add(whenEntryExpression);
                }
                this.builder.jump(doneLabel, (KtElement)expression2);
                if (isElse || nextLabel == null) continue;
                this.builder.bindLabel(nextLabel);
                if (iterator2.hasNext() || !WhenChecker.isWhenExhaustive(expression2, ControlFlowProcessor.this.trace)) continue;
                this.builder.magic((KtElement)expression2, null, CollectionsKt.emptyList(), MagicKind.EXHAUSTIVE_WHEN_ELSE);
            }
            this.builder.bindLabel(doneLabel);
            this.mergeValues((List<? extends KtExpression>)branches, (KtExpression)expression2);
            WhenChecker.INSTANCE.checkDuplicatedLabels(expression2, ControlFlowProcessor.this.trace, ControlFlowProcessor.this.languageVersionSettings);
        }

        public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark((KtElement)expression2);
            KtObjectDeclaration ktObjectDeclaration = expression2.getObjectDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)ktObjectDeclaration, (String)"expression.objectDeclaration");
            KtObjectDeclaration declaration = ktObjectDeclaration;
            this.generateInstructions((KtElement)declaration);
            this.builder.createAnonymousObject(expression2);
        }

        public void visitObjectDeclaration(@NotNull KtObjectDeclaration objectDeclaration) {
            Intrinsics.checkNotNullParameter((Object)objectDeclaration, (String)"objectDeclaration");
            this.generateHeaderDelegationSpecifiers((KtClassOrObject)objectDeclaration);
            this.generateInitializersForClassOrObject((KtDeclarationContainer)objectDeclaration);
            this.generateDeclarationForLocalClassOrObjectIfNeeded((KtClassOrObject)objectDeclaration);
        }

        public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark((KtElement)expression2);
            ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
            KtStringTemplateEntry[] ktStringTemplateEntryArray = expression2.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"expression.entries");
            for (KtStringTemplateEntry entry : ktStringTemplateEntryArray) {
                if (!(entry instanceof KtStringTemplateEntryWithExpression)) continue;
                KtExpression entryExpression = entry.getExpression();
                this.generateInstructions((KtElement)entryExpression);
                if (entryExpression == null) continue;
                inputExpressions.add(entryExpression);
            }
            this.builder.loadStringTemplate(expression2, this.elementsToValues((List<? extends KtElement>)inputExpressions));
        }

        public void visitTypeProjection(@NotNull KtTypeProjection typeProjection) {
            Intrinsics.checkNotNullParameter((Object)typeProjection, (String)"typeProjection");
        }

        public void visitAnonymousInitializer(@NotNull KtAnonymousInitializer classInitializer) {
            Intrinsics.checkNotNullParameter((Object)classInitializer, (String)"classInitializer");
            this.generateInstructions((KtElement)classInitializer.getBody());
        }

        private final void generateHeaderDelegationSpecifiers(KtClassOrObject classOrObject) {
            for (KtSuperTypeListEntry specifier : classOrObject.getSuperTypeListEntries()) {
                this.generateInstructions((KtElement)specifier);
            }
        }

        private final void generateInitializersForClassOrObject(KtDeclarationContainer classOrObject) {
            for (KtDeclaration declaration : classOrObject.getDeclarations()) {
                if (!(declaration instanceof KtProperty) && !(declaration instanceof KtAnonymousInitializer)) continue;
                this.generateInstructions((KtElement)declaration);
            }
        }

        private final void processEntryOrObject(KtClassOrObject entryOrObject) {
            DeclarationDescriptor classDescriptor2 = ControlFlowProcessor.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, entryOrObject);
            if (classDescriptor2 instanceof ClassDescriptor) {
                this.builder.declareEntryOrObject(entryOrObject);
                this.builder.write((KtElement)entryOrObject, (KtElement)entryOrObject, this.createSyntheticValue((KtElement)entryOrObject, MagicKind.FAKE_INITIALIZER, new KtElement[0]), new AccessTarget.Declaration(new FakeCallableDescriptorForObject((ClassDescriptor)classDescriptor2)), MapsKt.emptyMap());
                this.generateInstructions((KtElement)entryOrObject);
            }
        }

        public void visitClass(@NotNull KtClass klass) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            if (klass.hasPrimaryConstructor()) {
                this.processParameters(klass.getPrimaryConstructorParameters());
                this.generateHeaderDelegationSpecifiers((KtClassOrObject)klass);
                this.generateInitializersForClassOrObject((KtDeclarationContainer)klass);
            }
            this.generateDeclarationForLocalClassOrObjectIfNeeded((KtClassOrObject)klass);
            if (klass.isEnum()) {
                Iterable $this$forEach$iv = klass.getDeclarations();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtDeclaration it = (KtDeclaration)element$iv;
                    boolean bl = false;
                    KtDeclaration ktDeclaration = it;
                    if (ktDeclaration instanceof KtEnumEntry) {
                        this.processEntryOrObject((KtClassOrObject)it);
                        continue;
                    }
                    if (!(ktDeclaration instanceof KtObjectDeclaration) || !((KtObjectDeclaration)it).isCompanion()) continue;
                    this.processEntryOrObject((KtClassOrObject)it);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        public void visitScript(@NotNull KtScript script) {
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            var4_2 = (PsiElement)script;
            $i$f$getChildOfType = false;
            var3_8 = (KtBlockExpression)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtBlockExpression.class);
            if (var3_8 == null) ** GOTO lbl-1000
            $i$f$getChildOfType = (PsiElement)var3_8;
            $i$f$getChildrenOfType = false;
            v0 = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtScriptInitializer.class);
            if (v0 == null) {
                v0 = (PsiElement[])new KtScriptInitializer[0];
            }
            if (($this$getChildOfType$iv = (KtScriptInitializer[])v0) != null) {
                v1 = (KtScriptInitializer)ArraysKt.lastOrNull((Object[])$this$getChildOfType$iv);
            } else lbl-1000:
            // 2 sources

            {
                v1 = null;
            }
            v2 = lastInitializer = v1;
            if (v2 != null) {
                $this$getChildOfType$iv = (Object[])v2;
                $i$f$getChildOfType = false;
                v3 = (KtExpression)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtExpression.class);
            } else {
                v3 = null;
            }
            v4 = resultExpression = v3;
            if (v4 != null) {
                $i$f$getChildOfType = v4;
                var6_10 = ControlFlowProcessor.this;
                it = $i$f$getChildOfType;
                $i$a$-let-ControlFlowProcessor$CFPVisitor$visitScript$resultType$1 = false;
                v5 = ControlFlowProcessor.access$getTrace$p(var6_10).getBindingContext().getType(it);
            } else {
                v5 = null;
            }
            resultType = v5;
            hasResultField = resultType != null && TypeUtilsKt.isUnit(resultType) == false && TypeUtilsKt.isNothing(resultType) == false;
            for (KtDeclaration declaration : script.getDeclarations()) {
                if (declaration instanceof KtAnonymousInitializer) {
                    this.generateInstructions((KtElement)declaration);
                    if (!hasResultField || !Intrinsics.areEqual((Object)declaration, (Object)lastInitializer)) continue;
                    v6 = resultExpression;
                    if (v6 != null) {
                        BindingContextUtilsKt.recordUsedAsExpression((KtElement)v6, ControlFlowProcessor.access$getTrace$p(ControlFlowProcessor.this), true);
                    }
                    continue;
                }
                if (!(declaration instanceof KtProperty) && !(declaration instanceof KtDestructuringDeclaration)) continue;
                this.generateInstructions((KtElement)declaration);
            }
        }

        private final void generateDeclarationForLocalClassOrObjectIfNeeded(KtClassOrObject classOrObject) {
            if (classOrObject.isLocal()) {
                for (KtDeclaration declaration : classOrObject.getDeclarations()) {
                    if (declaration instanceof KtSecondaryConstructor || declaration instanceof KtProperty || declaration instanceof KtAnonymousInitializer) continue;
                    this.generateInstructions((KtElement)declaration);
                }
            }
        }

        private final void processParameters(List<? extends KtParameter> parameters2) {
            for (KtParameter ktParameter : parameters2) {
                this.generateInstructions((KtElement)ktParameter);
            }
        }

        public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)constructor), KtClassOrObject.class);
            if (ktClassOrObject == null) {
                throw new IllegalStateException("Guaranteed by parsing contract".toString());
            }
            KtClassOrObject classOrObject = ktClassOrObject;
            this.processParameters(constructor.getValueParameters());
            this.generateCallOrMarkUnresolved((KtCallElement)constructor.getDelegationCall());
            if (!constructor.getDelegationCall().isCallToThis()) {
                this.generateInitializersForClassOrObject((KtDeclarationContainer)classOrObject);
            }
            this.generateInstructions((KtElement)constructor.getBodyExpression());
        }

        public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call2) {
            Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
            this.generateCallOrMarkUnresolved((KtCallElement)call2);
        }

        public void visitInitializerList(@NotNull KtInitializerList list2) {
            Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
            list2.acceptChildren((PsiElementVisitor)this);
        }

        /*
         * WARNING - void declaration
         */
        private final void generateCallOrMarkUnresolved(KtCallElement call2) {
            if (!this.generateCall((KtElement)call2)) {
                void $this$mapNotNullTo$iv$iv;
                List list2 = call2.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"call.valueArguments");
                Iterable $this$mapNotNull$iv = list2;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    KtExpression it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    ValueArgument p0 = (ValueArgument)element$iv$iv;
                    boolean bl2 = false;
                    if (p0.getArgumentExpression() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List arguments2 = (List)destination$iv$iv;
                for (KtExpression argument2 : arguments2) {
                    this.generateInstructions((KtElement)argument2);
                }
                this.createNonSyntheticValue((KtElement)call2, arguments2, MagicKind.UNRESOLVED_CALL);
            }
        }

        public void visitDelegatedSuperTypeEntry(@NotNull KtDelegatedSuperTypeEntry specifier) {
            Intrinsics.checkNotNullParameter((Object)specifier, (String)"specifier");
            KtExpression delegateExpression = specifier.getDelegateExpression();
            this.generateInstructions((KtElement)delegateExpression);
            if (delegateExpression != null) {
                KtElement[] ktElementArray = new KtElement[]{delegateExpression};
                this.createSyntheticValue((KtElement)specifier, MagicKind.VALUE_CONSUMER, ktElementArray);
            }
        }

        public void visitSuperTypeEntry(@NotNull KtSuperTypeEntry specifier) {
            Intrinsics.checkNotNullParameter((Object)specifier, (String)"specifier");
        }

        public void visitSuperTypeList(@NotNull KtSuperTypeList list2) {
            Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
            list2.acceptChildren((PsiElementVisitor)this);
        }

        public void visitKtFile(@NotNull KtFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            for (KtDeclaration declaration : file2.getDeclarations()) {
                if (!(declaration instanceof KtProperty)) continue;
                this.generateInstructions((KtElement)declaration);
            }
        }

        public void visitDoubleColonExpression(@NotNull KtDoubleColonExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.mark((KtElement)expression2);
            KtExpression receiverExpression = expression2.getReceiverExpression();
            if (receiverExpression != null && ControlFlowProcessor.this.trace.getBindingContext().get(BindingContext.DOUBLE_COLON_LHS, receiverExpression) instanceof DoubleColonLHS.Expression) {
                this.generateInstructions((KtElement)receiverExpression);
                KtElement[] ktElementArray = new KtElement[]{receiverExpression};
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.BOUND_CALLABLE_REFERENCE, ktElementArray);
            } else {
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNBOUND_CALLABLE_REFERENCE, new KtElement[0]);
            }
        }

        public void visitKtElement(@NotNull KtElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.createNonSyntheticValue(element, MagicKind.UNSUPPORTED_ELEMENT, new KtElement[0]);
        }

        private final boolean generateQualifier(KtExpression expression2, Qualifier qualifier) {
            FakeCallableDescriptorForObject fakeCallableDescriptorForObject;
            DeclarationDescriptor qualifierDescriptor = qualifier.getDescriptor();
            if (qualifierDescriptor instanceof ClassDescriptor && (fakeCallableDescriptorForObject = TowerLevelsKt.getFakeDescriptorForObject((ClassifierDescriptor)qualifierDescriptor)) != null) {
                FakeCallableDescriptorForObject it = fakeCallableDescriptorForObject;
                boolean bl = false;
                this.mark((KtElement)expression2);
                this.builder.read((KtElement)expression2, new AccessTarget.Declaration(it), MapsKt.emptyMap());
                return true;
            }
            return false;
        }

        private final boolean generateCall(KtElement callElement) {
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callElement, bindingContext);
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            if (resolvedCall3 == null || (resolvedCall3 = resolvedCall3.getCall()) == null || (resolvedCall3 = resolvedCall3.getCallElement()) == null) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> callElementFromResolvedCall = resolvedCall3;
            if (PsiUtilsKt.isAncestor((PsiElement)((PsiElement)callElement), (PsiElement)((PsiElement)callElementFromResolvedCall), (boolean)true)) {
                return false;
            }
            return this.checkAndGenerateCall(resolvedCall2);
        }

        private final boolean checkAndGenerateCall(ResolvedCall<?> resolvedCall2) {
            if (resolvedCall2 == null) {
                return false;
            }
            this.generateCall(resolvedCall2);
            return true;
        }

        private final InstructionWithValue generateCall(ResolvedCall<?> resolvedCall2) {
            Instruction instruction;
            KtElement ktElement = resolvedCall2.getCall().getCallElement();
            Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"resolvedCall.call.callElement");
            KtElement callElement = ktElement;
            Map<PseudoValue, ReceiverValue> receivers = this.getReceiverValues(resolvedCall2);
            this.deferredGeneratorsStack.push(new ArrayList());
            SmartFMap<PseudoValue, ValueParameterDescriptor> smartFMap = SmartFMap.emptyMap();
            Intrinsics.checkNotNullExpressionValue((Object)smartFMap, (String)"emptyMap<PseudoValue, ValueParameterDescriptor>()");
            SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValues = smartFMap;
            for (ValueArgument valueArgument : resolvedCall2.getCall().getValueArguments()) {
                ArgumentMapping argumentMapping;
                Intrinsics.checkNotNullExpressionValue((Object)resolvedCall2.getArgumentMapping(valueArgument), (String)"resolvedCall.getArgumentMapping(argument)");
                KtExpression argumentExpression = valueArgument.getArgumentExpression();
                if (argumentMapping instanceof ArgumentMatch) {
                    Intrinsics.checkNotNullExpressionValue((Object)valueArgument, (String)"argument");
                    parameterValues = this.generateValueArgument(valueArgument, ((ArgumentMatch)argumentMapping).getValueParameter(), parameterValues);
                    continue;
                }
                if (argumentExpression == null) continue;
                this.generateInstructions((KtElement)argumentExpression);
                KtElement[] ktElementArray = new KtElement[]{argumentExpression};
                this.createSyntheticValue((KtElement)argumentExpression, MagicKind.VALUE_CONSUMER, ktElementArray);
            }
            if (resolvedCall2.getResultingDescriptor() instanceof VariableDescriptor) {
                KtExpression ktExpression = callElement instanceof KtExpression ? (KtExpression)callElement : null;
                if (ktExpression == null) {
                    throw new IllegalStateException(("Variable-based call without callee expression: " + callElement.getText()).toString());
                }
                KtExpression ktExpression2 = ktExpression;
                boolean argumentMapping = parameterValues.isEmpty();
                if (_Assertions.ENABLED && !argumentMapping) {
                    boolean bl = false;
                    String string2 = "Variable-based call with non-empty argument list: " + ((KtExpression)callElement).getText();
                    throw new AssertionError((Object)string2);
                }
                instruction = this.builder.readVariable(ktExpression2, resolvedCall2, receivers);
            } else {
                KtElement ktElement2 = resolvedCall2.getCall().getCallElement();
                Intrinsics.checkNotNullExpressionValue((Object)ktElement2, (String)"resolvedCall.call.callElement");
                this.mark(ktElement2);
                instruction = this.builder.call(callElement, resolvedCall2, receivers, (Map)parameterValues);
            }
            Instruction callInstruction = instruction;
            List<Function1<ControlFlowBuilder, Unit>> list2 = this.deferredGeneratorsStack.pop();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"deferredGeneratorsStack.pop()");
            Iterable iterable = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : iterable) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)this.builder);
            }
            return (InstructionWithValue)callInstruction;
        }

        private final Map<PseudoValue, ReceiverValue> getReceiverValues(ResolvedCall<?> resolvedCall2) {
            PseudoValue varCallResult = null;
            ReceiverValue explicitReceiver = null;
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                varCallResult = this.generateCall(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall()).getOutputValue();
                switch (WhenMappings.$EnumSwitchMapping$0[resolvedCall2.getExplicitReceiverKind().ordinal()]) {
                    case 1: {
                        explicitReceiver = resolvedCall2.getDispatchReceiver();
                        break;
                    }
                    case 2: 
                    case 3: {
                        explicitReceiver = resolvedCall2.getExtensionReceiver();
                    }
                }
            }
            SmartFMap<PseudoValue, ReceiverValue> smartFMap = SmartFMap.emptyMap();
            Intrinsics.checkNotNullExpressionValue((Object)smartFMap, (String)"emptyMap<PseudoValue, ReceiverValue>()");
            SmartFMap<PseudoValue, ReceiverValue> receiverValues = smartFMap;
            if (explicitReceiver != null && varCallResult != null) {
                SmartFMap smartFMap2 = receiverValues.plus((Object)varCallResult, explicitReceiver);
                Intrinsics.checkNotNullExpressionValue((Object)smartFMap2, (String)"receiverValues.plus(varC\u2026Result, explicitReceiver)");
                receiverValues = smartFMap2;
            }
            KtElement ktElement = resolvedCall2.getCall().getCallElement();
            Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"resolvedCall.call.callElement");
            KtElement callElement = ktElement;
            receiverValues = this.getReceiverValues(callElement, resolvedCall2.getDispatchReceiver(), receiverValues);
            receiverValues = this.getReceiverValues(callElement, resolvedCall2.getExtensionReceiver(), receiverValues);
            return (Map)receiverValues;
        }

        private final SmartFMap<PseudoValue, ReceiverValue> getReceiverValues(KtElement callElement, ReceiverValue receiver, SmartFMap<PseudoValue, ReceiverValue> receiverValuesArg) {
            SmartFMap receiverValues = receiverValuesArg;
            if (receiver == null || receiverValues.containsValue((Object)receiver)) {
                return receiverValues;
            }
            ReceiverValue receiverValue = receiver;
            if (receiverValue instanceof ImplicitReceiver) {
                DeclarationDescriptor declaration;
                if (callElement instanceof KtCallExpression && (declaration = ((ImplicitReceiver)receiver).getDeclarationDescriptor()) instanceof ClassDescriptor) {
                    FakeCallableDescriptorForObject fakeDescriptor = TowerLevelsKt.getFakeDescriptorForObject((ClassifierDescriptor)declaration);
                    KtExpression calleeExpression = ((KtCallExpression)callElement).getCalleeExpression();
                    if (fakeDescriptor != null && calleeExpression != null) {
                        this.builder.read((KtElement)calleeExpression, new AccessTarget.Declaration(fakeDescriptor), MapsKt.emptyMap());
                    }
                }
                SmartFMap smartFMap = receiverValues.plus((Object)this.createSyntheticValue(callElement, MagicKind.IMPLICIT_RECEIVER, new KtElement[0]), (Object)receiver);
                Intrinsics.checkNotNullExpressionValue((Object)smartFMap, (String)"receiverValues.plus(crea\u2026ICIT_RECEIVER), receiver)");
                receiverValues = smartFMap;
            } else if (receiverValue instanceof ExpressionReceiver) {
                PseudoValue receiverPseudoValue;
                KtExpression expression2 = ((ExpressionReceiver)receiver).getExpression();
                if (this.builder.getBoundValue((KtElement)expression2) == null) {
                    this.generateInstructions((KtElement)expression2);
                }
                if ((receiverPseudoValue = this.getBoundOrUnreachableValue((KtElement)expression2)) != null) {
                    SmartFMap smartFMap = receiverValues.plus((Object)receiverPseudoValue, (Object)receiver);
                    Intrinsics.checkNotNullExpressionValue((Object)smartFMap, (String)"receiverValues.plus(receiverPseudoValue, receiver)");
                    receiverValues = smartFMap;
                }
            } else if (!(receiverValue instanceof TransientReceiver)) {
                throw new IllegalArgumentException("Unknown receiver kind: " + receiver);
            }
            return receiverValues;
        }

        private final SmartFMap<PseudoValue, ValueParameterDescriptor> generateValueArgument(ValueArgument valueArgument, ValueParameterDescriptor parameterDescriptor, SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValuesArg) {
            SmartFMap parameterValues = parameterValuesArg;
            KtExpression expression2 = valueArgument.getArgumentExpression();
            if (expression2 != null) {
                PseudoValue argValue;
                if (!valueArgument.isExternal()) {
                    this.generateInstructions((KtElement)expression2);
                }
                if ((argValue = this.getBoundOrUnreachableValue((KtElement)expression2)) != null) {
                    SmartFMap smartFMap = parameterValues.plus((Object)argValue, (Object)parameterDescriptor);
                    Intrinsics.checkNotNullExpressionValue((Object)smartFMap, (String)"parameterValues.plus(arg\u2026lue, parameterDescriptor)");
                    parameterValues = smartFMap;
                }
            }
            return parameterValues;
        }

        public static final /* synthetic */ PseudoValue access$getBoundOrUnreachableValue(CFPVisitor $this, KtElement element) {
            return $this.getBoundOrUnreachableValue(element);
        }

        public static final /* synthetic */ boolean access$generateCall(CFPVisitor $this, KtElement callElement) {
            return $this.generateCall(callElement);
        }

        public static final /* synthetic */ PseudoValue access$createNonSyntheticValue(CFPVisitor $this, KtElement to, MagicKind kind, KtElement ... from) {
            return $this.createNonSyntheticValue(to, kind, from);
        }

        public static final /* synthetic */ void access$mark(CFPVisitor $this, KtElement element) {
            $this.mark(element);
        }

        public static final /* synthetic */ void access$copyValue(CFPVisitor $this, KtElement from, KtElement to) {
            $this.copyValue(from, to);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$FinallyBlockGenerator;", "", "finallyBlock", "Lorg/jetbrains/kotlin/psi/KtFinallySection;", "(Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor;Lorg/jetbrains/kotlin/psi/KtFinallySection;)V", "finishFinally", "Lorg/jetbrains/kotlin/cfg/Label;", "startFinally", "generate", "", "cfg"})
        @SourceDebugExtension(value={"SMAP\nControlFlowProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlFlowProcessor.kt\norg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$FinallyBlockGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1700:1\n1#2:1701\n*E\n"})
        private final class FinallyBlockGenerator {
            @Nullable
            private final KtFinallySection finallyBlock;
            @Nullable
            private Label startFinally;
            @Nullable
            private Label finishFinally;

            public FinallyBlockGenerator(KtFinallySection finallyBlock) {
                this.finallyBlock = finallyBlock;
            }

            public final void generate() {
                KtFinallySection ktFinallySection = this.finallyBlock;
                Object object = ktFinallySection != null ? ktFinallySection.getFinalExpression() : null;
                if (object == null) {
                    return;
                }
                KtBlockExpression finalExpression = object;
                CFPVisitor.this.catchFinallyStack.push(new CatchFinallyLabels(null, null, null));
                Label label = this.startFinally;
                if (label != null) {
                    boolean bl;
                    Label label2 = label;
                    CFPVisitor cFPVisitor = CFPVisitor.this;
                    Label it = label2;
                    boolean bl2 = false;
                    boolean bl3 = bl = this.finishFinally != null;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl4 = false;
                        String string2 = "startFinally label is set to " + this.startFinally + " but finishFinally label is not set";
                        throw new AssertionError((Object)string2);
                    }
                    ControlFlowBuilder controlFlowBuilder = cFPVisitor.builder;
                    Label label3 = this.finishFinally;
                    Intrinsics.checkNotNull((Object)label3);
                    controlFlowBuilder.repeatPseudocode(it, label3);
                    cFPVisitor.catchFinallyStack.pop();
                    return;
                }
                label = CFPVisitor.this.builder.createUnboundLabel("start finally");
                CFPVisitor cFPVisitor = CFPVisitor.this;
                Label it = label;
                boolean bl = false;
                this.startFinally = it;
                cFPVisitor.builder.bindLabel(it);
                CFPVisitor.this.generateInstructions((KtElement)finalExpression);
                label = CFPVisitor.this.builder.createUnboundLabel("finish finally");
                cFPVisitor = CFPVisitor.this;
                it = label;
                boolean bl5 = false;
                this.finishFinally = it;
                cFPVisitor.builder.bindLabel(it);
                CFPVisitor.this.catchFinallyStack.pop();
            }
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ExplicitReceiverKind.values().length];
                try {
                    nArray[ExplicitReceiverKind.DISPATCH_RECEIVER.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExplicitReceiverKind.EXTENSION_RECEIVER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExplicitReceiverKind.BOTH_RECEIVERS.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExplicitReceiverKind.NO_EXPLICIT_RECEIVER.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CatchFinallyLabels;", "", "onException", "Lorg/jetbrains/kotlin/cfg/Label;", "toFinally", "tryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "(Lorg/jetbrains/kotlin/cfg/Label;Lorg/jetbrains/kotlin/cfg/Label;Lorg/jetbrains/kotlin/psi/KtTryExpression;)V", "getOnException", "()Lorg/jetbrains/kotlin/cfg/Label;", "getToFinally", "getTryExpression", "()Lorg/jetbrains/kotlin/psi/KtTryExpression;", "cfg"})
    private static final class CatchFinallyLabels {
        @Nullable
        private final Label onException;
        @Nullable
        private final Label toFinally;
        @Nullable
        private final KtTryExpression tryExpression;

        public CatchFinallyLabels(@Nullable Label onException, @Nullable Label toFinally, @Nullable KtTryExpression tryExpression) {
            this.onException = onException;
            this.toFinally = toFinally;
            this.tryExpression = tryExpression;
        }

        @Nullable
        public final Label getOnException() {
            return this.onException;
        }

        @Nullable
        public final Label getToFinally() {
            return this.toFinally;
        }

        @Nullable
        public final KtTryExpression getTryExpression() {
            return this.tryExpression;
        }
    }
}

