/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrMutableAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmNames;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u0015\u001a\u00020\b*\u00020\u00162\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOverloadsAnnotationLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "generateWrapper", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "target", "numDefaultParametersToExpect", "", "generateWrappers", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lower", "generateNewValueParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "oldFunction", "generateWrapperHeader", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nJvmOverloadsAnnotationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmOverloadsAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmOverloadsAnnotationLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,181:1\n800#2,11:182\n766#2:193\n857#2,2:194\n1855#2,2:196\n1774#2,4:198\n223#3,4:202\n179#3,4:206\n*S KotlinDebug\n*F\n+ 1 JvmOverloadsAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmOverloadsAnnotationLowering\n*L\n34#1:182,11\n34#1:193\n34#1:194,2\n38#1:196,2\n44#1:198,4\n122#1:202,4\n130#1:206,4\n*E\n"})
final class JvmOverloadsAnnotationLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public JvmOverloadsAnnotationLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public void lower(@NotNull IrClass irClass) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Iterable $this$filterIsInstance$iv = irClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrFunction it = (IrFunction)element$iv$iv;
            boolean bl = false;
            if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)it), (FqName)JvmNames.INSTANCE.getJVM_OVERLOADS_FQ_NAME())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List functions2 = (List)destination$iv$iv;
        Iterable $this$forEach$iv = functions2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFunction it = (IrFunction)element$iv;
            boolean bl = false;
            this.generateWrappers(it, irClass);
        }
    }

    private final void generateWrappers(IrFunction target, IrClass irClass) {
        int n;
        Iterable $this$count$iv = target.getValueParameters();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl = false;
                if (!(it.getDefaultValue() != null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int numDefaultParameters = n;
        for (int i = numDefaultParameters - 1; -1 < i; --i) {
            IrFunction wrapper = this.generateWrapper(target, i);
            IrDeclarationsKt.addMember((IrClass)irClass, (IrDeclaration)((IrDeclaration)wrapper));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrFunction generateWrapper(IrFunction target, int numDefaultParametersToExpect) {
        IrGetValueImpl irGetValueImpl;
        IrGetValueImpl irGetValueImpl2;
        IrValueParameter dispatchReceiver;
        IrFunctionAccessExpression irFunctionAccessExpression;
        Object object;
        IrFunctionAccessExpression irFunctionAccessExpression2;
        IrFunction wrapperIrFunction = this.generateWrapperHeader(this.context.getIrFactory(), target, numDefaultParametersToExpect);
        IrFunction irFunction = target;
        if (irFunction instanceof IrConstructor) {
            irFunctionAccessExpression2 = (IrFunctionAccessExpression)IrDelegatingConstructorCallImpl.Companion.fromSymbolOwner$default((IrDelegatingConstructorCallImpl.Companion)IrDelegatingConstructorCallImpl.Companion, (int)-1, (int)-1, (IrType)this.context.getIrBuiltIns().getUnitType(), (IrConstructorSymbol)((IrConstructor)target).getSymbol(), (int)0, (int)0, (int)48, null);
        } else if (irFunction instanceof IrSimpleFunction) {
            irFunctionAccessExpression2 = (IrFunctionAccessExpression)IrCallImpl.Companion.fromSymbolOwner$default((IrCallImpl.Companion)IrCallImpl.Companion, (int)-1, (int)-1, (IrType)target.getReturnType(), (IrSimpleFunctionSymbol)((IrSimpleFunction)target).getSymbol(), (int)0, (int)0, null, null, (int)240, null);
        } else {
            throw new IllegalStateException(("unknown function kind: " + RenderIrElementKt.render((IrElement)((IrElement)target))).toString());
        }
        IrFunctionAccessExpression call2 = irFunctionAccessExpression2;
        for (IrTypeParameter arg : IrUtilsKt.getAllTypeParameters((IrFunction)wrapperIrFunction)) {
            call2.putTypeArgument(arg.getIndex(), IrTypesKt.getDefaultType((IrTypeParameter)arg));
        }
        IrFunctionAccessExpression irFunctionAccessExpression3 = call2;
        IrValueParameter irValueParameter = wrapperIrFunction.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            object = irValueParameter;
            irFunctionAccessExpression = irFunctionAccessExpression3;
            boolean bl = false;
            irGetValueImpl2 = new IrGetValueImpl(-1, -1, (IrValueSymbol)dispatchReceiver.getSymbol(), null, 8, null);
            irFunctionAccessExpression3 = irFunctionAccessExpression;
        } else {
            irGetValueImpl2 = null;
        }
        irFunctionAccessExpression3.setDispatchReceiver((IrExpression)irGetValueImpl2);
        IrFunctionAccessExpression irFunctionAccessExpression4 = call2;
        IrValueParameter irValueParameter2 = wrapperIrFunction.getExtensionReceiverParameter();
        if (irValueParameter2 != null) {
            void extensionReceiver;
            dispatchReceiver = irValueParameter2;
            irFunctionAccessExpression = irFunctionAccessExpression4;
            boolean bl = false;
            irGetValueImpl = new IrGetValueImpl(-1, -1, (IrValueSymbol)extensionReceiver.getSymbol(), null, 8, null);
            irFunctionAccessExpression4 = irFunctionAccessExpression;
        } else {
            irGetValueImpl = null;
        }
        irFunctionAccessExpression4.setExtensionReceiver((IrExpression)irGetValueImpl);
        int parametersCopied = 0;
        int defaultParametersCopied = 0;
        object = target.getValueParameters().iterator();
        int n = 0;
        while (object.hasNext()) {
            int i = n++;
            IrValueParameter valueParameter2 = (IrValueParameter)object.next();
            if (valueParameter2.getDefaultValue() != null) {
                if (defaultParametersCopied < numDefaultParametersToExpect) {
                    ++defaultParametersCopied;
                    call2.putValueArgument(i, (IrExpression)new IrGetValueImpl(-1, -1, (IrValueSymbol)((IrValueParameter)wrapperIrFunction.getValueParameters().get(parametersCopied++)).getSymbol(), null, 8, null));
                    continue;
                }
                call2.putValueArgument(i, null);
                continue;
            }
            call2.putValueArgument(i, (IrExpression)new IrGetValueImpl(-1, -1, (IrValueSymbol)((IrValueParameter)wrapperIrFunction.getValueParameters().get(parametersCopied++)).getSymbol(), null, 8, null));
        }
        wrapperIrFunction.setBody(target instanceof IrConstructor ? (IrBody)new IrBlockBodyImpl(-1, -1, CollectionsKt.listOf((Object)call2)) : (IrBody)new IrExpressionBodyImpl(-1, -1, (IrExpression)call2));
        return wrapperIrFunction;
    }

    private final IrFunction generateWrapperHeader(IrFactory $this$generateWrapperHeader, IrFunction oldFunction, int numDefaultParametersToExpect) {
        IrFunction irFunction;
        IrFunction irFunction2 = oldFunction;
        if (irFunction2 instanceof IrConstructor) {
            IrFactory $this$buildConstructor$iv = $this$generateWrapperHeader;
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u2422$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$generateWrapperHeader_u24lambda_u245 = $this$buildConstructor_u24lambda_u2422$iv;
            boolean bl2 = false;
            $this$generateWrapperHeader_u24lambda_u245.setOrigin((IrDeclarationOrigin)JvmLoweredDeclarationOrigin.JVM_OVERLOADS_WRAPPER.INSTANCE);
            $this$generateWrapperHeader_u24lambda_u245.setName(oldFunction.getName());
            $this$generateWrapperHeader_u24lambda_u245.setVisibility(oldFunction.getVisibility());
            $this$generateWrapperHeader_u24lambda_u245.setReturnType(oldFunction.getReturnType());
            $this$generateWrapperHeader_u24lambda_u245.setInline(oldFunction.isInline());
            irFunction = (IrFunction)DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u2422$iv);
        } else if (irFunction2 instanceof IrSimpleFunction) {
            IrFactory $this$buildFun$iv = $this$generateWrapperHeader;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2418$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$generateWrapperHeader_u24lambda_u246 = $this$buildFun_u24lambda_u2418$iv;
            boolean bl3 = false;
            $this$generateWrapperHeader_u24lambda_u246.setOrigin((IrDeclarationOrigin)JvmLoweredDeclarationOrigin.JVM_OVERLOADS_WRAPPER.INSTANCE);
            $this$generateWrapperHeader_u24lambda_u246.setName(oldFunction.getName());
            $this$generateWrapperHeader_u24lambda_u246.setVisibility(oldFunction.getVisibility());
            $this$generateWrapperHeader_u24lambda_u246.setModality(this.context.getState().getLanguageVersionSettings().supportsFeature(LanguageFeature.GenerateJvmOverloadsAsFinal) ? Modality.FINAL : ((IrSimpleFunction)oldFunction).getModality());
            $this$generateWrapperHeader_u24lambda_u246.setReturnType(oldFunction.getReturnType());
            $this$generateWrapperHeader_u24lambda_u246.setInline(oldFunction.isInline());
            $this$generateWrapperHeader_u24lambda_u246.setSuspend(((IrSimpleFunction)oldFunction).isSuspend());
            irFunction = (IrFunction)DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2418$iv);
        } else {
            throw new IllegalStateException(("Unknown kind of IrFunction: " + oldFunction).toString());
        }
        IrFunction res2 = irFunction;
        res2.setParent(oldFunction.getParent());
        IrUtilsKt.copyAnnotationsFrom((IrMutableAnnotationContainer)((IrMutableAnnotationContainer)res2), (IrAnnotationContainer)((IrAnnotationContainer)oldFunction));
        IrUtilsKt.copyTypeParametersFrom$default((IrTypeParametersContainer)((IrTypeParametersContainer)res2), (IrTypeParametersContainer)((IrTypeParametersContainer)oldFunction), null, null, (int)6, null);
        IrValueParameter irValueParameter = oldFunction.getDispatchReceiverParameter();
        res2.setDispatchReceiverParameter(irValueParameter != null ? IrUtilsKt.copyTo$default((IrValueParameter)irValueParameter, (IrFunction)res2, null, (int)0, (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (int)8190, null) : null);
        IrValueParameter irValueParameter2 = oldFunction.getExtensionReceiverParameter();
        res2.setExtensionReceiverParameter(irValueParameter2 != null ? IrUtilsKt.copyTo$default((IrValueParameter)irValueParameter2, (IrFunction)res2, null, (int)0, (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (int)8190, null) : null);
        res2.setValueParameters(CollectionsKt.plus((Collection)res2.getValueParameters(), (Iterable)this.generateNewValueParameters(res2, oldFunction, numDefaultParametersToExpect)));
        return res2;
    }

    private final List<IrValueParameter> generateNewValueParameters(IrFunction $this$generateNewValueParameters, IrFunction oldFunction, int numDefaultParametersToExpect) {
        int parametersCopied = 0;
        int defaultParametersCopied = 0;
        List result2 = new ArrayList();
        for (IrValueParameter oldValueParameter : oldFunction.getValueParameters()) {
            if (oldValueParameter.getDefaultValue() != null && defaultParametersCopied < numDefaultParametersToExpect) {
                ++defaultParametersCopied;
                result2.add(IrUtilsKt.copyTo$default((IrValueParameter)oldValueParameter, (IrFunction)$this$generateNewValueParameters, null, (int)parametersCopied++, (int)0, (int)0, null, null, null, null, null, (boolean)oldValueParameter.isCrossinline(), (boolean)oldValueParameter.isNoinline(), (boolean)false, (int)4602, null));
                continue;
            }
            if (oldValueParameter.getDefaultValue() != null) continue;
            result2.add(IrUtilsKt.copyTo$default((IrValueParameter)oldValueParameter, (IrFunction)$this$generateNewValueParameters, null, (int)parametersCopied++, (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (int)8186, null));
        }
        return result2;
    }
}

