/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeChecker;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"isAssignmentCorrectWithDataFlowInfo", "", "leftType", "Lorg/jetbrains/kotlin/types/KotlinType;", "rightExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "rightType", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
@SourceDebugExtension(value={"SMAP\nassignmentCheckUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 assignmentCheckUtils.kt\norg/jetbrains/kotlin/resolve/calls/checkers/AssignmentCheckUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,26:1\n1747#2,3:27\n*S KotlinDebug\n*F\n+ 1 assignmentCheckUtils.kt\norg/jetbrains/kotlin/resolve/calls/checkers/AssignmentCheckUtilsKt\n*L\n25#1:27,3\n*E\n"})
public final class AssignmentCheckUtilsKt {
    public static final boolean isAssignmentCorrectWithDataFlowInfo(@NotNull KotlinType leftType, @NotNull KtExpression rightExpression, @NotNull KotlinType rightType, @NotNull CallCheckerContext context) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)leftType, (String)"leftType");
            Intrinsics.checkNotNullParameter((Object)rightExpression, (String)"rightExpression");
            Intrinsics.checkNotNullParameter((Object)rightType, (String)"rightType");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            NewKotlinTypeChecker kotlinTypeChecker = context.getCallComponents().getKotlinTypeChecker();
            if (kotlinTypeChecker.isSubtypeOf(rightType, leftType)) {
                return true;
            }
            DataFlowInfo dfi = context.getDataFlowInfo();
            DataFlowValueFactory dfvFactory = context.getDataFlowValueFactory();
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
            Set<KotlinType> stableTypesFromDataFlow = dfi.getStableTypes(dfvFactory.createDataFlowValue(rightExpression, rightType, bindingContext, context.getModuleDescriptor()), context.getLanguageVersionSettings());
            Iterable $this$any$iv = stableTypesFromDataFlow;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!kotlinTypeChecker.isSubtypeOf(it, leftType)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }
}

