/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.MoveBodilessDeclarationsToSeparatePlaceLowering;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0006\u001a\f\u0010\u0016\u001a\u00020\u0006*\u00020\bH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"BODILESS_BUILTIN_CLASSES", "", "Lorg/jetbrains/kotlin/name/FqName;", "JsIntrinsicFqName", "JsPackage", "isBuiltInClass", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isIntrinsic", "isStdLibClass", "moveBodilessDeclarationsToSeparatePlace", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "validateIsExternal", "packageFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "validateNestedExternalDeclarations", "isExternalTopLevel", "isPlacedInsideInternalPackage", "backend.js"})
@SourceDebugExtension(value={"SMAP\nMoveBodilessDeclarationsToSeparatePlace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveBodilessDeclarationsToSeparatePlace.kt\norg/jetbrains/kotlin/ir/backend/js/lower/MoveBodilessDeclarationsToSeparatePlaceKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1747#2,3:146\n1855#2,2:149\n1855#2,2:151\n1549#2:153\n1620#2,3:154\n*S KotlinDebug\n*F\n+ 1 MoveBodilessDeclarationsToSeparatePlace.kt\norg/jetbrains/kotlin/ir/backend/js/lower/MoveBodilessDeclarationsToSeparatePlaceKt\n*L\n60#1:146,3\n64#1:149,2\n139#1:151,2\n43#1:153\n43#1:154,3\n*E\n"})
public final class MoveBodilessDeclarationsToSeparatePlaceKt {
    @NotNull
    private static final Set<FqName> BODILESS_BUILTIN_CLASSES;
    @NotNull
    private static final FqName JsPackage;
    @NotNull
    private static final FqName JsIntrinsicFqName;

    public static final boolean isBuiltInClass(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return declaration instanceof IrClass && CollectionsKt.contains((Iterable)BODILESS_BUILTIN_CLASSES, (Object)IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isStdLibClass(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!(declaration instanceof IrClass)) return false;
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration));
        if (fqName2 == null) return true;
        if (FqNamesUtilKt.isChildOf((FqName)fqName2, (FqName)JsPackage)) return true;
        return false;
    }

    private static final boolean isPlacedInsideInternalPackage(IrDeclaration $this$isPlacedInsideInternalPackage) {
        IrDeclarationParent irDeclarationParent = $this$isPlacedInsideInternalPackage.getParent();
        IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
        return Intrinsics.areEqual((Object)(irPackageFragment != null ? irPackageFragment.getFqName() : null), (Object)JsPackage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isIntrinsic(IrDeclaration declaration) {
        IrConstructorCall it;
        if (!(declaration instanceof IrSimpleFunction)) return false;
        if (!MoveBodilessDeclarationsToSeparatePlaceKt.isPlacedInsideInternalPackage(declaration)) return false;
        Iterable $this$any$iv = declaration.getAnnotations();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (IrConstructorCall)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)AdditionalIrUtilsKt.getConstructedClass((IrConstructor)((IrConstructor)it.getSymbol().getOwner())))), (Object)JsIntrinsicFqName));
        return true;
    }

    public static final void moveBodilessDeclarationsToSeparatePlace(@NotNull JsIrBackendContext context, @NotNull IrModuleFragment moduleFragment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)moduleFragment, (String)"moduleFragment");
        MoveBodilessDeclarationsToSeparatePlaceLowering moveBodiless = new MoveBodilessDeclarationsToSeparatePlaceLowering(context);
        boolean bl = false;
        Iterable $this$forEach$iv = moduleFragment.getFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFile it = (IrFile)element$iv;
            boolean bl2 = false;
            MoveBodilessDeclarationsToSeparatePlaceKt.validateIsExternal((IrPackageFragment)it);
            moveBodiless.lower(it);
        }
    }

    public static final void validateIsExternal(@NotNull IrPackageFragment packageFragment) {
        Intrinsics.checkNotNullParameter((Object)packageFragment, (String)"packageFragment");
        for (IrDeclaration declaration : packageFragment.getDeclarations()) {
            IrPossiblyExternalDeclaration irPossiblyExternalDeclaration = declaration instanceof IrPossiblyExternalDeclaration ? (IrPossiblyExternalDeclaration)declaration : null;
            MoveBodilessDeclarationsToSeparatePlaceKt.validateNestedExternalDeclarations(declaration, irPossiblyExternalDeclaration != null ? irPossiblyExternalDeclaration.isExternal() : false);
        }
    }

    public static final void validateNestedExternalDeclarations(@NotNull IrDeclaration declaration, boolean isExternalTopLevel) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof IrPossiblyExternalDeclaration) {
            MoveBodilessDeclarationsToSeparatePlaceKt.validateNestedExternalDeclarations$checkExternal((IrPossiblyExternalDeclaration)declaration, isExternalTopLevel, declaration);
        }
        if (declaration instanceof IrProperty) {
            IrSimpleFunction irSimpleFunction = ((IrProperty)declaration).getGetter();
            if (irSimpleFunction != null) {
                MoveBodilessDeclarationsToSeparatePlaceKt.validateNestedExternalDeclarations$checkExternal((IrPossiblyExternalDeclaration)irSimpleFunction, isExternalTopLevel, declaration);
            }
            IrSimpleFunction irSimpleFunction2 = ((IrProperty)declaration).getSetter();
            if (irSimpleFunction2 != null) {
                MoveBodilessDeclarationsToSeparatePlaceKt.validateNestedExternalDeclarations$checkExternal((IrPossiblyExternalDeclaration)irSimpleFunction2, isExternalTopLevel, declaration);
            }
            IrField irField = ((IrProperty)declaration).getBackingField();
            if (irField != null) {
                MoveBodilessDeclarationsToSeparatePlaceKt.validateNestedExternalDeclarations$checkExternal((IrPossiblyExternalDeclaration)irField, isExternalTopLevel, declaration);
            }
        }
        if (declaration instanceof IrClass) {
            Iterable $this$forEach$iv = ((IrClass)declaration).getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                MoveBodilessDeclarationsToSeparatePlaceKt.validateNestedExternalDeclarations(it, isExternalTopLevel);
            }
        }
    }

    private static final void validateNestedExternalDeclarations$checkExternal(IrPossiblyExternalDeclaration $this$validateNestedExternalDeclarations_u24checkExternal, boolean $isExternalTopLevel, IrDeclaration $declaration) {
        if ($this$validateNestedExternalDeclarations_u24checkExternal.isExternal() != $isExternalTopLevel) {
            CompilationExceptionKt.compilationException((String)"isExternal validation failed for declaration", (IrDeclaration)$declaration);
            throw null;
        }
    }

    public static final /* synthetic */ boolean access$isIntrinsic(IrDeclaration declaration) {
        return MoveBodilessDeclarationsToSeparatePlaceKt.isIntrinsic(declaration);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Object[] objectArray = new String[]{"kotlin.String", "kotlin.Nothing", "kotlin.Array", "kotlin.Any", "kotlin.ByteArray", "kotlin.CharArray", "kotlin.ShortArray", "kotlin.IntArray", "kotlin.LongArray", "kotlin.FloatArray", "kotlin.DoubleArray", "kotlin.BooleanArray", "kotlin.Boolean", "kotlin.Byte", "kotlin.Short", "kotlin.Int", "kotlin.Float", "kotlin.Double", "kotlin.Function"};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FqName((String)it));
        }
        BODILESS_BUILTIN_CLASSES = CollectionsKt.toSet((Iterable)((List)var3_3));
        JsPackage = new FqName("kotlin.js");
        JsIntrinsicFqName = new FqName("kotlin.js.JsIntrinsic");
    }
}

